/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import model1_8.CoOccurrence;
import model1_8.Fssabnd;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.SipmDict;
import model1_8.Sipmcat;
import model1_8.TaxonCompareCategory;
import model1_8.TaxonCompareGenus;
import model1_8.TaxonCompareSpecies;
import util.ProgressBarMonitor;
import util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Taxon
extends Observable
implements Comparable {
    private SBdb SB = null;
    private int specID = 0;
    int donorID = 0;
    private int genID = 0;
    private int prefID = 0;
    private Taxon pref = null;
    String donorString = "";
    String donorOccType = "In-situ";
    private boolean donorMatchSaved = true;
    private boolean isEdited = false;
    private boolean wasAdded;
    private char discID = '\u0000';
    private String cat_mnem = "";
    private String genus = "";
    private String subGenus = "";
    private String species = "";
    private String subSpecies = "";
    private String author = "";
    private int year = 0;
    private String alphaCode = "";
    private int numericCode = 0;
    private int ccode = 0;
    private String gq1 = "";
    private String gq2 = "";
    private String gq3 = "";
    private String gq4 = "";
    private String sq1 = "";
    private String sq2 = "";
    private String sq3 = "";
    private String sq4 = "";
    private String notes = "";
    private String reference = "";
    private boolean notesDirty = false;
    private boolean numericCodeDirty = false;
    private boolean notesLoaded = false;
    static SimpleDateFormat databaseDate = new SimpleDateFormat("yyyy-MM-dd");
    static boolean includeCategoryInString = false;
    static int NQUAL = 8;
    static int[] preqal = new int[]{1, 0, 1, 0, 1, 0, 1, 0};
    static int NSYM = 9;
    static int MAXSYM = 6;
    static String[] qulsym = new String[]{"\"", "?", "cf.", "aff.", "ss.", "sl.", "grp.", "sensu", "var."};
    static int[][] symord = new int[][]{{1, 2, 3, 0, -1, -1}, {1, 0, 6, 4, 5, -1}, {2, 3, 0, -1, -1, -1}, {1, 0, 6, 4, 5, -1}, {2, 3, 0, -1, -1, -1}, {1, 0, 6, 4, 5, 7}, {2, 3, 0, 8, -1, -1}, {1, 0, 4, 5, 7, -1}};
    static int[][] mutexc = new int[][]{{1, 1, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 2, 2, 2, 0, 0}, {1, 0, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 2, 2, 2, 0, 0}, {1, 0, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 2, 2, 2, 2, 0}, {1, 0, 2, 2, 0, 0, 0, 0, 2}, {1, 1, 0, 0, 2, 2, 0, 2, 0}};
    static final String INSITU_OCC = "In-situ";
    static final String REWORKED_OCC = "Reworked";
    static final String CAVED_OCC = "Caved";
    static final String QUESTIONABLE_OCC = "Questionable";

    public SBdb getDatabase() {
        return this.SB;
    }

    public int getSpecID() {
        return this.specID;
    }

    public int getDonorID() {
        return this.donorID;
    }

    public int getGenID() {
        return this.genID;
    }

    public int getPrefID() {
        return this.prefID;
    }

    public Taxon getPref() {
        return this.pref;
    }

    public char getDiscID() {
        return this.discID;
    }

    public String getCatMnem() {
        return this.cat_mnem;
    }

    public String getGenus() {
        return this.genus;
    }

    public String getSubGenus() {
        return this.subGenus;
    }

    public String getSpecies() {
        return this.species;
    }

    public String getSubSpecies() {
        return this.subSpecies;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getYear() {
        return this.year;
    }

    public String getAlphaCode() {
        return this.alphaCode;
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public int getCcode() {
        return this.ccode;
    }

    public String getGq1() {
        return this.gq1;
    }

    public String getGq2() {
        return this.gq2;
    }

    public String getGq3() {
        return this.gq3;
    }

    public String getGq4() {
        return this.gq4;
    }

    public String getSq1() {
        return this.sq1;
    }

    public String getSq2() {
        return this.sq2;
    }

    public String getSq3() {
        return this.sq3;
    }

    public String getSq4() {
        return this.sq4;
    }

    public String getNotes() throws SQLException {
        this.loadNotes();
        return this.notes;
    }

    public String getReference() throws SQLException {
        this.loadNotes();
        return this.reference;
    }

    public Taxon(String iGenus, String iSpecies) {
        this.SB = null;
        this.genus = iGenus;
        this.species = iSpecies;
    }

    public void copy(Taxon rhs) {
        this.alphaCode = rhs.alphaCode;
        this.author = rhs.author;
        this.cat_mnem = rhs.cat_mnem;
        this.ccode = rhs.ccode;
        this.discID = rhs.discID;
        this.genID = rhs.genID;
        this.genus = rhs.genus;
        this.gq1 = rhs.gq1;
        this.gq2 = rhs.gq2;
        this.gq3 = rhs.gq3;
        this.gq4 = rhs.gq4;
        this.notes = rhs.notes;
        this.notesLoaded = rhs.notesLoaded;
        this.numericCode = rhs.numericCode;
        this.pref = rhs.pref;
        this.prefID = rhs.prefID;
        this.reference = rhs.reference;
        this.specID = rhs.specID;
        this.species = rhs.species;
        this.sq1 = rhs.sq1;
        this.sq2 = rhs.sq2;
        this.sq3 = rhs.sq3;
        this.sq4 = rhs.sq4;
        this.subGenus = rhs.subGenus;
        this.subSpecies = rhs.subSpecies;
        this.year = rhs.year;
        this.setChanged();
    }

    public Taxon(SBdb SB2, String catMnem, String genus, String subGenus, String species, String subSpecies, String gq1, String gq2, String gq3, String gq4, String sq1, String sq2, String sq3, String sq4) throws SQLException {
        this.SB = SB2;
        this.cat_mnem = catMnem;
        this.genus = genus;
        this.subGenus = subGenus;
        this.gq1 = gq1;
        this.gq2 = gq2;
        this.gq3 = gq3;
        this.gq4 = gq4;
        this.getGenus(true);
        this.species = species;
        this.subSpecies = subSpecies;
        this.sq1 = sq1;
        this.sq2 = sq2;
        this.sq3 = sq3;
        this.sq4 = sq4;
        this.getSpecies(true);
        if (this.specID == 0) {
            SB2 = null;
        } else {
            SB2.taxa.addTaxon(this);
        }
    }

    public void setAuthor(String author, int year) throws SQLException {
        if (this.SB != null && this.specID > 0) {
            String sql = "UPDATE " + this.SB.DBTableName("species") + " SET author=" + util.SB.DBString(author) + ",year=" + year + " WHERE spec_id=" + this.specID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
        }
        this.author = author;
        this.year = year;
        this.setChanged();
    }

    public void setAlphaCode(String alphaCode) throws SQLException {
        if (this.SB != null && this.specID > 0) {
            String sql = "UPDATE " + this.SB.DBTableName("species") + " SET alphacode=" + util.SB.DBString(alphaCode) + " WHERE spec_id=" + this.specID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
        }
        this.alphaCode = alphaCode;
        this.setChanged();
    }

    public Taxon(SBdb SB2, boolean lookupCode, String alphaCode) throws SBException, SQLException {
        if (!SB2.hasAlphaCode) {
            throw new SBException("Database does not have alphanumeric codes");
        }
        String sql = "SELECT spec_id FROM " + SB2.DBTableName("species") + " WHERE ucase(alphacode)=" + util.SB.DBString(alphaCode.toUpperCase());
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        if (!rs.next()) {
            stmt.close();
            throw new SBException("Taxon for code: " + alphaCode + " does not exist");
        }
        this.SB = SB2;
        this.fillSpecies(rs.getInt("spec_id"));
        stmt.close();
    }

    public Taxon(Taxon copy) {
        this.copy(copy);
    }

    public Taxon(String taxonString) {
        int i;
        String strDot;
        boolean usedQualifier;
        StringTokenizer st = new StringTokenizer(taxonString);
        if (!st.hasMoreTokens()) {
            return;
        }
        String str = st.nextToken();
        while (str != null) {
            usedQualifier = false;
            strDot = str + '.';
            for (i = 0; i < NSYM; ++i) {
                if (qulsym[i].compareToIgnoreCase(str) == 0 || qulsym[i].compareToIgnoreCase(strDot) == 0) {
                    if (this.gq1.length() > 0) {
                        this.gq1 = this.gq1 + ' ';
                    }
                    this.gq1 = this.gq1 + qulsym[i];
                    if (!st.hasMoreTokens()) {
                        return;
                    }
                    str = st.nextToken();
                    usedQualifier = true;
                    break;
                }
                if (qulsym[i].length() >= str.length() || qulsym[i].charAt(qulsym[i].length() - 1) != '.' || qulsym[i].compareToIgnoreCase(str.substring(0, qulsym[i].length())) != 0) continue;
                if (this.gq1.length() > 0) {
                    this.gq1 = this.gq1 + ' ';
                }
                this.gq1 = this.gq1 + qulsym[i];
                str = str.substring(qulsym[i].length());
                usedQualifier = true;
                break;
            }
            if (usedQualifier) continue;
            break;
        }
        if (str.charAt(0) == '?') {
            this.gq1 = this.gq1 + '?';
            str = str.substring(1);
        }
        if (str.charAt(0) == '\"') {
            this.gq1 = this.gq1.length() > 0 ? this.gq1 + " \"" : "\"";
            if ((str = str.substring(1)).endsWith("\"")) {
                str = str.substring(0, str.length() - 1);
            }
            this.gq2 = "\"";
        }
        if (str.endsWith("?")) {
            this.gq2 = this.gq2.length() > 0 ? this.gq2 + " ?" : "?";
            str = str.substring(0, str.length() - 2);
        }
        this.genus = str;
        if (!st.hasMoreTokens()) {
            return;
        }
        str = st.nextToken();
        if (str != null && str.startsWith("(") && str.endsWith(")")) {
            this.subGenus = str.substring(1, str.length() - 1);
            if (!st.hasMoreTokens()) {
                return;
            }
            str = st.nextToken();
        }
        while (str != null) {
            usedQualifier = false;
            strDot = str + '.';
            for (i = 0; i < NSYM; ++i) {
                if (qulsym[i].compareToIgnoreCase(str) == 0 || qulsym[i].compareToIgnoreCase(strDot) == 0) {
                    if (qulsym[i].equals("?")) {
                        if (this.sq2.length() > 0) {
                            this.sq2 = this.sq2 + ' ';
                        }
                        this.sq2 = this.sq2 + qulsym[i];
                    } else {
                        if (this.sq1.length() > 0) {
                            this.sq1 = this.sq1 + ' ';
                        }
                        this.sq1 = this.sq1 + qulsym[i];
                    }
                    if (!st.hasMoreTokens()) {
                        return;
                    }
                    str = st.nextToken();
                    usedQualifier = true;
                    break;
                }
                if (qulsym[i].length() >= str.length() || qulsym[i].charAt(qulsym[i].length() - 1) != '.' || qulsym[i].compareToIgnoreCase(str.substring(0, qulsym[i].length())) != 0) continue;
                if (this.sq1.length() > 0) {
                    this.sq1 = this.sq1 + ' ';
                }
                this.sq1 = this.sq1 + qulsym[i];
                str = str.substring(qulsym[i].length());
                usedQualifier = true;
                break;
            }
            if (usedQualifier) continue;
            break;
        }
        if (str.charAt(0) == '?') {
            this.sq2 = this.sq2 + '?';
            str = str.substring(1);
        }
        if (str.charAt(0) == '\"') {
            this.sq1 = this.sq1.length() > 0 ? this.sq1 + " \"" : "\"";
            if ((str = str.substring(1)).endsWith("\"")) {
                str = str.substring(0, str.length() - 1);
            }
            this.sq2 = "\"";
        }
        if (str.endsWith("?")) {
            this.sq2 = this.sq2.length() > 0 ? this.sq2 + " ?" : "?";
            str = str.substring(0, str.length() - 1);
        }
        this.species = str;
        try {
            this.qulord();
        }
        catch (SBException e) {
            e.printStackTrace();
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        str = st.nextToken();
        boolean moveToSubSpecies = false;
        while (true) {
            if (str != null) {
                usedQualifier = false;
                String strDot2 = str + '.';
                for (i = 0; i < NSYM; ++i) {
                    if (qulsym[i].compareToIgnoreCase(str) == 0 || qulsym[i].compareToIgnoreCase(strDot2) == 0) {
                        if (this.sq2.length() > 0) {
                            this.sq2 = this.sq2 + ' ';
                        }
                        this.sq2 = this.sq2 + qulsym[i];
                        if (!st.hasMoreTokens()) {
                            return;
                        }
                        str = st.nextToken();
                        usedQualifier = true;
                        moveToSubSpecies = true;
                        break;
                    }
                    if (qulsym[i].length() >= str.length() || qulsym[i].charAt(qulsym[i].length() - 1) != '.' || qulsym[i].compareToIgnoreCase(str.substring(0, qulsym[i].length())) != 0) continue;
                    if (this.sq1.length() > 0) {
                        this.sq2 = this.sq2 + ' ';
                    }
                    this.sq2 = this.sq2 + qulsym[i];
                    str = str.substring(qulsym[i].length());
                    usedQualifier = true;
                    moveToSubSpecies = true;
                    break;
                }
                if (usedQualifier) continue;
            }
            if (moveToSubSpecies) break;
            this.species = this.species + ' ';
            this.species = this.species + str;
            if (!st.hasMoreTokens()) {
                return;
            }
            str = st.nextToken();
        }
        this.subSpecies = str;
        while (st.hasMoreTokens()) {
            str = st.nextToken();
            if (Character.isDigit(str.charAt(0))) {
                this.year = Integer.parseInt(str);
                continue;
            }
            if (this.author.length() > 0) {
                this.author = this.author + ' ';
            }
            this.author = this.author + str;
        }
    }

    public Taxon(SBdb SB2, int iSpecID) throws SQLException, SBException {
        this.SB = SB2;
        if (iSpecID == 0) {
            throw new SBException("Blank ID in taxon contstructor");
        }
        this.fillSpecies(iSpecID);
    }

    private void fillSpecies(int iSpecID) throws SQLException {
        String sql = "SELECT gen_id,q1,species,q2,q3,sub_spec,q4,author,year";
        if (this.SB.hasAlphaCode) {
            sql = sql + ",alphaCode";
        }
        sql = sql + " FROM " + this.SB.DBTableName("species") + " s WHERE spec_id=" + iSpecID;
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            this.genID = rs.getInt("gen_id");
            this.specID = iSpecID;
            this.sq1 = rs.getString("q1");
            this.sq1 = this.sq1 != null ? this.sq1.trim() : "";
            this.species = rs.getString("species");
            this.species = this.species != null ? this.species.trim() : "";
            this.sq2 = rs.getString("q2");
            this.sq2 = this.sq2 != null ? this.sq2.trim() : "";
            this.sq3 = rs.getString("q3");
            this.sq3 = this.sq3 != null ? this.sq3.trim() : "";
            this.subSpecies = rs.getString("sub_spec");
            this.subSpecies = this.subSpecies != null ? this.subSpecies.trim() : "";
            this.sq4 = rs.getString("q4");
            this.sq4 = this.sq4 != null ? this.sq4.trim() : "";
            this.author = rs.getString("author");
            this.author = this.author != null ? this.author.trim() : "";
            this.year = rs.getInt("year");
            if (this.SB.hasAlphaCode) {
                this.alphaCode = rs.getString("alphacode");
            }
            this.fillGenus();
            this.isEdited = false;
        }
        this.fillSipmCode(1);
        stmt.close();
    }

    private void fillSipmCode(int dictionary) throws SQLException {
        Statement stmt;
        ResultSet rs;
        String sql = "SELECT sipm_code FROM " + this.SB.DBTableName("SIPMCODE") + " WHERE spec_id=" + this.specID;
        if (this.SB.hasSIPMdict) {
            sql = sql + " AND ccode=" + dictionary;
        }
        this.numericCode = (rs = (stmt = this.SB.getDatabase().createStatement()).executeQuery(this.SB.modQuery(sql))).next() ? rs.getInt("SIPM_CODE") : 0;
        stmt.close();
    }

    private void fillGenus() throws SQLException {
        String query = "SELECT cat_mnem,genus,sub_genus,gen_id,q1,q2,q3,q4";
        query = query + " FROM " + this.SB.DBTableName("genus") + " WHERE gen_id=" + this.genID;
        query = this.SB.modQuery(query);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            this.cat_mnem = rs.getString("cat_mnem");
            if (this.cat_mnem != null) {
                this.cat_mnem = this.cat_mnem.trim();
            }
            this.genus = rs.getString("genus");
            this.genus = this.genus != null ? this.genus.trim() : "";
            this.subGenus = rs.getString("sub_genus");
            this.subGenus = this.subGenus != null ? this.subGenus.trim() : "";
            this.genID = rs.getInt("gen_id");
            this.gq1 = rs.getString("q1");
            this.gq1 = this.gq1 != null ? this.gq1.trim() : "";
            this.gq2 = rs.getString("q2");
            this.gq2 = this.gq2 != null ? this.gq2.trim() : "";
            this.gq3 = rs.getString("q3");
            this.gq3 = this.gq3 != null ? this.gq3.trim() : "";
            this.gq4 = rs.getString("q4");
            this.gq4 = this.gq4 != null ? this.gq4.trim() : "";
        }
        stmt.close();
    }

    public String toGenusString(boolean includeCat) {
        String strg = "";
        if (includeCat) {
            strg = this.cat_mnem;
            while (strg.length() < 6) {
                strg = strg + ' ';
            }
        }
        if (this.gq1 != null && this.gq1.length() > 0) {
            strg = strg + this.gq1 + (this.gq1.endsWith("\"") || this.gq1.endsWith("?") ? "" : " ");
        }
        strg = strg + this.genus;
        if (this.gq2 != null && this.gq2.length() > 0) {
            strg = strg + (this.gq2.startsWith("\"") || this.gq2.startsWith("?") ? "" : " ") + this.gq2;
        }
        strg = strg.trim();
        if (this.subGenus != null && this.subGenus.length() > 0) {
            strg = strg + " (";
            if (this.gq3 != null && this.gq3.length() > 0) {
                strg = strg + this.gq3 + (this.gq3.endsWith("\"") || this.gq3.endsWith("?") ? "" : " ");
            }
            strg = strg + this.subGenus;
            if (this.gq4 != null && this.gq4.length() > 0) {
                strg = strg + (this.gq4.startsWith("\"") || this.gq4.startsWith("?") ? "" : " ") + this.gq4;
            }
            strg = strg + ")";
        }
        return strg.trim();
    }

    public boolean lookupDonorCode() throws SQLException {
        if (this.specID == 0 && this.donorString != null && this.donorString.length() > 0) {
            String sql = "SELECT spec_id FROM " + this.SB.DBTableName("SPECIES") + " WHERE alphaCode=" + util.SB.DBString(this.donorString);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            if (rs.next()) {
                this.specID = rs.getInt("spec_id");
            }
            stmt.close();
        }
        return this.specID > 0;
    }

    void updateAlphaCode(Statement stmt) throws SQLException {
        if (this.specID == 0) {
            return;
        }
        String sql = "UPDATE " + this.SB.DBTableName("species") + " SET alphacode=" + util.SB.DBString(this.alphaCode) + " WHERE spec_id=" + this.specID;
        stmt.executeUpdate(this.SB.modQuery(sql));
    }

    public static int reassign(SBdb SB2, int donor, int target, int wellListID) throws SBException, SQLException {
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "UPDATE " + SB2.DBTableName("FSSABND") + " SET spec_id=" + target + " WHERE floor(samp_id/" + 65536 + ") IN (SELECT well_id FROM " + SB2.DBTableName("SBWLMB") + " WHERE id=" + wellListID + ")";
        sql = sql + " AND spec_id=" + donor;
        int nRows = stmt.executeUpdate(SB2.modQuery(sql));
        return nRows;
    }

    public static void checkCoOccurrences(SBdb SB2, int donor, int target, int wellListID) throws SQLException, SBException {
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "SELECT w.well_name,w.units,v.code,s.depth,s.bot_depth,s.type,f1.samp_id,f1.disc_id,f1.analyst,f1.ident_type,f1.status,f1.form,f1.growth FROM " + SB2.DBTableName("FSSABND") + " f1, " + SB2.DBTableName("FSSABND") + " f2," + SB2.DBTableName("WELLS") + " w," + SB2.DBTableName("VERSION") + " v," + SB2.DBTableName("SAMPLES") + " s ";
        if (wellListID > 0) {
            sql = sql + ", " + SB2.DBTableName("SBWLMB");
            sql = sql + " l ";
        }
        sql = sql + " WHERE  f1.samp_id=f2.samp_id AND f1.disc_id=f2.disc_id AND f1.analyst=f2.analyst  AND f1.spec_id=" + donor + " AND f2.spec_id=" + target + " AND ((f1.status=f2.status) or (f1.status is null and f2.status is null)) " + " AND f1.ident_type=f2.ident_type " + " AND ((f1.form=f2.form) or (f1.form is null and f2.form is null)) " + " AND ((f1.growth=f2.growth) or (f1.growth is null and f2.growth is null))" + " AND f1.samp_id=s.samp_id AND v.well_id=floor(s.samp_id/" + 65536 + ") AND w.well_code=v.code";
        if (wellListID > 0) {
            sql = sql + " AND floor(s.samp_id/65536) = l.well_id AND l.id=" + wellListID;
        }
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        LinkedList<CoOccurrence> coOccurrences = new LinkedList<CoOccurrence>();
        String lastCode = "";
        String lastAnalyst = "";
        while (rs.next()) {
            String wellName = rs.getString("well_name");
            char units = util.SB.getDBChar(rs, "units");
            String wellCode = rs.getString("code");
            String item = "";
            if (!wellCode.equals(lastCode)) {
                item = wellName;
                item = item + "(";
                item = item + wellCode;
                item = item + ")";
                item = item + ", ";
                lastCode = wellCode;
            } else {
                item = item + "  ...";
            }
            double top = rs.getDouble("depth");
            double base = rs.getDouble("bot_depth");
            item = item + util.SB.getDepthString(top, units, 2);
            if (top != base) {
                item = item + "-";
                item = item + util.SB.getDepthString(base, units, 2);
            }
            item = item + ", ";
            item = item + rs.getString("type");
            item = item + " (id=";
            int sampID = rs.getInt("samp_id");
            item = item + sampID;
            item = item + "), ";
            char discID = util.SB.getDBChar(rs, "disc_id");
            item = item + SBdb.getDiscAdj(discID);
            String analyst = rs.getString("analyst");
            if (!lastAnalyst.equals(analyst)) {
                item = item + ": ";
                item = item + analyst;
                lastAnalyst = analyst;
            }
            char identType = util.SB.getDBChar(rs, "ident_type");
            boolean reworked = util.SB.getDBChar(rs, "status") == 'R';
            char form = util.SB.getDBChar(rs, "form");
            char growth = util.SB.getDBChar(rs, "growth");
            CoOccurrence coOcc = new CoOccurrence();
            coOcc.sampID = sampID;
            coOcc.analyst = analyst;
            coOcc.discID = discID;
            coOcc.reason = item;
            coOcc.target = new Fssabnd(SB2, sampID, discID, analyst, SB2.getTaxon(target), reworked, identType, form, growth);
            coOcc.donor = new Fssabnd(SB2, sampID, discID, analyst, SB2.getTaxon(donor), reworked, identType, form, growth);
            coOccurrences.add(coOcc);
        }
        if (coOccurrences.size() > 0) {
            SBException e = new SBException("Cannot update/merge taxon (ID=" + donor + ", to ID=" + target + ") because it would create co-occurring data\nThe samples in which this happens are listed");
            e.setData(coOccurrences);
            throw e;
        }
    }

    private Taxon(SBdb SB2) {
        this.SB = SB2;
    }

    public static void loadAll(SBdb SB2, HashMap<Integer, Taxon> set) throws SQLException {
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "SELECT g.gen_id,s.spec_id,g.cat_mnem,g.genus,g.sub_genus,g.q1 AS gq1,g.q2 AS gq2,g.q3 AS gq3,g.q4 AS gq4,s.q1 AS sq1,s.species,s.q2 AS sq2,s.q3 AS sq3,s.sub_spec,s.q4 AS sq4,s.author,s.year";
        if (SB2.hasAlphaCode) {
            sql = sql + ",s.alphaCode";
        }
        sql = sql + " FROM " + SB2.DBTableName("species") + " s, " + SB2.DBTableName("genus") + " g WHERE g.gen_id=s.gen_id ORDER BY s.spec_id";
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            Taxon taxon = new Taxon(SB2);
            taxon.genID = rs.getInt("gen_id");
            taxon.specID = rs.getInt("spec_id");
            taxon.cat_mnem = util.SB.getDBString(rs, "cat_mnem");
            taxon.genus = util.SB.getDBString(rs, "genus");
            taxon.subGenus = util.SB.getDBString(rs, "sub_genus");
            taxon.gq1 = util.SB.getDBString(rs, "gq1");
            taxon.gq2 = util.SB.getDBString(rs, "gq2");
            taxon.gq3 = util.SB.getDBString(rs, "gq3");
            taxon.gq4 = util.SB.getDBString(rs, "gq4");
            taxon.sq1 = util.SB.getDBString(rs, "sq1");
            taxon.species = util.SB.getDBString(rs, "species");
            taxon.sq2 = util.SB.getDBString(rs, "sq2");
            taxon.sq3 = util.SB.getDBString(rs, "sq3");
            taxon.subSpecies = util.SB.getDBString(rs, "sub_spec");
            taxon.sq4 = util.SB.getDBString(rs, "sq4");
            taxon.author = util.SB.getDBString(rs, "author");
            taxon.year = rs.getInt("year");
            set.put(taxon.specID, taxon);
        }
        stmt.close();
    }

    static void merge(SBdb SB2, boolean checkCoOccurrences, int donor, int target) throws SBException, SQLException {
        String sql;
        Statement stmt = SB2.getDatabase().createStatement();
        if (checkCoOccurrences) {
            Taxon.checkCoOccurrences(SB2, donor, target, 0);
        }
        try {
            sql = "UPDATE " + SB2.DBTableName("AGES") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        catch (SQLException ex) {
            sql = "DELETE FROM " + SB2.DBTableName("AGES") + " WHERE spec_id=" + donor;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        sql = "SELECT ev_id FROM ";
        sql = sql + SB2.DBTableName("EVENTDIC");
        sql = sql + " WHERE spec_id=" + target;
        sql = sql + " AND generate='Y'";
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        boolean keepGenerateFlag = true;
        if (rs.next()) {
            keepGenerateFlag = false;
        }
        sql = "UPDATE " + SB2.DBTableName("EVENTDIC") + " SET spec_id=" + target;
        if (!keepGenerateFlag) {
            sql = sql + ",generate='N'";
        }
        sql = sql + " WHERE spec_id=" + donor;
        stmt.executeUpdate(SB2.modQuery(sql));
        Statement stmt2 = SB2.getDatabase().createStatement();
        sql = "SELECT grp_id FROM ";
        sql = sql + SB2.DBTableName("GROUPMBR");
        sql = sql + " WHERE spec_id=" + target;
        rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int grpID = rs.getInt("grp_id");
            sql = "DELETE FROM ";
            sql = sql + SB2.DBTableName("GROUPMBR");
            sql = sql + " WHERE spec_id=" + donor;
            sql = sql + " AND grp_id=" + grpID;
            stmt2.executeUpdate(SB2.modQuery(sql));
        }
        sql = "UPDATE " + SB2.DBTableName("GROUPMBR") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "UPDATE " + SB2.DBTableName("OVR_MAP") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "SELECT pref";
        if (SB2.hasSynonymSchemes) {
            sql = sql + ",sch_id";
        }
        sql = sql + " FROM ";
        sql = sql + SB2.DBTableName("SYNONYMY");
        sql = sql + " WHERE spec_id=" + target;
        rs = stmt.executeQuery(SB2.modQuery(sql));
        int schID = 0;
        while (rs.next()) {
            int prefID = rs.getInt("pref");
            if (SB2.hasSynonymSchemes) {
                schID = rs.getInt("sch_id");
            }
            sql = "DELETE FROM ";
            sql = sql + SB2.DBTableName("SYNONYMY");
            sql = sql + " WHERE spec_id=" + donor;
            sql = sql + " AND pref=" + prefID;
            if (SB2.hasSynonymSchemes) {
                sql = sql + " AND sch_id=" + schID;
            }
            stmt2.executeUpdate(SB2.modQuery(sql));
        }
        stmt2.close();
        sql = "UPDATE " + SB2.DBTableName("SIPMCODE") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "UPDATE " + SB2.DBTableName("SYNONYMY") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "UPDATE " + SB2.DBTableName("FSSABND") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
        stmt.executeUpdate(SB2.modQuery(sql));
        int donorGenID = 0;
        sql = "SELECT gen_id FROM " + SB2.DBTableName("species") + " WHERE spec_id=" + donor;
        rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            donorGenID = rs.getInt("gen_id");
        }
        sql = "DELETE FROM " + SB2.DBTableName("SPECIES") + " WHERE spec_id=" + donor;
        stmt.executeUpdate(SB2.modQuery(sql));
        boolean deleteGenus = true;
        sql = "SELECT gen_id FROM " + SB2.DBTableName("species") + " WHERE gen_id=" + donorGenID;
        rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            deleteGenus = false;
        }
        if (deleteGenus) {
            sql = "DELETE FROM " + SB2.DBTableName("genus") + " WHERE gen_id=" + donorGenID;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
    }

    public int checkNSpeciesOfGenus() throws SQLException, SBException {
        if (this.SB == null) {
            throw new SBException("database reference null in checkNspecies");
        }
        if (this.genID == 0) {
            throw new SBException("Genus ID zero in checkNspecies");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT count(spec_id) AS nspecies";
        sql = sql + " FROM ";
        sql = sql + this.SB.DBTableName("species") + " WHERE gen_id=" + this.genID;
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        int nSpecies = 0;
        if (rs.next()) {
            nSpecies = rs.getInt("nspecies");
        }
        rs.close();
        return nSpecies;
    }

    public boolean genusEqual(String catMnem, String genus, String subGenus, String gq1, String gq2, String gq3, String gq4) {
        if (!this.cat_mnem.equalsIgnoreCase(catMnem)) {
            return false;
        }
        if (!this.genus.equalsIgnoreCase(genus)) {
            return false;
        }
        if (!this.subGenus.equalsIgnoreCase(subGenus)) {
            return false;
        }
        if (!this.gq1.equalsIgnoreCase(gq1)) {
            return false;
        }
        if (!this.gq2.equalsIgnoreCase(gq2)) {
            return false;
        }
        if (!this.gq3.equalsIgnoreCase(gq3)) {
            return false;
        }
        return this.gq4.equalsIgnoreCase(gq4);
    }

    public boolean genusCaseEqual(String catMnem, String genus, String subGenus, String gq1, String gq2, String gq3, String gq4) {
        if (!this.cat_mnem.equals(catMnem)) {
            return false;
        }
        if (!this.genus.equals(genus)) {
            return false;
        }
        if (!this.subGenus.equals(subGenus)) {
            return false;
        }
        if (!this.gq1.equals(gq1)) {
            return false;
        }
        if (!this.gq2.equals(gq2)) {
            return false;
        }
        if (!this.gq3.equals(gq3)) {
            return false;
        }
        return this.gq4.equals(gq4);
    }

    static int selectGenus(SBdb SB2, int existingID, String catMnem, String genus, String subGenus, String gq1, String gq2, String gq3, String gq4) throws SQLException {
        int genID = 0;
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "SELECT gen_id, genus, q1, q2, q3, sub_genus, q4 FROM ";
        sql = sql + SB2.DBTableName("GENUS");
        sql = sql + " WHERE ";
        if (catMnem.length() > 0) {
            sql = sql + "cat_mnem='";
            sql = sql + catMnem;
            sql = sql + "' AND ";
        }
        sql = sql + " ucase(genus)=";
        sql = sql + util.SB.DBString(genus.toUpperCase());
        if (gq1 != null && gq1.length() > 0) {
            sql = sql + " AND lcase(q1)='";
            sql = sql + gq1 + "'";
        }
        if (gq2 != null && gq2.length() > 0) {
            sql = sql + " AND lcase(q2)='";
            sql = sql + gq2 + "'";
        }
        if (gq3 != null && gq3.length() > 0) {
            sql = sql + " AND lcase(q3)='";
            sql = sql + gq3 + "'";
        }
        if (subGenus != null && subGenus.length() > 0) {
            sql = sql + " AND ucase(sub_genus)=";
            sql = sql + util.SB.DBString(subGenus.toUpperCase());
        }
        if (gq4 != null && gq4.length() > 0) {
            sql = sql + " AND lcase(q4)='";
            sql = sql + gq4 + "'";
        }
        if (existingID > 0) {
            sql = sql + " AND gen_id <>" + existingID;
        }
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            String strg;
            boolean match = true;
            genID = rs.getInt("gen_id");
            if (gq1.length() == 0) {
                strg = rs.getString("q1");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else {
                gq1 = gq1.toLowerCase();
            }
            if (gq2.length() == 0 && match) {
                strg = rs.getString("q2");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else {
                gq2 = gq2.toLowerCase();
            }
            if (gq3.length() == 0 && match) {
                strg = rs.getString("q3");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else {
                gq3 = gq3.toLowerCase();
            }
            if (subGenus.length() == 0 && match && (strg = rs.getString("sub_genus")) != null && strg.trim().length() > 0) {
                match = false;
            }
            if (gq4.length() == 0 && match) {
                strg = rs.getString("q4");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else {
                gq4 = gq4.toLowerCase();
            }
            if (match) break;
            genID = 0;
        }
        stmt.close();
        return genID;
    }

    public void updateGenus(SBdb SB2, boolean updateAll, String catMnem, String genus, String subGenus, String gq1, String gq2, String gq3, String gq4) throws SQLException, util.SBException, SBException {
        Statement stmt = SB2.getDatabase().createStatement();
        int tempID = Taxon.selectGenus(SB2, this.genID, catMnem, genus, subGenus, gq1, gq2, gq3, gq4);
        if (tempID > 0) {
            String sql;
            if (updateAll) {
                sql = "UPDATE " + SB2.DBTableName("species") + " SET gen_id=" + tempID + " WHERE gen_id=" + this.genID;
                stmt.executeUpdate(SB2.modQuery(sql));
                SB2.taxa.updateGenID(this.genID, tempID, this);
            } else {
                sql = "UPDATE " + SB2.DBTableName("species") + " SET gen_id=" + tempID + " WHERE gen_id=" + this.genID + " AND spec_id=" + this.specID;
                stmt.executeUpdate(SB2.modQuery(sql));
            }
            sql = "DELETE FROM " + SB2.DBTableName("genus") + " WHERE gen_id=" + this.genID;
            stmt.executeUpdate(SB2.modQuery(sql));
            this.genID = tempID;
        } else if (updateAll) {
            String sql = "UPDATE " + SB2.DBTableName("genus") + " SET " + "cat_mnem='" + catMnem + "'" + ",q1='" + gq1 + "'" + ",genus=" + util.SB.DBString(genus) + ",q2='" + gq2 + "'" + ",q3='" + gq3 + "'" + ",sub_genus=" + util.SB.DBString(subGenus) + ",q4='" + gq4 + "'" + " WHERE gen_id=" + this.genID;
            stmt.executeUpdate(SB2.modQuery(sql));
        } else {
            this.genID = Taxon.addGenus(stmt, SB2, catMnem, genus, subGenus, gq1, gq2, gq3, gq4);
        }
        stmt.close();
        this.cat_mnem = catMnem;
        this.genus = genus;
        this.gq1 = gq1;
        this.gq2 = gq2;
        this.gq3 = gq3;
        this.gq4 = gq4;
        this.setChanged();
    }

    public void updateSpecies(SBdb SB2, String species, String subSpecies, String sq1, String sq2, String sq3, String sq4) throws SQLException {
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "UPDATE " + SB2.DBTableName("species") + " SET " + " q1='" + sq1 + "'" + ",species='" + species + "'" + ",q2='" + sq2 + "'" + ",q3='" + sq3 + "'" + ",sub_spec=" + util.SB.DBString(subSpecies) + ",q4='" + sq4 + "'" + " WHERE spec_id=" + this.specID;
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
        this.sq1 = sq1;
        this.species = species;
        this.sq2 = sq2;
        this.sq3 = sq3;
        this.subSpecies = subSpecies;
        this.sq4 = sq4;
        this.setChanged();
    }

    public int checkOcc() throws SQLException, SBException {
        if (this.specID == 0) {
            return 0;
        }
        if (this.SB == null) {
            throw new SBException("Database reference not initialised in taxon.checkOcc()");
        }
        int nSpecies = 0;
        String sql = "SELECT count(spec_id) as nspecies";
        sql = sql + " FROM ";
        sql = sql + this.SB.DBTableName("fssabnd") + " WHERE spec_id=" + this.specID;
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            nSpecies += rs.getInt("nspecies");
        }
        stmt.close();
        return nSpecies;
    }

    public boolean checkCategory() throws SQLException {
        boolean found = false;
        if (this.cat_mnem == null) {
            return false;
        }
        this.cat_mnem = this.cat_mnem.trim();
        if (this.cat_mnem.length() == 0) {
            return false;
        }
        String sql = "SELECT cat_mnem FROM ";
        sql = sql + this.SB.DBTableName("category") + " WHERE cat_mnem='" + this.cat_mnem + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            found = true;
        }
        stmt.close();
        return found;
    }

    public int store(SBdb SB2) throws SQLException, util.SBException, SBException {
        String sql;
        if (!this.isEdited && this.specID != 0) {
            return this.specID;
        }
        if (!this.checkCategory()) {
            throw new SBException("Category invalid");
        }
        Statement stmt = SB2.getDatabase().createStatement();
        this.genID = 0;
        if (this.getGenus(false) == 0) {
            this.addGenus(stmt);
        }
        if (this.getSpecies(false) == 0) {
            this.wasAdded = true;
            this.addSpecies(stmt);
        }
        if (SB2.hasAlphaCode && this.specID > 0 && this.alphaCode != null && this.alphaCode.length() > 0) {
            sql = "UPDATE " + SB2.DBTableName("SPECIES") + " SET alphaCode=" + util.SB.DBString(this.alphaCode) + " WHERE spec_id=" + this.specID;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        if (this.numericCodeDirty) {
            this.updateNumericCode(this.ccode, this.numericCode);
        }
        if (this.notesDirty) {
            sql = "DELETE FROM " + SB2.DBTableName("TXNOTES") + " WHERE spec_id=" + this.specID;
            stmt.executeUpdate(SB2.modQuery(sql));
            if (this.notes.length() > 0) {
                sql = "INSERT INTO " + SB2.DBTableName("TXNOTES") + " (spec_id,notes) VALUES (" + this.specID + "," + util.SB.DBString(this.notes) + ")";
                stmt.executeUpdate(SB2.modQuery(sql));
            }
            sql = "DELETE FROM " + SB2.DBTableName("TXREFS") + " WHERE spec_id=" + this.specID;
            stmt.executeUpdate(SB2.modQuery(sql));
            if (this.reference.length() > 0) {
                sql = "INSERT INTO " + SB2.DBTableName("TXREFS") + " (spec_id,references) VALUES (" + this.specID + "," + util.SB.DBString(this.reference) + ")";
                stmt.executeUpdate(SB2.modQuery(sql));
            }
        }
        this.isEdited = false;
        stmt.close();
        this.SB = SB2;
        SB2.taxa.addTaxon(this);
        return this.specID;
    }

    public static String getCategory(SBdb SB2, String genus) throws SQLException {
        String catMnem = null;
        String sql = "SELECT cat_mnem,gen_id FROM " + SB2.DBTableName("genus") + " WHERE ucase(genus)=" + util.SB.DBString(genus.toUpperCase()) + " order by gen_id ";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            catMnem = rs.getString("cat_mnem");
        }
        stmt.close();
        return catMnem;
    }

    void updateNumericCode(int ccode, int numericCode) throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.SB.DBTableName("SIPMCODE") + " WHERE spec_id=" + this.specID;
        if (this.SB.hasSIPMdict) {
            sql = sql + " AND ccode=" + ccode;
        }
        stmt.executeUpdate(this.SB.modQuery(sql));
        if (numericCode != 0) {
            sql = "INSERT INTO " + this.SB.DBTableName("SIPMCODE") + " (spec_id,sipm_code,ccode) VALUES (" + this.specID + "," + numericCode + ",";
            sql = this.SB.hasSIPMdict ? sql + "" + ccode : sql + "1";
            sql = sql + ")";
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        stmt.close();
        this.numericCode = numericCode;
        this.ccode = ccode;
        this.setChanged();
    }

    void setGenusFields(int genID, Taxon taxon) {
        this.genID = genID;
        this.cat_mnem = taxon.cat_mnem;
        this.genus = taxon.genus;
        this.subGenus = taxon.subGenus;
        this.gq1 = taxon.gq1;
        this.gq2 = taxon.gq2;
        this.gq3 = taxon.gq3;
        this.gq4 = taxon.gq4;
    }

    public void setGenusFields(Taxon taxon) {
        if (taxon.genID != this.genID) {
            return;
        }
        this.genus = taxon.genus;
        this.subGenus = taxon.subGenus;
        this.gq1 = taxon.gq1;
        this.gq2 = taxon.gq2;
        this.gq3 = taxon.gq3;
        this.gq4 = taxon.gq4;
    }

    boolean hasQualifiers() {
        if (this.gq1 != null && this.gq1.length() > 0) {
            return true;
        }
        if (this.gq2 != null && this.gq2.length() > 0) {
            return true;
        }
        if (this.gq3 != null && this.gq3.length() > 0) {
            return true;
        }
        if (this.gq4 != null && this.gq4.length() > 0) {
            return true;
        }
        if (this.sq1 != null && this.sq1.length() > 0) {
            return true;
        }
        if (this.sq2 != null && this.sq2.length() > 0) {
            return true;
        }
        if (this.sq3 != null && this.sq3.length() > 0) {
            return true;
        }
        return this.sq4 != null && this.sq4.length() > 0;
    }

    public void getTaxon() throws SQLException {
        if (this.cat_mnem.length() == 0) {
            this.cat_mnem = Taxon.getCategory(this.SB, this.genus);
        }
        if (this.cat_mnem.length() > 0) {
            this.getGenus(true);
            if (this.genus.length() > 0) {
                this.getSpecies(true);
                if (this.specID == 0 && (this.species.compareToIgnoreCase("sp") == 0 || this.species.compareToIgnoreCase("spp") == 0)) {
                    String oldSpecies = this.species;
                    this.species = "spp.";
                    this.getSpecies(false);
                    if (this.specID == 0) {
                        this.species = oldSpecies;
                    }
                }
            }
            if (this.specID == 0) {
                this.genID = 0;
            }
        }
        this.isEdited = false;
    }

    void suggestCategory() throws SQLException {
        this.cat_mnem = "MP";
        String sql = "SELECT cat_mnem FROM " + this.SB.DBTableName("genus_ref") + " WHERE ucase(genus)='" + this.genus.toUpperCase() + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            this.cat_mnem = rs.getString("cat_mnem");
        }
    }

    public void convertCase() {
        if (this.SB == null || this.specID == 0) {
            this.genus = Taxon.toGenusCase(this.genus);
            this.subGenus = Taxon.toGenusCase(this.subGenus);
            this.species = Taxon.toSpeciesCase(this.species);
            this.subSpecies = Taxon.toSpeciesCase(this.subSpecies);
            this.gq1 = Taxon.caseQualifier(this.gq1);
            this.gq2 = Taxon.caseQualifier(this.gq2);
            this.gq3 = Taxon.caseQualifier(this.gq3);
            this.gq4 = Taxon.caseQualifier(this.gq4);
            this.sq1 = Taxon.caseQualifier(this.sq1);
            this.sq2 = Taxon.caseQualifier(this.sq2);
            this.sq3 = Taxon.caseQualifier(this.sq3);
            this.sq4 = Taxon.caseQualifier(this.sq4);
        }
    }

    static int getGenusID(SBdb SB2, String genus) throws SQLException {
        String sql = "SELECT gen_id FROM " + SB2.DBTableName("genus") + " WHERE genus=" + util.SB.DBString(genus);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        int genID = 0;
        if (rs.next()) {
            genID = rs.getInt("gen_id");
        }
        return genID;
    }

    public static List lookupGenus(SBdb SB2, String catMnem, String genus) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        String sql = "SELECT DISTINCT cat_mnem,genus FROM " + SB2.DBTableName("genus") + " WHERE ucase(genus) like " + util.SB.DBString(genus.toUpperCase() + "%");
        if (catMnem.length() > 0) {
            sql = sql + " AND cat_mnem like '" + catMnem + "%'";
        }
        sql = sql + " ORDER BY genus, cat_mnem";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            String item = rs.getString("cat_mnem");
            while (item.length() < 6) {
                item = item + ' ';
            }
            item = item + " " + rs.getString("genus");
            list.add(item);
        }
        return list;
    }

    public static List lookupSpecies(SBdb SB2, String catMnem, String genus, String species) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        String sql = "SELECT s.species FROM " + SB2.DBTableName("GENUS") + " g," + SB2.DBTableName("SPECIES") + " s WHERE ";
        if (catMnem.length() > 0) {
            sql = sql + "g.cat_mnem='" + catMnem + "' AND ";
        }
        if (genus.length() > 0) {
            sql = sql + " ucase(g.genus)='" + genus.toUpperCase() + "' AND ";
        }
        if (species.length() > 0) {
            sql = sql + " ucase(s.species) like '" + species.toUpperCase() + "%' AND";
        }
        sql = sql + " g.gen_id=s.gen_id ORDER by species";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            String item = rs.getString("species");
            list.add(item);
        }
        return list;
    }

    public static String caseQualifier(String qual) {
        if (!(qual = qual.toLowerCase()).endsWith(".")) {
            for (int i = 0; i < NQUAL + 1; ++i) {
                if (!qulsym[i].endsWith(".") || qual.compareTo(qulsym[i].substring(0, qulsym[i].length() - 1)) != 0) continue;
                qual = qual + ".";
                break;
            }
        }
        return qual;
    }

    public void loadNotes() throws SQLException {
        if (this.specID == 0) {
            return;
        }
        if (this.notesLoaded) {
            return;
        }
        String sql = "SELECT notes FROM " + this.SB.DBTableName("TXNOTES") + " WHERE spec_id=" + this.specID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            this.notes = rs.getString("notes");
        }
        if ((rs = stmt.executeQuery(this.SB.modQuery(sql = "SELECT references FROM " + this.SB.DBTableName("TXREFS") + " WHERE spec_id=" + this.specID))).next()) {
            this.reference = rs.getString("references");
        }
        this.notesLoaded = true;
    }

    public char getDiscId() throws SQLException {
        if (this.discID == '\u0000') {
            String sql = "SELECT disc_id FROM " + this.SB.DBTableName("category") + " WHERE cat_mnem='" + this.cat_mnem + "'";
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            if (rs.next()) {
                this.discID = rs.getString("disc_id").charAt(0);
            }
        }
        return this.discID;
    }

    private int getGenus(boolean switchCase) throws SQLException {
        if (this.genID != 0) {
            return this.genID;
        }
        if (this.genus.length() == 0) {
            return -2;
        }
        String sql = "SELECT cat_mnem, gen_id, genus, q1, q2, q3, sub_genus, q4 FROM ";
        sql = sql + this.SB.DBTableName("GENUS");
        sql = sql + " WHERE ";
        if (this.cat_mnem.length() > 0) {
            sql = sql + "cat_mnem='";
            sql = sql + this.cat_mnem;
            sql = sql + "' AND ";
        }
        sql = sql + " ucase(genus)=";
        sql = sql + util.SB.DBString(this.genus.toUpperCase());
        if (this.gq1 != null && this.gq1.length() > 0) {
            sql = sql + " AND lcase(q1)='";
            sql = sql + this.gq1 + "'";
        }
        if (this.gq2 != null && this.gq2.length() > 0) {
            sql = sql + " AND lcase(q2)='";
            sql = sql + this.gq2 + "'";
        }
        if (this.gq3 != null && this.gq3.length() > 0) {
            sql = sql + " AND lcase(q3)='";
            sql = sql + this.gq3 + "'";
        }
        if (this.subGenus != null && this.subGenus.length() > 0) {
            sql = sql + " AND ucase(sub_genus)=";
            sql = sql + util.SB.DBString(this.subGenus.toUpperCase());
        }
        if (this.gq4 != null && this.gq4.length() > 0) {
            sql = sql + " AND lcase(q4)='";
            sql = sql + this.gq4 + "'";
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            String strg;
            boolean match = true;
            this.cat_mnem = rs.getString("cat_mnem");
            this.genID = rs.getInt("gen_id");
            if (switchCase) {
                this.genus = rs.getString("genus");
            }
            if (this.gq1.length() == 0) {
                strg = rs.getString("q1");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else {
                this.gq1 = this.gq1.toLowerCase();
            }
            if (this.gq2.length() == 0 && match) {
                strg = rs.getString("q2");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else {
                this.gq2 = this.gq2.toLowerCase();
            }
            if (this.gq3.length() == 0 && match) {
                strg = rs.getString("q3");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else {
                this.gq3 = this.gq3.toLowerCase();
            }
            if (this.subGenus.length() == 0 && match) {
                strg = rs.getString("sub_genus");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else if (this.subGenus.length() > 0 && switchCase) {
                this.subGenus = rs.getString("sub_genus");
            }
            if (this.gq4.length() == 0 && match) {
                strg = rs.getString("q4");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else {
                this.gq4 = this.gq4.toLowerCase();
            }
            if (match) break;
            this.genID = 0;
        }
        stmt.close();
        return this.genID;
    }

    private int getSpecies(boolean switchCase) throws SQLException {
        if (this.specID != 0) {
            return this.specID;
        }
        if (this.species.length() == 0) {
            return -1;
        }
        if (this.genID == 0) {
            return -2;
        }
        String sql = "SELECT spec_id, species, q1, q2, q3, sub_spec, q4, author, year ";
        if (this.SB.hasAlphaCode) {
            sql = sql + ",alphacode";
        }
        sql = sql + " FROM ";
        sql = sql + this.SB.DBTableName("SPECIES");
        sql = sql + " WHERE ucase(species)=" + util.SB.DBString(this.species.toUpperCase()) + " AND gen_id=" + this.genID;
        if (this.sq1.length() > 0) {
            sql = sql + " AND lcase(q1)='" + this.sq1.toLowerCase() + "'";
        }
        if (this.sq2.length() > 0) {
            sql = sql + " AND lcase(q2)='" + this.sq2.toLowerCase() + "'";
        }
        if (this.sq3.length() > 0) {
            sql = sql + " AND lcase(q3)='" + this.sq3.toLowerCase() + "'";
        }
        if (this.subSpecies.length() > 0) {
            sql = sql + " AND ucase(sub_spec)=" + util.SB.DBString(this.subSpecies.toUpperCase());
        }
        if (this.sq4.length() > 0) {
            sql = sql + " AND lcase(q4)='" + this.sq4.toLowerCase() + "'";
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            String strg;
            this.specID = rs.getInt("spec_id");
            boolean match = true;
            if (switchCase) {
                this.species = rs.getString("species");
            }
            if (this.sq1.length() == 0) {
                strg = rs.getString("q1");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else {
                this.sq1 = this.sq1.toLowerCase();
            }
            if (this.sq2.length() == 0 && match) {
                strg = rs.getString("q2");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else {
                this.sq2 = this.sq2.toLowerCase();
            }
            if (this.sq3.length() == 0 && match) {
                strg = rs.getString("q3");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else {
                this.sq3 = this.sq3.toLowerCase();
            }
            if (this.subSpecies.length() == 0 && match) {
                strg = rs.getString("sub_spec");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else if (this.subSpecies.length() > 0 && switchCase) {
                this.subSpecies = rs.getString("sub_spec");
            }
            if (this.sq4.length() == 0 && match) {
                strg = rs.getString("q4");
                if (strg != null && strg.trim().length() > 0) {
                    match = false;
                }
            } else {
                this.sq4 = this.sq4.toLowerCase();
            }
            if (match) {
                if (this.author == null || this.author.length() == 0) {
                    this.author = rs.getString("author");
                }
                if (this.year == 0) {
                    this.year = rs.getInt("year");
                }
                if (!this.SB.hasAlphaCode) break;
                this.alphaCode = rs.getString("alphacode");
                break;
            }
            this.specID = 0;
        }
        stmt.close();
        return this.specID;
    }

    private int addGenus(Statement stmt) throws SQLException, util.SBException, SBException {
        if (this.genID != 0) {
            return this.genID;
        }
        this.genID = Taxon.addGenus(stmt, this.SB, this.cat_mnem, this.genus, this.subGenus, this.gq1, this.gq2, this.gq3, this.gq4);
        return this.genID;
    }

    static int addGenus(Statement stmt, SBdb SB2, String catMnem, String genus, String subGenus, String gq1, String gq2, String gq3, String gq4) throws SQLException, util.SBException, SBException {
        int genID = SB2.nextControl("GEN_ID");
        String sql = "INSERT INTO " + SB2.DBTableName("GENUS");
        sql = sql + " ( cat_mnem, gen_id, genus";
        if (gq1.length() > 0) {
            sql = sql + ",q1";
        }
        if (gq2.length() > 0) {
            sql = sql + ",q2";
        }
        if (gq3.length() > 0) {
            sql = sql + ",q3";
        }
        if (subGenus.length() > 0) {
            sql = sql + ",sub_genus";
        }
        if (gq4.length() > 0) {
            sql = sql + ",q4";
        }
        sql = sql + ") VALUES ('";
        sql = sql + catMnem;
        sql = sql + "',";
        sql = sql + genID;
        sql = sql + "," + util.SB.DBString(genus);
        if (gq1.length() > 0) {
            sql = sql + ",'" + gq1 + "'";
        }
        if (gq2.length() > 0) {
            sql = sql + ",'" + gq2 + "'";
        }
        if (gq3.length() > 0) {
            sql = sql + ",'" + gq3 + "'";
        }
        if (subGenus.length() > 0) {
            sql = sql + "," + util.SB.DBString(subGenus);
        }
        if (gq4.length() > 0) {
            sql = sql + ",'" + gq4 + "'";
        }
        sql = sql + ")";
        if (stmt == null) {
            stmt = SB2.getDatabase().createStatement();
        }
        stmt.executeUpdate(SB2.modQuery(sql));
        return genID;
    }

    private int addSpecies(Statement stmt) throws SQLException, util.SBException, SBException {
        if (this.specID != 0) {
            return this.specID;
        }
        this.specID = this.SB.nextControl("SPEC_ID");
        String sql = "INSERT INTO " + this.SB.DBTableName("species") + " ( gen_id, species, spec_id ";
        if (this.sq1.length() > 0) {
            sql = sql + ",q1";
        }
        if (this.sq2.length() > 0) {
            sql = sql + ",q2";
        }
        if (this.sq3.length() > 0) {
            sql = sql + ",q3";
        }
        if (this.subSpecies.length() > 0) {
            sql = sql + ",sub_spec";
        }
        if (this.sq4.length() > 0) {
            sql = sql + ",q4";
        }
        if (this.author != null && this.author.length() > 0) {
            sql = sql + ",author";
        }
        if (this.year != 0) {
            sql = sql + ",year";
        }
        sql = sql + ",entered_by,created";
        sql = sql + ") VALUES (" + this.genID + "," + util.SB.DBString(this.species) + "," + this.specID;
        if (this.sq1.length() > 0) {
            sql = sql + ",'" + this.sq1 + "'";
        }
        if (this.sq2.length() > 0) {
            sql = sql + ",'" + this.sq2 + "'";
        }
        if (this.sq3.length() > 0) {
            sql = sql + ",'" + this.sq3 + "'";
        }
        if (this.subSpecies.length() > 0) {
            sql = sql + "," + util.SB.DBString(this.subSpecies);
        }
        if (this.sq4.length() > 0) {
            sql = sql + ",'" + this.sq4 + "'";
        }
        if (this.author != null && this.author.length() > 0) {
            sql = sql + "," + util.SB.DBString(this.author);
        }
        if (this.year != 0) {
            sql = sql + "," + this.year;
        }
        sql = sql + ",'" + this.SB.user.getUsrID() + "','" + databaseDate.format(new Date()) + "'";
        sql = sql + ")";
        if (stmt == null) {
            stmt = this.SB.getDatabase().createStatement();
        }
        stmt.executeUpdate(this.SB.modQuery(sql));
        return this.specID;
    }

    public void setQualifiers(String _gq1, String _gq2, String _gq3, String _gq4, String _sq1, String _sq2, String _sq3, String _sq4) throws SBException {
        this.gq1 = _gq1;
        this.gq2 = _gq2;
        this.gq3 = _gq3;
        this.gq4 = _gq4;
        this.sq1 = _sq1;
        this.sq2 = _sq2;
        this.sq3 = _sq3;
        this.sq4 = _sq4;
        this.qualchk();
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.toString(true, false, true);
    }

    public String toQuotedString(boolean useAuthor) {
        String strg = this.toString(useAuthor, false, false);
        if (strg.indexOf(44) >= 0) {
            if (strg.indexOf(34) >= 0) {
                strg.replace('\"', '\'');
            }
            strg = "\"" + strg + "\"";
        }
        return strg;
    }

    public String toString(boolean useAuthor, boolean useAlphaCode, boolean includeCat) {
        String name = this.toString(useAuthor, includeCat);
        if (useAlphaCode && this.alphaCode != null && this.alphaCode.length() > 0) {
            name = name + " (" + this.alphaCode + ")";
        }
        return name;
    }

    public String toString(boolean useAuthor) {
        return this.toString(useAuthor, false, true);
    }

    public String toString(boolean useAuthor, boolean includeCat) {
        String name = this.toGenusString(includeCat);
        if (this.species != null && this.species.length() > 0) {
            name = name + " ";
            if (this.sq1 != null && this.sq1.length() > 0) {
                name = name + this.sq1;
                if (!this.sq1.endsWith("\"")) {
                    name = name + " ";
                }
            }
            name = name + this.species;
            if (this.sq2 != null && this.sq2.length() > 0) {
                if (!this.sq2.startsWith("\"") && !this.sq2.startsWith("?")) {
                    name = name + " ";
                }
                name = name + this.sq2;
            }
        }
        name = name.trim();
        if (this.sq3 != null && this.sq3.length() > 0) {
            name = name + " ";
            name = name + this.sq3;
        }
        if (this.subSpecies != null && this.subSpecies.length() > 0) {
            if (!this.sq3.endsWith("\"")) {
                name = name + " ";
            }
            name = name + this.subSpecies;
        }
        if (this.sq4 != null && this.sq4.length() > 0) {
            if (!this.sq4.startsWith("\"") && !this.sq4.startsWith("?")) {
                name = name + " ";
            }
            name = name + this.sq4;
        }
        if (useAuthor) {
            if (this.author != null && this.author.length() > 0) {
                name = name + " " + this.author;
            }
            if (this.year != 0) {
                name = name + ", " + String.valueOf(this.year);
            }
        }
        if (name.length() == 0 && this.donorString != null && this.donorString.length() > 0) {
            name = this.donorString;
        }
        return name.trim();
    }

    private void checkNull() {
        if (this.cat_mnem == null) {
            this.cat_mnem = "";
        }
        if (this.gq1 == null) {
            this.gq1 = "";
        }
        if (this.gq2 == null) {
            this.gq2 = "";
        }
        if (this.gq3 == null) {
            this.gq3 = "";
        }
        if (this.gq4 == null) {
            this.gq4 = "";
        }
        if (this.sq1 == null) {
            this.sq1 = "";
        }
        if (this.sq2 == null) {
            this.sq2 = "";
        }
        if (this.sq3 == null) {
            this.sq3 = "";
        }
        if (this.sq4 == null) {
            this.sq4 = "";
        }
        if (this.genus == null) {
            this.genus = "";
        }
        if (this.subGenus == null) {
            this.subGenus = "";
        }
        if (this.species == null) {
            this.species = "";
        }
        if (this.subSpecies == null) {
            this.subSpecies = "";
        }
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int compareTo(Object rhs) {
        return this.compareTo((Taxon)rhs);
    }

    public int compareTo(Taxon rhs) {
        this.checkNull();
        rhs.checkNull();
        int result = this.genus.compareToIgnoreCase(rhs.genus);
        if (result != 0) {
            return result;
        }
        if (this.subGenus != null && (result = this.subGenus.compareToIgnoreCase(rhs.subGenus)) != 0) {
            return result;
        }
        result = this.species.compareToIgnoreCase(rhs.species);
        if (result != 0) {
            return result;
        }
        if (this.subSpecies != null && (result = this.subSpecies.compareToIgnoreCase(rhs.subSpecies)) != 0) {
            return result;
        }
        if (this.gq1 != null && (result = this.gq1.compareTo(rhs.gq1)) != 0) {
            return result;
        }
        if (this.gq2 != null && (result = this.gq2.compareTo(rhs.gq2)) != 0) {
            return result;
        }
        if (this.gq3 != null && (result = this.gq3.compareTo(rhs.gq3)) != 0) {
            return result;
        }
        if (this.gq4 != null && (result = this.gq4.compareTo(rhs.gq4)) != 0) {
            return result;
        }
        if (this.sq1 != null && (result = this.sq1.compareTo(rhs.sq1)) != 0) {
            return result;
        }
        if (this.sq2 != null && (result = this.sq2.compareTo(rhs.sq2)) != 0) {
            return result;
        }
        if (this.sq3 != null && (result = this.sq3.compareTo(rhs.sq3)) != 0) {
            return result;
        }
        if (this.sq4 != null) {
            result = this.sq4.compareTo(rhs.sq4);
        }
        return result;
    }

    public void qulord() throws SBException {
        String string = new String();
        String fldp = new String();
        block10: for (int i = 0; i < NQUAL; ++i) {
            fldp = this.getQualField(i);
            if (fldp.length() == 0) continue;
            string = "";
            boolean symFound = false;
            int sum = 0;
            for (int j = 0; j < MAXSYM && symord[i][j] >= 0; ++j) {
                if (fldp.indexOf(qulsym[symord[i][j]]) < 0) continue;
                if (mutexc[i][symord[i][j]] == 2) {
                    ++sum;
                }
                if (sum >= 2) {
                    throw new SBException("More than one mutually exclusive qualifier in field " + (i + 1));
                }
                if (string.length() > 0) {
                    string = string + " ";
                }
                string = string + qulsym[symord[i][j]];
                symFound = true;
            }
            if (!symFound) {
                throw new SBException("A incorrect or misplaced qualifier '" + fldp + "' was found in taxon: " + this);
            }
            switch (i + 1) {
                case 1: {
                    this.gq1 = string;
                    continue block10;
                }
                case 2: {
                    this.gq2 = string;
                    continue block10;
                }
                case 3: {
                    this.gq3 = string;
                    continue block10;
                }
                case 4: {
                    this.gq4 = string;
                    continue block10;
                }
                case 5: {
                    this.sq1 = string;
                    continue block10;
                }
                case 6: {
                    this.sq2 = string;
                    continue block10;
                }
                case 7: {
                    this.sq3 = string;
                    continue block10;
                }
                case 8: {
                    this.sq4 = string;
                }
            }
        }
    }

    public void qualchk() throws SBException {
        int iret;
        String fldp;
        int i;
        int ifound = 0;
        this.qulord();
        for (i = 0; i < NQUAL; ++i) {
            fldp = this.getQualField(i);
            if (fldp.indexOf(34) < 0) continue;
            if (ifound == 0) {
                if (preqal[i] > 0) {
                    ifound = 1;
                    iret = i;
                    continue;
                }
                throw new SBException("Unpaired quotes in qualifier " + (i + 1));
            }
            if (ifound == 1) {
                if (preqal[i] == 0) {
                    ifound = 2;
                    continue;
                }
                throw new SBException("Unpaired quotes in qualifier " + (i + 1));
            }
            if (ifound < 2) continue;
            throw new SBException("Too many paired quotes in qualifier " + (i + 1));
        }
        if (ifound == 1) {
            throw new SBException("Unpaired quote found in qualifiers");
        }
        ifound = 0;
        iret = 0;
        for (i = 0; i < NQUAL; ++i) {
            fldp = this.getQualField(i);
            if (fldp.indexOf(63) < 0) continue;
            ++ifound;
            iret = i;
        }
        if (ifound >= 4) {
            throw new SBException("Too many '?' in qualifiers");
        }
    }

    public String getQualField(int i) {
        String fldp;
        switch (i + 1) {
            default: {
                fldp = this.gq1;
                break;
            }
            case 2: {
                fldp = this.gq2;
                break;
            }
            case 3: {
                fldp = this.gq3;
                break;
            }
            case 4: {
                fldp = this.gq4;
                break;
            }
            case 5: {
                fldp = this.sq1;
                break;
            }
            case 6: {
                fldp = this.sq2;
                break;
            }
            case 7: {
                fldp = this.sq3;
                break;
            }
            case 8: {
                fldp = this.sq4;
            }
        }
        return fldp;
    }

    public int hashCode() {
        return this.specID;
    }

    public void setFssOccType(Fssabnd fss) throws util.SBException, SBException {
        if (this.donorOccType != null) {
            if (this.donorOccType.equalsIgnoreCase(REWORKED_OCC)) {
                fss.setReworked(true, false);
            } else if (this.donorOccType.equalsIgnoreCase(CAVED_OCC)) {
                fss.setCaved(true, false);
            } else if (this.donorOccType.equalsIgnoreCase(QUESTIONABLE_OCC)) {
                fss.setIdentType('?', false);
            }
        }
    }

    boolean setSpeciesQual(int field, String qual) throws SBException {
        boolean valid = false;
        String existingQual = this.getQualField(field);
        if (existingQual.indexOf(qual) > 0) {
            return false;
        }
        for (int j = 0; j < qulsym.length; ++j) {
            if (!qual.equals(qulsym[j])) continue;
            valid = true;
        }
        if (!valid) {
            throw new SBException("Invalid qualifier: " + qual + " passed to setSpeciesQual");
        }
        existingQual = existingQual == null || existingQual.length() == 0 ? qual : existingQual + " " + qual;
        this.setQualField(field, existingQual);
        this.qualchk();
        return true;
    }

    private void setQualField(int field, String qual) throws SBException {
        switch (field) {
            case 0: {
                this.gq1 = qual;
                break;
            }
            case 1: {
                this.gq2 = qual;
                break;
            }
            case 2: {
                this.gq3 = qual;
                break;
            }
            case 3: {
                this.gq4 = qual;
                break;
            }
            case 4: {
                this.sq1 = qual;
                break;
            }
            case 5: {
                this.sq2 = qual;
                break;
            }
            case 6: {
                this.sq3 = qual;
                break;
            }
            case 7: {
                this.sq4 = qual;
                break;
            }
            default: {
                throw new SBException("Invalid qualifier field: " + field + " passed to setQualField");
            }
        }
    }

    public void writeDEX(FileWriter out, String eol) throws IOException {
        out.write("Species = " + this.toString(true, false, true) + eol);
        out.write("   ID : " + this.getSpecID() + eol);
        out.write("   Category : " + this.cat_mnem + eol);
        if (this.gq1 != null && this.gq1.length() > 0) {
            out.write("   Pre-Genus qualifier : " + this.gq1 + eol);
        }
        out.write("   Genus : " + this.genus + eol);
        if (this.gq2 != null && this.gq2.length() > 0) {
            out.write("   Post-Genus qualifier : " + this.gq2 + eol);
        }
        if (this.gq3 != null && this.gq3.length() > 0) {
            out.write("   Pre-Subgenus qualifier : " + this.gq3 + eol);
        }
        if (this.subGenus != null && this.subGenus.length() > 0) {
            out.write("   Subgenus : " + this.subGenus + eol);
        }
        if (this.gq4 != null && this.gq4.length() > 0) {
            out.write("   Post-Subgenus qualifier : " + this.gq4 + eol);
        }
        if (this.sq1 != null && this.sq1.length() > 0) {
            out.write("   Pre-Species qualifier : " + this.sq1 + eol);
        }
        out.write("   Species : " + this.species + eol);
        if (this.sq2 != null && this.sq2.length() > 0) {
            out.write("   Post-Species qualifier : " + this.sq2 + eol);
        }
        if (this.sq3 != null && this.sq3.length() > 0) {
            out.write("   Pre-Subspecies qualifier : " + this.sq3 + eol);
        }
        if (this.subSpecies != null && this.subSpecies.length() > 0) {
            out.write("   Subspecies : " + this.subSpecies + eol);
        }
        if (this.sq4 != null && this.sq4.length() > 0) {
            out.write("   Post-Subspecies qualifier : " + this.sq4 + eol);
        }
        if (this.author != null && this.author.length() > 0) {
            out.write("   Author : " + this.author + eol);
        }
        if (this.year > 0) {
            out.write("   Year : " + this.year + eol);
        }
        if (this.numericCode > 0) {
            out.write("   Numeric Code : " + this.numericCode + eol);
        }
        if (this.alphaCode != null && this.alphaCode.length() > 0) {
            out.write("   Alphanumeric Code : " + this.alphaCode + eol);
        }
        out.write(eol);
    }

    public void writeSbugs(FileWriter out) throws IOException {
        out.write((this.specID != 0 ? String.valueOf(this.specID) : String.valueOf(this.donorID)) + '\t' + this.toString() + '\n');
        out.write(this.cat_mnem + '\t' + this.gq1 + '\t' + this.genus + '\t' + this.gq2 + '\t' + this.gq3 + '\t' + this.subGenus + '\t' + this.gq4 + '\t' + this.sq1 + '\t' + this.species + '\t' + this.sq2 + '\t' + this.sq3 + '\t' + this.subSpecies + '\t' + this.sq4 + '\t' + this.author + '\t');
        if (this.year > 0) {
            out.write(this.year);
        }
        out.write("\t\n");
    }

    public String getSipmCat(int sipmCode) throws SQLException {
        String sql = "SELECT cat_mnem FROM " + this.SB.DBTableName("sipmcat") + " WHERE lcode <=" + sipmCode + " AND uCode >=" + sipmCode;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            this.cat_mnem = rs.getString("cat_mnem");
        }
        stmt.close();
        return this.cat_mnem;
    }

    static void loadSipmCat(SBdb SB2, List sipmCat) throws SQLException {
        sipmCat.clear();
        String sql = "SELECT lcode,ucode,cat_mnem FROM " + SB2.DBTableName("sipmcat") + " ORDER BY lcode";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            Sipmcat sipmcat = new Sipmcat();
            sipmcat.lCode = rs.getInt("lcode");
            sipmcat.uCode = rs.getInt("ucode");
            sipmcat.catMnem = rs.getString("cat_mnem");
            sipmCat.add(sipmcat);
        }
        stmt.close();
    }

    static void loadSipmDict(SBdb SB2, List sipmDict) throws SQLException {
        sipmDict.clear();
        String sql = "SELECT ccode,txt FROM " + SB2.DBTableName("sipmdict") + " ORDER BY ccode";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            SipmDict sipmDictEntry = new SipmDict();
            sipmDictEntry.countryCode = rs.getInt("ccode");
            sipmDictEntry.text = rs.getString("txt");
            sipmDict.add(sipmDictEntry);
        }
        stmt.close();
    }

    public static String getSipmCat(int sipmCode, List sipmCat) {
        for (Sipmcat cat : sipmCat) {
            if (sipmCode > cat.uCode || sipmCode < cat.lCode) continue;
            return cat.catMnem;
        }
        if (sipmCode >= 80000000) {
            return "MP";
        }
        return "MM";
    }

    public static int getSipmDict(SBdb SB2, String sipmArea, List sipmDict) throws SQLException {
        SipmDict sipmDictEntry;
        Iterator it = sipmDict.iterator();
        int countryCode = 0;
        while (it.hasNext()) {
            sipmDictEntry = (SipmDict)it.next();
            if (sipmDictEntry.text.equalsIgnoreCase(sipmArea)) {
                return sipmDictEntry.countryCode;
            }
            countryCode = sipmDictEntry.countryCode;
        }
        sipmDictEntry = new SipmDict();
        sipmDictEntry.countryCode = countryCode + 1;
        sipmDictEntry.text = sipmArea;
        String sql = "INSERT INTO " + SB2.DBTableName("sipmdict") + "(ccode,txt) VALUES (" + sipmDictEntry.countryCode + "," + util.SB.DBString(sipmDictEntry.text) + ")";
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
        sipmDict.add(sipmDictEntry);
        return sipmDictEntry.countryCode;
    }

    void storeSipmCode() throws SQLException {
        String sql = "INSERT INTO " + this.SB.DBTableName("sipmcode") + "(spec_ID,ccode,sipm_code) VALUES (" + this.specID + "," + this.ccode + "," + this.numericCode + ")";
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public Taxon getPreferred(int synSch) throws SQLException, util.SBException, SBException {
        if (this.specID > 0) {
            return this.SB.getPreferredTerm(synSch, this.specID);
        }
        return null;
    }

    boolean hasOccurrences() throws SQLException {
        String sql = "SELECT count(spec_id) AS total FROM " + this.SB.DBTableName("FSSABND") + " WHERE spec_id=" + this.specID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        int nRows = 0;
        if (rs.next()) {
            nRows = rs.getInt("total");
        }
        stmt.close();
        return nRows > 0;
    }

    public boolean hasEvents() throws SQLException {
        String sql = "SELECT count(spec_id) AS total FROM " + this.SB.DBTableName("EVENTDIC") + " WHERE spec_id=" + this.specID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        int nRows = 0;
        if (rs.next()) {
            nRows = rs.getInt("total");
        }
        stmt.close();
        return nRows > 0;
    }

    public void getStats(int[] stats) throws SQLException {
        String sql = "SELECT status,ident_type,caved FROM " + this.SB.DBTableName("FSSABND") + " WHERE spec_id=" + this.specID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        for (int i = 0; i < stats.length; ++i) {
            stats[i] = 0;
        }
        while (rs.next()) {
            char status = util.SB.getDBChar(rs, "status");
            char identType = util.SB.getDBChar(rs, "ident_type");
            char caved = util.SB.getDBChar(rs, "caved");
            stats[0] = stats[0] + 1;
            if (status == 'R') {
                stats[2] = stats[2] + 1;
            } else {
                stats[1] = stats[1] + 1;
            }
            if (identType == '?') {
                stats[4] = stats[4] + 1;
            } else {
                stats[3] = stats[3] + 1;
            }
            if (caved == 'Y') {
                stats[5] = stats[5] + 1;
                continue;
            }
            stats[6] = stats[6] + 1;
        }
        stmt.close();
    }

    public int updateOcc(String field, char value) throws SQLException {
        String sql = "UPDATE " + this.SB.DBTableName("FSSABND") + " SET " + field + "='" + value + "' WHERE spec_id=" + this.specID;
        Statement stmt = this.SB.getDatabase().createStatement();
        int nUpdated = stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        return nUpdated;
    }

    void storeMatch(String sourceID, String donorString, String donorOccType, Statement stmt) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("TXLOAD") + " WHERE source_id='" + sourceID + "' AND ucase(txt)=" + util.SB.DBString(donorString.toUpperCase());
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "INSERT INTO " + this.SB.DBTableName("TXLOAD") + " (source_id,spec_id,txt";
        if (this.SB.hasTxLoadOccType) {
            sql = sql + ",occ_type";
        }
        sql = sql + ") VALUES('" + sourceID + "'," + this.specID + "," + util.SB.DBString(donorString);
        if (this.SB.hasTxLoadOccType) {
            sql = sql + "," + util.SB.DBString(donorOccType);
        }
        sql = sql + ")";
        stmt.executeUpdate(this.SB.modQuery(sql));
    }

    static void deleteSpecies(SBdb SB2, List specIDs, boolean delFss, ProgressBarMonitor prog) throws SQLException {
        PreparedStatement[] pStmt = new PreparedStatement[13];
        int n = 0;
        String sql = "DELETE FROM " + SB2.DBTableName("FSSABND") + " WHERE spec_id=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("AGES") + " WHERE spec_id=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("GROUPMBR") + " WHERE spec_id=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("IMAGE") + " WHERE spec_id=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("OVR_MAP") + " WHERE spec_id=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SIPMCODE") + " WHERE spec_id=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SYNONYMY") + " WHERE spec_id=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SYNONYMY") + " WHERE pref=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("TXDEPTH") + " WHERE spec_id=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("TXLOAD") + " WHERE spec_id=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("TXNOTES") + " WHERE spec_id=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("TXREFS") + " WHERE spec_id=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SPECIES") + " WHERE spec_id=?";
        pStmt[n++] = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
        if (prog != null) {
            prog.getProgressBar().setMinimum(0);
            prog.getProgressBar().setMaximum(specIDs.size());
        }
        int i = 0;
        Iterator it = specIDs.iterator();
        while (it.hasNext()) {
            int specID = (Integer)it.next();
            int n2 = n = delFss ? 0 : 1;
            while (n < pStmt.length) {
                pStmt[n].setInt(1, specID);
                pStmt[n].execute();
                ++n;
            }
            if (prog == null) continue;
            if (prog.getInterrupt()) {
                return;
            }
            prog.getProgressBar().setValue(i++);
        }
        for (n = 0; n < pStmt.length; ++n) {
            pStmt[n].close();
        }
    }

    static int deleteGenera(SBdb SB2) throws SQLException {
        String sql = "DELETE FROM " + SB2.DBTableName("GENUS") + " WHERE gen_id NOT IN (SELECT distinct gen_id FROM " + SB2.DBTableName("SPECIES") + ")";
        Statement stmt = SB2.getDatabase().createStatement();
        int nRows = stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
        return nRows;
    }

    public static List<Taxon> search(SBdb SB2, String catMnem, boolean includeSubCategories, String genus, String subGenus, String species, String subSpecies, String alphaCode, String gq1, String gq2, String gq3, String gq4, String sq1, String sq2, String sq3, String sq4) throws SQLException, util.SBException, SBException {
        String text;
        String sql = "SELECT spec_id FROM " + SB2.DBTableName("genus") + " g," + SB2.DBTableName("species") + " s WHERE s.gen_id=g.gen_id ";
        if (catMnem.length() > 0) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            sql = includeSubCategories ? sql + "g.cat_mnem like '" + catMnem + "%'" : sql + "g.cat_mnem='" + catMnem + "'";
        }
        if ((text = genus.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? sql + "ucase(g.genus) like '" + text + "'" : sql + "ucase(g.genus)='" + text + "'";
        }
        if ((text = subGenus.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? sql + "ucase(g.sub_genus) like '" + text + "'" : sql + "ucase(g.sub_genus)='" + text + "'";
        }
        if ((text = species.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? sql + "ucase(s.species) like '" + text + "'" : sql + "ucase(s.species)='" + text + "'";
        }
        if ((text = subSpecies.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? sql + "ucase(s.sub_spec) like '" + text + "'" : sql + "ucase(s.sub_spec)='" + text + "'";
        }
        if ((text = alphaCode.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? sql + "ucase(s.alphaCode) like '" + text + "'" : sql + "ucase(s.alphaCode)='" + text + "'";
        }
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        while (rs.next()) {
            Taxon taxon = SB2.getTaxon(rs.getInt("spec_id"));
            boolean toAdd = true;
            if (gq1 != null && !taxon.getGq1().equalsIgnoreCase(gq1)) {
                toAdd = false;
            }
            if (gq2 != null && !taxon.getGq2().equalsIgnoreCase(gq2)) {
                toAdd = false;
            }
            if (gq3 != null && !taxon.getGq2().equalsIgnoreCase(gq3)) {
                toAdd = false;
            }
            if (gq4 != null && !taxon.getGq2().equalsIgnoreCase(gq4)) {
                toAdd = false;
            }
            if (sq1 != null && !taxon.getSq1().equalsIgnoreCase(sq1)) {
                toAdd = false;
            }
            if (sq2 != null && !taxon.getSq2().equalsIgnoreCase(sq2)) {
                toAdd = false;
            }
            if (sq3 != null && !taxon.getSq2().equalsIgnoreCase(sq3)) {
                toAdd = false;
            }
            if (sq4 != null && !taxon.getSq2().equalsIgnoreCase(sq4)) {
                toAdd = false;
            }
            if (!toAdd) continue;
            resultList.add(taxon);
        }
        Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        stmt.close();
        return resultList;
    }

    public static void sort(List<Taxon> list, SortOrder order) {
        switch (order) {
            case SORT_GENUS: {
                Collections.sort(list, new TaxonCompareGenus(new TaxonCompareSpecies()));
                break;
            }
            case SORT_SPECIES: {
                Collections.sort(list, new TaxonCompareSpecies());
                break;
            }
            case SORT_CATEGORY: {
                Collections.sort(list, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
            }
        }
    }

    public static String toGenusCase(String strg) {
        strg = util.SB.capitalise(strg);
        return strg;
    }

    public static String toSpeciesCase(String strg) {
        if ((strg = strg.toLowerCase()).startsWith("sp.") || strg.startsWith("sp ") || strg.startsWith("var ")) {
            String upper = strg.substring(3);
            upper = upper.toUpperCase();
            strg = strg.substring(0, 3) + upper;
        }
        String[] replacers = new String[]{" spt", " rri", " ms"};
        for (int j = 0; j < replacers.length; ++j) {
            String replacer = replacers[j];
            int i = strg.indexOf(replacer + " ");
            if (i >= 0) {
                strg = strg.substring(0, i) + replacer.toUpperCase() + " " + strg.substring(i + replacer.length(), strg.length());
            }
            if (!strg.endsWith(replacer) || (i = strg.indexOf(replacer)) < 0) continue;
            strg = strg.substring(0, i) + replacer.toUpperCase();
        }
        return strg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortOrder {
        SORT_GENUS,
        SORT_SPECIES,
        SORT_CATEGORY;

    }
}

