/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.TreeSet;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Taxon;
import util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxGroup
extends Observable
implements Comparable {
    private SBdb SB;
    private String name;
    private String abr;
    private int ID;
    private Color colour = Color.WHITE;
    private Set<Integer> specIDs = null;

    TxGroup(SBdb SB2, int ID, String name, String abr) throws SQLException {
        this.SB = SB2;
        this.ID = ID;
        this.name = name == null ? "No name, ID=" + ID : name;
        this.abr = abr;
        this.loadColour();
    }

    TxGroup(SBdb SB2, String name, String abr) throws SQLException, SBException {
        this.SB = SB2;
        this.ID = SB2.nextControl("GRP_ID");
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "INSERT INTO " + SB2.DBTableName("TXGROUP") + " (grp_id,group_name,abr) VALUES (" + this.ID + "," + util.SB.DBString(name) + "," + util.SB.DBString(abr) + ")";
        stmt.executeUpdate(SB2.modQuery(sql));
        this.name = name;
        this.abr = abr;
        stmt.close();
    }

    public int getID() {
        return this.ID;
    }

    public int compareTo(Object rhs) {
        if (rhs.getClass() == TxGroup.class) {
            return this.compareTo((TxGroup)rhs);
        }
        return 0;
    }

    public int compareTo(TxGroup rhs) {
        return this.name.compareToIgnoreCase(rhs.name);
    }

    int getSize() throws SQLException {
        if (this.specIDs == null) {
            this.load();
        }
        return this.specIDs.size();
    }

    Set<Integer> getSpecIDs() throws SQLException {
        if (this.specIDs == null) {
            this.load();
        }
        return this.specIDs;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setColour(Color colour) throws SQLException {
        this.saveColour(colour);
        this.colour = colour;
        this.notifyObservers(colour);
    }

    void delete() throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("CATCOL") + " WHERE abr='" + this.ID + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("TXGROUP") + " WHERE grp_id=" + this.ID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public void setName(String newName) throws SQLException, SBException {
        String sql = "UPDATE " + this.SB.DBTableName("txgroup") + " SET group_name=" + util.SB.DBString(newName) + " WHERE grp_id=" + this.ID;
        Statement stmt = this.SB.getDatabase().createStatement();
        if (stmt.executeUpdate(this.SB.modQuery(sql)) != 1) {
            throw new SBException("Cannot update group: " + this.name);
        }
        this.name = newName;
        stmt.close();
        this.setChanged();
        this.notifyObservers(this.name);
    }

    public String getAbr() {
        if (this.abr != null) {
            return this.abr;
        }
        return "";
    }

    public SBdb getDatabase() throws SBException {
        if (this.SB == null) {
            throw new SBException("Null database pointer in class TxGroup");
        }
        return this.SB;
    }

    public Color getColour() {
        return this.colour;
    }

    private void loadColour() throws SQLException {
        if (this.ID == 0) {
            return;
        }
        String sql = "SELECT red,green,blue FROM " + this.SB.DBTableName("CATCOL") + " WHERE abr='" + this.ID + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            int red = rs.getInt("red");
            int green = rs.getInt("green");
            int blue = rs.getInt("blue");
            this.colour = new Color(red, green, blue);
        }
        stmt.close();
    }

    static void load(SBdb SB2, HashMap txGroups) throws SQLException {
        String sql = "SELECT grp_id, group_name, abr FROM " + SB2.DBTableName("TXGROUP") + " ORDER BY group_name";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int ID = rs.getInt("grp_id");
            if (SB2.getTxGroup(ID) != null) continue;
            TxGroup group = new TxGroup(SB2, ID, rs.getString("group_name"), rs.getString("abr"));
            txGroups.put(ID, group);
        }
        stmt.close();
    }

    public boolean isMember(int specID) throws SQLException {
        if (this.specIDs == null) {
            this.load();
        }
        return this.specIDs.contains(new Integer(specID));
    }

    public int getNtaxa() throws SQLException {
        if (this.specIDs == null) {
            this.load();
        }
        return this.specIDs.size();
    }

    public void addTaxa(List<Taxon> taxa) throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        for (Taxon taxon : taxa) {
            if (this.isMember(taxon.getSpecID())) continue;
            String sql = "INSERT INTO " + this.SB.DBTableName("GROUPMBR") + " (grp_id,spec_id) VALUES (";
            sql = sql + this.ID + "," + taxon.getSpecID() + ")";
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        for (Taxon taxon : taxa) {
            if (this.isMember(taxon.getSpecID())) continue;
            this.specIDs.add(taxon.getSpecID());
            this.setChanged();
        }
        stmt.close();
        this.notifyObservers();
    }

    public void deleteAllTaxa() throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.SB.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        if (this.specIDs.size() > 0) {
            this.specIDs.clear();
            this.setChanged();
        }
    }

    public void deleteTaxa(List<Taxon> taxa) throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        for (Taxon taxon : taxa) {
            if (!this.isMember(taxon.getSpecID())) {
                System.out.println("Taxon: " + taxon.getSpecID() + " to be deleted does not exist in group: " + this.ID);
            }
            String sql = "DELETE FROM " + this.SB.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID + " AND spec_id=" + taxon.getSpecID();
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        for (Taxon taxon : taxa) {
            if (!this.isMember(taxon.getSpecID())) continue;
            this.specIDs.remove(taxon.getSpecID());
            this.setChanged();
        }
        stmt.close();
        this.notifyObservers();
    }

    void removeSpecies(int specID) {
        if (this.specIDs != null) {
            try {
                if (this.isMember(specID)) {
                    this.specIDs.remove(specID);
                    this.setChanged();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    void insertSpecies(int specID) {
        if (this.specIDs != null) {
            try {
                if (!this.isMember(specID)) {
                    this.specIDs.add(specID);
                    this.setChanged();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    void load() throws SQLException {
        if (this.specIDs == null) {
            this.specIDs = new TreeSet<Integer>();
        }
        String sql = "SELECT spec_id FROM " + this.SB.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int specID = rs.getInt("spec_id");
            if (this.specIDs.contains(specID)) continue;
            this.specIDs.add(specID);
        }
        stmt.close();
    }

    void store() throws SQLException, SBException {
        String sql;
        Statement stmt = this.SB.getDatabase().createStatement();
        if (this.ID > 0) {
            sql = "DELETE FROM " + this.SB.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
            sql = "UPDATE " + this.SB.DBTableName("TXGROUP") + " SET group_name='" + this.name + "' WHERE grp_id=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        } else {
            this.ID = this.SB.nextControl("GRP_ID");
            sql = "INSERT INTO " + this.SB.DBTableName("TXGROUP") + " (grp_id,group_name) VALUES (" + this.ID + ",'" + this.name + "')";
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        Iterator<Integer> it = this.specIDs.iterator();
        while (it.hasNext()) {
            sql = "INSERT INTO " + this.SB.DBTableName("GROUPMBR") + " (spec_id,grp_id) VALUES (" + it.next() + "," + this.ID + ")";
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        stmt.close();
        this.setColour(this.colour);
    }

    void saveColour(Color colour) throws SQLException {
        if (colour == null) {
            return;
        }
        String sql = "DELETE FROM " + this.SB.DBTableName("CATCOL") + " WHERE abr='" + this.ID + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "INSERT INTO " + this.SB.DBTableName("CATCOL") + " (abr,red,green,blue) VALUES ('" + this.ID + "'," + colour.getRed() + "," + colour.getGreen() + "," + colour.getBlue() + ")";
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.setChanged();
    }

    public void writeDEX(FileWriter out, DecimalFormat nFormat, String eol, Hashtable taxa) throws IOException, SQLException, SBException {
        out.write("[SPECIES GROUP " + this.name + "]" + eol);
        out.write("  Name : " + this.name + eol);
        out.write("  Group ID : " + this.ID + eol);
        if (this.abr != null && this.abr.length() > 0) {
            out.write("  Abbreviation : " + this.abr + eol);
        }
        if (this.colour != null) {
            out.write("  Colour = " + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue());
        }
        out.write(eol);
        for (int specID : this.specIDs) {
            Taxon taxon = this.SB.getTaxon(specID);
            taxon.writeDEX(out, eol);
        }
        out.write(eol);
    }
}

