/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.TxGroup;
import util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxGroupSet {
    private int grpSetID;
    private String name;
    private SBdb SB;
    private Set<Integer> grpIDs = null;

    public TxGroupSet(TxGroupSet rhs) throws SQLException {
        if (rhs == null) {
            return;
        }
        this.grpSetID = rhs.grpSetID;
        this.name = rhs.name;
        this.grpIDs = rhs.grpIDs;
        this.SB = rhs.SB;
    }

    TxGroupSet(SBdb SB2, int ID, String name) {
        this.SB = SB2;
        this.grpSetID = ID;
        this.name = name;
    }

    TxGroupSet(SBdb SB2, String name, Set<Integer> groupIDs) throws SQLException, SBException {
        this.SB = SB2;
        this.name = name;
        this.grpIDs = groupIDs;
        this.store();
    }

    public List<TxGroup> getGroups() throws SQLException, SBException {
        if (this.grpIDs == null) {
            this.loadGroups();
        }
        LinkedList<TxGroup> groups = new LinkedList<TxGroup>();
        for (int grpId : this.grpIDs) {
            groups.add(this.SB.getTxGroup(grpId));
        }
        Collections.sort(groups);
        return groups;
    }

    public String toString() {
        return this.name;
    }

    public int getID() {
        return this.grpSetID;
    }

    public String getName() {
        return this.name;
    }

    void loadGroups() throws SQLException {
        if (this.grpSetID == 0) {
            return;
        }
        if (this.grpIDs == null) {
            this.grpIDs = new TreeSet<Integer>();
        }
        if (this.grpIDs.size() > 0) {
            return;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT grp_id FROM " + this.SB.DBTableName("SETMBR") + " WHERE grpset_id=" + this.grpSetID;
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int grpID = rs.getInt("grp_id");
            if (grpID <= 0) continue;
            this.grpIDs.add(grpID);
        }
        stmt.close();
    }

    boolean isMember(int specID) throws SBException, SQLException {
        if (this.grpIDs == null) {
            throw new SBException("Groups in set: " + this + " not loaded");
        }
        for (int grpID : this.grpIDs) {
            TxGroup group = this.SB.getTxGroup(grpID);
            if (group == null) {
                throw new SBException("Cannot find group, ID " + grpID + " in set " + this.name);
            }
            group.load();
            if (!group.isMember(specID)) continue;
            return true;
        }
        return false;
    }

    boolean isGroupMember(int grpID) throws SBException, SQLException {
        if (this.grpIDs == null) {
            throw new SBException("Groups in set: " + this + " not loaded");
        }
        return this.grpIDs.contains(grpID);
    }

    void delete() throws SQLException {
        if (this.grpSetID == 0) {
            return;
        }
        String sql = "DELETE FROM " + this.SB.DBTableName("GROUPSET") + " WHERE grpset_id=" + this.grpSetID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("SETMBR") + " WHERE grpset_id=" + this.grpSetID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("TXGROUP") + " SET grpset_id=0 WHERE grpset_id=" + this.grpSetID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public void update(String newName, Collection<TxGroup> groups) throws SQLException, SBException {
        String sql;
        if (this.grpSetID == 0) {
            throw new SBException("Cannot update null group set");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        if (!newName.equals(this.name)) {
            sql = "UPDATE " + this.SB.DBTableName("GROUPSET") + " SET group_set=" + util.SB.DBString(newName) + " WHERE grpset_id=" + this.grpSetID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        sql = "DELETE FROM " + this.SB.DBTableName("SETMBR") + " WHERE grpset_id=" + this.grpSetID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        for (TxGroup group : groups) {
            sql = "INSERT INTO " + this.SB.DBTableName("SETMBR") + " (grpset_id,grp_id) VALUES (" + this.grpSetID + "," + group.getID() + ")";
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        this.name = newName;
        this.grpIDs.clear();
        for (TxGroup group : groups) {
            this.grpIDs.add(group.getID());
        }
        stmt.close();
    }

    void store() throws SQLException, SBException {
        ResultSet rs;
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT group_set FROM " + this.SB.DBTableName("GROUPSET") + " WHERE ucase(group_set)=" + util.SB.DBString(this.name.toUpperCase());
        if (this.grpSetID > 0) {
            sql = sql + " AND grpset_id <> " + this.grpSetID;
        }
        if ((rs = stmt.executeQuery(this.SB.modQuery(sql))).next()) {
            stmt.close();
            throw new SBException("Group set name is not unique");
        }
        rs.close();
        if (this.grpSetID == 0) {
            this.grpSetID = this.SB.nextControl("GRPSET_ID");
            sql = "INSERT INTO " + this.SB.DBTableName("GROUPSET") + " (grpset_id,group_set) VALUES (" + this.grpSetID + "," + util.SB.DBString(this.name) + ")";
            stmt.executeUpdate(this.SB.modQuery(sql));
        } else {
            sql = "UPDATE " + this.SB.DBTableName("GROUPSET") + " SET group_set=" + util.SB.DBString(this.name) + " WHERE grpset_id=" + this.grpSetID;
            stmt.executeUpdate(this.SB.modQuery(sql));
            sql = "DELETE FROM " + this.SB.DBTableName("SETMBR") + " WHERE grpset_id=" + this.grpSetID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        for (int grpID : this.grpIDs) {
            sql = "INSERT INTO " + this.SB.DBTableName("SETMBR") + " (grpset_id,grp_id) VALUES (" + this.grpSetID + "," + grpID + ")";
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        stmt.close();
    }

    static void load(SBdb SB2, HashMap<Integer, TxGroupSet> sets) throws SQLException {
        sets.clear();
        String sql = "SELECT grpset_id,group_set FROM " + SB2.DBTableName("GROUPSET") + " order by group_set";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int grpSetID = rs.getInt("grpset_id");
            String name = rs.getString("group_set");
            TxGroupSet set = new TxGroupSet(SB2, grpSetID, name);
            sets.put(grpSetID, set);
        }
        stmt.close();
    }
}

