/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.StringTokenizer;
import model1_8.SBException;
import model1_8.SBdb;
import util.SB;

public class Userdef {
    private String name = "";
    private String usrid = "";
    private String sys_name = "";
    private String pwd = "";
    private char discID = (char)77;
    private int priv = 0;
    Color colour;
    SBdb sbdb = null;
    static boolean showName = false;
    public static final int STBROW = 1;
    public static final int STADDOCC = 2;
    public static final int STADDIGD = 4;
    public static final int STADDDIC = 8;
    public static final int STADDWELL = 16;
    public static final int STDELWELL = 32;
    public static final int STADDUSR = 64;
    public static final int STADDSPE = 128;
    public static final int STDELSPE = 256;
    public static final int STADDREF = 512;
    public static final int STEDITSCH = 1024;
    public static final int STCONTR = 2048;
    public static final int STIGDINF = 4096;
    public static final int STIMPORT = 8192;
    public static final int STEXPORT = 16384;

    public char getDiscID() {
        return this.discID;
    }

    public int getPriv() {
        return this.priv;
    }

    public Color getColour() {
        return this.colour;
    }

    public Userdef(SBdb model) {
        this.sbdb = model;
    }

    public Userdef() {
        assert (this.sbdb != null);
    }

    Userdef(String usrID, String name, String sysName, char discID, Color colour, String pwd, int priv, SBdb SB2) throws SQLException, SBException {
        this.sbdb = SB2;
        if (this.sbdb.getUser(usrID) != null) {
            throw new SBException("User: " + usrID + " already exists");
        }
        this.usrid = usrID;
        this.name = name;
        this.sys_name = sysName;
        this.colour = colour;
        this.priv = priv;
        this.discID = discID;
        this.pwd = pwd;
        this.sbdb.putUser(this);
    }

    public Userdef(SBdb SB2, String usrID, String name, String sysName, char discID, Color colour, String pwd, int priv) throws SQLException, SBException {
        this.sbdb = SB2;
        if (this.sbdb.getUser(usrID) != null) {
            throw new SBException("User: " + usrID + " already exists");
        }
        this.usrid = usrID;
        this.name = name;
        this.sys_name = sysName;
        this.colour = colour;
        this.priv = priv;
        this.discID = discID;
        if (pwd != null) {
            this.pwd = SB.crypt(true, "SBPW", pwd);
        }
        this.add();
        this.sbdb.putUser(this);
    }

    public void update(String usrID, String name, String sysName, char discID, Color colour, String pwd, int priv) throws SQLException, SBException {
        String oldUsrID = this.usrid;
        if (!usrID.equals(this.usrid)) {
            this.updateUsrid(usrID);
            this.sbdb.removeUser(oldUsrID);
            this.sbdb.putUser(this);
        }
        String sql = "UPDATE " + this.sbdb.DBTableName("USERDEF") + " SET name='" + name + "',usrid='" + usrID + "',sys_name='" + sysName + "',disc='" + discID + "',user_priv=" + priv;
        if (this.sbdb.hasUserColour) {
            sql = sql + ",colour='" + colour.getRed() + "," + colour.getGreen() + "," + colour.getBlue() + "'";
        }
        if (this.sbdb.hasUserPassword) {
            sql = sql + ",password='" + (pwd == null ? "NOPASSWORD" : SB.crypt(true, "SBPW", pwd)) + "'";
        }
        sql = sql + " WHERE usrid='" + oldUsrID + "'";
        Statement stmt = this.sbdb.getDatabase().createStatement();
        if (stmt.executeUpdate(this.sbdb.modQuery(sql)) != 1) {
            throw new SBException("Update statement failed: " + sql);
        }
        this.name = name;
        this.usrid = usrID;
        this.sys_name = sysName;
        this.colour = colour;
        this.priv = priv;
        this.discID = discID;
        this.pwd = pwd != null ? SB.crypt(true, "SBPW", pwd) : null;
    }

    public Userdef(SBdb sbdb, String userID) throws SQLException, SBException {
        this.sbdb = sbdb;
        String sql = "SELECT name,usrid,sys_name,disc,user_priv";
        if (sbdb.hasUserColour) {
            sql = sql + ",colour";
        }
        if (sbdb.hasUserPassword) {
            sql = sql + ",password";
        }
        sql = sql + " FROM " + sbdb.DBTableName("USERDEF") + " WHERE usrid='" + userID + "'";
        Statement stmt = sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        if (rs.next()) {
            this.getUserDetailsFromResultSet(rs);
        }
        stmt.close();
    }

    public void setShowName(boolean showName) {
        Userdef.showName = showName;
    }

    public String toString() {
        if (!showName) {
            return this.usrid;
        }
        String strg = this.name;
        strg = strg + " (" + this.usrid + ')';
        return strg;
    }

    public String getName() {
        return this.name;
    }

    public String getNameID() {
        return this.name + " (" + this.usrid + ")";
    }

    public String getUsrID() {
        return this.usrid;
    }

    public String getSysName() {
        return this.sys_name;
    }

    public String getPwd() {
        String retVal = null;
        if (this.pwd != null && !this.pwd.equals("NOPASSWORD") && this.pwd.length() > 2) {
            try {
                retVal = SB.crypt(false, "SBPW", this.pwd);
            }
            catch (NumberFormatException ex) {
                System.out.println("Cannot decrypt password for: " + this.toString() + ",password was: " + this.pwd);
            }
        }
        return retVal;
    }

    void store(boolean toAdd) throws SQLException, SBException {
        if (toAdd) {
            this.add();
        } else {
            String sql = "UPDATE " + this.sbdb.DBTableName("USERDEF") + " SET name='" + this.name + "',usrid='" + this.usrid + "',sys_name='" + this.sys_name + "',disc='" + this.discID + "',user_priv=" + this.priv;
            if (this.sbdb.hasUserColour) {
                sql = sql + ",colour='" + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + "'";
            }
            if (this.sbdb.hasUserPassword) {
                sql = sql + ",password='" + (this.pwd == null ? "NOPASSWORD" : this.pwd) + "'";
            }
            sql = sql + " WHERE usrid='" + this.usrid + "'";
            Statement stmt = this.sbdb.getDatabase().createStatement();
            if (stmt.executeUpdate(this.sbdb.modQuery(sql)) != 1) {
                throw new SBException("Update statement failed: " + sql);
            }
        }
    }

    private void add() throws SQLException {
        String sql = "INSERT INTO " + this.sbdb.DBTableName("USERDEF") + " (name,usrid,sys_name,disc,user_priv";
        if (this.sbdb.hasUserColour) {
            sql = sql + ",colour";
        }
        if (this.sbdb.hasUserPassword) {
            sql = sql + ",password";
        }
        sql = sql + ") VALUES ('" + this.name + "','" + this.usrid + "','" + this.sys_name + "','" + this.discID + "'," + this.priv;
        if (this.sbdb.hasUserColour) {
            if (this.colour == null) {
                this.colour = Color.BLACK;
            }
            sql = sql + ",'" + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + "'";
        }
        if (this.sbdb.hasUserPassword) {
            sql = sql + ",'" + (this.pwd == null ? "NOPASSWORD" : this.pwd) + "'";
        }
        sql = sql + ")";
        this.sbdb.getDatabase().createStatement().executeUpdate(this.sbdb.modQuery(sql));
    }

    public void updateUsrid(String newUsrid) throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.sbdb.DBTableName("LASTVAL") + " SET usrid='" + newUsrid + "' WHERE usrid='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("SAMPLES") + " SET modifier='" + newUsrid + "' WHERE modifier='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("SAMPLES") + " SET creator='" + newUsrid + "' WHERE creator='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("WELLS") + " SET usrid='" + newUsrid + "' WHERE usrid='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        if (this.sbdb.hasWellPerm) {
            sql = "UPDATE " + this.sbdb.DBTableName("WELLPERM") + " SET usrid='" + newUsrid + "' WHERE usrid='" + this.usrid + "'";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("WELLPERM") + " SET auth='" + newUsrid + "' WHERE auth='" + this.usrid + "'";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        if (this.sbdb.hasUserPerm) {
            sql = "UPDATE " + this.sbdb.DBTableName("USERPERM") + " SET usrid='" + newUsrid + "' WHERE usrid='" + this.usrid + "'";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        sql = "UPDATE " + this.sbdb.DBTableName("SBCHARTS") + " SET owner='" + newUsrid + "' WHERE owner='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("SBTEMPLT") + " SET owner='" + newUsrid + "' WHERE owner='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("SMPDTL") + " SET analyst='" + newUsrid + "' WHERE analyst='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("SMPDTL") + " SET modifier='" + newUsrid + "' WHERE modifier='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("FSSABND") + " SET analyst='" + newUsrid + "' WHERE analyst='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("SPECIES") + " SET entered_by='" + newUsrid + "' WHERE entered_by='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("IGD_SCH") + " SET creator='" + newUsrid + "' WHERE creator='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("IGD_ENV") + " SET modifier='" + newUsrid + "' WHERE modifier='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("IGD_DICT") + " SET creator='" + newUsrid + "' WHERE creator='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("IGD_BZON") + " SET modifier='" + newUsrid + "' WHERE modifier='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET modifier='" + newUsrid + "' WHERE modifier='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET top_analy='" + newUsrid + "' WHERE top_analy='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET base_analy='" + newUsrid + "' WHERE base_analy='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("BCMMNTS") + " SET analyst='" + newUsrid + "' WHERE analyst='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("EVENTDIC") + " SET creator='" + newUsrid + "' WHERE creator='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("CMPSTD") + " SET creator='" + newUsrid + "' WHERE creator='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        sql = "UPDATE " + this.sbdb.DBTableName("USERDEF") + " SET usrid='" + newUsrid + "' WHERE usrid='" + this.usrid + "'";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        this.usrid = newUsrid;
        stmt.close();
    }

    public boolean hasAnalyses() throws SQLException {
        String sql;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT DISTINCT (analyst) FROM " + this.sbdb.DBTableName("smpdtl") + " WHERE analyst='" + this.usrid + "'"));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT DISTINCT (analyst) FROM " + this.sbdb.DBTableName("fssabnd") + " WHERE analyst='" + this.usrid + "'";
        rs = stmt.executeQuery(this.sbdb.modQuery(sql));
        return rs.next();
    }

    public boolean hasIGD() throws SQLException {
        String sql;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT DISTINCT (top_analy) FROM " + this.sbdb.DBTableName("igd") + " WHERE top_analy='" + this.usrid + "'"));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT DISTINCT (base_analy) FROM " + this.sbdb.DBTableName("igd") + " WHERE base_analy='" + this.usrid + "'";
        rs = stmt.executeQuery(this.sbdb.modQuery(sql));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT DISTINCT (analyst) FROM " + this.sbdb.DBTableName("bcmmnts") + " WHERE analyst='" + this.usrid + "'";
        rs = stmt.executeQuery(this.sbdb.modQuery(sql));
        return rs.next();
    }

    public void delete() throws SQLException {
        String sql = "DELETE FROM " + this.sbdb.DBTableName("USERDEF") + " WHERE usrid='" + this.usrid + "'";
        this.sbdb.getDatabase().createStatement().executeUpdate(this.sbdb.modQuery(sql));
    }

    void getUserDetailsFromResultSet(ResultSet rs) throws SQLException, SBException {
        this.name = rs.getString("name");
        this.usrid = rs.getString("usrid");
        if (this.usrid == null) {
            throw new SBException("User ID is null for user: " + this.name);
        }
        this.sys_name = rs.getString("sys_name");
        String strg = rs.getString("disc");
        if (strg != null && strg.length() > 0) {
            this.discID = strg.charAt(0);
        }
        this.priv = rs.getInt("user_priv");
        if (this.sbdb.hasUserColour && (strg = rs.getString("colour")) != null && strg.length() > 0) {
            StringTokenizer tok = new StringTokenizer(strg, ",");
            try {
                this.colour = new Color(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()));
            }
            catch (Exception n) {
                this.colour = Color.BLACK;
            }
        }
        if (this.sbdb.hasUserPassword) {
            if (this.usrid == null) {
                System.out.println("Warning: USERDEF entry has no user ID");
            } else {
                this.pwd = rs.getString("password");
            }
        }
    }

    static void getUsers(SBdb SB2, List users) throws SQLException {
        String sql = "SELECT name,usrid,sys_name,disc,user_priv";
        if (SB2.hasUserColour) {
            sql = sql + ",colour";
        }
        if (SB2.hasUserPassword) {
            sql = sql + ",password";
        }
        sql = sql + " FROM " + SB2.DBTableName("USERDEF") + " ORDER BY usrid";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            Userdef user = new Userdef(SB2);
            try {
                user.getUserDetailsFromResultSet(rs);
                users.add(user);
            }
            catch (SBException sbe) {
                System.out.println("Warning: " + sbe.getMessage());
            }
        }
        stmt.close();
    }

    static String getName(List users, String usrid) {
        for (Userdef user : users) {
            if (!user.usrid.equalsIgnoreCase(usrid)) continue;
            return user.name;
        }
        return "(No name)";
    }

    static boolean checkUsrid(List users, String usrid) {
        for (Userdef user : users) {
            if (!user.usrid.equalsIgnoreCase(usrid)) continue;
            return true;
        }
        return false;
    }
}

