/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import model1_8.AbnScheme;
import model1_8.AnalystHeader;
import model1_8.Biocom;
import model1_8.Casing;
import model1_8.CasingPoint;
import model1_8.CoredInterval;
import model1_8.Cores;
import model1_8.DiscAnalyst;
import model1_8.EvProject;
import model1_8.GrainSizeList;
import model1_8.IGDInterval;
import model1_8.IGDIntervalEnv;
import model1_8.IGDIntervalZone;
import model1_8.InterpHdr;
import model1_8.Licence;
import model1_8.LithInterval;
import model1_8.LithQualifier;
import model1_8.Lithdesc;
import model1_8.Markers;
import model1_8.QSLOC;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import model1_8.SampleLithology;
import model1_8.SeismicMarker;
import model1_8.Smpdtl;
import model1_8.TVDList;
import model1_8.TVDepth;
import model1_8.TWTDepth;
import model1_8.TWTList;
import model1_8.Taxon;
import model1_8.Userdef;
import model1_8.WellEvent;
import model1_8.WellHeader;
import model1_8.WellInterp;
import util.MergeStatus;
import util.SB;
import util.SbugsStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Well
extends Observable
implements SbugsStatus,
Comparable {
    SBdb SB;
    public static final int SFACTOR = 65536;
    public static final int SORTDOWNHOLE = 0;
    public static final int SORTUPHOLE = 1;
    public static final int SORTALPHA = 3;
    DTMonitor[] dtMonitor = new DTMonitor[28];
    int wellID = 0;
    WellHeader header = new WellHeader();
    int environmentScheme = 1;
    List<Sample> samples = new LinkedList<Sample>();
    HashMap<Integer, Sample> defunctSamples;
    private boolean allSamplesLoaded = false;
    private boolean analysesLoaded = false;
    Map<String, AbnScheme> abn = new HashMap<String, AbnScheme>();
    List analystHeaders = new LinkedList();
    public List interps = new LinkedList();
    boolean interpsLoaded = false;
    List evProjects = new LinkedList();
    boolean evProjectsLoaded = false;
    String[] bzTitle = new String[]{"", "", "", ""};
    boolean bzTitlesLoaded = false;
    Vector lithIntervals = new Vector();
    Vector lithQualifiers = new Vector();
    GrainSizeList grainSize = new GrainSizeList();
    private Cores cores = null;
    private Casing casing = null;
    private Markers markers = null;
    private TVDList TVD = null;
    private TWTList TWT = null;
    boolean useDonorSamples = false;
    boolean useDonorTaxa = false;

    public SBdb getDataModel() {
        return this.SB;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    public String getWellName() {
        return this.header.getWellName();
    }

    public String getWellCode() {
        return this.header.getWellCode();
    }

    public char getType() {
        return this.header.getType();
    }

    public char getWellUnits() {
        return this.header.getWellUnits();
    }

    public double getTD() {
        return this.header.getTD();
    }

    public WellHeader getHeader() {
        return this.header;
    }

    public List getSamples() {
        return this.samples;
    }

    public String[] getBzTitles() throws SQLException {
        this.loadBzTitles();
        return this.bzTitle;
    }

    public Cores getCores() throws SQLException, SBException {
        if (this.cores == null) {
            this.cores = new Cores(this.SB);
            this.cores.load(this.wellCode());
        }
        return this.cores;
    }

    public Casing getCasing() throws SQLException, SBException {
        if (this.casing == null) {
            this.casing = new Casing(this.SB);
            this.casing.load(this.wellCode());
        }
        return this.casing;
    }

    public Markers getMarkers() throws SQLException, SBException {
        if (this.markers == null) {
            this.markers = new Markers(this.SB);
            this.markers.load(this.wellCode());
        }
        return this.markers;
    }

    void init() {
    }

    public TVDList getTVDlist() throws SQLException {
        if (this.TVD == null) {
            this.TVD = new TVDList(this.SB);
            this.TVD.load(this.wellCode());
        }
        return this.TVD;
    }

    public TWTList getTWTlist() throws SQLException {
        if (this.TWT == null) {
            this.TWT = new TWTList(this.SB);
            this.TWT.load(this.wellCode());
        }
        return this.TWT;
    }

    void removeInterp(WellInterp wellInterp) {
        if (this.interps.remove(wellInterp)) {
            this.setChanged();
        }
    }

    public WellInterp getInterp(int interpID) throws SBException {
        WellInterp thisInterp = null;
        for (int i = 0; i < this.interps.size(); ++i) {
            thisInterp = (WellInterp)this.interps.get(i);
            if (interpID != thisInterp.interpID) continue;
            return thisInterp;
        }
        throw new SBException("No interpretations found");
    }

    public WellInterp getAddInterp(int interpID, HashMap<Integer, InterpHdr> interpHdrs) throws SBException, SQLException {
        WellInterp thisInterp = null;
        for (int i = 0; i < this.interps.size(); ++i) {
            thisInterp = (WellInterp)this.interps.get(i);
            if (interpID != thisInterp.interpID) continue;
            return thisInterp;
        }
        thisInterp = new WellInterp(this.SB, interpID, interpHdrs, this.header.getType());
        this.interps.add(thisInterp);
        this.setChanged();
        this.notifyObservers(thisInterp);
        return thisInterp;
    }

    public WellInterp getAddInterp(InterpHdr interpHdr) throws SBException, SQLException {
        WellInterp thisInterp = null;
        for (int i = 0; i < this.interps.size(); ++i) {
            thisInterp = (WellInterp)this.interps.get(i);
            if (interpHdr.getInterpID() != thisInterp.interpID) continue;
            return thisInterp;
        }
        thisInterp = new WellInterp(this.SB, interpHdr.getInterpID(), this.SB.interpHdrs, this.header.getType());
        this.interps.add(thisInterp);
        this.setChanged();
        this.notifyObservers(thisInterp);
        return thisInterp;
    }

    boolean hasInterpLoaded(int interpID) {
        WellInterp thisInterp = null;
        for (int i = 0; i < this.interps.size(); ++i) {
            thisInterp = (WellInterp)this.interps.get(i);
            if (interpID != thisInterp.interpID) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.wellID;
    }

    @Override
    public Color getStatus() {
        if (this.header.getStatus() == UNKNOWN) {
            if (this.wellID != 0) {
                return STORED;
            }
            return NOTSTORED;
        }
        return this.header.getStatus();
    }

    AnalystHeader getAnalystHeader(String analyst, char discID, boolean load) throws SQLException {
        Iterator it = this.analystHeaders.iterator();
        AnalystHeader header = null;
        while (it.hasNext()) {
            AnalystHeader aHeader = (AnalystHeader)it.next();
            if (!analyst.equals(aHeader.analyst) || discID != aHeader.discID) continue;
            header = aHeader;
            break;
        }
        if (header == null && load) {
            header = new AnalystHeader(this.SB, analyst, discID);
            this.analystHeaders.add(header);
            if (this.wellID > 0) {
                header.load(this.wellID, analyst, discID);
            }
        }
        return header;
    }

    char getPrefUnits(char units) {
        if (units == 'D') {
            units = this.header.getWellUnits();
        }
        return units;
    }

    String wellCode() {
        return this.header.getWellCode();
    }

    char type() {
        return this.header.getType();
    }

    public void loadData(int dType, Lithdesc lithdesc, List envSchemes, HashMap<Integer, InterpHdr> interpHdrs) throws SQLException, SBException {
        if (this.dtMonitor[dType] == null) {
            throw new SBException("Data type monitor for : " + dType + " is null in Well.loadData");
        }
        if (this.dtMonitor[dType].status != UNKNOWN) {
            return;
        }
        switch (dType) {
            case 22: {
                this.loadSamples(lithdesc);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                this.loadSamples(lithdesc);
                this.loadSampleDetails(SBdb.dt2discID(dType), "", this.SB.getAbnSchemes());
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                this.loadInterps(interpHdrs);
                for (WellInterp interp : this.interps) {
                    interp.loadComments(SBdb.dt2discID(dType), this);
                    interp.fillSamples(this.samples, this.header.getWellUnits());
                }
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.loadInterps(interpHdrs);
                for (WellInterp interp : this.interps) {
                    interp.loadZones(IGDInterval.dType2IGDtype(dType), this.wellID, this);
                    interp.fillSamples(this.samples, this.header.getWellUnits());
                    interp.sortByDepth(IGDInterval.dType2IGDtype(dType));
                }
                break;
            }
            case 16: {
                this.loadInterps(interpHdrs);
                for (WellInterp interp : this.interps) {
                    interp.loadEnvs(this, envSchemes);
                    interp.fillSamples(this.samples, this.header.getWellUnits());
                    interp.sortEnvByDepth();
                }
                break;
            }
            case 17: {
                this.cores.load(this.wellCode());
                break;
            }
            case 18: {
                this.casing.load(this.wellCode());
                break;
            }
            case 21: {
                this.markers.load(this.wellCode());
                break;
            }
            case 23: {
                this.TVD.load(this.wellCode());
                break;
            }
            case 24: {
                this.TWT.load(this.wellCode());
                break;
            }
            case 19: {
                this.loadLithIntervals(this.lithIntervals, lithdesc);
                this.loadLithQualifiers(this.lithQualifiers, lithdesc);
                break;
            }
            case 26: {
                this.loadEvProjects();
                for (EvProject evProject : this.evProjects) {
                    evProject.load(this.wellID, null);
                    evProject.fillSamples(this.samples, this.header.getWellUnits(), this.header.getType());
                }
                break;
            }
        }
        this.loadBzTitles();
        this.refreshDataRange(dType);
    }

    void updateSampleAnalyst(boolean saveToDatabase, int sampID, char discID, String analyst, String newAnalyst) throws SQLException, SBException {
        if (saveToDatabase) {
            Statement stmt = this.SB.getDatabase().createStatement();
            String sql = "UPDATE " + this.SB.DBTableName("igd") + " SET top_analy='" + newAnalyst + "' WHERE top_id=" + sampID + " AND top_analy='" + analyst + "'";
            stmt.executeUpdate(this.SB.modQuery(sql));
            sql = "UPDATE " + this.SB.DBTableName("igd") + " SET base_analy='" + newAnalyst + "' WHERE base_id=" + sampID + " AND base_analy='" + analyst + "'";
            stmt.executeUpdate(this.SB.modQuery(sql));
            sql = "UPDATE " + this.SB.DBTableName("bcmmnts") + " SET analyst='" + newAnalyst + "' WHERE usamp_id=" + sampID + " AND disc_id='" + discID + "' AND analyst='" + analyst + "'";
            sql = "UPDATE " + this.SB.DBTableName("bcmmnts") + " SET analyst='" + newAnalyst + "' WHERE lsamp_id=" + sampID + " AND disc_id='" + discID + "' AND analyst='" + analyst + "'";
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        for (WellInterp interp : this.interps) {
            for (Biocom biocom : interp.comments) {
                if (biocom.getTopID() != sampID && biocom.getBaseID() != sampID || biocom.getDiscID() != discID || !biocom.getAnalyst().equals(analyst)) continue;
                throw new SBException("Can't update biocom analyst");
            }
            int[] igdVects = new int[]{41, 42, 43, 44};
            for (int i = 0; i < igdVects.length; ++i) {
                List igdVec = interp.getIGDList(igdVects[i]);
                for (IGDIntervalZone zone : igdVec) {
                    if (zone.getTopID() == sampID && zone.getTopAnalyst().equals(analyst)) {
                        throw new SBException("Can't update zonal analyst");
                    }
                    if (zone.getBaseID() != sampID || !zone.getBaseAnalyst().equals(analyst)) continue;
                    throw new SBException("Can't update zonal analyst");
                }
            }
        }
    }

    void loadBzTitles() throws SQLException {
        if (!this.bzTitlesLoaded) {
            if (this.wellID > 0) {
                String sql = "SELECT col_num,col_name FROM " + this.SB.DBTableName("IGD_BZON") + " WHERE well_id=" + this.wellID;
                Statement stmt = this.SB.getDatabase().createStatement();
                ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
                int colNum = 0;
                while (rs.next()) {
                    colNum = rs.getInt("col_num");
                    this.bzTitle[colNum] = rs.getString("col_name");
                }
            }
            this.bzTitlesLoaded = true;
        }
    }

    int getBzIGDTypeFromTitle(String title, boolean add) {
        int i;
        for (i = 0; i < this.bzTitle.length; ++i) {
            if (!this.bzTitle[i].equalsIgnoreCase(title)) continue;
            return 41 + i;
        }
        if (!add) {
            return -1;
        }
        for (i = 0; i < this.bzTitle.length; ++i) {
            if (this.bzTitle[i].length() != 0) continue;
            this.bzTitle[i] = title;
            return 41 + i;
        }
        return -1;
    }

    void storeBzTitles() throws SQLException {
        if (this.wellID > 0) {
            Statement stmt = this.SB.getDatabase().createStatement();
            int i = 0;
            while (true) {
                if (i >= 4) break;
                if (this.bzTitle[i].length() > 0) {
                    String sql = "DELETE FROM " + this.SB.DBTableName("IGD_BZON") + " WHERE well_id=" + this.wellID + " AND col_num=" + i;
                    stmt.executeUpdate(this.SB.modQuery(sql));
                    sql = "INSERT INTO " + this.SB.DBTableName("IGD_BZON") + " (well_id,igd_type,col_num,col_name) VALUES (" + this.wellID + ",4," + i + "," + util.SB.DBString(this.bzTitle[i]) + ")";
                    stmt.executeUpdate(this.SB.modQuery(sql));
                }
                ++i;
            }
            stmt.close();
        }
    }

    public void fillInterpCombo(JComboBox combo) {
        combo.removeAllItems();
        Iterator it = this.interps.iterator();
        while (it.hasNext()) {
            combo.addItem(it.next());
        }
    }

    public void loadInterps() throws SQLException, SBException {
        this.loadInterps(this.SB.interpHdrs);
    }

    public void loadInterp(WellInterp wellInterp) throws SQLException, SBException {
        wellInterp.load(this);
        this.loadSampleAges(wellInterp.interpID);
    }

    public void loadInterps(HashMap<Integer, InterpHdr> interpHdrs) throws SQLException, SBException {
        if (!this.interpsLoaded && this.wellID > 0) {
            String sql = "SELECT DISTINCT interp_id FROM " + this.SB.DBTableName("IGD") + " WHERE top_id>=" + this.wellID * 65536 + " AND top_id<" + (this.wellID + 1) * 65536;
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            int interpID = 0;
            while (rs.next()) {
                try {
                    interpID = rs.getInt("interp_id");
                    this.getInterp(interpID);
                }
                catch (SBException se) {
                    this.interps.add(new WellInterp(this.SB, interpID, interpHdrs, this.type()));
                }
            }
            sql = "SELECT DISTINCT interp_id FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE top_id>=" + this.wellID * 65536 + " AND top_id<" + (this.wellID + 1) * 65536;
            rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                try {
                    interpID = rs.getInt("interp_id");
                    this.getInterp(interpID);
                }
                catch (SBException se) {
                    this.interps.add(new WellInterp(this.SB, interpID, interpHdrs, this.type()));
                }
            }
            sql = "SELECT DISTINCT interp_id FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE usamp_id>=" + this.wellID * 65536 + " AND usamp_id<" + (this.wellID + 1) * 65536;
            rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                try {
                    interpID = rs.getInt("interp_id");
                    this.getInterp(interpID);
                }
                catch (SBException se) {
                    this.interps.add(new WellInterp(this.SB, interpID, interpHdrs, this.type()));
                }
            }
            this.interpsLoaded = true;
            stmt.close();
            this.getAddInterp(0, interpHdrs);
        }
    }

    void resetDataMonitors() {
        int i = 0;
        while (true) {
            if (i >= 28) break;
            this.dtMonitor[i] = null;
            ++i;
        }
    }

    void unloadData(int dType) throws SBException {
        if (this.dtMonitor[dType] == null) {
            return;
        }
        if (!this.dtMonitor[dType].hasData) {
            this.dtMonitor[dType] = null;
            return;
        }
        switch (dType) {
            case 22: {
                throw new SBException("Attempt to unload Samples data");
            }
            case 1: {
                this.unloadOccs('A');
                break;
            }
            case 3: {
                this.unloadOccs('M');
                break;
            }
            case 5: {
                this.unloadOccs('N');
                break;
            }
            case 7: {
                this.unloadOccs('P');
                break;
            }
            case 4: {
                this.unloadBCM('M');
                break;
            }
            case 6: {
                this.unloadBCM('N');
                break;
            }
            case 8: {
                this.unloadBCM('P');
                break;
            }
            case 2: {
                this.unloadBCM('A');
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.unloadIGD(IGDInterval.dType2IGDtype(dType));
                break;
            }
            case 19: {
                this.unloadLithology();
                break;
            }
            case 16: {
                this.unloadEnv();
                break;
            }
            case 17: {
                this.cores.clear();
                break;
            }
            case 18: {
                this.casing.clear();
                break;
            }
            case 21: {
                this.markers.clear();
                break;
            }
            case 26: {
                this.unloadEvents();
                break;
            }
            case 23: {
                this.unloadTVDs();
                break;
            }
            case 24: {
                this.unloadTWTs();
                break;
            }
            case 27: {
                this.unloadLOCs();
                break;
            }
            case 20: {
                break;
            }
            default: {
                throw new SBException("No status for data type: " + dType);
            }
        }
        this.dtMonitor[dType] = null;
    }

    void loadGrainSize() throws SQLException {
        if (this.wellID > 0 && this.grainSize.size() == 0) {
            this.grainSize.load(this.wellID);
        }
    }

    void unloadBCM(char discID) {
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = (WellInterp)this.interps.get(ni);
            Iterator<Biocom> it = in.comments.iterator();
            while (it.hasNext()) {
                Biocom comm = it.next();
                if (comm.getDiscID() != discID) continue;
                it.remove();
            }
        }
    }

    public SbugsStatus getDataRange(int dType, char units) throws SQLException, SBException {
        if (units == 'D') {
            units = this.header.getWellUnits();
        }
        if (this.dtMonitor[dType] == null) {
            this.dtMonitor[dType] = new DTMonitor();
            this.refreshDataRange(dType);
        }
        if (!this.dtMonitor[dType].hasData) {
            this.dtMonitor[dType].stringValue = "(No data)";
            this.dtMonitor[dType].status = UNKNOWN;
        } else {
            String range;
            this.dtMonitor[dType].stringValue = range = util.SB.getDepthString(this.dtMonitor[dType].depthFrom, units, 2) + " - " + util.SB.getDepthString(this.dtMonitor[dType].depthTo, units, 2);
        }
        this.prependBzTitles(this.dtMonitor[dType], dType);
        return this.dtMonitor[dType];
    }

    void prependBzTitles(DTMonitor monitor, int dType) throws SQLException {
        if (!this.bzTitlesLoaded) {
            this.loadBzTitles();
        }
        int colNum = -1;
        switch (dType) {
            case 12: {
                colNum = 0;
                break;
            }
            case 13: {
                colNum = 1;
                break;
            }
            case 14: {
                colNum = 2;
                break;
            }
            case 15: {
                colNum = 3;
            }
        }
        if (colNum >= 0 && this.bzTitle[colNum] != null) {
            monitor.stringValue = this.bzTitle[colNum] + " : " + monitor.stringValue;
        }
    }

    Color getDataStatus(int dType) throws SBException {
        if (this.dtMonitor[dType] != null) {
            return this.dtMonitor[dType].status;
        }
        return UNKNOWN;
    }

    void writeText(FileWriter out, int dType, char delim, char units) throws IOException, SBException {
        DecimalFormat nFormat = new DecimalFormat("#####0.0##");
        switch (dType) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                for (int ni = 0; ni < this.interps.size(); ++ni) {
                    WellInterp in = (WellInterp)this.interps.get(ni);
                    List vect = in.getIGDList(IGDInterval.dType2IGDtype(dType));
                    if (vect.size() <= 0) continue;
                    for (int i = 0; i < vect.size(); ++i) {
                        IGDIntervalZone zone = (IGDIntervalZone)vect.get(i);
                        out.write(this.header.getWellName() + delim + nFormat.format(zone.getTopSample().getDepth(units)) + delim + zone.getTopBnd() + delim + nFormat.format(zone.getBaseSample().getDepth(units)) + delim + zone.getBaseBnd() + delim + zone.toString() + "\r\n");
                    }
                }
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                for (int ni = 0; ni < this.interps.size(); ++ni) {
                    WellInterp in = (WellInterp)this.interps.get(ni);
                    List<Biocom> vect = in.comments;
                    if (vect.size() <= 0) continue;
                    for (int i = 0; i < vect.size(); ++i) {
                        Biocom comm = vect.get(i);
                        if (comm.getDiscID() != SBdb.dt2discID(dType)) continue;
                        out.write(this.header.getWellName() + delim + nFormat.format(comm.getTopSample().getDepth(units)) + delim + "-" + delim + nFormat.format(comm.getBaseSample() != null ? comm.getBaseSample().getDepth(units) : comm.getTopSample().getDepth(units)) + delim + "-" + delim + comm.getText().replace('\n', delim).replace('\r', ' ') + "\r\n");
                    }
                }
                break;
            }
            default: {
                throw new SBException("Export for data type: " + SBdb.dTypeNames[dType] + " is not currently supported");
            }
        }
    }

    String stripHydroName() {
        String name = this.header.getWellName();
        if (this.header.getWellName().lastIndexOf("_SUMLOG") > 0) {
            name = this.header.getWellName().substring(0, this.header.getWellName().lastIndexOf("_SUMLOG"));
        }
        if (name.lastIndexOf("/0") > 0) {
            name = name.substring(0, name.lastIndexOf("/0")) + "/" + name.substring(name.lastIndexOf("/0") + 2);
        }
        if (name.lastIndexOf("-0") > 0) {
            name = name.substring(0, name.lastIndexOf("-0")) + "-" + name.substring(name.lastIndexOf("-0") + 2);
        }
        return name;
    }

    void writeHydroText(FileWriter out, int dType) throws IOException, SBException {
        DecimalFormat nFormat = new DecimalFormat("###0.00000");
        char delim = ',';
        switch (dType) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                for (int ni = 0; ni < this.interps.size(); ++ni) {
                    WellInterp in = (WellInterp)this.interps.get(ni);
                    List vect = in.getIGDList(IGDInterval.dType2IGDtype(dType));
                    if (vect.size() <= 0) continue;
                    for (int i = 0; i < vect.size(); ++i) {
                        IGDIntervalZone zone = (IGDIntervalZone)vect.get(i);
                        out.write(nFormat.format(zone.getTopSample().getDepth('M')) + delim + zone.toString().toUpperCase() + "\r\n");
                    }
                }
                break;
            }
            default: {
                throw new SBException("Hydro export for data type: " + SBdb.dTypeNames[dType] + " is not currently supported");
            }
        }
    }

    void refreshDataRange(int dType) throws SQLException, SBException {
        DTMonitor monitor = this.dtMonitor[dType];
        monitor.status = DTMonitor.UNKNOWN;
        switch (dType) {
            case 22: {
                monitor.depthFrom = 99999.0;
                monitor.depthTo = -99999.0;
                boolean depthAssigned = false;
                if (this.samples.size() > 0 || this.wellID == 0) {
                    for (int i = 0; i < this.samples.size(); ++i) {
                        Sample sample = this.samples.get(i);
                        try {
                            double baseDepth = sample.getBaseDepth('M');
                            if (baseDepth < monitor.depthFrom) {
                                monitor.depthFrom = baseDepth;
                            }
                            if (baseDepth > monitor.depthTo) {
                                monitor.depthTo = baseDepth;
                            }
                        }
                        catch (SBException se) {
                            // empty catch block
                        }
                        try {
                            double topDepth = sample.getTopDepth('M');
                            if (topDepth < monitor.depthFrom) {
                                monitor.depthFrom = topDepth;
                            }
                            if (topDepth > monitor.depthTo) {
                                monitor.depthTo = topDepth;
                            }
                        }
                        catch (SBException se) {
                            // empty catch block
                        }
                        monitor.hasData = true;
                        monitor.status = MergeStatus.merge(monitor.status, sample.status);
                    }
                    break;
                }
                if (this.wellID <= 0) break;
                String sql = "SELECT max(depth) as maxtop,max(bot_depth) as maxbot,min(bot_depth) as minbot,min(depth) as mintop FROM " + this.SB.DBTableName("samples") + " WHERE samp_id>=" + this.wellID * 65536 + " AND samp_id < " + (this.wellID + 1) * 65536;
                sql = this.SB.modQuery(sql);
                Statement stmt = this.SB.getDatabase().createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                monitor.depthFrom = 99999.0;
                monitor.depthTo = -99999.0;
                if (rs.next()) {
                    double depth = rs.getDouble("maxtop");
                    monitor.depthTo = rs.getDouble("maxbot");
                    if (depth > monitor.depthTo) {
                        monitor.depthTo = depth;
                    }
                    depth = rs.getDouble("minbot");
                    monitor.depthFrom = rs.getDouble("mintop");
                    if (depth > 0.0 && depth < monitor.depthFrom) {
                        monitor.depthFrom = depth;
                    }
                    monitor.hasData = true;
                } else {
                    monitor.hasData = false;
                }
                stmt.close();
                break;
            }
            case 1: {
                this.refreshOccRange('A', monitor);
                break;
            }
            case 3: {
                this.refreshOccRange('M', monitor);
                break;
            }
            case 5: {
                this.refreshOccRange('N', monitor);
                break;
            }
            case 7: {
                this.refreshOccRange('P', monitor);
                break;
            }
            case 4: {
                this.refreshBCMRange('M', monitor);
                break;
            }
            case 6: {
                this.refreshBCMRange('N', monitor);
                break;
            }
            case 8: {
                this.refreshBCMRange('P', monitor);
                break;
            }
            case 2: {
                this.refreshBCMRange('A', monitor);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.refreshIGDRange(IGDInterval.dType2IGDtype(dType), monitor);
                break;
            }
            case 19: {
                this.refreshLithologyRange(monitor);
                break;
            }
            case 16: {
                this.refreshEnvRange(monitor);
                break;
            }
            case 17: {
                this.refreshCoreRange(monitor);
                break;
            }
            case 18: {
                this.refreshCasingRange(monitor);
                break;
            }
            case 21: {
                this.refreshMarkersRange(monitor);
                break;
            }
            case 26: {
                this.refreshEventsRange(monitor);
                break;
            }
            case 27: {
                this.refreshLOCRange(monitor);
                break;
            }
            case 23: {
                this.refreshTVDRange(monitor);
                break;
            }
            case 24: {
                this.refreshTWTRange(monitor);
                break;
            }
            case 20: {
                break;
            }
            case 25: {
                break;
            }
            default: {
                throw new SBException("No status for data type: " + dType);
            }
        }
        if (monitor.depthFrom > 99990.0 && monitor.depthTo < -99990.0) {
            monitor.depthFrom = 0.0;
            monitor.depthTo = 0.0;
            monitor.hasData = false;
        }
    }

    void unloadOccs(char discID) {
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            Iterator<Smpdtl> it = sample.analyses.iterator();
            while (it.hasNext()) {
                Smpdtl smpdtl = it.next();
                if (smpdtl.getDiscID() != discID) continue;
                it.remove();
            }
        }
    }

    void updateTaxonRef(Taxon donor, Taxon target) throws SBException {
        Iterator<Sample> i$ = this.samples.iterator();
        while (i$.hasNext()) {
            Sample o;
            Sample s = o = i$.next();
            for (Smpdtl od : s.analyses) {
                Smpdtl d = od;
                if (!d.updateTaxonRef(donor, target)) continue;
                d.notifyObservers();
            }
        }
    }

    void refreshOccRange(char discID, DTMonitor monitor) throws SQLException, SBException {
        monitor.depthFrom = 99999.0;
        monitor.depthTo = -99999.0;
        if (this.allSamplesLoaded || this.wellID == 0) {
            for (int i = 0; i < this.samples.size(); ++i) {
                Sample sample = this.samples.get(i);
                if (!sample.hasDisciplineData(discID)) continue;
                double depth = sample.getBaseDepth('M');
                double topDepth = sample.getTopDepth('M');
                if (depth < monitor.depthFrom) {
                    monitor.depthFrom = depth;
                }
                if (depth > monitor.depthTo) {
                    monitor.depthTo = depth;
                }
                if (topDepth < monitor.depthFrom) {
                    monitor.depthFrom = topDepth;
                }
                if (topDepth > monitor.depthTo) {
                    monitor.depthTo = topDepth;
                }
                monitor.hasData = true;
                monitor.status = MergeStatus.merge(monitor.status, sample.status);
            }
        } else if (this.wellID > 0) {
            String sql = "SELECT max(s.depth) as maxtop,max(s.bot_depth) as maxbot,min(s.bot_depth) as minbot,min(s.depth) as mintop FROM " + this.SB.DBTableName("samples") + " s," + this.SB.DBTableName("SMPDTL") + " d WHERE s.samp_id>=" + this.wellID * 65536 + " AND s.samp_id < " + (this.wellID + 1) * 65536 + " AND s.samp_id=d.samp_id" + " AND d.disc_id='" + discID + "'";
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                double depth = rs.getDouble("maxtop");
                monitor.depthTo = rs.getDouble("maxbot");
                if (depth > monitor.depthTo) {
                    monitor.depthTo = depth;
                }
                depth = rs.getDouble("minbot");
                monitor.depthFrom = rs.getDouble("mintop");
                if (depth > 0.0 && depth < monitor.depthFrom) {
                    monitor.depthFrom = depth;
                }
                monitor.hasData = true;
                if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                    monitor.hasData = false;
                }
            } else {
                monitor.hasData = false;
            }
            stmt.close();
        }
    }

    void refreshBCMRange(char discID, DTMonitor monitor) throws SQLException, SBException {
        monitor.depthFrom = 99999.0;
        monitor.depthTo = -99999.0;
        monitor.hasData = false;
        boolean hasDataLoaded = false;
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = (WellInterp)this.interps.get(ni);
            if (in.comments.size() <= 0) continue;
            for (int i = 0; i < in.comments.size(); ++i) {
                double topDepth;
                Biocom comment = in.comments.get(i);
                if (comment.getDiscID() != discID) continue;
                hasDataLoaded = true;
                double baseDepth = topDepth = comment.getTopSample().getDepth('M');
                if (comment.getBaseSample() != null) {
                    baseDepth = comment.getBaseSample().getDepth('M');
                }
                if (baseDepth < topDepth) {
                    baseDepth = topDepth;
                }
                if (topDepth < monitor.depthFrom) {
                    monitor.depthFrom = topDepth;
                }
                if (baseDepth > monitor.depthTo) {
                    monitor.depthTo = baseDepth;
                }
                monitor.hasData = true;
                monitor.status = MergeStatus.merge(monitor.status, comment.status);
            }
        }
        if (!hasDataLoaded && this.wellID > 0) {
            String sql = "SELECT max(s.depth) as maxtop,max(s.bot_depth) as maxbot,min(s.bot_depth) as minbot,min(s.depth) as mintop FROM " + this.SB.DBTableName("samples") + " s," + this.SB.DBTableName("BCMMNTS") + " b WHERE s.samp_id>=" + this.wellID * 65536 + " AND s.samp_id < " + (this.wellID + 1) * 65536 + " AND s.samp_id=b.usamp_id" + " AND b.disc_id='" + discID + "'";
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                double depth = rs.getDouble("maxtop");
                monitor.depthTo = rs.getDouble("maxbot");
                if (depth > monitor.depthTo) {
                    monitor.depthTo = depth;
                }
                depth = rs.getDouble("minbot");
                monitor.depthFrom = rs.getDouble("mintop");
                if (depth > 0.0 && depth < monitor.depthFrom) {
                    monitor.depthFrom = depth;
                }
                monitor.hasData = true;
                if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                    monitor.hasData = false;
                }
            } else {
                monitor.hasData = false;
            }
            stmt.close();
        }
    }

    void unloadEnv() {
        boolean hasDataLoaded = false;
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = (WellInterp)this.interps.get(ni);
            in.envs.clear();
        }
    }

    void refreshEnvRange(DTMonitor monitor) throws SQLException, SBException {
        monitor.depthFrom = 99999.0;
        monitor.depthTo = -99999.0;
        boolean hasDataLoaded = false;
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = (WellInterp)this.interps.get(ni);
            if (in.envs.size() <= 0) continue;
            for (int i = 0; i < in.envs.size(); ++i) {
                double topDepth;
                IGDIntervalEnv env = (IGDIntervalEnv)in.envs.get(i);
                hasDataLoaded = true;
                double baseDepth = topDepth = env.getTopSample().getDepth('M');
                if (env.getBaseSample() != null) {
                    baseDepth = env.getBaseSample().getDepth('M');
                }
                if (baseDepth < topDepth) {
                    baseDepth = topDepth;
                }
                if (topDepth < monitor.depthFrom) {
                    monitor.depthFrom = topDepth;
                }
                if (baseDepth > monitor.depthTo) {
                    monitor.depthTo = baseDepth;
                }
                monitor.hasData = true;
                monitor.status = MergeStatus.merge(monitor.status, env.status);
            }
        }
        if (!hasDataLoaded && this.wellID > 0) {
            String sql = "SELECT max(s.depth) as maxtop,max(s.bot_depth) as maxbot,min(s.bot_depth) as minbot,min(s.depth) as mintop FROM " + this.SB.DBTableName("samples") + " s," + this.SB.DBTableName("IGD_ENV") + " b WHERE s.samp_id>=" + this.wellID * 65536 + " AND s.samp_id < " + (this.wellID + 1) * 65536 + " AND s.samp_id=b.top_id";
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                double depth = rs.getDouble("maxtop");
                monitor.depthTo = rs.getDouble("maxbot");
                if (depth > monitor.depthTo) {
                    monitor.depthTo = depth;
                }
                depth = rs.getDouble("minbot");
                monitor.depthFrom = rs.getDouble("mintop");
                if (depth > 0.0 && depth < monitor.depthFrom) {
                    monitor.depthFrom = depth;
                }
                monitor.hasData = true;
                if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                    monitor.hasData = false;
                }
            } else {
                monitor.hasData = false;
            }
            stmt.close();
        }
    }

    void unloadLithology() {
        this.lithIntervals.clear();
        this.lithQualifiers.clear();
    }

    void refreshLithologyRange(DTMonitor monitor) throws SQLException {
        monitor.depthFrom = 99999.0;
        monitor.depthTo = -99999.0;
        boolean hasDataLoaded = false;
        Vector lithology = new Vector(this.lithIntervals);
        lithology.addAll(this.lithQualifiers);
        for (int i = 0; i < lithology.size(); ++i) {
            LithInterval lithInt = (LithInterval)lithology.get(i);
            hasDataLoaded = true;
            double topDepth = lithInt.topDepth;
            double baseDepth = lithInt.baseDepth;
            if (topDepth < monitor.depthFrom) {
                monitor.depthFrom = topDepth;
            }
            if (baseDepth > monitor.depthTo) {
                monitor.depthTo = baseDepth;
            }
            monitor.hasData = true;
            monitor.status = MergeStatus.merge(monitor.status, lithInt.status);
        }
        if (!hasDataLoaded && this.wellID > 0) {
            monitor.hasData = false;
            String sql = "SELECT min(top_depth) as mintop,max(base_depth) as maxbot FROM " + this.SB.DBTableName("sbilith") + " b WHERE well_id=" + this.wellID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.depthFrom = rs.getDouble("mintop");
                monitor.depthTo = rs.getDouble("maxbot");
                monitor.hasData = true;
                if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                    monitor.hasData = false;
                }
            }
            sql = "SELECT min(top_depth) as mintop,max(base_depth) as maxbot FROM " + this.SB.DBTableName("sbqlith") + " b WHERE well_id=" + this.wellID;
            rs = stmt.executeQuery(sql = this.SB.modQuery(sql));
            if (rs.next()) {
                double maxbot;
                double mintop = rs.getDouble("mintop");
                if (mintop < monitor.depthFrom) {
                    monitor.depthFrom = mintop;
                }
                if ((maxbot = rs.getDouble("maxbot")) > monitor.depthTo) {
                    monitor.depthTo = maxbot;
                }
                monitor.hasData = true;
                if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                    monitor.hasData = false;
                }
            }
            stmt.close();
        }
    }

    void refreshCoreRange(DTMonitor monitor) throws SQLException {
        monitor.depthFrom = 99999.0;
        monitor.depthTo = 0.0;
        boolean hasDataLoaded = false;
        for (int i = 0; i < this.cores.getSize(); ++i) {
            CoredInterval core = this.cores.getCore(i);
            hasDataLoaded = true;
            double topDepth = core.getTopDepth();
            double baseDepth = core.getBaseDepth();
            if (topDepth < monitor.depthFrom) {
                monitor.depthFrom = topDepth;
            }
            if (baseDepth > monitor.depthTo) {
                monitor.depthTo = baseDepth;
            }
            monitor.hasData = true;
            monitor.status = MergeStatus.merge(monitor.status, core.status);
        }
        if (!hasDataLoaded && this.wellID > 0) {
            String sql = "SELECT min(top_depth) as mintop,max(base_depth) as maxbot FROM " + this.SB.DBTableName("cores") + " b WHERE well_code='" + this.wellCode() + "'";
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.depthFrom = rs.getDouble("mintop");
                monitor.depthTo = rs.getDouble("maxbot");
                monitor.hasData = true;
                if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                    monitor.hasData = false;
                }
            } else {
                monitor.hasData = false;
            }
            stmt.close();
        }
    }

    void refreshCasingRange(DTMonitor monitor) throws SQLException {
        monitor.depthFrom = 99999.0;
        monitor.depthTo = 0.0;
        boolean hasDataLoaded = false;
        for (int i = 0; i < this.casing.getSize(); ++i) {
            CasingPoint casingPoint = this.casing.getCasingPoint(i);
            hasDataLoaded = true;
            double depth = casingPoint.getDepth();
            if (depth < monitor.depthFrom) {
                monitor.depthFrom = depth;
            }
            if (depth > monitor.depthTo) {
                monitor.depthTo = depth;
            }
            monitor.hasData = true;
            monitor.status = MergeStatus.merge(monitor.status, casingPoint.status);
        }
        if (!hasDataLoaded && this.wellID > 0) {
            String sql = "SELECT min(depth) as mintop,max(depth) as maxbot FROM " + this.SB.DBTableName("casing") + " b WHERE well_code='" + this.wellCode() + "'";
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.depthFrom = rs.getDouble("mintop");
                monitor.depthTo = rs.getDouble("maxbot");
                monitor.hasData = true;
                if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                    monitor.hasData = false;
                }
            } else {
                monitor.hasData = false;
            }
            stmt.close();
        }
    }

    void refreshMarkersRange(DTMonitor monitor) throws SQLException {
        monitor.depthFrom = 99999.0;
        monitor.depthTo = 0.0;
        boolean hasDataLoaded = false;
        for (int i = 0; i < this.markers.getSize(); ++i) {
            SeismicMarker marker = this.markers.get(i);
            hasDataLoaded = true;
            double depth = marker.getDepth();
            if (depth < monitor.depthFrom) {
                monitor.depthFrom = depth;
            }
            if (depth > monitor.depthTo) {
                monitor.depthTo = depth;
            }
            monitor.hasData = true;
            monitor.status = MergeStatus.merge(monitor.status, marker.status);
        }
        if (!hasDataLoaded && this.wellID > 0) {
            String sql = "SELECT min(depth) as mintop,max(depth) as maxbot FROM " + this.SB.DBTableName("wellsmark") + " b WHERE well_code='" + this.wellCode() + "'";
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.depthFrom = rs.getDouble("mintop");
                monitor.depthTo = rs.getDouble("maxbot");
                monitor.hasData = true;
                if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                    monitor.hasData = false;
                }
            } else {
                monitor.hasData = false;
            }
            stmt.close();
        }
    }

    void refreshTVDRange(DTMonitor monitor) throws SQLException {
        monitor.depthFrom = 99999.0;
        monitor.depthTo = 0.0;
        boolean hasDataLoaded = false;
        for (int i = 0; i < this.TVD.getSize(); ++i) {
            TVDepth tvd = this.TVD.get(i);
            hasDataLoaded = true;
            double depth = tvd.getDDepth();
            if (depth < monitor.depthFrom) {
                monitor.depthFrom = depth;
            }
            if (depth > monitor.depthTo) {
                monitor.depthTo = depth;
            }
            monitor.hasData = true;
            monitor.status = this.wellID > 0 ? STORED : NOTSTORED;
        }
        if (!hasDataLoaded && this.wellID > 0) {
            String sql = "SELECT min(ddepth) as mintop,max(ddepth) as maxbot FROM " + this.SB.DBTableName("welltvd") + " b WHERE well_code='" + this.wellCode() + "'";
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.depthFrom = rs.getDouble("mintop");
                monitor.depthTo = rs.getDouble("maxbot");
                monitor.hasData = true;
                if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                    monitor.hasData = false;
                }
                monitor.status = UNKNOWN;
            } else {
                monitor.hasData = false;
            }
            stmt.close();
        }
    }

    void refreshTWTRange(DTMonitor monitor) throws SQLException {
        if (this.SB.hasTWT) {
            monitor.depthFrom = 99999.0;
            monitor.depthTo = 0.0;
            boolean hasDataLoaded = false;
            for (int i = 0; i < this.TWT.getSize(); ++i) {
                TWTDepth twt = this.TWT.get(i);
                hasDataLoaded = true;
                double depth = twt.getDepth();
                if (depth < monitor.depthFrom) {
                    monitor.depthFrom = depth;
                }
                if (depth > monitor.depthTo) {
                    monitor.depthTo = depth;
                }
                monitor.hasData = true;
                monitor.status = this.wellID > 0 ? STORED : NOTSTORED;
            }
            if (!hasDataLoaded && this.wellID > 0) {
                String sql = "SELECT min(ddepth) as mintop,max(ddepth) as maxbot FROM " + this.SB.DBTableName("welltwt") + " b WHERE well_code='" + this.wellCode() + "'";
                sql = this.SB.modQuery(sql);
                Statement stmt = this.SB.getDatabase().createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    monitor.depthFrom = rs.getDouble("mintop");
                    monitor.depthTo = rs.getDouble("maxbot");
                    monitor.hasData = true;
                    if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                        monitor.hasData = false;
                    }
                    monitor.status = UNKNOWN;
                } else {
                    monitor.hasData = false;
                }
                stmt.close();
            }
        }
    }

    void unloadIGD(int igdType) {
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = (WellInterp)this.interps.get(ni);
            List vect = in.getIGDList(igdType);
            vect.clear();
        }
    }

    void refreshIGDRange(int igdType, DTMonitor monitor) throws SQLException, SBException {
        monitor.depthFrom = 99999.0;
        monitor.depthTo = -99999.0;
        boolean hasDataLoaded = false;
        for (int ni = 0; ni < this.interps.size(); ++ni) {
            WellInterp in = (WellInterp)this.interps.get(ni);
            List vect = in.getIGDList(igdType);
            if (vect.size() <= 0) continue;
            for (int i = 0; i < vect.size(); ++i) {
                double topDepth;
                IGDInterval zone = (IGDInterval)vect.get(i);
                hasDataLoaded = true;
                double baseDepth = topDepth = zone.getTopSample().getDepth('M');
                if (zone.getBaseSample() != null) {
                    baseDepth = zone.getBaseSample().getDepth('M');
                }
                if (baseDepth < topDepth) {
                    baseDepth = topDepth;
                }
                if (topDepth < monitor.depthFrom) {
                    monitor.depthFrom = topDepth;
                }
                if (baseDepth > monitor.depthTo) {
                    monitor.depthTo = baseDepth;
                }
                monitor.hasData = true;
                monitor.status = MergeStatus.merge(monitor.status, zone.status);
            }
        }
        if (!hasDataLoaded && this.wellID > 0) {
            String sql = "SELECT max(s.depth) as maxtop,max(s.bot_depth) as maxbot,min(s.bot_depth) as minbot,min(s.depth) as mintop FROM " + this.SB.DBTableName("samples") + " s," + this.SB.DBTableName("igd") + " i WHERE s.samp_id>=" + this.wellID * 65536 + " AND s.samp_id < " + (this.wellID + 1) * 65536 + " AND i.igd_type=" + igdType + " AND (s.samp_id=i.top_id" + " OR s.samp_id=i.base_id)";
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                double depth = rs.getDouble("maxtop");
                monitor.depthTo = rs.getDouble("maxbot");
                if (depth > monitor.depthTo) {
                    monitor.depthTo = depth;
                }
                depth = rs.getDouble("minbot");
                monitor.depthFrom = rs.getDouble("mintop");
                if (depth > 0.0 && depth < monitor.depthFrom) {
                    monitor.depthFrom = depth;
                }
                monitor.hasData = true;
                if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                    monitor.hasData = false;
                }
            } else {
                monitor.hasData = false;
            }
            stmt.close();
        }
    }

    void unloadEvents() {
        for (int ni = 0; ni < this.evProjects.size(); ++ni) {
            EvProject in = (EvProject)this.evProjects.get(ni);
            in.events.clear();
        }
    }

    void unloadLOCs() {
        for (int ni = 0; ni < this.evProjects.size(); ++ni) {
            EvProject in = (EvProject)this.evProjects.get(ni);
            in.LOCs.clear();
        }
    }

    void unloadTVDs() {
        this.TVD.clear();
    }

    void unloadTWTs() {
        this.TWT.clear();
    }

    void refreshEventsRange(DTMonitor monitor) throws SQLException, SBException {
        monitor.depthFrom = 99999.0;
        monitor.depthTo = -99999.0;
        boolean hasDataLoaded = false;
        for (int ni = 0; ni < this.evProjects.size(); ++ni) {
            EvProject in = (EvProject)this.evProjects.get(ni);
            List list = in.events;
            Iterator it = in.events.iterator();
            while (it.hasNext()) {
                WellEvent event = (WellEvent)it.next();
                if (event.sample == null) {
                    System.out.println("Warning: null sample found for event: " + event + " in well: " + this);
                    it.remove();
                    continue;
                }
                hasDataLoaded = true;
                double depth = event.sample.getDepth('M');
                if (depth < monitor.depthFrom) {
                    monitor.depthFrom = depth;
                }
                if (depth > monitor.depthTo) {
                    monitor.depthTo = depth;
                }
                monitor.hasData = true;
                monitor.status = MergeStatus.merge(monitor.status, event.status);
            }
        }
        if (!hasDataLoaded && this.wellID > 0) {
            String sql = "SELECT max(s.depth) as maxtop,max(s.bot_depth) as maxbot,min(s.bot_depth) as minbot,min(s.depth) as mintop FROM " + this.SB.DBTableName("samples") + " s," + this.SB.DBTableName("events") + " e WHERE s.samp_id>=" + this.wellID * 65536 + " AND s.samp_id < " + (this.wellID + 1) * 65536 + " AND s.samp_id=e.samp_id";
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                double depth = rs.getDouble("maxtop");
                monitor.depthTo = rs.getDouble("maxbot");
                if (depth > monitor.depthTo) {
                    monitor.depthTo = depth;
                }
                depth = rs.getDouble("minbot");
                monitor.depthFrom = rs.getDouble("mintop");
                if (depth > 0.0 && depth < monitor.depthFrom) {
                    monitor.depthFrom = depth;
                }
                monitor.hasData = true;
                if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                    monitor.hasData = false;
                }
            } else {
                monitor.hasData = false;
            }
            stmt.close();
        }
    }

    void refreshLOCRange(DTMonitor monitor) throws SQLException {
        monitor.depthFrom = 99999.0;
        monitor.depthTo = -99999.0;
        boolean hasDataLoaded = false;
        for (int ni = 0; ni < this.evProjects.size(); ++ni) {
            EvProject in = (EvProject)this.evProjects.get(ni);
            List list = in.LOCs;
            if (list.size() <= 0) continue;
            for (int i = 0; i < list.size(); ++i) {
                QSLOC loc = (QSLOC)list.get(i);
                hasDataLoaded = true;
                double depth = loc.getDepth1();
                if (depth < monitor.depthFrom) {
                    monitor.depthFrom = depth;
                }
                if (depth > monitor.depthTo) {
                    monitor.depthTo = depth;
                }
                if ((depth = loc.getDepth2()) > monitor.depthTo) {
                    monitor.depthTo = depth;
                }
                if (depth < monitor.depthFrom) {
                    monitor.depthFrom = depth;
                }
                monitor.hasData = true;
                monitor.status = MergeStatus.merge(monitor.status, loc.status);
            }
        }
        if (!hasDataLoaded && this.wellID > 0) {
            String sql = "SELECT max(depth1) as max1,max(depth2) as max2,min(depth1) as min1,min(depth2) as min2 FROM " + this.SB.DBTableName("qsloc") + " WHERE well_id=" + this.wellID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                monitor.depthTo = rs.getDouble("max1");
                double depth = rs.getDouble("max2");
                if (depth > monitor.depthTo) {
                    monitor.depthTo = depth;
                }
                monitor.depthFrom = rs.getDouble("min1");
                depth = rs.getDouble("min2");
                if (depth < monitor.depthFrom) {
                    monitor.depthFrom = depth;
                }
                monitor.hasData = true;
                if (monitor.depthFrom == 0.0 && monitor.depthTo == 0.0) {
                    monitor.hasData = false;
                }
            } else {
                monitor.hasData = false;
            }
            stmt.close();
        }
    }

    public Well(SBdb SB2) throws SQLException {
        this.SB = SB2;
        this.init();
    }

    public Well(SBdb SB2, int i) throws SQLException, SBException {
        this.SB = SB2;
        this.wellID = i;
        this.init();
        this.header.load(SB2, this.wellID);
    }

    public Well(SBdb SB2, int i, boolean loadSamp, boolean loadFss, Lithdesc lithdesc) throws SQLException, SBException {
        this.SB = SB2;
        this.wellID = i;
        this.init();
        this.header.load(SB2, this.wellID);
        this.interps.add(new InterpHdr(SB2, 0));
        if (loadSamp) {
            this.loadSamples(lithdesc);
        }
    }

    public int compareTo(Object o) {
        Well rhs = (Well)o;
        return this.header.compareTo(rhs.header);
    }

    Sample getSample(double topDepth, double baseDepth, String type, boolean useAnyType) {
        if (!useAnyType && type == null) {
            type = "CU";
        }
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            try {
                if (!useAnyType && !sample.getType().equals(type) || !(Math.abs(topDepth - sample.getTopDepth('M')) < 0.003048) || !(Math.abs(baseDepth - sample.getBaseDepth('M')) < 0.003048)) continue;
                return sample;
            }
            catch (SBException se) {
                // empty catch block
            }
        }
        return null;
    }

    Sample getTopSample(double topDepth, String type, boolean useAnyType) {
        if (!useAnyType && type == null) {
            type = "CU";
        }
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            try {
                if (!useAnyType && !sample.getType().equals(type) || !(Math.abs(topDepth - sample.getTopDepth('M')) < 0.003048)) continue;
                return sample;
            }
            catch (SBException se) {
                // empty catch block
            }
        }
        return null;
    }

    public void deleteSample(Sample sample) throws SQLException {
        sample.delete();
        this.samples.remove(sample);
        this.setChanged();
    }

    public boolean hasSampleIGD(Sample sample) throws SQLException {
        Iterator it = this.interps.iterator();
        int sampID = sample.getSampID();
        while (it.hasNext()) {
            WellInterp in = (WellInterp)it.next();
            for (int i = 0; i < in.zoneTypes.length; ++i) {
                List vect = in.zoneTypes[i];
                for (IGDInterval zone : vect) {
                    if (zone.getTopSample() == sample || zone.getBaseSample() == sample) {
                        return true;
                    }
                    if (sampID > 0 && zone.topID > 0 && sampID == zone.topID) {
                        return true;
                    }
                    if (sampID <= 0 || zone.baseID <= 0 || sampID != zone.baseID) continue;
                    return true;
                }
            }
            for (Biocom biocom : in.comments) {
                if (biocom.getTopSample() == sample || biocom.getBaseSample() == sample) {
                    return true;
                }
                if (sampID > 0 && biocom.getTopID() > 0 && sampID == biocom.getTopID()) {
                    return true;
                }
                if (sampID <= 0 || biocom.getBaseID() <= 0 || sampID != biocom.getBaseID()) continue;
                return true;
            }
        }
        if (sample.hasAgeData()) {
            return true;
        }
        if (sample.lithology.size() > 0) {
            return true;
        }
        for (EvProject project : this.evProjects) {
            for (WellEvent event : project.events) {
                if (event.sample == sample) {
                    return true;
                }
                if (event.sampID <= 0 || sampID <= 0 || event.sampID != sampID) continue;
                return true;
            }
        }
        return sample.hasIGDdataInDB();
    }

    public Sample getSample(int sampID) {
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            if (sample.getSampID() != sampID) continue;
            return sample;
        }
        if (this.defunctSamples != null) {
            return this.defunctSamples.get(sampID);
        }
        return null;
    }

    public AbnScheme fillAbnScheme(List abnSchemes, char discID, boolean useDefault) throws SQLException {
        AbnScheme abnScheme;
        String sql = "SELECT disc_id, sch_abn FROM " + this.SB.DBTableName("WELLABN") + " WHERE well_id=" + this.wellID;
        if (discID != '\u0000') {
            sql = sql + " AND disc_id='" + discID + "'";
        }
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        int abnID = 0;
        if (discID == '\u0000') {
            this.abn.clear();
        }
        while (rs.next()) {
            String discIDstrg = rs.getString("disc_id");
            abnID = rs.getInt("sch_abn");
            if (abnID <= 0) continue;
            abnScheme = AbnScheme.get(abnSchemes, abnID, 0);
            if (abnScheme == null) {
                abnScheme = new AbnScheme(this.SB, abnID);
                if (abnScheme.getID() > 0 || abnID == 0) {
                    abnSchemes.add(abnScheme);
                } else {
                    abnScheme = null;
                }
            }
            if (this.abn.get(discIDstrg) != null || abnScheme == null) continue;
            this.abn.put(discIDstrg, abnScheme);
        }
        stmt.close();
        if (abnID > 0 && discID != '\u0000') {
            return AbnScheme.get(abnSchemes, abnID, 0);
        }
        if (discID != '\u0000' && useDefault) {
            abnID = 1;
            abnScheme = AbnScheme.get(abnSchemes, abnID, 0);
            if (abnScheme == null) {
                abnScheme = new AbnScheme(this.SB, abnID);
                if (abnScheme.getID() > 0 || abnID == 0) {
                    abnSchemes.add(abnScheme);
                } else {
                    abnScheme = null;
                }
            }
            if (this.abn.get("" + discID) == null && abnScheme != null) {
                this.abn.put("" + discID, abnScheme);
            }
            return abnScheme;
        }
        return null;
    }

    public Sample addSample(double topDepth, double baseDepth, String sampleType, String label) throws SBException, SQLException {
        Sample sample = new Sample(this.SB, this.type(), topDepth, baseDepth, sampleType, label);
        this.addSample(sample);
        return sample;
    }

    public void updateSample(Sample sample, double topDepth, double baseDepth, String sampleType, String label) throws SBException, SQLException {
        boolean depthChanged = false;
        boolean detailsChanged = false;
        if (Math.abs(sample.getTopDepth('M') - topDepth) > 0.01 || Math.abs(sample.getBaseDepth('M') - baseDepth) > 0.01) {
            depthChanged = true;
        }
        if (!sampleType.equals(sample.getType()) || !label.equals(sample.getLabel())) {
            detailsChanged = true;
        }
        if (depthChanged || detailsChanged) {
            sample.update(topDepth, baseDepth, sampleType, label);
        }
        if (depthChanged) {
            this.samples.remove(sample);
            Sample.insert(this.samples, sample, this.getWellUnits());
            this.setChanged();
        }
    }

    public void loadSamples(Lithdesc lithdesc) throws SQLException, SBException {
        try {
            if (this.dtMonitor[22] == null) {
                this.dtMonitor[22] = new DTMonitor();
            }
            if (!this.allSamplesLoaded & this.wellID > 0) {
                String sql = "SELECT samp_id,depth,bot_depth,type,grid_x,grid_y,created,creator,modified,modifier,label";
                sql = sql + " FROM " + this.SB.DBTableName("SAMPLES") + " WHERE samp_id >=" + this.wellID * 65536 + " AND samp_id<" + (this.wellID + 1) * 65536;
                sql = sql + " ORDER BY bot_depth, depth, type, samp_id";
                sql = this.SB.modQuery(sql);
                Statement stmt = this.SB.getDatabase().createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                this.allSamplesLoaded = true;
                String strg = null;
                while (rs.next()) {
                    int sampID = rs.getInt("samp_id");
                    double topDepth = rs.getDouble("depth");
                    double baseDepth = rs.getDouble("bot_depth");
                    if (this.header.getWellUnits() == 'F') {
                        double baseDepthF;
                        double topDepthF = (double)Math.round(topDepth / 0.3048 * 100.0) / 100.0;
                        if (Math.abs(topDepth - topDepthF * 0.3048) > 9.0E-4) {
                            topDepth = topDepthF * 0.3048;
                        }
                        if (Math.abs(baseDepth - (baseDepthF = (double)Math.round(baseDepth / 0.3048 * 100.0) / 100.0) * 0.3048) > 9.0E-4) {
                            baseDepth = baseDepthF * 0.3048;
                        }
                    }
                    String sampleType = rs.getString("type");
                    int gridX = rs.getInt("grid_x");
                    int gridY = rs.getInt("grid_y");
                    Date created = rs.getDate("created");
                    String creator = rs.getString("creator");
                    Date modified = rs.getDate("modified");
                    String modifier = rs.getString("modifier");
                    strg = rs.getString("label");
                    Sample sample = new Sample(this.SB, this.type(), sampID, topDepth, baseDepth, sampleType, gridX, gridY, created, creator, modified, modifier, strg);
                    boolean exists = false;
                    boolean diff = false;
                    for (int i = 0; i < this.samples.size(); ++i) {
                        Sample exist = this.samples.get(i);
                        if (sample.compareTo(exist) != 0) continue;
                        if (exist.getSampID() != sample.getSampID() && exist.getSampID() > 0) {
                            System.out.println("Warning: Duplicate sample for well: " + this + ", sample: " + sample + ", ID: " + sample.getSampID() + " Original sample ID: " + exist.getSampID());
                            if (exist.alternativeIDs == null) {
                                exist.alternativeIDs = new LinkedList();
                            }
                            exist.alternativeIDs.add(new Integer(sample.getSampID()));
                            if (this.defunctSamples == null) {
                                this.defunctSamples = new HashMap();
                            }
                            this.defunctSamples.put(sample.getSampID(), exist);
                        }
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    sample.status = STORED;
                    Sample.insert(this.samples, sample, this.header.getWellUnits());
                }
                stmt.close();
                if (lithdesc != null) {
                    this.loadSampleLithology(lithdesc);
                }
                this.loadSampleAges(0);
            }
            this.dtMonitor[22].status = UNKNOWN;
            for (int i = 0; i < this.samples.size(); ++i) {
                Sample sample = this.samples.get(i);
                this.dtMonitor[22].status = MergeStatus.merge(this.dtMonitor[22].status, sample.status);
            }
        }
        catch (SBException se) {
            throw new SBException("Well : " + this + ". Loading samples:" + se.getMessage());
        }
    }

    public double getMinAge() {
        double age = 99999.0;
        for (Sample o : this.samples) {
            Sample s = o;
            if (!(s.getAge() < age)) continue;
            age = s.getAge();
        }
        if (age > 1000.0) {
            age = 0.0;
        }
        return age;
    }

    public double getMaxAge() {
        double age = 0.0;
        for (Sample o : this.samples) {
            Sample s = o;
            if (!(s.getAge() > age)) continue;
            age = s.getAge();
        }
        return age;
    }

    public void loadSampleAges(int interpID) throws SQLException, SBException {
        String sql = "SELECT samp_id,age,age_below,ageplus,ageminus,ratio FROM " + this.SB.DBTableName("SBSSR") + " WHERE samp_id>=" + this.wellID * 65536 + " AND samp_id<" + (this.wellID + 1) * 65536;
        if (this.SB.hasSrInterp) {
            sql = interpID == 0 ? sql + " AND (interp_id IS NULL OR interp_id=0)" : sql + " AND interp_id=" + interpID;
        }
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            Sample sample = this.getSample(sampID);
            if (sample != null) {
                double age = rs.getDouble("age");
                double ageBelow = rs.getDouble("age_below");
                double ageErrorPlus = rs.getDouble("ageplus");
                double ageErrorMinus = rs.getDouble("ageminus");
                double ratio = rs.getDouble("ratio");
                sample.setAge(age, ageBelow, ageErrorPlus, ageErrorMinus, ratio);
                continue;
            }
            System.out.println("Cannot find sample: " + sampID + " in loadSampleAges");
        }
        stmt.close();
    }

    public void deleteSampleAges(int interpID) throws SQLException, SBException {
        String sql = "DELETE FROM " + this.SB.DBTableName("SBSSR") + " WHERE samp_id>=" + this.wellID * 65536 + " AND samp_id<" + (this.wellID + 1) * 65536;
        if (this.SB.hasSrInterp) {
            sql = interpID == 0 ? sql + " AND (interp_id IS NULL OR interp_id=0)" : sql + " AND interp_id=" + interpID;
        }
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(sql);
        for (Sample o : this.samples) {
            Sample sample = o;
            if (!sample.hasAgeData()) continue;
            sample.removeAgeData();
        }
        stmt.close();
    }

    public double getTopSampleDepth() throws SBException {
        if (this.samples.size() > 0) {
            Sample sample = this.samples.get(0);
            return sample.getDepth('M');
        }
        return 0.0;
    }

    public double getBaseSampleDepth() throws SBException {
        if (this.samples.size() > 0) {
            Sample sample = this.samples.get(this.samples.size() - 1);
            return sample.getDepth('M');
        }
        return 0.0;
    }

    void loadSampleLithology(Lithdesc lithdesc) throws SQLException, SBException {
        String sql = "SELECT samp_id,lith_id,percnt FROM " + this.SB.DBTableName("SBSLITH") + " WHERE samp_id>=" + this.wellID * 65536 + " AND samp_id<" + (this.wellID + 1) * 65536 + " ORDER BY samp_id";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        int lastID = 0;
        Sample sample = null;
        while (rs.next()) {
            int lithID;
            int sampID = rs.getInt("samp_id");
            if (sampID != lastID) {
                sample = this.getSample(sampID);
                if (sample == null) {
                    throw new SBException("Cannot find sample: " + sampID + " in loadSampleAges");
                }
                sample.lithology.clear();
                lastID = sampID;
            }
            if ((lithID = rs.getInt("lith_id")) == 0) continue;
            SampleLithology lith = new SampleLithology(this.SB, lithdesc.getLithology(lithID), rs.getInt("percnt"));
            sample.lithology.add(lith);
        }
        stmt.close();
    }

    void loadSampleDetails(char discID, String analyst, List abnSchemes) throws SQLException, SBException {
        for (Sample sample : this.samples) {
            sample.loadDetails(discID, analyst);
            if (!sample.hasDisciplineData(discID)) continue;
            if (this.dtMonitor[SBdb.did2dtype(discID)] == null) {
                this.dtMonitor[SBdb.did2dtype((char)discID)] = new DTMonitor();
            }
            this.dtMonitor[SBdb.did2dtype((char)discID)].status = MergeStatus.merge(this.dtMonitor[SBdb.did2dtype((char)discID)].status, sample.getAnySmpdtl((char)discID, (String)analyst).status);
        }
        this.fillAbnScheme(abnSchemes, discID, true);
    }

    void loadHeader() throws SQLException, SBException {
        if (this.wellID == 0) {
            return;
        }
        this.header.load(this.SB, this.wellID);
    }

    @Override
    public String statusString() {
        return this.header.statusString();
    }

    public String toString() {
        return this.header.toString();
    }

    void updateStatus(boolean checkSamples, Lithdesc lithdesc, List envSchemes) throws SQLException, SBException {
        int iProj;
        DTMonitor monitor;
        boolean oldDataLoaded;
        Observable oldData;
        this.updateHeaderStatus();
        this.updateSampleStatus(checkSamples);
        for (int i = 0; i < this.interps.size(); ++i) {
            WellInterp interpretation = (WellInterp)this.interps.get(i);
            oldData = new WellInterp(this.SB, interpretation.interpID, this.SB.interpHdrs, this.type());
            for (int list = 0; list < interpretation.zoneTypes.length; ++list) {
                List igdList = interpretation.zoneTypes[list];
                oldDataLoaded = false;
                int igdType = WellInterp.zoneType2IGDType(list);
                monitor = this.dtMonitor[IGDInterval.igdType2dType(igdType)];
                if (i == 0 && monitor != null) {
                    monitor.status = UNKNOWN;
                }
                for (int iZone = 0; iZone < igdList.size(); ++iZone) {
                    if (monitor == null) {
                        this.getDataRange(IGDInterval.igdType2dType(igdType), this.header.getWellUnits());
                        monitor = this.dtMonitor[IGDInterval.igdType2dType(igdType)];
                    } else {
                        monitor.hasData = true;
                    }
                    if (!oldDataLoaded && this.wellID != 0) {
                        ((WellInterp)oldData).loadZones(igdType, this.wellID, this);
                        ((WellInterp)oldData).fillSamples(this.samples, this.header.getWellUnits());
                        oldDataLoaded = true;
                    }
                    IGDIntervalZone zone = (IGDIntervalZone)igdList.get(iZone);
                    if (monitor == null) continue;
                    if (this.wellID != 0) {
                        zone.updateStatus(((WellInterp)oldData).getIGDList(igdType));
                    } else {
                        zone.updateStatus(igdList);
                    }
                    monitor.status = MergeStatus.merge(monitor.status, zone.getStatus());
                }
                if (monitor == null || !monitor.hasData) continue;
                this.refreshDataRange(IGDInterval.igdType2dType(igdType));
            }
            int disc = 0;
            while (true) {
                if (disc >= 4) break;
                char discID = SBdb.discArr[disc];
                List<Biocom> comments = interpretation.comments;
                oldDataLoaded = false;
                monitor = this.dtMonitor[SBdb.did2comType(discID)];
                if (monitor != null) {
                    monitor.status = UNKNOWN;
                }
                for (int iComm = 0; iComm < comments.size(); ++iComm) {
                    Biocom comment;
                    if (monitor == null) {
                        this.getDataRange(SBdb.did2comType(discID), this.header.getWellUnits());
                        monitor = this.dtMonitor[SBdb.did2comType(discID)];
                    } else {
                        monitor.hasData = true;
                    }
                    if (!oldDataLoaded) {
                        ((WellInterp)oldData).loadComments(discID, this);
                        ((WellInterp)oldData).fillSamples(this.samples, this.header.getWellUnits());
                        oldDataLoaded = true;
                    }
                    if ((comment = comments.get(iComm)).getDiscID() != discID || monitor == null) continue;
                    if (this.wellID != 0) {
                        comment.updateStatus(((WellInterp)oldData).comments);
                    } else {
                        comment.updateStatus(comments);
                    }
                    monitor.status = MergeStatus.merge(monitor.status, comment.getStatus());
                }
                if (monitor != null && monitor.hasData) {
                    this.refreshDataRange(SBdb.did2comType(discID));
                }
                ++disc;
            }
            if (envSchemes == null) continue;
            oldDataLoaded = false;
            monitor = this.dtMonitor[16];
            if (i == 0 && monitor != null) {
                monitor.status = UNKNOWN;
            }
            for (int iEnv = 0; iEnv < interpretation.envs.size(); ++iEnv) {
                if (monitor == null) {
                    this.getDataRange(16, this.header.getWellUnits());
                    monitor = this.dtMonitor[16];
                } else {
                    monitor.hasData = true;
                }
                if (!oldDataLoaded && this.wellID != 0) {
                    ((WellInterp)oldData).loadEnvs(this, envSchemes);
                    ((WellInterp)oldData).fillSamples(this.samples, this.header.getWellUnits());
                    oldDataLoaded = true;
                }
                IGDIntervalEnv env = (IGDIntervalEnv)interpretation.envs.get(iEnv);
                if (monitor == null) continue;
                if (this.wellID != 0) {
                    env.updateStatus(((WellInterp)oldData).envs);
                } else {
                    env.updateStatus(interpretation.envs);
                }
                monitor.status = MergeStatus.merge(monitor.status, env.getStatus());
            }
            if (monitor == null || !monitor.hasData) continue;
            this.refreshDataRange(16);
        }
        monitor = this.dtMonitor[26];
        if (monitor != null) {
            monitor.status = UNKNOWN;
        }
        for (iProj = 0; iProj < this.evProjects.size(); ++iProj) {
            List events = ((EvProject)this.evProjects.get((int)iProj)).events;
            oldDataLoaded = false;
            oldData = new EvProject(this.SB, ((EvProject)this.evProjects.get((int)iProj)).qsID);
            for (int iEvent = 0; iEvent < events.size(); ++iEvent) {
                if (monitor == null) {
                    this.getDataRange(26, this.header.getWellUnits());
                    monitor = this.dtMonitor[26];
                } else {
                    monitor.hasData = true;
                    this.refreshDataRange(26);
                }
                if (!oldDataLoaded) {
                    ((EvProject)oldData).load(this.wellID, null);
                    ((EvProject)oldData).fillSamples(this.samples, this.header.getWellUnits(), this.type());
                    oldDataLoaded = true;
                }
                WellEvent event = (WellEvent)events.get(iEvent);
                if (monitor == null) continue;
                if (this.wellID != 0) {
                    event.updateStatus(((EvProject)oldData).events);
                } else {
                    event.updateStatus(events);
                }
                monitor.status = MergeStatus.merge(monitor.status, event.getStatus());
            }
        }
        monitor = this.dtMonitor[27];
        if (monitor != null) {
            monitor.status = UNKNOWN;
        }
        for (iProj = 0; iProj < this.evProjects.size(); ++iProj) {
            List LOCs = ((EvProject)this.evProjects.get((int)iProj)).LOCs;
            oldDataLoaded = false;
            oldData = new EvProject(this.SB, ((EvProject)this.evProjects.get((int)iProj)).qsID);
            for (int iLoc = 0; iLoc < LOCs.size(); ++iLoc) {
                if (monitor == null) {
                    this.getDataRange(27, this.header.getWellUnits());
                    monitor = this.dtMonitor[27];
                } else {
                    monitor.hasData = true;
                    this.refreshDataRange(27);
                }
                if (!oldDataLoaded) {
                    ((EvProject)oldData).load(this.wellID, null);
                    oldDataLoaded = true;
                }
                QSLOC loc = (QSLOC)LOCs.get(iLoc);
                if (monitor == null) continue;
                if (this.wellID != 0) {
                    loc.updateStatus(((EvProject)oldData).LOCs);
                } else {
                    loc.updateStatus(LOCs);
                }
                monitor.status = MergeStatus.merge(monitor.status, loc.getStatus());
            }
        }
        if (lithdesc != null) {
            this.updateLithologyStatus(lithdesc);
        }
        this.updateCoreStatus();
        this.updateCasingStatus();
        this.updateMarkersStatus();
    }

    void updateSampleStatus(boolean checkSamples) throws SBException, SQLException {
        if (this.dtMonitor[22] == null) {
            this.getDataRange(22, 'M');
        }
        this.dtMonitor[22].status = UNKNOWN;
        if (this.dtMonitor[3] == null) {
            this.getDataRange(3, 'M');
        }
        this.dtMonitor[3].status = UNKNOWN;
        if (this.dtMonitor[5] == null) {
            this.getDataRange(5, 'M');
        }
        this.dtMonitor[5].status = UNKNOWN;
        if (this.dtMonitor[7] == null) {
            this.getDataRange(7, 'M');
        }
        this.dtMonitor[7].status = UNKNOWN;
        if (this.dtMonitor[1] == null) {
            this.getDataRange(1, 'M');
        }
        this.dtMonitor[1].status = UNKNOWN;
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            if (checkSamples) {
                sample.updateStatus(this.wellID);
            }
            this.dtMonitor[22].status = MergeStatus.merge(this.dtMonitor[22].status, sample.getStatus());
            block7: for (int j = 0; j < sample.analyses.size(); ++j) {
                Smpdtl smpdtl = sample.analyses.get(j);
                if (smpdtl == null) continue;
                switch (smpdtl.getDiscID()) {
                    case 'M': {
                        this.dtMonitor[3].status = MergeStatus.merge(this.dtMonitor[3].status, smpdtl.getStatus());
                        continue block7;
                    }
                    case 'N': {
                        this.dtMonitor[5].status = MergeStatus.merge(this.dtMonitor[5].status, smpdtl.getStatus());
                        continue block7;
                    }
                    case 'P': {
                        this.dtMonitor[7].status = MergeStatus.merge(this.dtMonitor[7].status, smpdtl.getStatus());
                        continue block7;
                    }
                    case 'A': {
                        this.dtMonitor[1].status = MergeStatus.merge(this.dtMonitor[1].status, smpdtl.getStatus());
                    }
                }
            }
        }
    }

    void updateLithologyStatus(Lithdesc lithdesc) throws SBException, SQLException {
        LithInterval lith;
        int i;
        if (this.dtMonitor[19] == null) {
            this.getDataRange(19, 'M');
        }
        if (lithdesc == null) {
            throw new SBException("Lith dictionary null in update status");
        }
        DTMonitor monitor = this.dtMonitor[19];
        monitor.status = UNKNOWN;
        for (i = 0; i < this.lithIntervals.size(); ++i) {
            lith = (LithInterval)this.lithIntervals.get(i);
            lith.updateStatus(this.lithIntervals, false);
            monitor.status = MergeStatus.merge(monitor.status, lith.status);
        }
        for (i = 0; i < this.lithQualifiers.size(); ++i) {
            lith = (LithQualifier)this.lithQualifiers.get(i);
            ((LithQualifier)lith).updateStatus(this.lithQualifiers, false);
            monitor.status = MergeStatus.merge(monitor.status, ((LithQualifier)lith).status);
        }
        if (this.wellID > 0) {
            LithInterval lith2;
            int i2;
            Vector oldLith = new Vector();
            this.loadLithIntervals(oldLith, lithdesc);
            for (i2 = 0; i2 < this.lithIntervals.size(); ++i2) {
                lith2 = (LithInterval)this.lithIntervals.get(i2);
                if (lith2.status == LithInterval.CONFLICT) continue;
                lith2.updateStatus(oldLith, true);
                monitor.status = MergeStatus.merge(monitor.status, lith2.status);
            }
            this.loadLithQualifiers(oldLith, lithdesc);
            for (i2 = 0; i2 < this.lithQualifiers.size(); ++i2) {
                lith2 = (LithQualifier)this.lithQualifiers.get(i2);
                if (((LithQualifier)lith2).status == LithQualifier.CONFLICT) continue;
                ((LithQualifier)lith2).updateStatus(oldLith, true);
                monitor.status = MergeStatus.merge(monitor.status, ((LithQualifier)lith2).status);
            }
        }
        this.refreshDataRange(19);
    }

    void updateCoreStatus() throws SBException, SQLException {
        if (this.dtMonitor[17] == null) {
            this.getDataRange(17, 'M');
        }
        this.dtMonitor[17].status = UNKNOWN;
        if (this.wellID > 0 && this.cores.getSize() > 0) {
            Cores oldCores = new Cores(this.SB);
            oldCores.load(this.wellCode());
            for (int i = 0; i < this.cores.getSize(); ++i) {
                CoredInterval core = this.cores.getCore(i);
                core.updateStatus(oldCores);
                this.dtMonitor[17].status = MergeStatus.merge(this.dtMonitor[17].status, core.status);
            }
        } else {
            for (int i = 0; i < this.cores.getSize(); ++i) {
                CoredInterval core = this.cores.getCore(i);
                core.updateStatus(this.cores);
                this.dtMonitor[17].status = MergeStatus.merge(this.dtMonitor[17].status, core.status);
            }
        }
        this.refreshDataRange(17);
    }

    void updateCasingStatus() throws SBException, SQLException {
        if (this.dtMonitor[18] == null) {
            this.getDataRange(18, 'M');
        }
        this.dtMonitor[18].status = UNKNOWN;
        if (this.wellID > 0 && this.casing.getSize() > 0) {
            Casing oldCasing = new Casing(this.SB);
            oldCasing.load(this.wellCode());
            for (int i = 0; i < this.casing.getSize(); ++i) {
                CasingPoint casingPoint = this.casing.getCasingPoint(i);
                casingPoint.updateStatus(oldCasing);
                this.dtMonitor[18].status = MergeStatus.merge(this.dtMonitor[18].status, casingPoint.status);
            }
        } else {
            for (int i = 0; i < this.casing.getSize(); ++i) {
                CasingPoint casingPoint = this.casing.getCasingPoint(i);
                casingPoint.updateStatus(this.casing);
                this.dtMonitor[18].status = MergeStatus.merge(this.dtMonitor[18].status, casingPoint.status);
            }
        }
        this.refreshDataRange(18);
    }

    void updateMarkersStatus() throws SBException, SQLException {
        if (this.dtMonitor[21] == null) {
            this.getDataRange(21, 'M');
        }
        this.dtMonitor[21].status = UNKNOWN;
        if (this.wellID > 0 && this.markers.getSize() > 0) {
            Markers oldMarkers = new Markers(this.SB);
            oldMarkers.load(this.wellCode());
            for (int i = 0; i < this.markers.getSize(); ++i) {
                SeismicMarker marker = this.markers.get(i);
                marker.updateStatus(oldMarkers);
                this.dtMonitor[21].status = MergeStatus.merge(this.dtMonitor[21].status, marker.status);
            }
        } else {
            for (int i = 0; i < this.markers.getSize(); ++i) {
                SeismicMarker marker = this.markers.get(i);
                marker.updateStatus(this.markers);
                this.dtMonitor[21].status = MergeStatus.merge(this.dtMonitor[21].status, marker.status);
            }
        }
        this.refreshDataRange(21);
    }

    public void update(String code, WellHeader header) throws SQLException, SBException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        header.update(this.SB, df);
        this.header.copy(header);
        this.updateCode(code);
        this.notifyObservers();
    }

    void updateCode(String newCode) throws SQLException, SBException {
        if ((newCode = newCode.trim()).equals(this.wellCode())) {
            return;
        }
        if (Well.getWellID(this.SB, newCode) > 0) {
            throw new SBException("Well of code: '" + newCode + "' already exists");
        }
        this.setChanged();
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "UPDATE " + this.SB.DBTableName("casing") + " SET well_code='" + newCode + "' WHERE well_code='" + this.wellCode() + "'";
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("cores") + " SET well_code='" + newCode + "' WHERE well_code='" + this.wellCode() + "'";
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("wellsmark") + " SET well_code='" + newCode + "' WHERE well_code='" + this.wellCode() + "'";
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("welltvd") + " SET well_code='" + newCode + "' WHERE well_code='" + this.wellCode() + "'";
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("welltwt") + " SET well_code='" + newCode + "' WHERE well_code='" + this.wellCode() + "'";
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("version") + " SET code='" + newCode + "' WHERE code='" + this.wellCode() + "'";
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("wells") + " SET well_code='" + newCode + "' WHERE well_code='" + this.wellCode() + "'";
        stmt.executeUpdate(this.SB.modQuery(sql));
        this.header.setWellCode(newCode);
        stmt.close();
        this.SB.getDatabase().commit();
    }

    boolean hasDisciplineData(char discID) {
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            if (!sample.hasDisciplineData(discID)) continue;
            return true;
        }
        return false;
    }

    public void fillTaxa(Hashtable taxa) throws SBException, SQLException {
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            sample.fillTaxa(taxa);
        }
    }

    void updateHeaderStatus() throws SBException, SQLException {
        if (this.wellID == 0) {
            return;
        }
        this.header.updateStatus(this.SB, this.wellID);
    }

    public void fillTaxonList(List taxa, char discID) {
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            sample.fillTaxa(taxa, discID);
        }
    }

    void fillTaxonListFromDatabase(List taxa, char discID) throws SQLException, SBException, SBException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT DISTINCT spec_id FROM " + this.SB.DBTableName("FSSABND") + " WHERE samp_id>" + this.wellID * 65536 + " AND samp_id<" + (this.wellID + 1) * 65536 + " AND disc_id=" + util.SB.DBChar(discID);
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int specID = rs.getInt("spec_id");
            boolean found = false;
            Iterator it = taxa.iterator();
            while (it.hasNext()) {
                if (specID != ((Taxon)it.next()).getSpecID()) continue;
                found = true;
                break;
            }
            if (found) continue;
            taxa.add(new Taxon(this.SB, specID));
        }
        stmt.close();
    }

    public void sortTaxonList(List taxa, char discID, int sort) throws SBException {
        double[] depths = new double[taxa.size()];
        for (int i = 0; i < taxa.size(); ++i) {
            Taxon taxon = (Taxon)taxa.get(i);
            depths[i] = this.getEndSampleDepth(taxon.getSpecID() > 0 ? taxon.getSpecID() : taxon.getDonorID(), discID, sort);
        }
        boolean swap = true;
        block1: while (swap) {
            swap = false;
            for (int i = 1; i < depths.length; ++i) {
                if (!(sort == 0 && depths[i] < depths[i - 1]) && (sort != 1 || !(depths[i] > depths[i - 1]))) continue;
                swap = true;
                double tempDepth = depths[i];
                depths[i] = depths[i - 1];
                depths[i - 1] = tempDepth;
                Taxon tempTaxon = (Taxon)taxa.get(i);
                taxa.remove(i);
                taxa.add(i - 1, tempTaxon);
                continue block1;
            }
        }
    }

    double getEndSampleDepth(int specID, char discID, int sort) throws SBException {
        double depth = 0.0;
        if (sort == 0) {
            for (int i = 0; i < this.samples.size(); ++i) {
                Sample sample = this.samples.get(i);
                if (sample.hasInSituSpecies(discID, specID, 'R')) {
                    depth = sample.getDepth('M');
                    break;
                }
                if (!sample.hasSpecies(discID, specID) || !(depth < 0.003048)) continue;
                depth = sample.getDepth('M');
            }
        } else {
            for (int i = this.samples.size() - 1; i >= 0; --i) {
                Sample sample = this.samples.get(i);
                if (sample.hasInSituSpecies(discID, specID, 'C')) {
                    depth = sample.getDepth('M');
                    break;
                }
                if (!sample.hasSpecies(discID, specID) || !(depth < 0.003048)) continue;
                depth = sample.getDepth('M');
            }
        }
        return depth;
    }

    Sample getDonorSample(int sampID) {
        if (sampID == 0) {
            return null;
        }
        Sample sample = null;
        for (int i = 0; i < this.samples.size(); ++i) {
            sample = this.samples.get(i);
            if (sample.donorID != sampID) continue;
            return sample;
        }
        return null;
    }

    boolean hasExistingData() throws SQLException, SBException {
        for (int i = 0; i < this.interps.size(); ++i) {
            WellInterp interpretation = (WellInterp)this.interps.get(i);
            for (int list = 0; list < interpretation.zoneTypes.length; ++list) {
                if (interpretation.zoneTypes[i].size() <= 0 || !interpretation.hasExistingIGDData(WellInterp.zoneType2IGDType(i), this.wellID)) continue;
                return true;
            }
            LinkedList<DiscAnalyst> discAnalystList = new LinkedList<DiscAnalyst>();
            List<Biocom> comments = interpretation.comments;
            for (int iComm = 0; iComm < comments.size(); ++iComm) {
                Biocom comment = comments.get(iComm);
                DiscAnalyst discAnalyst = new DiscAnalyst(comment.getDiscID(), comment.getAnalyst());
                if (discAnalystList.contains(discAnalyst)) continue;
                discAnalystList.add(discAnalyst);
            }
            for (DiscAnalyst discAnalyst : discAnalystList) {
                if (!interpretation.hasExistingBiocomData(discAnalyst, this.wellID)) continue;
                return true;
            }
            if (interpretation.envs.size() <= 0 || !interpretation.hasExistingEnvData(this.wellID)) continue;
            return true;
        }
        LinkedList<DiscAnalyst> discAnalystList = new LinkedList<DiscAnalyst>();
        for (Sample sample : this.samples) {
            for (Smpdtl smpdtl : sample.analyses) {
                DiscAnalyst discAnalyst;
                discAnalyst = new DiscAnalyst(smpdtl.getDiscID(), smpdtl.getAnalyst());
                if (discAnalystList.contains(discAnalyst)) continue;
                discAnalystList.add(discAnalyst);
            }
        }
        for (DiscAnalyst discAnalyst : discAnalystList) {
            if (!this.hasExistingAnalyses(discAnalyst)) continue;
            return true;
        }
        return false;
    }

    void deleteExistingData() throws SQLException, SBException {
        for (int i = 0; i < this.interps.size(); ++i) {
            WellInterp interpretation = (WellInterp)this.interps.get(i);
            for (int list = 0; list < interpretation.zoneTypes.length; ++list) {
                if (interpretation.zoneTypes[i].size() <= 0) continue;
                interpretation.deleteExistingIGDData(WellInterp.zoneType2IGDType(i), this.wellID);
            }
            LinkedList<DiscAnalyst> discAnalystList = new LinkedList<DiscAnalyst>();
            List<Biocom> comments = interpretation.comments;
            for (int iComm = 0; iComm < comments.size(); ++iComm) {
                Biocom comment = comments.get(iComm);
                DiscAnalyst discAnalyst = new DiscAnalyst(comment.getDiscID(), comment.getAnalyst());
                if (discAnalystList.contains(discAnalyst)) continue;
                discAnalystList.add(discAnalyst);
            }
            for (DiscAnalyst discAnalyst : discAnalystList) {
                interpretation.deleteExistingBiocomData(discAnalyst, this.wellID);
            }
            if (interpretation.envs.size() <= 0) continue;
            interpretation.deleteExistingEnvData(this.wellID);
        }
        LinkedList<DiscAnalyst> discAnalystList = new LinkedList<DiscAnalyst>();
        for (Sample sample : this.samples) {
            for (Smpdtl smpdtl : sample.analyses) {
                DiscAnalyst discAnalyst;
                discAnalyst = new DiscAnalyst(smpdtl.getDiscID(), smpdtl.getAnalyst());
                if (discAnalystList.contains(discAnalyst)) continue;
                discAnalystList.add(discAnalyst);
            }
        }
        for (DiscAnalyst discAnalyst : discAnalystList) {
            this.deleteExistingAnalyses(discAnalyst);
        }
    }

    boolean hasExistingAnalyses(DiscAnalyst discAnalyst) throws SQLException {
        String sql = "SELECT samp_id FROM " + this.SB.DBTableName("FSSABND") + " WHERE disc_id=" + util.SB.DBChar(discAnalyst.discID);
        sql = sql + " AND analyst='" + discAnalyst.analyst + "' ";
        sql = sql + " AND samp_id >=" + this.wellID * 65536 + " AND samp_id < " + (this.wellID + 1) * 65536;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            stmt.close();
            return true;
        }
        stmt.close();
        return false;
    }

    void deleteExistingAnalyses(DiscAnalyst discAnalyst) throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.SB.DBTableName("FSSABND") + " WHERE disc_id=" + util.SB.DBChar(discAnalyst.discID);
        sql = sql + " AND analyst='" + discAnalyst.analyst + "' ";
        sql = sql + " AND samp_id >=" + this.wellID * 65536 + " AND samp_id < " + (this.wellID + 1) * 65536;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("SMPDTL") + " WHERE disc_id=" + util.SB.DBChar(discAnalyst.discID);
        sql = sql + " AND analyst='" + discAnalyst.analyst + "' ";
        sql = sql + " AND samp_id >=" + this.wellID * 65536 + " AND samp_id < " + (this.wellID + 1) * 65536;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public void addSample(Sample sample) throws SBException, SQLException {
        Sample.insert(this.samples, sample, this.getWellUnits());
        String sql = "SELECT noof_samp FROM " + this.SB.DBTableName("version") + " WHERE well_id=" + this.wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        int noofSamp = 0;
        if (rs.next()) {
            noofSamp = rs.getInt("noof_samp");
        }
        rs.close();
        noofSamp = sample.store(this.wellID, noofSamp);
        stmt.executeUpdate(this.SB.modQuery("UPDATE " + this.SB.DBTableName("version") + " SET noof_samp=" + noofSamp + " WHERE well_id=" + this.wellID));
        stmt.close();
        this.setChanged();
    }

    public Well(SBdb SB2, String wellCode, WellHeader header) throws SQLException, SBException {
        this.header = header;
        this.SB = SB2;
        this.add(wellCode);
    }

    public List<Smpdtl> getAnalyses(char discID, String analyst) throws SQLException, SBException {
        LinkedList<Smpdtl> smpdtls = new LinkedList<Smpdtl>();
        if (!this.analysesLoaded) {
            this.loadAnalyses();
        }
        for (Sample sample : this.samples) {
            for (Smpdtl smpdtl : sample.analyses) {
                boolean required = true;
                if (discID > '\u0000' && discID != smpdtl.getDiscID()) {
                    required = false;
                }
                if (analyst != null && analyst.length() > 0 && !analyst.equals(smpdtl.getAnalyst())) {
                    required = false;
                }
                if (!required) continue;
                smpdtls.add(smpdtl);
            }
        }
        return smpdtls;
    }

    void loadAnalyses() throws SQLException, SBException {
        if (this.analysesLoaded) {
            return;
        }
        if (!this.allSamplesLoaded) {
            this.loadSamples(null);
        }
        String sql = "SELECT samp_id,disc_id,analyst,picker,source,modified,modifier,barren,notes";
        if (this.SB.hasSampleEnv) {
            sql = sql + ",proximal,distal";
        }
        sql = sql + ",weight,coarse,medium,fine";
        sql = sql + " FROM " + this.SB.DBTableName("SMPDTL") + " WHERE samp_id>=" + this.wellID * 65536 + " AND samp_id<" + (this.wellID + 1) * 65536;
        Statement stmt = this.SB.getDatabase().createStatement();
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        String strg = null;
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            char discID = util.SB.getDBChar(rs, "disc_id");
            String analyst = rs.getString("analyst");
            String picker = rs.getString("picker");
            String source = rs.getString("source");
            Timestamp modified = rs.getTimestamp("modified");
            String modifier = rs.getString("modifier");
            boolean isAnalysed = true;
            boolean barren = false;
            strg = rs.getString("barren");
            if (strg == null) {
                isAnalysed = false;
            } else {
                isAnalysed = true;
                if (strg.length() > 0 && strg.charAt(0) == 'Y') {
                    barren = true;
                }
            }
            String notes = rs.getString("notes");
            int proximal = 0;
            int distal = 0;
            if (this.SB.hasSampleEnv) {
                proximal = rs.getInt("proximal");
                distal = rs.getInt("distal");
            }
            float weight = 0.0f;
            float coarse = 0.0f;
            float medium = 0.0f;
            float fine = 0.0f;
            if (this.SB.hasWeightSplits[SBdb.did2i(discID)]) {
                weight = rs.getFloat("weight");
                coarse = rs.getFloat("coarse");
                medium = rs.getFloat("medium");
                fine = rs.getFloat("fine");
            }
            if (analyst == null || analyst.length() == 0) {
                throw new SBException("Analyst null for sample : " + this);
            }
            Sample sample = this.getSample(sampID);
            if (sample == null) {
                System.out.println("Null sample for sampID =" + sampID + " in Well.loadAnalyses");
                continue;
            }
            Smpdtl dtl = new Smpdtl(this.SB, sample, discID, analyst, picker, source, notes, modified, modifier, barren, proximal, distal, weight, coarse, medium, fine);
            dtl.status = STORED;
            Iterator<Smpdtl> it = sample.analyses.iterator();
            boolean toAdd = true;
            while (it.hasNext()) {
                Smpdtl analysis = it.next();
                if (analysis.getDiscID() != dtl.getDiscID() || !analysis.getAnalyst().equals(dtl.getAnalyst())) continue;
                String message = "Duplicate analyst for discID: " + analysis.getDiscID() + ", analyst:" + analysis.getAnalyst() + ", sample ID: " + sampID;
                if (dtl.occur.size() > 0 && analysis.occur.size() == 0) {
                    System.out.println(message + ", sample details: " + analysis + " removed.");
                    it.remove();
                    break;
                }
                if (dtl.occur.size() == analysis.occur.size()) {
                    System.out.println(message + ", sample details: " + dtl + " ignored.");
                    toAdd = false;
                    continue;
                }
                throw new SBException(message + ", analyses have different occurrence records");
            }
            if (!toAdd) continue;
            sample.analyses.add(dtl);
            sample.detailsLoaded[SBdb.did2i((char)discID)] = true;
        }
        rs.close();
        stmt.close();
        this.analysesLoaded = true;
    }

    void add(String wellCode) throws SQLException, SBException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String sql = "SELECT code FROM " + this.SB.DBTableName("VERSION") + " WHERE code='" + wellCode + "'";
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            throw new SBException("Well code: '" + wellCode + "' Already exists. Well not saved");
        }
        this.wellID = this.SB.nextControl("WELL_ID");
        if (this.wellID == 0) {
            throw new SBException("Cannot get new well ID");
        }
        Licence licence = new Licence(this.SB);
        SBdb.DBType cfr_ignored_0 = this.SB.dbType;
        if (this.SB.dbType != SBdb.DBType.ORACLE && licence.isEvaluation()) {
            if (this.wellID > 4) {
                throw new SBException("Evaluation system is restricted to 4 wells/outcrops");
            }
            JOptionPane.showMessageDialog(null, "This is an evaluation system. You can enter " + (4 - this.wellID) + " more wells/outcrops", "StrataBugs", 1);
        }
        sql = "INSERT INTO " + this.SB.DBTableName("VERSION") + " (well_id,code,version,descrip,noof_samp";
        if (this.SB.isOW) {
            sql = sql + ",ow_well_id";
        }
        sql = sql + ") VALUES (";
        if (this.header.getDescrip() == null || this.header.getDescrip().trim().length() == 0) {
            this.header.setDescrip("Inserted by jSbugs on " + df.format(new java.util.Date()));
        }
        sql = sql + this.wellID + "," + util.SB.DBString(wellCode) + ",1," + util.SB.DBString(this.header.getDescrip()) + ",0";
        if (this.SB.isOW) {
            sql = sql + "," + this.header.getWellCode();
        }
        sql = sql + ")";
        sql = this.SB.modQuery(sql);
        stmt.executeUpdate(sql);
        if (!this.SB.isOW) {
            sql = "INSERT INTO " + this.SB.DBTableName("WELLS") + " (well_name,well_code,country) VALUES (" + util.SB.DBString(this.header.getWellName()) + "," + util.SB.DBString(wellCode) + "," + util.SB.DBString(this.header.getCountry()) + ")";
            sql = this.SB.modQuery(sql);
            stmt.executeUpdate(sql);
            this.header.setWellCode(wellCode);
            this.header.updateFromMaster(this.SB, df, true);
            this.header.update(this.SB, df);
        }
        stmt.close();
        this.header.setWellCode(wellCode);
    }

    void store(boolean headerOnly, boolean headerAnalysesOnly, Lithdesc lithdesc, List envSchemes, List users) throws SBException, SQLException, Exception {
        int i;
        Statement stmt;
        String sql;
        if (this.header.checkPerm(this.SB) != 1) {
            throw new SBException("No privilege to write data for well: " + this.toString());
        }
        if (this.header.getWellCode() == null || this.header.getWellCode().length() == 0) {
            throw new SBException("Well code blank for well: " + this.header.getWellName());
        }
        if (this.wellID == 0) {
            if (this.header.getWellName().trim().length() == 0) {
                throw new SBException("Well name blank for well code: " + this.header.getWellCode());
            }
            this.add(this.header.getWellCode());
        }
        if (this.header.getStatus() == NOTSTORED || this.header.getStatus() == PARTSTORED) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            this.header.update(this.SB, df);
            sql = "UPDATE " + this.SB.DBTableName("VERSION") + " SET descrip=" + util.SB.DBString(this.header.getDescrip()) + " WHERE code='" + this.header.getWellCode() + "'";
            stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
        }
        if (headerOnly) {
            return;
        }
        this.allSamplesLoaded = false;
        this.loadSamples(lithdesc);
        sql = "SELECT noof_samp FROM " + this.SB.DBTableName("version") + " WHERE well_id=" + this.wellID;
        stmt = this.SB.getDatabase().createStatement();
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        int noofSamp = 0;
        if (rs.next()) {
            noofSamp = rs.getInt("noof_samp");
        }
        rs.close();
        for (i = 0; i < this.samples.size(); ++i) {
            Smpdtl smpdtl;
            int j;
            Sample sample = this.samples.get(i);
            Sample existingSample = this.getSample(sample.getTopDepth('M'), sample.getBaseDepth('M'), sample.getType(), false);
            if (existingSample == null) {
                noofSamp = sample.store(this.wellID, noofSamp);
                continue;
            }
            for (j = 0; j < sample.analyses.size(); ++j) {
                smpdtl = sample.analyses.get(j);
                if (smpdtl.status != Smpdtl.NOTSTORED && smpdtl.status != Smpdtl.PARTSTORED) continue;
                if (users == null) {
                    throw new SBException("Usrid list null in Well.store()");
                }
                if (Userdef.checkUsrid(users, smpdtl.getAnalyst())) continue;
                throw new SBException("Cannot save sample with unkown analyst: " + smpdtl.getAnalyst() + "\n(Use Match | Analyst)");
            }
            if (existingSample.getSampID() == 0) {
                noofSamp = existingSample.store(this.wellID, noofSamp);
            } else if (sample.getSampID() > 0) {
                for (j = 0; j < sample.analyses.size(); ++j) {
                    smpdtl = sample.analyses.get(j);
                    if (smpdtl.status != Smpdtl.NOTSTORED && smpdtl.status != Smpdtl.PARTSTORED) continue;
                    smpdtl.store();
                }
            }
            if (sample.getSampID() == existingSample.getSampID()) continue;
            throw new SBException("Duplicate samples found");
        }
        stmt.executeUpdate(this.SB.modQuery("UPDATE " + this.SB.DBTableName("version") + " SET noof_samp=" + noofSamp + " WHERE well_id=" + this.wellID));
        this.storeAbn(stmt, '\u0000');
        stmt.close();
        if (headerAnalysesOnly) {
            return;
        }
        for (i = 0; i < this.interps.size(); ++i) {
            ((WellInterp)this.interps.get(i)).store();
        }
        this.storeBzTitles();
        for (i = 0; i < this.evProjects.size(); ++i) {
            ((EvProject)this.evProjects.get(i)).store(this.wellID);
        }
        try {
            for (int i2 = 0; i2 < this.lithIntervals.size(); ++i2) {
                LithInterval lith = (LithInterval)this.lithIntervals.get(i2);
                lith.store(this.wellID);
            }
            for (int i3 = 0; i3 < this.lithQualifiers.size(); ++i3) {
                LithQualifier lithQ = (LithQualifier)this.lithQualifiers.get(i3);
                lithQ.store(this.wellID);
            }
        }
        catch (SQLException se) {
            // empty catch block
        }
        this.cores.store(this.wellCode());
        this.casing.store(this.wellCode());
        this.markers.store(this.wellCode());
        this.TVD.store(this.wellCode());
        this.TWT.store(this.wellCode());
        this.updateStatus(false, lithdesc, envSchemes);
    }

    public void updateAbnScheme(char discID, AbnScheme abnScheme) throws SQLException {
        this.abn.remove("" + discID);
        this.abn.put("" + discID, abnScheme);
        Statement stmt = this.SB.getDatabase().createStatement();
        this.storeAbn(stmt, discID);
        stmt.close();
        this.setChanged();
        this.notifyObservers(abnScheme);
    }

    public boolean checkAbnScheme(AbnScheme scheme, char discID) throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT DISTINCT (subj_abund) FROM " + this.SB.DBTableName("fssabnd") + " WHERE samp_id>=" + this.wellID * 65536 + " AND samp_id<" + (this.wellID + 1) * 65536 + " AND disc_id='" + discID + "'";
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            String subjAbund = rs.getString("subj_abund");
            if (subjAbund == null || subjAbund.length() <= 0 || scheme.getIndex(subjAbund) >= 0) continue;
            stmt.close();
            System.out.println("Well subj abund trapped: " + subjAbund);
            return false;
        }
        stmt.close();
        return true;
    }

    public int updateSubjAbund(String donor, String target, char discID, String analyst) throws SQLException {
        int nUpdated = 0;
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "UPDATE " + this.SB.DBTableName("FSSABND") + " SET subj_abund=" + util.SB.DBString(target) + " WHERE samp_id>=" + this.wellID * 65536 + " AND samp_id < " + (this.wellID + 1) * 65536 + " AND disc_id=" + util.SB.DBChar(discID);
        if (analyst != null) {
            sql = sql + " AND analyst=" + util.SB.DBString(analyst);
        }
        sql = sql + " AND subj_abund=" + util.SB.DBString(donor);
        nUpdated = stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        for (Sample sample : this.samples) {
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (smpdtl.getDiscID() != discID || analyst != null && !smpdtl.getAnalyst().equals(analyst)) continue;
                smpdtl.replaceSubjAbund(donor, target);
                if (!smpdtl.hasChanged()) continue;
                smpdtl.notifyObservers();
            }
        }
        return nUpdated;
    }

    void storeAbn(Statement stmt, char discID) throws SQLException {
        int i = 0;
        while (true) {
            block6: {
                AbnScheme abnScheme;
                block5: {
                    if (i >= 4) break;
                    if (discID == '\u0000') break block5;
                    if (discID != SBdb.discArr[i]) break block6;
                }
                if ((abnScheme = this.abn.get("" + SBdb.discArr[i])) != null) {
                    String sql = "DELETE FROM " + this.SB.DBTableName("WELLABN") + " WHERE disc_id='" + SBdb.discArr[i] + "' AND well_id=" + this.wellID;
                    stmt.executeUpdate(this.SB.modQuery(sql));
                    sql = "INSERT INTO " + this.SB.DBTableName("WELLABN") + " (well_id,disc_id,sch_abn) VALUES (" + this.wellID + ",'" + SBdb.discArr[i] + "'," + abnScheme.getID() + ")";
                    stmt.executeUpdate(this.SB.modQuery(sql));
                }
            }
            ++i;
        }
    }

    void saveSample(Sample sample) throws SQLException, SBException {
        if (!this.allSamplesLoaded) {
            throw new SBException("Attempt to save sample when not all samples loaded for well - can produce duplicates");
        }
        if (sample.status == Sample.STORED) {
            return;
        }
        String sql = "SELECT noof_samp FROM " + this.SB.DBTableName("version") + " WHERE well_id=" + this.wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        int noofSamp = 0;
        if (rs.next()) {
            noofSamp = rs.getInt("noof_samp");
        }
        rs.close();
        noofSamp = sample.store(this.wellID, noofSamp);
        stmt.executeUpdate(this.SB.modQuery("UPDATE " + this.SB.DBTableName("version") + " SET noof_samp=" + noofSamp + " WHERE well_id=" + this.wellID));
    }

    void loadLithIntervals(Vector lithology, Lithdesc lithdesc) throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT top_depth,base_depth,lith_id FROM " + this.SB.DBTableName("SBILITH") + " WHERE well_id=" + this.wellID + " ORDER BY top_depth";
        lithology.clear();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            LithInterval lithInt = new LithInterval(this.SB);
            lithInt.topDepth = rs.getDouble("top_depth");
            lithInt.baseDepth = rs.getDouble("base_depth");
            lithInt.lithCode = rs.getInt("lith_id");
            lithInt.status = STORED;
            if (lithInt.lithCode != 0) {
                lithInt.desc = lithdesc.getLithology(lithInt.lithCode);
            }
            lithology.add(lithInt);
        }
        stmt.close();
    }

    void loadLithQualifiers(Vector lithology, Lithdesc lithdesc) throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT top_depth,base_depth,type,alignment,plotpos,lith_id FROM " + this.SB.DBTableName("SBQLITH") + " WHERE well_id=" + this.wellID + " ORDER BY top_depth";
        lithology.clear();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            LithQualifier lithQual = new LithQualifier(this.SB);
            lithQual.topDepth = rs.getDouble("top_depth");
            lithQual.baseDepth = rs.getDouble("base_depth");
            lithQual.qType = rs.getString("type").charAt(0);
            lithQual.alignment = rs.getString("alignment").charAt(0);
            lithQual.xPlotPos = rs.getFloat("plotpos");
            lithQual.lithCode = rs.getInt("lith_id");
            lithQual.status = STORED;
            if (lithQual.lithCode != 0) {
                lithQual.desc = lithdesc.getLithology(lithQual.lithCode);
            }
            lithology.add(lithQual);
        }
        stmt.close();
    }

    void writeSbugsTaxa(FileWriter out, char discID, Hashtable taxa) throws IOException {
        Taxon taxon;
        Vector<Taxon> wellTaxa = new Vector<Taxon>();
        Enumeration<Object> en = taxa.elements();
        block0: while (en.hasMoreElements()) {
            taxon = (Taxon)en.nextElement();
            for (int i = 0; i < this.samples.size(); ++i) {
                Sample sample = this.samples.get(i);
                if (taxon.getSpecID() == 0 || !sample.hasSpecies(discID, taxon.getSpecID())) continue;
                wellTaxa.add(taxon);
                continue block0;
            }
        }
        out.write("TAXA " + wellTaxa.size() + '\n');
        en = wellTaxa.elements();
        while (en.hasMoreElements()) {
            taxon = (Taxon)en.nextElement();
            taxon.writeSbugs(out);
        }
    }

    void writeSbugsSamples(FileWriter out, char discID) throws IOException {
        out.write("SAMPLES\n");
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            sample.writeSbugs(out, discID);
        }
    }

    void writeDEX(FileWriter out, String eol, boolean fullHeader, SimpleDateFormat df, Vector dataTypes, char units) throws IOException {
        Enumeration en2 = dataTypes.elements();
        boolean wantCores = false;
        boolean wantCasing = false;
        boolean wantLithology = false;
        boolean wantMarkers = false;
        boolean wantTVD = false;
        boolean wantTWT = false;
        this.header.writeDEX(out, eol, fullHeader, df, dataTypes, units);
        while (en2.hasMoreElements()) {
            int columnType = (Integer)en2.nextElement();
            char discID = '\u0000';
            switch (columnType) {
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    discID = SBdb.dt2discID(columnType);
                    break;
                }
                case 17: {
                    wantCores = true;
                    break;
                }
                case 18: {
                    wantCasing = true;
                    break;
                }
                case 21: {
                    wantMarkers = true;
                    break;
                }
                case 19: {
                    wantLithology = true;
                    break;
                }
                case 23: {
                    wantTVD = true;
                    break;
                }
                case 24: {
                    wantTWT = true;
                    break;
                }
            }
            if (discID <= '\u0000') continue;
            AbnScheme scheme = this.abn.get("" + discID);
            out.write("Abundance scheme ID = ");
            if (scheme.getID() > 0) {
                out.write("" + scheme.getID());
            } else {
                out.write("" + scheme.donorID);
            }
            out.write(eol + "  Discipline : " + discID + eol);
        }
        out.write(eol);
        if (wantCores) {
            this.cores.writeDEX(out, eol, units);
        }
        if (wantCasing) {
            this.casing.writeDEX(out, eol, units);
        }
        if (wantMarkers) {
            this.markers.writeDEX(out, eol, units);
        }
        if (wantTVD) {
            this.TVD.writeDEX(out, eol, units);
        }
        if (wantTWT) {
            this.TWT.writeDEX(out, eol, units);
        }
        if (wantLithology) {
            LithInterval zone;
            Enumeration en = this.lithIntervals.elements();
            while (en.hasMoreElements()) {
                zone = (LithInterval)en.nextElement();
                zone.status = LithInterval.NOTSTORED;
                zone.writeDEX(out, eol, units);
            }
            en = this.lithQualifiers.elements();
            while (en.hasMoreElements()) {
                zone = (LithQualifier)en.nextElement();
                ((LithQualifier)zone).status = LithQualifier.NOTSTORED;
                ((LithQualifier)zone).writeDEX(out, eol, units);
            }
        }
    }

    void writeXML(FileWriter out, int indent, boolean useDonorID, boolean useDonorSpecID) throws IOException {
        this.header.writeXML(out, indent);
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        for (String ele : this.abn.keySet()) {
            out.write(ind + "<AbundanceScheme Discipline=\"" + ele + "\" ID=\"" + this.abn.get(ele).getID() + "\"/>\n");
        }
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            out.write(ind + "<Sample ID=\"" + (useDonorID ? sample.donorID : sample.getSampID()) + "\">\n");
            sample.writeXML(out, indent + 3, this.header.getWellUnits(), useDonorSpecID);
            out.write(ind + "</Sample>\n");
        }
    }

    void parseXML(String chars, String element) throws ParseException {
        this.header.parseXML(chars, element);
    }

    void replaceAbnScheme(AbnScheme target, AbnScheme donor) {
        int i = 0;
        while (true) {
            if (i >= 4) break;
            String discipline = "" + SBdb.discArr[i];
            AbnScheme sch = this.abn.get(discipline);
            if (sch == donor) {
                this.abn.remove(discipline);
                this.abn.put(discipline, target);
                this.setChanged();
            }
            ++i;
        }
        this.notifyObservers(target);
    }

    public int getWellID() {
        return this.wellID;
    }

    public static int getWellID(SBdb SB2, String code) throws SQLException {
        String sql = "SELECT well_id FROM " + SB2.DBTableName("VERSION") + " WHERE code='" + code + "'";
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        int id = 0;
        if (rs.next()) {
            id = rs.getInt("well_id");
        }
        return id;
    }

    static int getWellIDFromName(SBdb SB2, String name) throws SQLException, SBException {
        String sql = "SELECT well_id FROM " + SB2.DBTableName("VERSION") + " v, " + SB2.DBTableName("WELLS") + " w WHERE w.well_name=" + util.SB.DBString(name) + " AND w.well_code=v.code";
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        int id = 0;
        boolean first = true;
        while (rs.next()) {
            id = rs.getInt("well_id");
            if (first) {
                first = false;
                continue;
            }
            throw new SBException("Cannot get well ID for well: " + name + ". More than one well with ID exists");
        }
        return id;
    }

    static int getWellIDFromNameCountry(SBdb SB2, String name, String iCountry) throws SQLException, SBException {
        String sql = "SELECT well_id FROM " + SB2.DBTableName("VERSION") + " v, " + SB2.DBTableName("WELLS") + " w WHERE w.well_name=" + util.SB.DBString(name) + " AND w.well_code=v.code AND w.country=" + util.SB.DBString(iCountry);
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        int id = 0;
        boolean first = true;
        while (rs.next()) {
            id = rs.getInt("well_id");
            if (first) {
                first = false;
                continue;
            }
            throw new SBException("Cannot get well ID for well: " + name + ",country: " + iCountry + ". More than one well with ID exists");
        }
        return id;
    }

    void delete() throws SQLException, SBException {
        if (this.header.checkPerm(this.SB) != 1) {
            throw new SBException("No privilege to write data for well: " + this.toString());
        }
        if (this.wellID != 0) {
            Well.deleteWell(this.SB, this.wellCode());
        }
    }

    void storeLithology() throws SQLException, SBException {
        LithInterval zone;
        if (this.header.checkPerm(this.SB) != 1) {
            throw new SBException("No privilege to write data for well: " + this.toString());
        }
        String sql = "DELETE FROM " + this.SB.DBTableName("SBILITH") + " WHERE well_id=" + this.wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        Enumeration en = this.lithIntervals.elements();
        while (en.hasMoreElements()) {
            zone = (LithInterval)en.nextElement();
            zone.status = LithInterval.NOTSTORED;
            zone.store(this.wellID);
        }
        sql = "DELETE FROM " + this.SB.DBTableName("SBQLITH") + " WHERE well_id=" + this.wellID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        en = this.lithQualifiers.elements();
        while (en.hasMoreElements()) {
            zone = (LithQualifier)en.nextElement();
            ((LithQualifier)zone).status = LithQualifier.NOTSTORED;
            ((LithQualifier)zone).store(this.wellID);
        }
        this.dtMonitor[19].status = STORED;
    }

    void loadEvProjects() throws SQLException {
        if (!this.evProjectsLoaded) {
            if (this.SB.hasEventExtensions) {
                this.evProjects.add(new EvProject(this.SB, 0));
            }
            String sql = "SELECT qs_id,name,creator,created,comments FROM " + this.SB.DBTableName("QSPROJ") + " ORDER BY lcase(name)";
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                EvProject project = new EvProject(this.SB);
                project.qsID = rs.getInt("qs_id");
                project.name = util.SB.getDBString(rs, "name");
                project.creator = rs.getString("creator");
                project.created = rs.getDate("created");
                project.description = util.SB.getDBString(rs, "comments");
                this.evProjects.add(project);
            }
            stmt.close();
            this.evProjectsLoaded = true;
        }
    }

    public EvProject getEvProject(int qsID) throws SQLException, SBException {
        if (!this.evProjectsLoaded) {
            this.loadEvProjects();
        }
        for (EvProject project : this.evProjects) {
            if (project.qsID != qsID) continue;
            return project;
        }
        throw new SBException("Cannot find event project with ID: " + qsID);
    }

    boolean sampleLoaded(Sample sample) {
        for (int i = 0; i < this.interps.size(); ++i) {
            WellInterp interpretation = (WellInterp)this.interps.get(i);
            for (int list = 0; list < interpretation.zoneTypes.length; ++list) {
                List igdList = interpretation.zoneTypes[list];
                for (int iZone = 0; iZone < igdList.size(); ++iZone) {
                    IGDIntervalZone zone = (IGDIntervalZone)igdList.get(iZone);
                    if (zone.getTopSample() == sample) {
                        return true;
                    }
                    if (zone.getBaseSample() != sample) continue;
                    return true;
                }
            }
            List<Biocom> comments = interpretation.comments;
            for (int iComm = 0; iComm < comments.size(); ++iComm) {
                Biocom comment = comments.get(iComm);
                if (comment.getTopSample() != sample && comment.getBaseSample() != sample) continue;
                return true;
            }
            for (int iEnv = 0; iEnv < interpretation.envs.size(); ++iEnv) {
                IGDIntervalEnv env = (IGDIntervalEnv)interpretation.envs.get(iEnv);
                if (env.getTopSample() != sample && env.getBaseSample() != sample) continue;
                return true;
            }
        }
        for (int iProj = 0; iProj < this.evProjects.size(); ++iProj) {
            List events = ((EvProject)this.evProjects.get((int)iProj)).events;
            for (int iEvent = 0; iEvent < events.size(); ++iEvent) {
                WellEvent event = (WellEvent)events.get(iEvent);
                if (event.sample != sample) continue;
                return true;
            }
        }
        return false;
    }

    public List getAnalysts(char discID) throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT distinct (analyst) FROM " + this.SB.DBTableName("SMPDTL") + " WHERE disc_id='" + discID + "' AND samp_id>=" + this.wellID * 65536 + " AND samp_id<" + (this.wellID + 1) * 65536;
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        ArrayList<String> list = new ArrayList<String>();
        while (rs.next()) {
            list.add(rs.getString("analyst"));
        }
        return list;
    }

    static void deleteWell(SBdb SB2, String wellCode) throws SQLException, SBException {
        if (wellCode.length() == 0) {
            return;
        }
        String sql = "SELECT well_id FROM " + SB2.DBTableName("VERSION") + " WHERE code='" + wellCode + "'";
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        int id = 0;
        if (rs.next()) {
            id = rs.getInt("well_id");
        }
        int lowSamp = id * 65536;
        int hiSamp = (id + 1) * 65536;
        sql = "DELETE FROM " + SB2.DBTableName("BCMMNTS") + " WHERE usamp_id >=" + lowSamp + " AND usamp_id < " + hiSamp;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("FSSABND") + " WHERE samp_id >=" + lowSamp + " AND samp_id < " + hiSamp;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SMPDTL") + " WHERE samp_id >=" + lowSamp + " AND samp_id < " + hiSamp;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("IGD") + " WHERE top_id >=" + lowSamp + " AND top_id < " + hiSamp;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("IGD_ENV") + " WHERE top_id >=" + lowSamp + " AND top_id < " + hiSamp;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("IGD_BZON") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        if (SB2.hasIGDHdr) {
            sql = "DELETE FROM " + SB2.DBTableName("IGD_HDR") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        sql = "DELETE FROM " + SB2.DBTableName("QSSECT") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("QSLOC") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SBILITH") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SBQLITH") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SBGS") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        if (!SB2.sbwlIsView) {
            sql = "DELETE FROM " + SB2.DBTableName("SBWLMB") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        if (SB2.hasAnalystHeader) {
            sql = "DELETE FROM " + SB2.DBTableName("ANALY_HDR") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        if (SB2.hasIGDHdr) {
            sql = "DELETE FROM " + SB2.DBTableName("IGD_HDR") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        sql = "DELETE FROM " + SB2.DBTableName("WELLABN") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SBSLITH") + " WHERE samp_id >=" + lowSamp + " AND samp_id < " + hiSamp;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("EVENTS") + " WHERE samp_id >=" + lowSamp + " AND samp_id < " + hiSamp;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SAMPLES") + " WHERE samp_id >=" + lowSamp + " AND samp_id < " + hiSamp;
        stmt.executeUpdate(SB2.modQuery(sql));
        if (SB2.hasWellPerm) {
            sql = "DELETE FROM " + SB2.DBTableName("WELLPERM") + " WHERE well_code =" + util.SB.DBString(wellCode);
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        sql = "DELETE FROM " + SB2.DBTableName("CASING") + " WHERE well_code =" + util.SB.DBString(wellCode);
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("CORES") + " WHERE well_code =" + util.SB.DBString(wellCode);
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("WELLSMARK") + " WHERE well_code =" + util.SB.DBString(wellCode);
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("WELLTVD") + " WHERE well_code =" + util.SB.DBString(wellCode);
        stmt.executeUpdate(SB2.modQuery(sql));
        if (SB2.hasTWT) {
            sql = "DELETE FROM " + SB2.DBTableName("WELLTWT") + " WHERE well_code =" + util.SB.DBString(wellCode);
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        if (!SB2.isOW) {
            sql = "DELETE FROM " + SB2.DBTableName("WELLS") + " WHERE well_code =" + util.SB.DBString(wellCode);
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        sql = "DELETE FROM " + SB2.DBTableName("VERSION") + " WHERE well_id =" + id;
        stmt.executeUpdate(SB2.modQuery(sql));
        if (id > 0) {
            sql = "SELECT chart_id FROM " + SB2.DBTableName("SBCHARTS") + " WHERE well_id=" + id;
            rs = stmt.executeQuery(SB2.modQuery(sql));
            Statement stmt2 = SB2.getDatabase().createStatement();
            while (rs.next()) {
                int chartID = rs.getInt("chart_id");
                sql = "DELETE FROM " + SB2.DBTableName("SBCHCLIN") + " WHERE chart_id =" + chartID;
                stmt2.executeUpdate(SB2.modQuery(sql));
                sql = "DELETE FROM " + SB2.DBTableName("SBCHPANL") + " WHERE chart_id =" + chartID;
                stmt2.executeUpdate(SB2.modQuery(sql));
                sql = "DELETE FROM " + SB2.DBTableName("SBLOGTRC") + " WHERE chart_id =" + chartID;
                stmt2.executeUpdate(SB2.modQuery(sql));
            }
            sql = "DELETE FROM " + SB2.DBTableName("SBCHARTS") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        stmt.close();
    }

    static void loadWellMasterFields(SBdb SB2, List wellMasterFields) throws SQLException {
        if (SB2.hasWellsMaster) {
            DatabaseMetaData meta = SB2.getDatabase().getMetaData();
            String schema = SB2.getSchema();
            ResultSet rs = meta.getColumns(null, schema, "WELLS_MASTER", null);
            while (rs.next()) {
                wellMasterFields.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
        }
    }

    static String getName(SBdb SB2, int wellID) throws SQLException {
        String wellName = null;
        if (wellID > 0) {
            String sql = "SELECT w.well_name FROM " + SB2.DBTableName("VERSION") + " v, " + SB2.DBTableName("WELLS") + " w " + " WHERE v.well_id=" + wellID + " AND v.code=w.well_code";
            sql = SB2.modQuery(sql);
            Statement stmt = SB2.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                wellName = rs.getString("well_name");
            }
            stmt.close();
        }
        return wellName;
    }

    public static String makeCode(String name) {
        String code = "";
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                code = code + c;
                continue;
            }
            if (c != '-' && c != '_') continue;
            code = code + c;
        }
        if ((code = code.toUpperCase()).length() > 25) {
            code = code.substring(0, 24);
            System.out.println("Warning: well code truncated");
        }
        return code;
    }

    class DTMonitor
    implements SbugsStatus {
        double depthFrom = 0.0;
        double depthTo = 0.0;
        boolean hasData = false;
        Color status = UNKNOWN;
        String stringValue = "Unassigned";

        DTMonitor() {
        }

        public String statusString() {
            return this.toString();
        }

        public String toString() {
            return this.stringValue;
        }

        public Color getStatus() {
            return this.status;
        }

        public String dbStatusString() {
            return "";
        }

        public Color getDbStatus() {
            return Color.WHITE;
        }
    }
}

