/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import model1_8.SBEvent;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import util.MergeStatus;
import util.SB;
import util.SbugsStatus;

public class WellEvent
implements SbugsStatus {
    SBdb SB;
    int qsID;
    int wellID;
    SBEvent sbEvent;
    Sample sample;
    int sampID;
    char type = (char)70;
    Color status = UNKNOWN;
    char discID;
    String analyst;
    String qualifier;
    String comments;
    String source;
    String company;
    Date modified;

    public Date getModified() {
        return this.modified;
    }

    public String getComments() {
        return this.comments;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public Sample getSample() {
        return this.sample;
    }

    public SBEvent getEvent() {
        return this.sbEvent;
    }

    public String getAnalyst() {
        return this.analyst;
    }

    public char getDiscID() {
        return this.discID;
    }

    public WellEvent(SBdb SB2) {
        this.SB = SB2;
    }

    public Color getStatus() {
        return this.status;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.sample.toString() + " " + this.getType() + " " + this.sbEvent.toString();
    }

    public char getCharType() {
        return this.type;
    }

    public String getType() {
        if (this.type == 'F') {
            return "Top";
        }
        if (this.type == 'L') {
            return "Base";
        }
        return "Single";
    }

    void delete() throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("EVENTS") + " WHERE qs_id=" + this.qsID + " AND samp_id=" + this.sampID + " AND ev_id=" + this.sbEvent.getEvID() + " AND ";
        sql = this.type > '\u0000' ? sql + "ev_type='" + this.type + "'" : sql + "ev_type is null";
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        this.status = UNKNOWN;
    }

    void updateStatus(List events) throws SQLException {
        if (this.sample != null) {
            this.sampID = this.sample.getSampID();
        }
        this.status = NOTSTORED;
        for (WellEvent event : events) {
            if (event == this || this.sampID == 0 || this.sampID != event.sampID || this.sbEvent.getEvID() != event.sbEvent.getEvID() || this.type != event.type) continue;
            if (this.SB.hasEventExtensions) {
                this.status = STORED;
                MergeStatus m = new MergeStatus(this.status);
                m.compareStringField("Analyst", event.analyst, this.analyst, false);
                m.compareStringField("Comments", event.comments, this.comments, false);
                m.compareStringField("Company", event.company, this.company, false);
                m.compareCharField("DiscID", event.discID, this.discID);
                m.compareStringField("Qualifier", event.qualifier, this.qualifier, false);
                m.compareStringField("Source", event.source, this.source, false);
                this.status = m.getStatus();
                break;
            }
            this.status = STORED;
            break;
        }
    }

    void store(int qsID) throws SBException, SQLException {
        if (this.sbEvent.status != SBEvent.STORED) {
            SBEvent event = new SBEvent(this.sbEvent.getName());
            if (event.status == SBEvent.STORED) {
                this.sbEvent = event;
            } else {
                this.sbEvent.store();
            }
        }
        this.qsID = qsID;
        if (this.sample != null && this.sampID == 0) {
            this.sampID = this.sample.getSampID();
        }
        if (this.sampID > 0 && this.status == NOTSTORED) {
            String sql = "INSERT INTO " + this.SB.DBTableName("EVENTS") + " (qs_id,ev_id,ev_type,samp_id";
            if (this.SB.hasEventExtensions) {
                sql = sql + ",disc_id,analyst,qualifier,comments,source,company,modified";
            }
            sql = sql + ") VALUES (" + qsID + "," + this.sbEvent.getEvID() + "," + util.SB.DBChar(this.type == '\u0000' ? (char)' ' : (char)this.type) + "," + this.sampID;
            if (this.SB.hasEventExtensions) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                if (this.modified == null) {
                    this.modified = new Date();
                }
                sql = sql + "," + util.SB.DBChar(this.discID) + "," + util.SB.DBString(this.analyst) + "," + util.SB.DBString(this.qualifier) + "," + util.SB.DBString(this.comments) + "," + util.SB.DBString(this.source) + "," + util.SB.DBString(this.company) + "," + "'" + df.format(this.modified) + "'";
            }
            sql = sql + ")";
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
            this.status = STORED;
        } else if (this.status == PARTSTORED) {
            throw new SBException("Attempt to update SBEvent");
        }
    }
}

