/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.util.Comparator;
import model1_8.WellEvent;

public class WellEventCompareDepth
implements Comparator {
    boolean isIncreasing = true;

    public WellEventCompareDepth(boolean isIncreasing) {
        this.isIncreasing = isIncreasing;
    }

    public int compare(Object t2, Object t1) {
        WellEvent event1 = (WellEvent)t1;
        WellEvent event2 = (WellEvent)t2;
        try {
            int comp = (int)((event2.getSample().getDepth() - event1.getSample().getDepth()) * 1000.0);
            if (!this.isIncreasing) {
                comp = -comp;
            }
            if (comp == 0) {
                int evt2;
                int evt1;
                switch (event1.getCharType()) {
                    case 'L': {
                        evt1 = -1;
                        break;
                    }
                    case 'F': {
                        evt1 = 1;
                        break;
                    }
                    default: {
                        evt1 = 0;
                    }
                }
                switch (event2.getCharType()) {
                    case 'L': {
                        evt2 = -1;
                        break;
                    }
                    case 'F': {
                        evt2 = 1;
                        break;
                    }
                    default: {
                        evt2 = 0;
                    }
                }
                comp = this.isIncreasing ? evt2 - evt1 : evt1 - evt2;
            }
            return comp;
        }
        catch (Exception e) {
            System.out.println("Exception comparing events");
            e.printStackTrace();
            return 0;
        }
    }
}

