/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Vector;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Well;
import util.MergeStatus;
import util.SB;
import util.SbugsStatus;

public class WellHeader
extends Observable
implements SbugsStatus,
Comparable {
    private boolean isUpdateable = false;
    private String wellName = "";
    private String wellCode = "";
    private char type = (char)87;
    private char wellUnits = (char)77;
    private boolean restrict = true;
    private String oper = "";
    private String country = "";
    private String field = "";
    private String quadrant = "";
    private String block = "";
    private String subBlock = "";
    private long gridX = 0L;
    private long gridY = 0L;
    private java.util.Date spud;
    private java.util.Date comp;
    private double td = 0.0;
    private double sl = 0.0;
    private double sb = 0.0;
    private double rte = 0.0;
    private double kicko = 0.0;
    private String ocs = "";
    private String county = "";
    private String usrid = "";
    private java.util.Date userDate;
    public static final int DATUMRTE = 1;
    public static final int DATUMSL = 2;
    public static final int DATUMSB = 3;
    private int datum;
    private double lat_dec;
    private char lat_ind = (char)78;
    private short lat_deg;
    private short lat_min;
    private float lat_sec;
    private double long_dec;
    private char long_ind = (char)69;
    private short long_deg;
    private short long_min;
    private float long_sec;
    private String geoDatum = "";
    private String descrip;
    static boolean permissionsLoaded = false;
    int wellPermission = -1;
    static List permissions = new ArrayList();
    static final int NOACCESS = 0;
    static final int FULLACCESS = 1;
    static final int READONLY = 2;
    Color status = NOTSTORED;
    MergeStatus headerMergeStatus = null;

    public WellHeader() {
        this.isUpdateable = true;
    }

    public WellHeader(WellHeader rhs) {
        this.copy(rhs);
        this.isUpdateable = true;
    }

    public void copy(WellHeader rhs) {
        this.isUpdateable = false;
        this.wellName = rhs.wellName;
        this.wellCode = rhs.wellCode;
        this.type = rhs.type;
        this.wellUnits = rhs.wellUnits;
        this.restrict = rhs.restrict;
        this.oper = rhs.oper;
        this.country = rhs.country;
        this.field = rhs.field;
        this.quadrant = rhs.quadrant;
        this.block = rhs.block;
        this.subBlock = rhs.subBlock;
        this.gridX = rhs.gridX;
        this.gridY = rhs.gridY;
        this.spud = rhs.spud;
        this.comp = rhs.comp;
        this.td = rhs.td;
        this.sl = rhs.sl;
        this.sb = rhs.sb;
        this.rte = rhs.rte;
        this.kicko = rhs.kicko;
        this.ocs = rhs.ocs;
        this.county = rhs.county;
        this.usrid = rhs.usrid;
        this.userDate = rhs.userDate;
        this.datum = rhs.datum;
        this.lat_dec = rhs.lat_dec;
        this.lat_ind = rhs.lat_ind;
        this.lat_deg = rhs.lat_deg;
        this.lat_min = rhs.lat_min;
        this.lat_sec = rhs.lat_sec;
        this.long_dec = rhs.long_dec;
        this.long_ind = rhs.long_ind;
        this.long_deg = rhs.long_deg;
        this.long_min = rhs.long_min;
        this.long_sec = rhs.long_sec;
        this.geoDatum = rhs.geoDatum;
        this.descrip = rhs.descrip;
    }

    public String toString() {
        return this.wellName + " (" + this.wellCode + ')';
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    public String statusString() {
        return this.toString();
    }

    public Color getStatus() {
        return this.status;
    }

    public String getWellName() {
        return this.wellName;
    }

    public String getWellCode() {
        return this.wellCode;
    }

    public char getType() {
        return this.type;
    }

    public char getWellUnits() {
        return this.wellUnits;
    }

    public boolean getRestrict() {
        return this.restrict;
    }

    public String getOper() {
        return this.oper;
    }

    public String getCountry() {
        return this.country;
    }

    public String getField() {
        return this.field;
    }

    public String getQuadrant() {
        return this.quadrant;
    }

    public String getBlock() {
        return this.block;
    }

    public String getSubBlock() {
        return this.subBlock;
    }

    public long getGridX() {
        return this.gridX;
    }

    public long getGridY() {
        return this.gridY;
    }

    public java.util.Date getSpud() {
        return this.spud;
    }

    public java.util.Date getComp() {
        return this.comp;
    }

    public double getTD() {
        return this.td;
    }

    public double getSL() {
        return this.sl;
    }

    public double getSB() {
        return this.sb;
    }

    public double getRTE() {
        return this.rte;
    }

    public double getKicko() {
        return this.kicko;
    }

    public String getOCS() {
        return this.ocs;
    }

    public String getCounty() {
        return this.county;
    }

    public String getUsrid() {
        return this.usrid;
    }

    public java.util.Date getUserDate() {
        return this.userDate;
    }

    public int getDatum() {
        return this.datum;
    }

    public double getLat_dec() {
        return this.lat_dec;
    }

    public char getLat_ind() {
        return this.lat_ind;
    }

    public short getLat_deg() {
        return this.lat_deg;
    }

    public short getLat_min() {
        return this.lat_min;
    }

    public float getLat_sec() {
        return this.lat_sec;
    }

    public double getLong_dec() {
        return this.long_dec;
    }

    public char getLong_ind() {
        return this.long_ind;
    }

    public short getLong_deg() {
        return this.long_deg;
    }

    public short getLong_min() {
        return this.long_min;
    }

    public float getLong_sec() {
        return this.long_sec;
    }

    public String getGeoDatum() {
        return this.geoDatum;
    }

    public String getDescrip() {
        return this.descrip;
    }

    public String getDatumString() {
        switch (this.datum) {
            default: {
                return "RT/KB";
            }
            case 2: {
                return "SL";
            }
            case 3: 
        }
        return "SB";
    }

    public void setWellName(String wellName) throws SBException {
        if (!wellName.equals(this.wellName)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update well name");
            }
            this.wellName = wellName;
            this.setChanged();
        }
    }

    void setWellCode(String wellCode) {
        this.wellCode = wellCode;
    }

    public void setType(char type) throws SBException {
        if (type != 'W' && type != 'O') {
            throw new SBException("Unrecognised section type: " + type);
        }
        if (type != this.type) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update type");
            }
            this.type = type;
            this.setChanged();
        }
    }

    public void setWellUnits(char wellUnits) throws SBException {
        if (wellUnits != 'F' && wellUnits != 'M') {
            throw new SBException("Unrecognised section wellUnits: " + wellUnits);
        }
        if (wellUnits != this.wellUnits) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update wellUnits");
            }
            this.wellUnits = wellUnits;
            this.setChanged();
        }
    }

    public void setRestrict(boolean restrict) throws SBException {
        if (restrict != this.restrict) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update restricted");
            }
            this.restrict = restrict;
            this.setChanged();
        }
    }

    public void setOper(String oper) throws SBException {
        if (!oper.equals(this.oper)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update operator ");
            }
            this.oper = oper;
            this.setChanged();
        }
    }

    public void setCountry(String country) throws SBException {
        if (!country.equals(this.country)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update country");
            }
            this.country = country;
            this.setChanged();
        }
    }

    public void setField(String field) throws SBException {
        if (!field.equals(this.field)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update field");
            }
            this.field = field;
            this.setChanged();
        }
    }

    public void setQuad(String quadrant, String block, String subBlock) throws SBException {
        if (!(quadrant.equals(this.quadrant) && block.equals(this.block) && subBlock.equals(this.subBlock))) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Quadrant information");
            }
            this.quadrant = quadrant;
            this.block = block;
            this.subBlock = subBlock;
            this.setChanged();
        }
    }

    public void setGrid(long gridX, long gridY) throws SBException {
        if (gridX != this.gridX || gridY != this.gridY) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update gridX/Y");
            }
            this.gridX = gridX;
            this.gridY = gridY;
            this.setChanged();
        }
    }

    public void setSpud(java.util.Date spud) throws SBException {
        if (spud != null || this.spud != null || spud != null && !spud.equals(this.spud)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update spud date");
            }
            this.spud = spud;
            this.setChanged();
        }
    }

    public void setComp(java.util.Date comp) throws SBException {
        if (comp != null || this.comp != null || comp != null && !comp.equals(this.comp)) {
            if (comp != null && this.spud != null && comp.compareTo(this.spud) < 0) {
                throw new SBException("Completion date is before spud date");
            }
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update comp");
            }
            this.comp = comp;
            this.setChanged();
        }
    }

    public void setTD(double td) throws SBException {
        if (td != this.td) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Termination Depth");
            }
            this.td = td;
            this.setChanged();
        }
    }

    public void setSL(double sl) throws SBException {
        if (sl != this.sl) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Sea Level");
            }
            this.sl = sl;
            this.setChanged();
        }
    }

    public void setSB(double sb) throws SBException {
        if (sb != this.sb) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Sea Bed");
            }
            this.sb = sb;
            this.setChanged();
        }
    }

    public void setRTE(double rte) throws SBException {
        if (rte != this.rte) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update RTE");
            }
            this.rte = rte;
            this.setChanged();
        }
    }

    public void setKicko(double kicko) throws SBException {
        if (kicko != this.kicko) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Kick off Depth");
            }
            this.kicko = kicko;
            this.setChanged();
        }
    }

    public void setOCS(String ocs) throws SBException {
        if (!ocs.equals(this.ocs)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update OCS number");
            }
            this.ocs = ocs;
            this.setChanged();
        }
    }

    public void setCounty(String county) throws SBException {
        if (!county.equals(this.county)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update county");
            }
            this.county = county;
            this.setChanged();
        }
    }

    public void setDatum(int datum) throws SBException {
        if (datum != this.datum) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update datum");
            }
            switch (datum) {
                case 1: 
                case 2: 
                case 3: {
                    this.datum = datum;
                    break;
                }
                default: {
                    throw new SBException("Unrecognised datum: " + datum);
                }
            }
            this.setChanged();
        }
    }

    public void setLat(short lat_deg, short lat_min, float lat_sec, char lat_ind) throws SBException {
        this.lat_dec = (float)lat_deg + (float)lat_min / 60.0f + lat_sec / 3600.0f;
        double temp = this.lat_dec;
        if (this.lat_dec != temp || lat_ind != this.lat_ind) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update datum");
            }
            this.lat_dec = temp;
            this.lat_ind = lat_ind;
            this.lat_deg = lat_deg;
            this.lat_min = lat_min;
            this.lat_sec = lat_sec;
            this.setChanged();
        }
    }

    public void setLong(short long_deg, short long_min, float long_sec, char long_ind) throws SBException {
        this.long_dec = (float)long_deg + (float)long_min / 60.0f + long_sec / 3600.0f;
        double temp = this.long_dec;
        if (this.long_dec != temp || long_ind != this.long_ind) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update datum");
            }
            this.long_dec = temp;
            this.long_ind = long_ind;
            this.long_deg = long_deg;
            this.long_min = long_min;
            this.long_sec = long_sec;
            this.setChanged();
        }
    }

    public void setGeoDatum(String geoDatum) throws SBException {
        if (!geoDatum.equals(this.geoDatum)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Geodetic Datum");
            }
            this.geoDatum = geoDatum;
            this.setChanged();
        }
    }

    public void setDescrip(String descrip) throws SBException {
        if (!descrip.equals(this.descrip)) {
            if (!this.isUpdateable) {
                throw new SBException("Attempt to update Description");
            }
            this.descrip = descrip;
            this.setChanged();
        }
    }

    boolean updateFromMaster(SBdb SB2, SimpleDateFormat df, boolean updateTableData) throws SQLException, SBException {
        if (!SB2.hasWellsMaster) {
            return false;
        }
        String sql = "SELECT ";
        Iterator it = SB2.wellMasterFields.iterator();
        while (it.hasNext()) {
            sql = sql + it.next();
            if (!it.hasNext()) continue;
            sql = sql + ",";
        }
        sql = sql + " FROM " + SB2.DBTableName("WELLS_MASTER");
        sql = sql + " WHERE well_code=" + SB.DBString(this.wellCode);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        boolean needsUpdate = false;
        WellHeader temp = new WellHeader(this);
        if (rs.next()) {
            for (String fieldName : SB2.wellMasterFields) {
                if (fieldName.equalsIgnoreCase("well_name")) {
                    String fieldData = rs.getString(fieldName);
                    temp.setWellName(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("restricted")) {
                    boolean fieldData = rs.getInt(fieldName) == 1;
                    temp.setRestrict(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("operator")) {
                    String fieldData = SB.getDBString(rs, fieldName);
                    temp.setOper(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("country")) {
                    String fieldData = SB.getDBString(rs, fieldName);
                    temp.setCountry(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("county")) {
                    String fieldData = SB.getDBString(rs, fieldName);
                    temp.setCounty(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("ocs")) {
                    String fieldData = SB.getDBString(rs, fieldName);
                    this.setOCS(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("field")) {
                    String fieldData = SB.getDBString(rs, fieldName);
                    this.setField(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("quadrant")) {
                    String fieldData = SB.getDBString(rs, fieldName);
                    if (temp.quadrant.equals(fieldData)) continue;
                    temp.quadrant = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("block")) {
                    String fieldData = SB.getDBString(rs, fieldName);
                    if (temp.block.equals(fieldData)) continue;
                    temp.block = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("sub_block")) {
                    String fieldData = SB.getDBString(rs, fieldName);
                    if (temp.subBlock.equals(fieldData)) continue;
                    temp.subBlock = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("grid_x")) {
                    long fieldData = rs.getLong(fieldName);
                    if (temp.gridX == fieldData) continue;
                    temp.gridX = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("grid_y")) {
                    long fieldData = rs.getLong(fieldName);
                    if (temp.gridY == fieldData) continue;
                    temp.gridY = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("spud_date")) {
                    Date fieldData = rs.getDate(fieldName);
                    temp.setSpud(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("comp_date")) {
                    Date fieldData = rs.getDate(fieldName);
                    temp.setComp(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("lat_dec")) {
                    double fieldData = rs.getDouble(fieldName);
                    if (temp.lat_dec == fieldData) continue;
                    temp.lat_dec = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("lat_ind")) {
                    char fieldData = SB.getDBChar(rs, fieldName);
                    if (temp.lat_ind == fieldData || fieldData != 'N' && fieldData != 'S') continue;
                    temp.lat_ind = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("lat_deg")) {
                    short fieldData = rs.getShort(fieldName);
                    if (temp.lat_deg == fieldData) continue;
                    temp.lat_deg = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("lat_min")) {
                    short fieldData = rs.getShort(fieldName);
                    if (temp.lat_min == fieldData) continue;
                    temp.lat_min = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("lat_sec")) {
                    float fieldData = rs.getFloat(fieldName);
                    if (temp.lat_sec == fieldData) continue;
                    temp.lat_sec = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("long_dec")) {
                    double fieldData = rs.getDouble(fieldName);
                    if (temp.long_dec == fieldData) continue;
                    temp.long_dec = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("long_ind")) {
                    char fieldData = SB.getDBChar(rs, fieldName);
                    if (temp.long_ind == fieldData || fieldData != 'E' && fieldData != 'W') continue;
                    temp.long_ind = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("long_deg")) {
                    short fieldData = rs.getShort(fieldName);
                    if (temp.long_deg == fieldData) continue;
                    temp.long_deg = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("long_min")) {
                    short fieldData = rs.getShort(fieldName);
                    if (temp.long_min == fieldData) continue;
                    temp.long_min = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("long_sec")) {
                    float fieldData = rs.getFloat(fieldName);
                    if (temp.long_sec == fieldData) continue;
                    temp.long_sec = fieldData;
                    temp.setChanged();
                    continue;
                }
                if (fieldName.equalsIgnoreCase("td")) {
                    double fieldData = rs.getDouble(fieldName);
                    temp.setTD(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("sl")) {
                    double fieldData = rs.getDouble(fieldName);
                    temp.setSL(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("sb")) {
                    double fieldData = rs.getDouble(fieldName);
                    temp.setSB(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("rte")) {
                    double fieldData = rs.getDouble(fieldName);
                    temp.setRTE(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("kicko")) {
                    double fieldData = rs.getDouble(fieldName);
                    temp.setKicko(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("datum")) {
                    int fieldData = rs.getInt(fieldName);
                    temp.setDatum(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("type")) {
                    char fieldData = SB.getDBChar(rs, fieldName);
                    temp.setType(fieldData);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("units")) {
                    char fieldData = SB.getDBChar(rs, fieldName);
                    temp.setWellUnits(fieldData);
                    continue;
                }
                if (!fieldName.equalsIgnoreCase("geodatum")) continue;
                String fieldData = SB.getDBString(rs, fieldName);
                temp.setGeoDatum(fieldData);
            }
        }
        stmt.close();
        if (updateTableData && temp.hasChanged()) {
            temp.update(SB2, df);
            this.copy(temp);
            return true;
        }
        return false;
    }

    void update(SBdb SB2, SimpleDateFormat df) throws SQLException, SBException {
        int rows;
        String sql;
        Statement stmt;
        block51: {
            block50: {
                block49: {
                    block48: {
                        if (this.checkPerm(SB2) != 1) {
                            throw new SBException("No privilege to write data for well: " + this.toString());
                        }
                        if (SB2.isOW) {
                            return;
                        }
                        stmt = SB2.getDatabase().createStatement();
                        sql = "UPDATE " + SB2.DBTableName("WELLS") + " SET well_name=" + SB.DBString(this.wellName) + ",restricted=" + (this.restrict ? 1 : 0) + ",operator=" + SB.DBString(this.oper) + ",country=" + SB.DBString(this.country) + " WHERE well_code=" + SB.DBString(this.wellCode);
                        rows = stmt.executeUpdate(sql = SB2.modQuery(sql));
                        if (rows != 1) {
                            throw new SBException("Error - in statement: " + sql + "\nNumber of rows updated: " + rows);
                        }
                        boolean comma = false;
                        sql = "UPDATE " + SB2.DBTableName("WELLS") + " SET ";
                        if (SB2.hasCounty && this.county != null && this.county.length() > 0) {
                            sql = sql + "county='" + this.county + "'";
                            comma = true;
                        }
                        if (SB2.hasOcs && this.ocs != null && this.ocs.length() > 0) {
                            if (comma) {
                                sql = sql + ",";
                            }
                            sql = sql + "ocs='" + this.ocs + "'";
                            comma = true;
                        }
                        if (this.field != null && this.field.length() > 0) {
                            if (comma) {
                                sql = sql + ",";
                            }
                            sql = sql + "field='" + this.field + "'";
                            comma = true;
                        }
                        if (this.quadrant != null && this.quadrant.length() > 0) {
                            if (comma) {
                                sql = sql + ",";
                            }
                            sql = sql + "quadrant='" + this.quadrant + "'";
                            comma = true;
                        }
                        if (this.block != null && this.block.length() > 0) {
                            if (comma) {
                                sql = sql + ",";
                            }
                            sql = sql + "block='" + this.block + "'";
                            comma = true;
                        }
                        if (this.subBlock != null && this.subBlock.length() > 0) {
                            if (comma) {
                                sql = sql + ",";
                            }
                            sql = sql + "sub_block='" + this.subBlock + "'";
                            comma = true;
                        }
                        if (Math.abs(this.gridX) > 0L) {
                            if (comma) {
                                sql = sql + ",";
                            }
                            sql = sql + "grid_x=" + this.gridX;
                            comma = true;
                        }
                        if (Math.abs(this.gridY) > 0L) {
                            if (comma) {
                                sql = sql + ",";
                            }
                            sql = sql + "grid_y=" + this.gridY;
                            comma = true;
                        }
                        if (this.spud != null) {
                            if (comma) {
                                sql = sql + ",";
                            }
                            sql = sql + "spud_date='" + df.format(this.spud) + "'";
                            comma = true;
                        }
                        if (this.comp != null) {
                            if (comma) {
                                sql = sql + ",";
                            }
                            sql = sql + "comp_date='" + df.format(this.comp) + "'";
                            comma = true;
                        }
                        if (comma) {
                            sql = sql + " WHERE well_code='" + this.wellCode + "'";
                            sql = SB2.modQuery(sql);
                            stmt.executeUpdate(sql);
                        }
                        comma = false;
                        sql = "UPDATE " + SB2.DBTableName("WELLS") + " SET ";
                        sql = sql + "lat_ind='" + this.lat_ind + "'";
                        if (Math.abs(this.lat_dec) > 0.001) {
                            sql = sql + ",lat_dec=" + this.lat_dec;
                        }
                        if (this.lat_deg > 0) {
                            sql = sql + ",lat_deg=" + this.lat_deg;
                        }
                        if (this.lat_min > 0) {
                            sql = sql + ",lat_min=" + this.lat_min;
                        }
                        if ((double)Math.abs(this.lat_sec) > 1.0E-4) {
                            sql = sql + ",lat_sec=" + this.lat_sec;
                        }
                        if (Math.abs(this.long_dec) > 0.001) {
                            sql = sql + ",long_dec=" + this.long_dec;
                        }
                        if (this.long_deg > 0) {
                            sql = sql + ",long_deg=" + this.long_deg;
                        }
                        if (this.long_min > 0) {
                            sql = sql + ",long_min=" + this.long_min;
                        }
                        if ((double)Math.abs(this.long_sec) > 1.0E-4) {
                            sql = sql + ",long_sec=" + this.long_sec;
                        }
                        if (Math.abs(this.td) > 0.001) {
                            sql = sql + ",td=" + this.td;
                        }
                        if (Math.abs(this.sl) > 0.001) {
                            sql = sql + ",sl=" + this.sl;
                        }
                        if (Math.abs(this.sb) > 0.001) {
                            sql = sql + ",sb=" + this.sb;
                        }
                        if (Math.abs(this.rte) > 0.001) {
                            sql = sql + ",rte=" + this.rte;
                        }
                        if (SB2.hasKicko && Math.abs(this.kicko) > 0.001) {
                            sql = sql + ",kicko=" + this.kicko;
                        }
                        sql = sql + " WHERE well_code='" + this.wellCode + "'";
                        rows = stmt.executeUpdate(sql = SB2.modQuery(sql));
                        if (rows != 1) {
                            throw new SBException("Error - in statement: " + sql + "\nNumber of rows updated: " + rows);
                        }
                        sql = "UPDATE " + SB2.DBTableName("WELLS") + " SET ";
                        sql = sql + "datum=" + this.datum + ",type='" + this.type + "',units='" + this.wellUnits + "'";
                        if (this.usrid == null || this.usrid.length() == 0) break block48;
                        if (SBdb.preserveAudit) break block49;
                    }
                    if (SB2.user != null) {
                        this.usrid = SB2.user.getUsrID();
                    }
                }
                if (this.userDate == null) break block50;
                if (SBdb.preserveAudit) break block51;
            }
            this.userDate = new java.util.Date();
        }
        if (this.usrid != null) {
            sql = sql + ",usrid='" + this.usrid + "'";
        }
        if (this.userDate != null) {
            sql = sql + ",userdate='" + df.format(this.userDate) + "'";
        }
        if (this.geoDatum != null && this.geoDatum.length() > 0) {
            sql = sql + ",geodatum='" + this.geoDatum + "'";
        }
        sql = sql + " WHERE well_code='" + this.wellCode + "'";
        rows = stmt.executeUpdate(sql = SB2.modQuery(sql));
        if (rows != 1) {
            throw new SBException("Error - in statement: " + sql + "\nNumber of rows updated: " + rows);
        }
        this.updateDescrip(SB2, this.wellCode, stmt);
        this.status = STORED;
        stmt.close();
        this.isUpdateable = false;
    }

    private void updateDescrip(SBdb SB2, String wellCode, Statement stmt) throws SQLException {
        String sql = "UPDATE " + SB2.DBTableName("version") + " SET descrip=" + SB.DBString(this.descrip) + " WHERE code=" + SB.DBString(wellCode);
        stmt.executeUpdate(SB2.modQuery(sql));
    }

    int checkPerm(SBdb SB2) throws SQLException {
        if (this.wellPermission != -1) {
            return this.wellPermission;
        }
        this.wellPermission = WellHeader.checkWellPerm(SB2, this.country, this.field, this.oper);
        if (this.wellPermission == 0 || !SB2.hasWellPerm) {
            return this.wellPermission;
        }
        this.wellPermission = 1;
        String sql = "SELECT acctype, usrid FROM ";
        sql = sql + SB2.DBTableName("WELLPERM");
        sql = sql + " WHERE well_code=";
        sql = sql + SB.DBString(this.wellCode);
        sql = sql + " ORDER BY acctype";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int acctype = rs.getInt("acctype");
            String usrid = rs.getString("usrid");
            if (usrid != null && usrid.equals(SB2.user.getUsrID())) {
                this.wellPermission = 1;
                break;
            }
            this.wellPermission = acctype;
        }
        stmt.close();
        return this.wellPermission;
    }

    static int checkWellPerm(SBdb SB2, String country, String field, String oper) throws SQLException {
        return 1;
    }

    static void loadPermissions(SBdb SB2) throws SQLException {
    }

    public int compareTo(Object o) {
        WellHeader rhs = (WellHeader)o;
        if (rhs.wellName.equalsIgnoreCase(this.wellName)) {
            return rhs.wellCode.compareToIgnoreCase(rhs.wellCode);
        }
        return rhs.wellName.compareToIgnoreCase(this.wellName);
    }

    void extendTD(double newTD) throws SBException {
        if (newTD > this.td) {
            this.setTD(newTD);
            if (this.status == Well.STORED) {
                this.status = Well.PARTSTORED;
            }
        }
    }

    void load(SBdb SB2, int wellID) throws SQLException, SBException {
        String sql = "SELECT well_name,well_code,v.descrip,restricted,operator,country,";
        if (SB2.hasCounty) {
            sql = sql + "county,";
        }
        if (SB2.hasOcs) {
            sql = sql + "ocs,";
        }
        sql = sql + "field,quadrant,block,sub_block,grid_x,grid_y,spud_date,comp_date,td,sl,sb,rte,";
        if (SB2.hasKicko) {
            sql = sql + "kicko,";
        }
        sql = sql + "datum,type,units,usrid,userdate,geodatum";
        sql = sql + " FROM " + SB2.DBTableName("WELLS") + " w," + SB2.DBTableName("VERSION") + " v WHERE w.well_code=v.code AND v.well_id=" + wellID;
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            this.wellName = rs.getString("well_name");
            this.wellCode = rs.getString("well_code");
            this.descrip = SB.getDBString(rs, "descrip");
            if (rs.getInt("restricted") == 1) {
                this.restrict = true;
            }
            this.oper = SB.getDBString(rs, "operator");
            this.country = SB.getDBString(rs, "country");
            if (SB2.hasCounty) {
                this.county = SB.getDBString(rs, "county");
            }
            if (SB2.hasOcs) {
                this.ocs = SB.getDBString(rs, "ocs");
            }
            this.field = SB.getDBString(rs, "field");
            this.quadrant = SB.getDBString(rs, "quadrant");
            this.block = SB.getDBString(rs, "block");
            this.subBlock = SB.getDBString(rs, "sub_block");
            this.gridX = rs.getInt("grid_x");
            this.gridY = rs.getInt("grid_y");
            this.spud = rs.getDate("spud_date");
            this.comp = rs.getDate("comp_date");
            this.td = rs.getDouble("td");
            this.sl = rs.getDouble("sl");
            this.sb = rs.getDouble("sb");
            this.rte = rs.getDouble("rte");
            if (SB2.hasKicko) {
                this.kicko = rs.getDouble("kicko");
            }
            this.datum = (char)rs.getInt("datum");
            String s = rs.getString("type");
            if (s != null && s.length() > 0) {
                this.type = s.charAt(0);
            }
            if ((s = rs.getString("units")) != null && s.length() > 0) {
                this.wellUnits = s.charAt(0);
            }
        } else {
            throw new SBException("WellHeader: Cannot select well with well_id=" + wellID);
        }
        this.usrid = rs.getString("usrid");
        this.userDate = rs.getDate("userdate");
        this.geoDatum = SB.getDBString(rs, "geodatum");
        sql = "SELECT lat_dec,lat_ind,lat_deg,lat_min,lat_sec,long_dec,long_ind,long_deg,long_min,long_sec";
        sql = sql + " FROM " + SB2.DBTableName("WELLS") + " WHERE well_code='" + this.wellCode + "'";
        sql = SB2.modQuery(sql);
        rs = stmt.executeQuery(sql);
        if (rs.next()) {
            this.lat_dec = rs.getDouble("lat_dec");
            String temp = rs.getString("lat_ind");
            if (temp != null && temp.length() > 0) {
                this.lat_ind = temp.charAt(0);
            }
            this.lat_deg = (short)rs.getInt("lat_deg");
            this.lat_min = (short)rs.getInt("lat_min");
            this.lat_sec = rs.getFloat("lat_sec");
            this.long_dec = rs.getDouble("long_dec");
            temp = rs.getString("long_ind");
            if (temp != null && temp.length() > 0) {
                this.long_ind = temp.charAt(0);
            }
            this.long_deg = (short)rs.getInt("long_deg");
            this.long_min = (short)rs.getInt("long_min");
            this.long_sec = rs.getFloat("long_sec");
            this.deriveCoords();
        }
        stmt.close();
    }

    void deriveCoords() {
        double temp_min;
        if (this.lat_deg == 0 && this.lat_dec > 0.001) {
            this.lat_deg = (short)this.lat_dec;
            temp_min = (this.lat_dec - (double)this.lat_deg) * 60.0;
            this.lat_min = (short)temp_min;
            this.lat_sec = (float)Math.round((temp_min - (double)this.lat_min) * 6000.0) / 100.0f;
        }
        if (this.long_deg == 0 && this.long_dec > 0.001) {
            this.long_deg = (short)this.long_dec;
            temp_min = (this.long_dec - (double)this.long_deg) * 60.0;
            this.long_min = (short)temp_min;
            this.long_sec = (float)Math.round((temp_min - (double)this.long_min) * 6000.0) / 100.0f;
        }
    }

    void updateStatus(SBdb SB2, int wellID) throws SBException, SQLException {
        if (this.status == PARTSTORED) {
            return;
        }
        Well well = new Well(SB2, wellID, false, false, null);
        WellHeader tmp = well.header;
        MergeStatus m = new MergeStatus(this.status);
        m.compareStringField("Well Code", this.wellCode, tmp.wellCode, false);
        m.compareStringField("Well Name", this.wellName, tmp.wellName, false);
        this.country = m.compareStringField("Country", this.country, tmp.country, true);
        this.county = m.compareStringField("County", this.county, tmp.county, true);
        this.field = m.compareStringField("Field", this.field, tmp.field, true);
        this.quadrant = m.compareStringField("Quadrant", this.quadrant, tmp.quadrant, true);
        this.block = m.compareStringField("Block", this.block, tmp.block, true);
        this.subBlock = m.compareStringField("Sub block", this.subBlock, tmp.subBlock, true);
        this.comp = m.compareDateField("Completion date", this.comp, tmp.comp);
        this.spud = m.compareDateField("Spud date", this.spud, tmp.spud);
        this.datum = m.compareIntField("Depth datum", this.datum, tmp.datum);
        this.geoDatum = m.compareStringField("Geodetic datum", this.geoDatum, tmp.geoDatum, true);
        this.gridX = m.compareLongField("Grid X", this.gridX, tmp.gridX);
        this.gridY = m.compareLongField("Grid Y", this.gridY, tmp.gridY);
        this.kicko = m.compareDoubleField("Kickoff depth", this.kicko, tmp.kicko);
        this.lat_dec = m.compareDoubleField("Latitude", this.lat_dec, tmp.lat_dec);
        this.long_dec = m.compareDoubleField("Longitude", this.long_dec, tmp.long_dec);
        this.lat_ind = m.compareCharField("Lat N/S", this.lat_ind, tmp.lat_ind);
        this.long_ind = m.compareCharField("Long E/W", this.long_ind, tmp.long_ind);
        this.ocs = m.compareStringField("OCS number", this.ocs, tmp.ocs, true);
        this.oper = m.compareStringField("Operator", this.oper, tmp.oper, true);
        this.rte = m.compareDoubleField("RTE", this.rte, tmp.rte);
        this.sb = m.compareDoubleField("Sea Bed", this.sb, tmp.sb);
        this.sl = m.compareDoubleField("Sea Level", this.sl, tmp.sl);
        this.td = m.compareDoubleField("Termination depth", this.td, tmp.td);
        this.type = m.compareCharField("Well/outcrop", this.type, tmp.type);
        m.compareCharField("Depth units", this.wellUnits, tmp.wellUnits);
        this.status = m.getStatus();
        if (this.status == CONFLICT) {
            this.headerMergeStatus = m;
        }
    }

    void writeSbugs(FileWriter out) throws IOException {
        out.write(this.wellName + '\t' + this.wellCode + '\t' + this.oper + '\t' + this.country + '\t' + this.field + '\t' + this.quadrant + '\t' + this.block + '\t' + this.subBlock + '\t' + this.gridX + '\t' + this.gridY + '\t');
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        if (this.spud != null) {
            out.write(df.format(this.spud));
        } else {
            out.write("00-Jan-0000");
        }
        out.write(9);
        if (this.comp != null) {
            out.write(df.format(this.comp));
        } else {
            out.write("00-Jan-0000");
        }
        out.write("\t" + this.lat_dec + '\t' + this.lat_ind + '\t' + this.lat_deg + '\t' + this.lat_min + '\t' + this.lat_sec + '\t');
        out.write("\t" + this.long_dec + '\t' + this.long_ind + '\t' + this.long_deg + '\t' + this.long_min + '\t' + this.long_sec + '\t');
        out.write("\t" + this.td + '\t' + this.sl + '\t' + this.sb + '\t' + this.rte + '\t' + this.datum + '\t' + this.type + '\t' + this.wellUnits + '\n');
    }

    void writeDEX(FileWriter out, String eol, boolean fullHeader, SimpleDateFormat df, Vector dataTypes, char units) throws IOException {
        out.write("[HEADER]" + eol);
        out.write("Well Name = " + this.wellName + eol);
        if (fullHeader) {
            out.write("Well Code = " + this.wellCode + eol);
            if (this.oper != null && this.oper.length() > 0) {
                out.write("Operator = " + this.oper + eol);
            }
            if (this.quadrant != null && this.quadrant.length() > 0) {
                out.write("Quadrant = " + this.quadrant + eol);
            }
            if (this.block != null && this.block.length() > 0) {
                out.write("Block = " + this.block + eol);
            }
            if (this.subBlock != null && this.subBlock.length() > 0) {
                out.write("Sub Block = " + this.subBlock + eol);
            }
            if (this.field != null && this.field.length() > 0) {
                out.write("Field = " + this.field + eol);
            }
            if (this.country != null && this.country.length() > 0) {
                out.write("Country = " + this.country + eol);
            }
            if (this.county != null && this.county.length() > 0) {
                out.write("County = " + this.county + eol);
            }
            out.write("Type = ");
            if (this.type == 'W') {
                out.write("Borehole");
            } else {
                out.write("Outcrop");
            }
            out.write(eol);
            out.write("Units = ");
            if (this.wellUnits == 'M') {
                out.write("metres");
            } else {
                out.write("feet");
            }
            out.write(eol);
            if (Math.abs(this.long_dec) > 0.003048) {
                out.write("Longtitude = " + this.long_dec + eol);
            }
            if (Math.abs(this.lat_dec) > 0.003048) {
                out.write("Latitude = " + this.lat_dec + eol);
            }
            if (this.gridX > 0L) {
                out.write("Grid X = " + this.gridX + eol);
            }
            if (this.gridY > 0L) {
                out.write("Grid Y = " + this.gridY + eol);
            }
            if (this.spud != null) {
                out.write("Spud Date = " + df.format(this.spud) + eol);
            }
            if (this.comp != null) {
                out.write("Completion Date = " + df.format(this.comp) + eol);
            }
            if (this.td > 0.0) {
                out.write("Terminal depth = " + SB.getDepthString(this.td, this.wellUnits, 2) + eol);
            }
            if (this.sl > 0.0) {
                out.write("SL = " + SB.getDepthString(this.sl, this.wellUnits, 2) + eol);
            }
            if (this.sb > 0.0) {
                out.write("SB = " + SB.getDepthString(this.sb, this.wellUnits, 2) + eol);
            }
            if (this.rte > 0.0) {
                out.write("RTE = " + SB.getDepthString(this.rte, this.wellUnits, 2) + eol);
            }
            if (this.kicko > 0.0) {
                out.write("Kick off depth = " + SB.getDepthString(this.kicko, this.wellUnits, 2) + eol);
            }
            out.write("Depth Datum = ");
            switch (this.datum) {
                default: {
                    out.write("RTE");
                    break;
                }
                case 2: {
                    out.write("SL");
                    break;
                }
                case 3: {
                    out.write("SB");
                }
            }
            out.write(eol);
        }
    }

    void writeXML(FileWriter out, int indent) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write(ind + "<WellCode>" + this.wellCode + "</WellCode>\n");
        out.write(ind + "<Country>" + this.country + "</Country>\n");
        out.write(ind + "<Type>" + (this.type == 'O' ? "Outcrop" : "Borehole") + "</Type>\n");
        out.write(ind + "<Units>" + (this.wellUnits == 'F' ? "feet" : "metres") + "</Units>\n");
        if (this.oper != null && this.oper.length() > 0) {
            out.write(ind + "<Operator>" + this.oper + "</Operator>\n");
        }
        if (this.ocs != null && this.ocs.length() > 0) {
            out.write(ind + "<Ocs>" + this.ocs + "</Ocs>\n");
        }
        if (this.quadrant != null && this.quadrant.length() > 0) {
            out.write(ind + "<Quadrant>" + this.quadrant + "</Quadrant>\n");
        }
        if (this.block != null && this.block.length() > 0) {
            out.write(ind + "<Block>" + this.block + "</Block>\n");
        }
        if (this.subBlock.length() > 0) {
            out.write(ind + "<SubBlock>" + this.subBlock + "</SubBlock>\n");
        }
        if (this.field != null && this.field.length() > 0) {
            out.write(ind + "<Field>" + this.field + "</Field>\n");
        }
        if (this.county != null && this.county.length() > 0) {
            out.write(ind + "<County>" + this.county + "</County>\n");
        }
        if (Math.abs(this.lat_dec) > 0.001) {
            out.write(ind + "<Latitude>" + this.lat_dec + "</Latitude>\n");
            out.write(ind + "<LatitudeIndicator>" + this.lat_ind + "</LatitudeIndicator>");
        }
        if (Math.abs(this.long_dec) > 0.001) {
            out.write(ind + "<Longitude>" + this.long_dec + "</Longitude>\n");
            out.write(ind + "<LongitudeIndicator>" + this.long_ind + "</LongitudeIndicator>");
        }
        if (this.geoDatum != null && this.geoDatum.length() > 0) {
            out.write(ind + "<GeodeticDatum>" + this.geoDatum + "</GeodeticDatum>\n");
        }
        if (this.gridX > 0L) {
            out.write(ind + "<GridX>" + this.gridX + "</GridX>\n");
        }
        if (this.gridY > 0L) {
            out.write(ind + "<GridY>" + this.gridY + "</GridY>\n");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (this.spud != null) {
            out.write(ind + "<SpudDate>" + df.format(this.spud) + "</SpudDate>\n");
        }
        if (this.comp != null) {
            out.write(ind + "<CompletionDate>" + df.format(this.comp) + "</CompletionDate>\n");
        }
        out.write(ind + "<TerminalDepth>" + SB.convFromM(this.td, this.wellUnits) + "</TerminalDepth>\n");
        switch (this.datum) {
            case 1: {
                out.write(ind + "<DepthDatum>RTE</DepthDatum>\n");
                break;
            }
            case 2: {
                out.write(ind + "<DepthDatum>SL</DepthDatum>\n");
                break;
            }
            case 3: {
                out.write(ind + "<DepthDatum>SB</DepthDatum>\n");
            }
        }
        if (Math.abs(this.rte) > 0.001) {
            out.write(ind + "<RotaryTableElevation>" + SB.convFromM(this.rte, this.wellUnits) + "</RotaryTableElevation>\n");
        }
        if (Math.abs(this.sl) > 0.001) {
            out.write(ind + "<SeaLevel>" + SB.convFromM(this.sl, this.wellUnits) + "</SeaLevel>\n");
        }
        if (Math.abs(this.sb) > 0.001) {
            out.write(ind + "<SeaBed>" + SB.convFromM(this.sb, this.wellUnits) + "</SeaBed>\n");
        }
        if (Math.abs(this.kicko) > 0.001) {
            out.write(ind + "<KickOffDepth>" + SB.convFromM(this.kicko, this.wellUnits) + "</KickOffDepth>\n");
        }
    }

    void parseXML(String chars, String element) throws ParseException {
        if (element.compareTo("WellCode") == 0) {
            this.wellCode = chars;
        } else if (element.compareTo("Country") == 0) {
            this.country = chars;
        } else if (element.compareTo("County") == 0) {
            this.county = chars;
        } else if (element.compareTo("Field") == 0) {
            this.field = chars;
        } else if (element.compareTo("Type") == 0) {
            if (chars.compareToIgnoreCase("Outcrop") == 0) {
                this.type = (char)79;
            }
        } else if (element.compareTo("Operator") == 0) {
            this.oper = chars;
        } else if (element.compareTo("Ocs") == 0) {
            this.ocs = chars;
        } else if (element.compareTo("Quadrant") == 0) {
            this.quadrant = chars;
        } else if (element.compareTo("Block") == 0) {
            this.block = chars;
        } else if (element.compareTo("SubBlock") == 0) {
            this.subBlock = chars;
        } else if (element.compareTo("Longitude") == 0) {
            this.long_dec = Float.parseFloat(chars);
            this.deriveCoords();
        } else if (element.compareTo("LatitudeIndicator") == 0) {
            if ((chars = chars.trim()).length() > 0) {
                this.lat_ind = chars.charAt(0);
            }
        } else if (element.compareTo("LongitudeIndicator") == 0) {
            if ((chars = chars.trim()).length() > 0) {
                this.long_ind = chars.charAt(0);
            }
        } else if (element.compareTo("Latitude") == 0) {
            this.lat_dec = Float.parseFloat(chars);
            this.deriveCoords();
        } else if (element.compareTo("GeodeticDatum") == 0) {
            this.geoDatum = chars;
        } else if (element.compareTo("GridX") == 0) {
            this.gridX = Long.parseLong(chars);
        } else if (element.compareTo("GridY") == 0) {
            this.gridY = Long.parseLong(chars);
        } else if (element.compareTo("SpudDate") == 0) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            this.spud = df.parse(chars);
        } else if (element.compareTo("CompletionDate") == 0) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            this.comp = df.parse(chars);
        } else if (element.compareTo("Units") == 0) {
            this.wellUnits = chars.toUpperCase().charAt(0);
        } else if (element.compareTo("TerminalDepth") == 0) {
            this.td = SB.convToM((double)Float.parseFloat(chars), this.wellUnits);
        } else if (element.compareTo("SeaLevel") == 0) {
            this.sl = SB.convToM((double)Float.parseFloat(chars), this.wellUnits);
        } else if (element.compareTo("SeaBed") == 0) {
            this.sb = SB.convToM((double)Float.parseFloat(chars), this.wellUnits);
        } else if (element.compareTo("KickOffDepth") == 0) {
            this.kicko = SB.convToM((double)Float.parseFloat(chars), this.wellUnits);
        } else if (element.compareTo("RotaryTableElevation") == 0) {
            this.rte = SB.convToM((double)Float.parseFloat(chars), this.wellUnits);
        } else if (element.compareTo("DepthDatum") == 0) {
            if (chars.compareTo("RTE") == 0) {
                this.datum = 1;
            } else if (chars.compareTo("SL") == 0) {
                this.datum = 2;
            } else if (chars.compareTo("SB") == 0) {
                this.datum = 3;
            }
        }
    }
}

