/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import model1_8.Biocom;
import model1_8.CompositeStandard;
import model1_8.DiscAnalyst;
import model1_8.EnvScheme;
import model1_8.EvProject;
import model1_8.IGDHdr;
import model1_8.IGDInterval;
import model1_8.IGDIntervalEnv;
import model1_8.IGDIntervalSeq;
import model1_8.IGDIntervalZone;
import model1_8.IGDScheme;
import model1_8.IGDUnit;
import model1_8.InterpHdr;
import model1_8.QSLOC;
import model1_8.SBEvent;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import model1_8.Well;
import model1_8.WellEvent;
import model1_8.WellEventCompareDepth;
import util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WellInterp
extends Observable {
    SBdb SB;
    InterpHdr interp;
    int interpID;
    private char sectionType = (char)87;
    List lstrat = new LinkedList();
    List chrono = new LinkedList();
    List biozone1 = new LinkedList();
    List biozone2 = new LinkedList();
    List biozone3 = new LinkedList();
    List biozone4 = new LinkedList();
    List sequences = new LinkedList();
    List[] zoneTypes = new List[]{this.lstrat, this.chrono, this.biozone1, this.biozone2, this.biozone3, this.biozone4, this.sequences};
    List<Biocom> comments = new LinkedList<Biocom>();
    List envs = new LinkedList();
    List headers = new LinkedList();
    EvProject evProject = null;
    private boolean loaded = false;

    public InterpHdr getHeader() {
        return this.interp;
    }

    public int getInterpID() {
        return this.interpID;
    }

    public WellInterp(SBdb SB2, char sectionType) {
        this.SB = SB2;
        this.sectionType = sectionType;
    }

    public String toString() {
        if (this.interp == null) {
            return "Null Interp";
        }
        return this.interp.toString();
    }

    public WellInterp(SBdb SB2, int interpID, HashMap<Integer, InterpHdr> interps, char sectionType) throws SQLException {
        this.SB = SB2;
        this.sectionType = sectionType;
        this.interpID = interpID;
        this.interp = interps.get(interpID);
        if (this.interp == null) {
            this.interp = new InterpHdr(SB2, interpID);
            interps.put(interpID, this.interp);
        }
    }

    static int zoneType2IGDType(int zoneType) throws SBException {
        switch (zoneType) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 41;
            }
            case 3: {
                return 42;
            }
            case 4: {
                return 43;
            }
            case 5: {
                return 44;
            }
            case 6: {
                return 10;
            }
        }
        throw new SBException("Overrun of zone type in zoneType2IGDType");
    }

    public double getMinAge(IGDScheme scheme) throws SBException {
        double age = -1.0;
        for (List zones : this.zoneTypes) {
            for (Object o : zones) {
                IGDUnit unit;
                IGDIntervalZone zone = (IGDIntervalZone)o;
                if (zone.getSchID() != scheme.getSchID() || (unit = scheme.findUnit(zone.getUppZone())) == null || !(age < 0.0) && !(unit.getUage() < age)) continue;
                age = unit.getUage();
            }
        }
        return age;
    }

    public double getMaxAge(IGDScheme scheme) throws SBException {
        double age = -1.0;
        for (List zones : this.zoneTypes) {
            for (Object o : zones) {
                IGDUnit unit;
                IGDIntervalZone zone = (IGDIntervalZone)o;
                if (zone.getSchID() != scheme.getSchID()) continue;
                int zoneID = zone.getLowZone();
                if (zoneID <= 0) {
                    zoneID = zone.getUppZone();
                }
                if ((unit = scheme.findUnit(zoneID)) == null || !(age < 0.0) && !(unit.getLage() > age)) continue;
                age = unit.getLage();
            }
        }
        return age;
    }

    boolean hasExistingIGDData(int igdType, int wellID) throws SQLException {
        String sql = "SELECT top_id FROM " + this.SB.DBTableName("IGD") + " WHERE igd_type=" + igdType + " AND " + IGDInterval.interpString(this.interpID, null) + " AND top_id >=" + wellID * 65536 + " AND top_id < " + (wellID + 1) * 65536;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            stmt.close();
            return true;
        }
        stmt.close();
        return false;
    }

    void deleteExistingIGDData(int igdType, int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD") + " WHERE igd_type=" + igdType + " AND " + IGDInterval.interpString(this.interpID, null) + " AND top_id >=" + wellID * 65536 + " AND top_id < " + (wellID + 1) * 65536;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    boolean hasExistingEnvData(int wellID) throws SQLException {
        String sql = "SELECT top_id FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE " + IGDInterval.interpString(this.interpID, null) + " AND top_id >=" + wellID * 65536 + " AND top_id < " + (wellID + 1) * 65536;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            stmt.close();
            return true;
        }
        stmt.close();
        return false;
    }

    void deleteExistingEnvData(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE " + IGDInterval.interpString(this.interpID, null) + " AND top_id >=" + wellID * 65536 + " AND top_id < " + (wellID + 1) * 65536;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    boolean hasExistingBiocomData(DiscAnalyst discAnalyst, int wellID) throws SQLException {
        String sql = "SELECT usamp_id FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE disc_id=" + util.SB.DBChar(discAnalyst.discID);
        sql = discAnalyst.analyst.length() > 0 ? sql + " AND analyst='" + discAnalyst.analyst + "' " : sql + " AND (analyst is null OR analyst='')";
        sql = sql + " AND " + IGDInterval.interpString(this.interpID, null);
        sql = sql + " AND usamp_id >=" + wellID * 65536 + " AND usamp_id < " + (wellID + 1) * 65536;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            stmt.close();
            return true;
        }
        stmt.close();
        return false;
    }

    void deleteExistingBiocomData(DiscAnalyst discAnalyst, int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE disc_id=" + util.SB.DBChar(discAnalyst.discID);
        sql = discAnalyst.analyst.length() > 0 ? sql + " AND analyst='" + discAnalyst.analyst + "' " : sql + " AND (analyst is null OR analyst='')";
        sql = sql + " AND " + IGDInterval.interpString(this.interpID, null);
        sql = sql + " AND usamp_id >=" + wellID * 65536 + " AND usamp_id < " + (wellID + 1) * 65536;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    IGDHdr getHeader(int igdType, boolean create) {
        Iterator it = this.headers.iterator();
        IGDHdr hdr = null;
        while (it.hasNext()) {
            hdr = (IGDHdr)it.next();
            if (hdr.igdType == igdType) {
                return hdr;
            }
            hdr = null;
        }
        if (create) {
            hdr = new IGDHdr(this.SB);
            hdr.igdType = igdType;
            this.headers.add(hdr);
        }
        return hdr;
    }

    IGDHdr loadHeader(int igdType, int wellID) throws SQLException, SBException {
        IGDHdr header = null;
        header = this.getHeader(igdType, true);
        header.load(this.interpID, wellID);
        return header;
    }

    void addHeader(int igdType, IGDHdr hdr) throws SBException {
        if (this.getHeader(igdType, false) != null) {
            throw new SBException("Attempt to add header that already exists");
        }
        this.headers.add(hdr);
    }

    void storeHeader(int igdType, int wellID) throws SQLException, SBException {
        if (wellID > 0) {
            IGDHdr hdr = this.getHeader(igdType, false);
            if (hdr == null) {
                throw new SBException("Can't locate IGD header to be stored");
            }
            hdr.store(this.interpID, wellID);
        }
    }

    void load(Well well) throws SBException, SQLException {
        if (!this.loaded) {
            System.out.println("Loading interp zones...");
            for (int zoneType = 0; zoneType < this.zoneTypes.length; ++zoneType) {
                this.loadZones(WellInterp.zoneType2IGDType(zoneType), well.wellID, well);
                this.loadHeader(WellInterp.zoneType2IGDType(zoneType), well.wellID);
            }
            System.out.println("Loading interp comments...");
            this.loadComments('\u0000', well);
            System.out.println("Loading interp envs...");
            this.loadEnvs(well, this.SB.getEnvSchemes());
            System.out.println("Loading interp events...");
            this.loadEvents(well);
            this.loaded = true;
        }
    }

    void loadEvents(Well well) throws SQLException, SBException {
        if (!this.SB.hasEventExtensions) {
            return;
        }
        if (this.evProject != null) {
            throw new SBException("Attempt to load new evProject");
        }
        this.evProject = new EvProject(this.SB, this.interpID);
        this.evProject.load(well.wellID, null);
        this.evProject.fillSamples(well.getSamples(), well.getWellUnits(), well.getType());
    }

    public void deleteEvent(WellEvent wellEvent) throws SBException, SQLException {
        if (this.evProject == null) {
            throw new SBException("No evProject loaded in wellInterp.deleteEvent");
        }
        this.evProject.deleteEvent(wellEvent);
        this.setChanged();
    }

    public void addEvent(Sample sample, SBEvent event, char eventType, char discID, String analyst, String comments) throws SBException, SQLException {
        if (this.evProject == null) {
            throw new SBException("No evProject loaded in wellInterp.addEvent");
        }
        this.evProject.addEvent(sample, event, eventType, discID, analyst, comments);
        this.setChanged();
    }

    public int generateEvents(Well well, boolean incCU, boolean incCO, boolean incSC, boolean incOC, String discs, boolean incRW, boolean incCV, CompositeStandard std, boolean useSynonym, int synSch) throws SQLException, SBException {
        int nAdded = 0;
        if (this.evProject == null) {
            throw new SBException("No evProject loaded in wellInterp.addEvent");
        }
        std.load();
        nAdded = this.evProject.generateEvents(well, incCU, incCO, incSC, incOC, discs, incRW, incCV, std, useSynonym, synSch);
        this.setChanged();
        return nAdded;
    }

    public void notifyEventObservers() {
        this.notifyObservers(this.evProject);
    }

    public List<WellEvent> getEvents() {
        if (this.evProject != null) {
            return this.evProject.events;
        }
        return null;
    }

    public List<WellEvent> getEventsByDepth() {
        if (this.evProject != null) {
            List events = this.evProject.events;
            Collections.sort(events, new WellEventCompareDepth(true));
            return events;
        }
        return null;
    }

    public void deleteLOC(QSLOC loc) throws SQLException, SBException {
        loc.delete();
        this.evProject.LOCs.remove(loc);
    }

    public List<QSLOC> getQSLOCs() {
        if (this.evProject != null) {
            return this.evProject.LOCs;
        }
        return null;
    }

    public void deleteQSLOCs(Well well) throws SQLException, SBException {
        if (this.evProject == null) {
            throw new SBException("No event project loaded in deleteQSLOCs");
        }
        this.evProject.deleteLOC(well.wellID);
        this.evProject.LOCs.clear();
    }

    public void addQSLOC(int index, Well well, CompositeStandard cmpStd, double csu1, double depth1, double csu2, double depth2, float width, Color colour) throws SBException, SQLException {
        if (this.evProject == null) {
            throw new SBException("No event project loaded in deleteQSLOCs");
        }
        QSLOC loc = new QSLOC(this.SB, cmpStd.getStdID(), this.evProject.qsID, well.wellID, depth1, depth2, csu1, csu2, colour, width);
        loc.status = QSLOC.NOTSTORED;
        loc.store(well.wellID, this.evProject.qsID);
        this.evProject.LOCs.add(index, loc);
    }

    public void deriveQSLOCs(IGDScheme scheme, Well well, CompositeStandard cmpStd) throws SQLException, SBException {
        List<IGDIntervalZone> zones = this.getMaxIGDHierZones(scheme.getIGDType());
        double lastDepth = -1.0;
        double lastCsu = -1.0;
        for (IGDIntervalZone zone : zones) {
            double lowDepth;
            if (zone.getSchID() != scheme.getID()) continue;
            IGDUnit uppUnit = scheme.findUnit(zone.getUppZone());
            IGDUnit lowUnit = scheme.findUnit(zone.getLowZone());
            if (uppUnit == null) continue;
            if (lowUnit == null) {
                lowUnit = uppUnit;
            }
            if (lastDepth >= 0.0 && (Math.abs((lowDepth = zone.getTopSample().getDepth()) - lastDepth) > 0.001 || Math.abs(lastCsu - uppUnit.getUage()) > 0.001)) {
                QSLOC loc = new QSLOC(this.SB, cmpStd, lowDepth, lastDepth, uppUnit.getUage(), lastCsu);
                loc.store(well.wellID, this.evProject.qsID);
                this.evProject.LOCs.add(loc);
            }
            QSLOC loc = new QSLOC(this.SB, cmpStd, zone.getBaseSample().getDepth(), zone.getTopSample().getDepth(), lowUnit.getLage(), uppUnit.getUage());
            loc.store(well.wellID, this.evProject.qsID);
            this.evProject.LOCs.add(loc);
            lastDepth = zone.getBaseSample().getDepth();
            lastCsu = lowUnit.getLage();
        }
    }

    public void deriveSampleAges(Well well, CompositeStandard cmpStd, char displayUnits) throws SQLException, SBException {
        List samples = well.getSamples();
        well.deleteSampleAges(this.interpID);
        for (Sample sample : samples) {
            List locs = this.evProject.LOCs;
            for (QSLOC LOC : locs) {
                if (!(LOC.getDepth2() <= sample.getDepth()) || !(LOC.getDepth1() >= sample.getDepth())) continue;
                if (LOC.isUnconformity()) {
                    sample.setAge(LOC.getCsu2(), LOC.getCsu1(), 0.0, 0.0, 0.0);
                } else if (!sample.hasAgeData()) {
                    double age = LOC.getCsu2() + (LOC.getCsu1() - LOC.getCsu2()) * (sample.getDepth() - LOC.getDepth2()) / (LOC.getDepth1() - LOC.getDepth2());
                    sample.setAge(age, 0.0, 0.0, 0.0, 0.0);
                    sample.displayUnits = displayUnits;
                }
                sample.storeAge(this.interpID);
            }
        }
        List locs = this.evProject.LOCs;
        for (QSLOC LOC : locs) {
            Sample sample;
            if (!LOC.isUnconformity() || (sample = well.getSample(LOC.getDepth1(), LOC.getDepth1(), "LOG", false)) != null) continue;
            sample = well.addSample(LOC.getDepth1(), LOC.getDepth1(), "LOG", "X");
            sample.setAge(LOC.getCsu2(), LOC.getCsu1(), 0.0, 0.0, 0.0);
        }
    }

    public Biocom addBiocom(Well well, char discID, Sample topSample, Sample baseSample, String analyst, String dataSource, String text) throws SBException, SQLException {
        for (Biocom bc : this.comments) {
            if (bc.getTopID() != topSample.getSampID() || bc.getDiscID() != discID || !bc.getAnalyst().equals(analyst)) continue;
            throw new SBException("A comment of this discipline/depth/analyst already exists");
        }
        Biocom biocom = new Biocom(this.SB, this.interpID, discID, topSample, baseSample, analyst, text, dataSource);
        this.insertBiocom(biocom);
        this.setChanged();
        return biocom;
    }

    public Biocom updateBiocom(Biocom biocom, char discID, Sample topSample, Sample baseSample, String analyst, String dataSource, String text) throws SBException, SQLException {
        for (Biocom bc : this.comments) {
            if (bc == biocom || bc.getTopID() != topSample.getSampID() || bc.getDiscID() != discID || !bc.getAnalyst().equals(analyst)) continue;
            throw new SBException("A comment of this discipline/depth/analyst already exists");
        }
        biocom.delete(this.interpID);
        this.comments.remove(biocom);
        biocom = new Biocom(this.SB, this.interpID, discID, topSample, baseSample, analyst, text, dataSource);
        biocom.status = Biocom.NOTSTORED;
        this.insertBiocom(biocom);
        this.setChanged();
        return biocom;
    }

    public void deleteBiocom(Biocom biocom) throws SBException, SQLException {
        biocom.delete(this.interpID);
        this.comments.remove(biocom);
        this.setChanged();
    }

    public IGDIntervalZone addZone(int igdType, Well well, Sample topSample, Sample baseSample, String topAnalyst, String baseAnalyst, int topBnd, int baseBnd, int plotPos, int schID, int uppZone, String uppInf, int lowZone, String lowInf, boolean qUzone, boolean qLzone) throws SBException, SQLException {
        String modifier = this.SB.getUser().getUsrID();
        java.util.Date modified = new java.util.Date();
        IGDIntervalZone zone = new IGDIntervalZone(this.SB, igdType, well, topSample.getID(), baseSample.getID(), topAnalyst, baseAnalyst, topBnd, baseBnd, plotPos, schID, uppZone, uppInf, lowZone, lowInf, qUzone, qLzone, modifier, modified);
        zone.status = IGDIntervalZone.NOTSTORED;
        this.checkOverlap(zone, null, true);
        zone.store(this.interpID);
        this.insertZone(zone);
        this.setChanged();
        return zone;
    }

    public IGDIntervalEnv addEnvInterval(Well well, Sample topSample, Sample baseSample, EnvScheme scheme, int up, int ud, int lp, int ld, int qual) throws SBException, SQLException {
        String modifier = this.SB.getUser().getUsrID();
        java.util.Date modified = new java.util.Date();
        if (up == 0) {
            throw new SBException("Null Upper proximal environment for interval at: " + topSample);
        }
        if (ud < up) {
            ud = up;
        }
        if (lp == 0) {
            lp = up;
        }
        if (ld < lp) {
            ld = lp;
        }
        IGDIntervalEnv zone = new IGDIntervalEnv(this.SB, topSample, baseSample, scheme, up, ud, lp, ld, qual, modifier, modified);
        zone.status = IGDIntervalEnv.NOTSTORED;
        this.checkOverlap(zone, null, true);
        zone.store(this.interpID);
        this.insertEnv(zone);
        this.setChanged();
        return zone;
    }

    public IGDIntervalEnv updateEnvInterval(IGDIntervalEnv original, Well well, Sample topSample, Sample baseSample, EnvScheme scheme, int up, int ud, int lp, int ld, int qual) throws SBException, SQLException {
        String modifier = this.SB.getUser().getUsrID();
        java.util.Date modified = new java.util.Date();
        IGDIntervalEnv zone = new IGDIntervalEnv(this.SB, topSample, baseSample, scheme, up, ud, lp, ld, qual, modifier, modified);
        this.checkOverlap(zone, original, true);
        original.delete(this.interpID);
        zone.status = IGDIntervalEnv.NOTSTORED;
        zone.store(this.interpID);
        this.replaceEnv(zone, original);
        this.setChanged();
        return zone;
    }

    public IGDIntervalZone updateZone(IGDIntervalZone original, int igdType, Well well, Sample topSample, Sample baseSample, String topAnalyst, String baseAnalyst, int topBnd, int baseBnd, int plotPos, int schID, int uppZone, String uppInf, int lowZone, String lowInf, boolean qUzone, boolean qLzone) throws SBException, SQLException {
        String modifier = this.SB.getUser().getUsrID();
        java.util.Date modified = new java.util.Date();
        IGDIntervalZone zone = new IGDIntervalZone(this.SB, igdType, well, topSample.getID(), baseSample.getID(), topAnalyst, baseAnalyst, topBnd, baseBnd, plotPos, schID, uppZone, uppInf, lowZone, lowInf, qUzone, qLzone, modifier, modified);
        this.checkOverlap(zone, original, true);
        original.delete(this.interpID);
        zone.status = IGDIntervalZone.NOTSTORED;
        zone.store(this.interpID);
        this.replaceZone(zone, original);
        this.setChanged();
        return zone;
    }

    public IGDIntervalSeq addSequence(int igdType, Well well, Sample topSample, Sample baseSample, String topAnalyst, String baseAnalyst, int topBnd, int baseBnd, int plotPos, int schID, int uppZone, String uppInf, int lowZone, String lowInf, boolean qUzone, boolean qLzone, boolean HST, boolean TST, boolean LST, String hst, String tst, String lst, Sample mfsSample, Sample tsSample) throws SBException, SQLException {
        String modifier = this.SB.getUser().getUsrID();
        java.util.Date modified = new java.util.Date();
        IGDIntervalSeq zone = new IGDIntervalSeq(this.SB, well, topSample.getID(), baseSample.getID(), topAnalyst, baseAnalyst, topBnd, baseBnd, plotPos, schID, uppZone, uppInf, lowZone, lowInf, qUzone, qLzone, HST, TST, LST, hst, tst, lst, mfsSample, tsSample, modifier, modified);
        zone.status = IGDIntervalZone.NOTSTORED;
        this.checkOverlap(zone, null, true);
        zone.store(this.interpID);
        this.insertZone(zone);
        this.setChanged();
        return zone;
    }

    public IGDIntervalSeq updateSequence(IGDIntervalSeq original, int igdType, Well well, Sample topSample, Sample baseSample, String topAnalyst, String baseAnalyst, int topBnd, int baseBnd, int plotPos, int schID, int uppZone, String uppInf, int lowZone, String lowInf, boolean qUzone, boolean qLzone, boolean HST, boolean TST, boolean LST, String hst, String tst, String lst, Sample mfsSample, Sample tsSample) throws SBException, SQLException {
        String modifier = this.SB.getUser().getUsrID();
        java.util.Date modified = new java.util.Date();
        IGDIntervalSeq zone = new IGDIntervalSeq(this.SB, well, topSample.getID(), baseSample.getID(), topAnalyst, baseAnalyst, topBnd, baseBnd, plotPos, schID, uppZone, uppInf, lowZone, lowInf, qUzone, qLzone, HST, TST, LST, hst, tst, lst, mfsSample, tsSample, modifier, modified);
        zone.status = IGDIntervalZone.NOTSTORED;
        this.checkOverlap(zone, original, true);
        original.delete(this.interpID);
        zone.store(this.interpID);
        this.removeZone(original);
        this.insertZone(zone);
        this.setChanged();
        return zone;
    }

    public void checkOverlap(IGDIntervalZone zone, IGDIntervalZone original, boolean checkBoundaries) throws SBException {
        List zones = this.getIGDList(zone.igdType);
        int nzTD = (int)(zone.topSample.getDepth('M') * 100.0);
        int nzBD = (int)(zone.baseSample.getDepth('M') * 100.0);
        for (int i = 0; i < zones.size(); ++i) {
            IGDIntervalZone compareWith = (IGDIntervalZone)zones.get(i);
            if (compareWith == original) continue;
            int cTD = (int)(compareWith.topSample.getDepth('M') * 100.0);
            int cBD = (int)(compareWith.baseSample.getDepth('M') * 100.0);
            if (zone.getPlotPos() != compareWith.getPlotPos()) continue;
            try {
                util.SB.checkOverlap(nzTD, nzBD, cTD, cBD);
            }
            catch (util.SBException sbe) {
                throw new SBException("Error inserting interval : " + sbe.getMessage() + " " + compareWith.toString());
            }
            if (!checkBoundaries) continue;
            if (cBD == nzTD && compareWith.getBaseBnd() != zone.getTopBnd()) {
                throw new SBException("New interval boundary clashes with: " + compareWith.toString());
            }
            if (cTD != nzBD || compareWith.getTopBnd() == zone.getBaseBnd()) continue;
            throw new SBException("New interval boundary clashes with: " + compareWith.toString());
        }
    }

    public void checkOverlap(IGDIntervalEnv zone, IGDIntervalEnv original, boolean checkBoundaries) throws SBException {
        int nzTD = (int)(zone.topSample.getDepth('M') * 100.0);
        int nzBD = (int)(zone.baseSample.getDepth('M') * 100.0);
        for (int i = 0; i < this.envs.size(); ++i) {
            IGDIntervalEnv compareWith = (IGDIntervalEnv)this.envs.get(i);
            if (compareWith == original) continue;
            int cTD = (int)(compareWith.topSample.getDepth('M') * 100.0);
            int cBD = (int)(compareWith.baseSample.getDepth('M') * 100.0);
            try {
                util.SB.checkOverlap(nzTD, nzBD, cTD, cBD);
                continue;
            }
            catch (util.SBException sbe) {
                throw new SBException("Error inserting palaeoenvironment: " + sbe.getMessage() + " " + compareWith.toString());
            }
        }
    }

    public void replaceZone(IGDIntervalZone zone, IGDIntervalZone original) throws SBException {
        this.removeZone(original);
        this.insertZone(zone);
    }

    public void replaceEnv(IGDIntervalEnv zone, IGDIntervalEnv original) throws SBException {
        this.envs.remove(original);
        this.insertEnv(zone);
    }

    public void deleteZone(IGDIntervalZone zone) throws SQLException, SBException {
        zone.delete(this.interpID);
        this.removeZone(zone);
    }

    public void deleteEnv(IGDIntervalEnv env) throws SQLException, SBException {
        env.delete(this.interpID);
        this.envs.remove(env);
        this.setChanged();
    }

    public void removeZone(IGDIntervalZone zone) {
        List zones = this.getIGDList(zone.igdType);
        zones.remove(zone);
        this.setChanged();
    }

    public void insertEnv(IGDIntervalEnv zone) throws SBException {
        if (this.envs == null) {
            throw new SBException("Unrecognised IGD type in interval: '" + zone.toString() + "'");
        }
        for (int i = 0; i < this.envs.size(); ++i) {
            IGDIntervalEnv insertPoint = (IGDIntervalEnv)this.envs.get(i);
            if (zone.topSample == null) break;
            if (!(zone.topSample.getDepth('M') < insertPoint.topSample.getDepth('M'))) continue;
            this.envs.add(i, zone);
            return;
        }
        this.envs.add(zone);
    }

    public void insertZone(IGDIntervalZone zone) throws SBException {
        List zones = this.getIGDList(zone.igdType);
        if (zones == null) {
            throw new SBException("Unrecognised IGD type in interval: '" + zone.toString() + "'");
        }
        for (int i = 0; i < zones.size(); ++i) {
            IGDIntervalZone insertPoint = (IGDIntervalZone)zones.get(i);
            if (zone.topSample == null) break;
            if (insertPoint.topSample == null) continue;
            if (zone.topSample.getDepth('M') < insertPoint.topSample.getDepth('M')) {
                zones.add(i, zone);
                return;
            }
            if (zone.topSample.getDepth('M') != insertPoint.topSample.getDepth('M') || zone.getPlotPos() >= insertPoint.getPlotPos()) continue;
            zones.add(i, zone);
            return;
        }
        zones.add(zone);
    }

    public void store() throws SQLException, SBException {
        IGDIntervalZone zone;
        int i;
        if (this.interpID == 0 && !this.interp.getDescription().equals(InterpHdr.defaultText)) {
            throw new SBException("Attempt to store interpretation '" + this.interp.getDescription() + "' with zero ID");
        }
        for (i = 0; i < this.chrono.size(); ++i) {
            zone = (IGDIntervalZone)this.chrono.get(i);
            zone.store(this.interpID);
        }
        for (i = 0; i < this.lstrat.size(); ++i) {
            zone = (IGDIntervalZone)this.lstrat.get(i);
            zone.store(this.interpID);
        }
        for (i = 0; i < this.sequences.size(); ++i) {
            zone = (IGDIntervalZone)this.sequences.get(i);
            zone.store(this.interpID);
        }
        for (i = 0; i < this.biozone1.size(); ++i) {
            zone = (IGDIntervalZone)this.biozone1.get(i);
            zone.store(this.interpID);
        }
        for (i = 0; i < this.biozone2.size(); ++i) {
            zone = (IGDIntervalZone)this.biozone2.get(i);
            zone.store(this.interpID);
        }
        for (i = 0; i < this.biozone3.size(); ++i) {
            zone = (IGDIntervalZone)this.biozone3.get(i);
            zone.store(this.interpID);
        }
        for (i = 0; i < this.biozone4.size(); ++i) {
            zone = (IGDIntervalZone)this.biozone4.get(i);
            zone.store(this.interpID);
        }
        this.storeComments();
        for (i = 0; i < this.envs.size(); ++i) {
            IGDIntervalEnv env = (IGDIntervalEnv)this.envs.get(i);
            env.store(this.interpID);
        }
    }

    void storeComments() throws SQLException {
        for (int i = 0; i < this.comments.size(); ++i) {
            Biocom comment = this.comments.get(i);
            comment.store(this.interpID);
        }
    }

    void loadComments(char discID, Well well) throws SQLException, SBException {
        if (well.wellID == 0) {
            return;
        }
        String sql = "SELECT usamp_id,lsamp_id,disc_id,analyst,comments";
        if (this.SB.hasBiocomSource) {
            sql = sql + ",source";
        }
        sql = sql + " FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE usamp_id >=" + well.wellID * 65536 + " AND usamp_id < " + (well.wellID + 1) * 65536 + " AND " + IGDInterval.interpString(this.interpID, null);
        if (discID > '\u0000') {
            sql = sql + " AND disc_id='" + discID + "'";
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        for (Biocom comment : this.comments) {
            if (comment.getDiscID() != discID) continue;
            this.comments.remove(comment);
        }
        while (rs.next()) {
            String text;
            int topID = rs.getInt("usamp_id");
            int baseID = rs.getInt("lsamp_id");
            if (baseID == topID) {
                baseID = 0;
            }
            discID = util.SB.getDBChar(rs, "disc_id");
            String analyst = rs.getString("analyst");
            if (analyst == null) {
                analyst = "";
            }
            if ((text = rs.getString("comments")) == null) {
                text = "";
            }
            String source = null;
            if (this.SB.hasBiocomSource) {
                source = rs.getString("source");
            }
            Sample topSample = well.getSample(topID);
            Sample baseSample = null;
            if (baseID > 0) {
                baseSample = well.getSample(baseID);
            }
            if (topSample != null) {
                Biocom comment;
                comment = new Biocom(this.SB, topSample, baseSample, discID, analyst, text, source);
                comment.status = Biocom.STORED;
                this.insertBiocom(comment);
                continue;
            }
            System.out.println("Error Loading: " + text + ", Sample ID: " + topID);
        }
        stmt.close();
    }

    void insertBiocom(Biocom biocom) throws SBException {
        Iterator<Biocom> en = this.comments.iterator();
        int i = 0;
        while (en.hasNext()) {
            Biocom current = en.next();
            if (biocom.getTopSample() == null) {
                throw new SBException("Attempt to insert Biostratigraphic Comment with no sample: " + biocom);
            }
            if (biocom.getTopSample().getDepth('M') < current.getTopSample().getDepth('M')) {
                this.comments.add(i, biocom);
                return;
            }
            ++i;
        }
        this.comments.add(biocom);
    }

    public void loadZones(int igdType, int wellID, Well well) throws SQLException, SBException {
        if (wellID == 0) {
            return;
        }
        this.getIGDList(igdType).clear();
        String sql = "SELECT top_id,base_id,top_analy,base_analy,top_bnd,base_bnd,plot_pos,sch_id,q_uzone,upp_zone,upp_inf,q_lzone,low_zone,low_inf" + (this.SB.hasIGDSep ? ",sep" : "") + ",modifier,modified FROM " + this.SB.DBTableName("IGD") + " WHERE igd_type=" + igdType + " AND " + IGDInterval.interpString(this.interpID, null) + " AND top_id >=" + wellID * 65536 + " AND top_id < " + (wellID + 1) * 65536;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        IGDIntervalZone zone = null;
        while (rs.next()) {
            int topID = rs.getInt("top_id");
            int baseID = rs.getInt("base_id");
            String topAnalyst = rs.getString("top_analy");
            String baseAnalyst = rs.getString("base_analy");
            int topBnd = rs.getInt("top_bnd");
            int baseBnd = rs.getInt("base_bnd");
            int plotPos = rs.getInt("plot_pos");
            int schID = rs.getInt("sch_id");
            String strg = rs.getString("q_uzone");
            boolean qUzone = strg != null && strg.charAt(0) == 'Y';
            int uppZone = rs.getInt("upp_zone");
            if (uppZone < 0) {
                uppZone = 0;
            }
            String uppInf = rs.getString("upp_inf");
            strg = rs.getString("q_lzone");
            boolean qLzone = strg != null && strg.charAt(0) == 'Y';
            int lowZone = rs.getInt("low_zone");
            if (lowZone < 0) {
                lowZone = 0;
            }
            String lowInf = rs.getString("low_inf");
            String sep = "-";
            if (this.SB.hasIGDSep && (sep = rs.getString("sep")) == null) {
                sep = "-";
            }
            String modifier = rs.getString("modifier");
            Date modified = rs.getDate("modified");
            if (igdType == 10) {
                try {
                    zone = new IGDIntervalSeq(this.SB, well, topID, baseID, topAnalyst, baseAnalyst, topBnd, baseBnd, plotPos, schID, uppZone, uppInf, lowZone, lowInf, qUzone, qLzone, modifier, modified);
                }
                catch (SBException sbe) {
                    if (sbe.getMessage().startsWith("Sample")) continue;
                    throw sbe;
                }
            }
            try {
                zone = new IGDIntervalZone(this.SB, igdType, well, topID, baseID, topAnalyst, baseAnalyst, topBnd, baseBnd, plotPos, schID, uppZone, uppInf, lowZone, lowInf, qUzone, qLzone, modifier, modified);
            }
            catch (SBException sbe) {
                if (sbe.getMessage().startsWith("Sample")) continue;
                throw sbe;
            }
            this.insertZone(zone);
        }
        stmt.close();
        if (igdType == 10) {
            this.loadSQTracts(wellID);
        }
    }

    public void loadSQTracts(int wellID) throws SQLException, SBException {
        String sql = "SELECT top_id,base_id,plot_pos,lst,lst_inf,tst,tst_inf,hst,hst_inf,ts_id,mfs_id FROM " + this.SB.DBTableName("SQTRACT") + " WHERE " + IGDInterval.interpString(this.interpID, null) + " AND top_id >=" + wellID * 65536 + " AND top_id < " + (wellID + 1) * 65536;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int topID = rs.getInt("top_id");
            int baseID = rs.getInt("base_id");
            Iterator en = this.sequences.iterator();
            boolean found = false;
            while (en.hasNext()) {
                IGDIntervalSeq zone = (IGDIntervalSeq)en.next();
                if (zone.getTopID() != topID || zone.getBaseID() != baseID) continue;
                String strg = rs.getString("lst");
                boolean LST = false;
                if (strg != null && strg.charAt(0) == 'Y') {
                    LST = true;
                }
                String lstInformal = rs.getString("lst_inf");
                strg = rs.getString("tst");
                boolean TST = false;
                if (strg != null && strg.charAt(0) == 'Y') {
                    TST = true;
                }
                String tstInformal = rs.getString("tst_inf");
                strg = rs.getString("hst");
                boolean HST = false;
                if (strg != null && strg.charAt(0) == 'Y') {
                    HST = true;
                }
                String hstInformal = rs.getString("hst_inf");
                int tsID = rs.getInt("ts_id");
                int mfsID = rs.getInt("mfs_id");
                zone.setTract(tsID, mfsID, LST, TST, HST, lstInformal, tstInformal, hstInformal);
                found = true;
                break;
            }
            if (found) continue;
            throw new SBException("Sequence tract found with no Sequence interval : " + topID + "," + baseID);
        }
        stmt.close();
    }

    public void loadEnvs(Well well, List envSchemes) throws SQLException, SBException {
        if (well.wellID == 0) {
            return;
        }
        this.envs.clear();
        String sql = "SELECT top_id,base_id,sch_id,up,ud,lp,ld,qual,modifier,modified FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE " + IGDInterval.interpString(this.interpID, null) + " AND top_id >=" + well.wellID * 65536 + " AND top_id < " + (well.wellID + 1) * 65536;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int topID = rs.getInt("top_id");
            int baseID = rs.getInt("base_id");
            int schID = rs.getInt("sch_id");
            EnvScheme scheme = null;
            if (schID > 0 && (scheme = EnvScheme.get(envSchemes, schID, 0)) == null) {
                scheme = new EnvScheme(this.SB, schID);
                envSchemes.add(scheme);
            }
            int up = rs.getInt("up");
            int ud = rs.getInt("ud");
            int lp = rs.getInt("lp");
            int ld = rs.getInt("ld");
            int qual = rs.getInt("qual");
            String modifier = rs.getString("modifier");
            Date modified = rs.getDate("modified");
            Sample topSample = well.getSample(topID);
            Sample baseSample = well.getSample(baseID);
            try {
                IGDIntervalEnv zone = new IGDIntervalEnv(this.SB, topSample, baseSample, scheme, up, ud, lp, ld, qual, modifier, modified);
                zone.status = IGDIntervalEnv.STORED;
                this.insertEnv(zone);
            }
            catch (SBException sbe) {
                System.out.println(sbe.getMessage());
                sbe.printStackTrace();
            }
        }
        stmt.close();
    }

    void fillSamples(List samples, char units) throws SBException, SQLException {
        for (int i = 0; i < 7; ++i) {
            List igdList = this.zoneTypes[i];
            for (IGDInterval zone : igdList) {
                try {
                    if (zone.topID != 0 && zone.topSample == null) {
                        zone.topSample = this.getSample(samples, zone.topID, units, this.sectionType);
                    }
                    if (zone.baseID != 0 && zone.baseSample == null) {
                        zone.baseSample = this.getSample(samples, zone.baseID, units, this.sectionType);
                    }
                }
                catch (SBException sbe) {
                    throw new SBException("Error filling samples for zone top/base : " + sbe.getMessage());
                }
                if (!zone.getClass().getName().equalsIgnoreCase("jsbugs.IGDIntervalSeq")) continue;
                try {
                    IGDIntervalSeq seq = (IGDIntervalSeq)zone;
                    if (seq.getTsID() != 0 && seq.getTsSample() == null) {
                        throw new SBException("Attempt to fill sequence sample");
                    }
                    if (seq.getMfsID() == 0 || seq.getMfsSample() != null) continue;
                    throw new SBException("Atempt to fill sequence sample");
                }
                catch (SBException sbe) {
                    throw new SBException("Error filling samples for sequence TS/MFS : " + sbe.getMessage());
                }
            }
        }
        for (IGDIntervalEnv env : this.envs) {
            try {
                if (env.topID != 0 && env.topSample == null) {
                    env.topSample = this.getSample(samples, env.topID, units, this.sectionType);
                }
                if (env.baseID == 0 || env.baseSample != null) continue;
                env.baseSample = this.getSample(samples, env.baseID, units, this.sectionType);
            }
            catch (SBException sbe) {
                throw new SBException("Error filling samples for Palaeoenvironment top/base sample : " + sbe.getMessage());
            }
        }
        this.sortEnvByDepth();
        Iterator<Object> en = this.comments.iterator();
        if (en.hasNext()) {
            Biocom comment = (Biocom)en.next();
            try {
                throw new SBException("Atempt to fill biocom sample");
            }
            catch (SBException sbe) {
                throw new SBException("Error filling samples for Biocom top/base sample : " + sbe.getMessage());
            }
        }
        this.sortComments();
    }

    Sample getSample(List samples, int ID, char units, char sectionType) throws SQLException, SBException {
        Sample sample2 = null;
        for (Sample sample2 : samples) {
            if (ID == sample2.getSampID()) {
                return sample2;
            }
            if (sample2.alternativeIDs == null) continue;
            Iterator it = sample2.alternativeIDs.iterator();
            while (it.hasNext()) {
                int altID = (Integer)it.next();
                if (ID != altID) continue;
                return sample2;
            }
        }
        sample2 = new Sample(this.SB, ID, sectionType);
        Sample.insert(samples, sample2, units);
        return sample2;
    }

    void sortByDepth(int igdType) throws SBException {
        boolean swap = true;
        List igd = this.getIGDList(igdType);
        block0: while (swap) {
            swap = false;
            for (int i = 1; i < igd.size(); ++i) {
                IGDInterval zone = (IGDInterval)igd.get(i);
                IGDInterval prevZone = (IGDInterval)igd.get(i - 1);
                if (zone.topSample == null || prevZone.topSample == null) {
                    throw new SBException("Null sample encountered during IGD sort");
                }
                if (!(zone.topSample.getDepth('M') < prevZone.topSample.getDepth('M'))) continue;
                igd.add(i - 1, zone);
                igd.remove(i + 1);
                swap = true;
                continue block0;
            }
        }
    }

    void sortEnvByDepth() throws SBException {
        boolean swap = true;
        block0: while (swap) {
            swap = false;
            for (int i = 1; i < this.envs.size(); ++i) {
                IGDIntervalEnv zone = (IGDIntervalEnv)this.envs.get(i);
                IGDIntervalEnv prevZone = (IGDIntervalEnv)this.envs.get(i - 1);
                if (zone.topSample == null || prevZone.topSample == null) {
                    throw new SBException("Null sample encountered during palaeoenvironments sort");
                }
                if (!(zone.topSample.getDepth('M') < prevZone.topSample.getDepth('M'))) continue;
                this.envs.add(i - 1, zone);
                this.envs.remove(i + 1);
                swap = true;
                continue block0;
            }
        }
    }

    void sortComments() throws SBException {
        boolean swap = true;
        block0: while (swap) {
            swap = false;
            for (int i = 1; i < this.comments.size(); ++i) {
                Biocom comment = this.comments.get(i);
                Biocom prevComment = this.comments.get(i - 1);
                if (comment.getTopSample() == null || prevComment.getTopSample() == null) {
                    throw new SBException("Null sample encountered during comment sort");
                }
                if (!(comment.getTopSample().getDepth('M') < prevComment.getTopSample().getDepth('M'))) continue;
                this.comments.add(i - 1, comment);
                this.comments.remove(i + 1);
                swap = true;
                continue block0;
            }
        }
    }

    public List getComments() {
        return this.comments;
    }

    public List<IGDIntervalEnv> getEnvs() {
        return this.envs;
    }

    public List getIGDList(int igdType) {
        switch (igdType) {
            case 3: {
                return this.chrono;
            }
            case 2: {
                return this.lstrat;
            }
            case 10: {
                return this.sequences;
            }
            case 41: {
                return this.biozone1;
            }
            case 42: {
                return this.biozone2;
            }
            case 43: {
                return this.biozone3;
            }
            case 44: {
                return this.biozone4;
            }
        }
        return null;
    }

    public List<IGDIntervalZone> getMaxIGDHierZones(int igdType) throws SBException {
        List list = this.getIGDList(igdType);
        if (igdType == 10) {
            return list;
        }
        if (list != null && list.size() > 0) {
            double minDepth = -1.0;
            double maxDepth = -1.0;
            int maxHier = -1;
            for (IGDIntervalZone zone : list) {
                if (zone.getPlotPos() > maxHier) {
                    maxHier = zone.getPlotPos();
                }
                if (minDepth < 0.0 || zone.getTopSample().getDepth('M') < minDepth) {
                    minDepth = zone.getTopSample().getDepth('M');
                }
                if (!(maxDepth < 0.0) && !(zone.getBaseSample().getDepth('M') > maxDepth)) continue;
                maxDepth = zone.getBaseSample().getDepth('M');
            }
            List<IGDIntervalZone> noOverlaps = this.getCompositeZones(list, new LinkedList<IGDIntervalZone>(), maxHier);
            return noOverlaps;
        }
        return null;
    }

    List<IGDIntervalZone> getCompositeZones(List<IGDIntervalZone> list, List<IGDIntervalZone> noOverlaps, int maxHier) throws SBException {
        LinkedList<IGDIntervalZone> orphanedBases = new LinkedList<IGDIntervalZone>();
        for (int hier = maxHier; hier >= 0; --hier) {
            for (IGDIntervalZone zone : list) {
                if (zone.getPlotPos() != hier) continue;
                int td = (int)(zone.getTopSample().getDepth('M') * 1000.0);
                int bd = (int)(zone.getBaseSample().getDepth('M') * 1000.0);
                boolean overlap = false;
                for (IGDIntervalZone z : noOverlaps) {
                    int ztd = (int)(z.getTopSample().getDepth('M') * 1000.0);
                    int zbd = (int)(z.getBaseSample().getDepth('M') * 1000.0);
                    if (td <= ztd && bd > ztd) {
                        if (bd > zbd) {
                            IGDIntervalZone baseZone = new IGDIntervalZone(zone);
                            if (zbd - ztd != 0) {
                                baseZone.setTop(z.getBaseSample(), z.getBaseBndID(), z.getBaseAnalyst());
                            } else {
                                baseZone.setTop(zone.getBaseSample(), zone.getBaseBndID(), zone.getBaseAnalyst());
                            }
                            orphanedBases.add(baseZone);
                        }
                        if (td < ztd) {
                            if (zbd - ztd != 0) {
                                zone.setBase(z.getTopSample(), z.getTopBndID(), z.getTopAnalyst());
                            } else {
                                zone.setBase(zone.topSample, zone.getTopBndID(), zone.getTopAnalyst());
                            }
                            overlap = false;
                            break;
                        }
                        overlap = true;
                        break;
                    }
                    if (td != ztd || bd != zbd) continue;
                    overlap = true;
                    break;
                }
                if (overlap) continue;
                boolean inserted = false;
                for (int i = 0; i < noOverlaps.size(); ++i) {
                    IGDIntervalZone insPoint = noOverlaps.get(i);
                    if (!(zone.getTopSample().getDepth('M') < insPoint.getTopSample().getDepth('M'))) continue;
                    noOverlaps.add(i, zone);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                noOverlaps.add(zone);
            }
        }
        if (orphanedBases.size() > 0) {
            noOverlaps = this.getCompositeZones(orphanedBases, noOverlaps, maxHier);
        }
        return noOverlaps;
    }

    boolean sampleIsUsed(int sampOrDonorID, Vector dataTypes) throws SBException {
        if (sampOrDonorID == 0) {
            return false;
        }
        Enumeration en = dataTypes.elements();
        while (en.hasMoreElements()) {
            int columnType = (Integer)en.nextElement();
            switch (columnType) {
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    if (!this.sampleInComments(sampOrDonorID, SBdb.dt2discID(columnType))) break;
                    return true;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    if (!this.sampleInIGD(sampOrDonorID, IGDInterval.dType2IGDtype(columnType))) break;
                    return true;
                }
                case 16: {
                    if (!this.sampleInEnv(sampOrDonorID)) break;
                    return true;
                }
            }
        }
        return false;
    }

    void writeDEX(FileWriter out, char units, String eol, SimpleDateFormat df, Vector dataTypes, String[] bzTitle, List igdSchemes) throws IOException, SBException {
        Enumeration en = dataTypes.elements();
        while (en.hasMoreElements()) {
            int columnType = (Integer)en.nextElement();
            switch (columnType) {
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    this.writeDEXComments(out, eol, SBdb.dt2discID(columnType));
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.writeDEXIGDIntervals(out, units, eol, IGDInterval.dType2IGDtype(columnType), bzTitle, igdSchemes, df);
                    break;
                }
                case 16: {
                    this.writeDEXEnvIntervals(out, units, eol, df);
                }
            }
        }
    }

    void writeDEXComments(FileWriter out, String eol, char discID) throws IOException, SBException {
        for (int i = 0; i < this.comments.size(); ++i) {
            Biocom comment = this.comments.get(i);
            if (comment.getDiscID() != discID) continue;
            comment.writeDEX(out, eol);
        }
    }

    boolean sampleInComments(int sampOrDonorID, char discID) throws SBException {
        for (int i = 0; i < this.comments.size(); ++i) {
            Biocom comment = this.comments.get(i);
            if (comment.getDiscID() != discID) continue;
            if (comment.getTopSample() == null) {
                throw new SBException("Sample null in comment : " + comment);
            }
            if (comment.getTopSample().getID() != sampOrDonorID && (comment.getBaseSample() == null || comment.getBaseSample().getID() != sampOrDonorID)) continue;
            return true;
        }
        return false;
    }

    void writeDEXIGDIntervals(FileWriter out, char units, String eol, int igdType, String[] bzTitle, List igdSchemes, SimpleDateFormat df) throws IOException, SBException {
        List igd = this.getIGDList(igdType);
        for (int i = 0; i < igd.size(); ++i) {
            IGDIntervalZone zone = (IGDIntervalZone)igd.get(i);
            if (zone.igdType == 10) {
                IGDIntervalSeq seqZone = (IGDIntervalSeq)zone;
                seqZone.writeDEX(out, eol, units, igdSchemes, df);
            } else {
                zone.writeDEX(out, eol, units, bzTitle, igdSchemes, df);
            }
            out.write(eol);
        }
    }

    void writeDEXEnvIntervals(FileWriter out, char units, String eol, SimpleDateFormat df) throws IOException, SBException {
        for (int i = 0; i < this.envs.size(); ++i) {
            IGDIntervalEnv env = (IGDIntervalEnv)this.envs.get(i);
            env.writeDEX(out, eol, units, df);
            out.write(eol);
        }
    }

    boolean sampleInIGD(int sampOrDonorID, int igdType) throws SBException {
        List igd = this.getIGDList(igdType);
        for (int i = 0; i < igd.size(); ++i) {
            IGDIntervalZone zone = (IGDIntervalZone)igd.get(i);
            if (zone.topSample.getID() != sampOrDonorID && (zone.baseSample == null || zone.baseSample.getID() != sampOrDonorID)) continue;
            return true;
        }
        return false;
    }

    boolean sampleInEnv(int sampOrDonorID) throws SBException {
        for (int i = 0; i < this.envs.size(); ++i) {
            IGDIntervalEnv zone = (IGDIntervalEnv)this.envs.get(i);
            if (zone.topSample.getID() != sampOrDonorID && (zone.baseSample == null || zone.baseSample.getID() != sampOrDonorID)) continue;
            return true;
        }
        return false;
    }

    void getIGDschemes(Vector dataTypes, List igdSchemes, List donorSchemes, List envSchemes) throws SBException, SQLException {
        Enumeration en2 = dataTypes.elements();
        while (en2.hasMoreElements()) {
            int columnType = (Integer)en2.nextElement();
            switch (columnType) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    List igdList = this.getIGDList(IGDInterval.dType2IGDtype(columnType));
                    for (IGDIntervalZone zone : igdList) {
                        IGDScheme scheme;
                        boolean found;
                        Iterator sch;
                        if (zone.getSchID() > 0) {
                            sch = igdSchemes.iterator();
                            found = false;
                            while (sch.hasNext()) {
                                scheme = (IGDScheme)sch.next();
                                if (scheme.schID != zone.getSchID()) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            try {
                                igdSchemes.add(new IGDScheme(zone.getSchID()));
                                continue;
                            }
                            catch (SBException sb) {
                                sb.printStackTrace();
                                throw new SBException("Zone: " + zone + ", " + sb.getMessage());
                            }
                        }
                        if (zone.donorSchID <= 0) continue;
                        sch = igdSchemes.iterator();
                        found = false;
                        while (sch.hasNext()) {
                            scheme = (IGDScheme)sch.next();
                            if (scheme.donorSchID != zone.donorSchID) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        sch = donorSchemes.iterator();
                        found = false;
                        scheme = null;
                        while (sch.hasNext()) {
                            scheme = (IGDScheme)sch.next();
                            if (scheme.donorSchID != zone.donorSchID) continue;
                            found = true;
                            break;
                        }
                        if (scheme == null || !found) {
                            throw new SBException("Donor scheme not present in IGD interval: " + zone);
                        }
                        igdSchemes.add(scheme);
                    }
                    break;
                }
                case 16: {
                    for (IGDIntervalEnv env : this.envs) {
                        if (env.getSchID() <= 0) continue;
                        Iterator sch = envSchemes.iterator();
                        boolean found = false;
                        while (sch.hasNext()) {
                            EnvScheme scheme = (EnvScheme)sch.next();
                            if (scheme.getID() != env.getSchID()) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        envSchemes.add(new EnvScheme(this.SB, env.getSchID()));
                    }
                    break;
                }
            }
        }
    }

    public static void loadCombo(SBdb SB2, DefaultComboBoxModel interps, boolean wellOnly, int wellID, char sectionType) throws SQLException {
        LinkedList list = new LinkedList();
        WellInterp.loadInterps(SB2, list, wellOnly, wellID, sectionType);
        interps.removeAllElements();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            interps.addElement(it.next());
        }
    }

    static void loadList(SBdb SB2, DefaultListModel interps, boolean wellOnly, int wellID, char sectionType) throws SQLException {
        LinkedList list = new LinkedList();
        WellInterp.loadInterps(SB2, list, wellOnly, wellID, sectionType);
        interps.removeAllElements();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            interps.addElement(it.next());
        }
    }

    static void loadInterps(SBdb SB2, List interps, boolean wellOnly, int wellID, char sectionType) throws SQLException {
        String creator;
        Date created;
        String description;
        Iterator en;
        int interpID;
        interps.clear();
        String sql = !wellOnly || wellID == 0 ? "SELECT interp_id, descrip, created, creator FROM " + SB2.DBTableName("INTERP") : "SELECT DISTINCT i.interp_id, i.descrip, i.created, i.creator FROM " + SB2.DBTableName("INTERP") + " i," + SB2.DBTableName("IGD") + " g WHERE i.interp_id=g.interp_id" + " AND g.top_id >=" + wellID * 65536 + " AND g.top_id <" + (wellID + 1) * 65536;
        sql = sql + " ORDER BY descrip";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        InterpHdr interp = new InterpHdr(SB2, 0);
        interps.add(interp);
        while (rs.next()) {
            interpID = rs.getInt("interp_id");
            String description2 = rs.getString("descrip");
            Date created2 = rs.getDate("created");
            String creator2 = rs.getString("creator");
            interp = new InterpHdr(SB2, interpID, description2, created2, creator2);
            interps.add(interp);
        }
        if (wellOnly && wellID != 0) {
            sql = "SELECT DISTINCT i.interp_id, i.descrip, i.created, i.creator FROM " + SB2.DBTableName("INTERP") + " i," + SB2.DBTableName("IGD_ENV") + " g WHERE i.interp_id=g.interp_id" + " AND g.top_id >=" + wellID * 65536 + " AND g.top_id <" + (wellID + 1) * 65536;
            sql = sql + " ORDER BY descrip";
            rs = stmt.executeQuery(SB2.modQuery(sql));
            while (rs.next()) {
                interpID = rs.getInt("interp_id");
                en = interps.iterator();
                boolean match = false;
                while (en.hasNext()) {
                    if (((WellInterp)en.next()).interpID != interpID) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                description = rs.getString("descrip");
                created = rs.getDate("created");
                creator = rs.getString("creator");
                interp = new InterpHdr(SB2, interpID, description, created, creator);
                interps.add(interp);
            }
        }
        if (wellOnly && wellID != 0) {
            sql = "SELECT DISTINCT i.interp_id, i.descrip, i.created, i.creator FROM " + SB2.DBTableName("INTERP") + " i," + SB2.DBTableName("BCMMNTS") + " g WHERE i.interp_id=g.interp_id" + " AND g.usamp_id >=" + wellID * 65536 + " AND g.usamp_id <" + (wellID + 1) * 65536;
            sql = sql + " ORDER BY descrip";
            rs = stmt.executeQuery(SB2.modQuery(sql));
            while (rs.next()) {
                interpID = rs.getInt("interp_id");
                en = interps.iterator();
                boolean match = false;
                while (en.hasNext()) {
                    if (((WellInterp)en.next()).interpID != interpID) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                description = rs.getString("descrip");
                created = rs.getDate("created");
                creator = rs.getString("creator");
                interp = new InterpHdr(SB2, interpID, description, created, creator);
                interps.add(interp);
            }
        }
        stmt.close();
    }
}

