/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import model1_8.SBdb;
import model1_8.WellHeader;

public class WellSearchResult {
    String wellName;
    String wellCode;
    String country;
    String field;
    String oper;
    String county;
    String quadrant;
    String block;
    String subBlock;
    int wellID;

    public String getWellName() {
        return this.wellName;
    }

    public String getWellCode() {
        return this.wellCode;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCounty() {
        return this.county;
    }

    public String getField() {
        return this.field;
    }

    public String getOperator() {
        return this.oper;
    }

    public String getQuadrant() {
        return this.quadrant;
    }

    public String getBlock() {
        return this.block;
    }

    public String getSubBlock() {
        return this.subBlock;
    }

    public int getWellID() {
        return this.wellID;
    }

    public static List search(SBdb SB2, String wellName, String wellCode, String country, String field, String oper, String county, String quadrant, String block, String subBlock) throws SQLException {
        LinkedList<WellSearchResult> results = new LinkedList<WellSearchResult>();
        String sql = "SELECT well_name,well_code,country,field,operator";
        if (SB2.hasCounty) {
            sql = sql + ",county";
        }
        sql = sql + ",quadrant,block,sub_block,well_id FROM " + SB2.DBTableName("WELLS ") + "," + SB2.DBTableName("VERSION ") + " WHERE well_code=code ";
        if (wellName.compareTo("%") > 0) {
            sql = sql + " AND ucase(well_name) like '" + wellName.trim().toUpperCase() + "'";
        }
        if (wellCode.compareTo("%") > 0) {
            sql = sql + " AND ucase(well_code) like '" + wellCode.trim().toUpperCase() + "'";
        }
        if (country.compareTo("%") > 0) {
            sql = sql + " AND ucase(country) like '" + country.trim().toUpperCase() + "'";
        }
        if (field.compareTo("%") > 0) {
            sql = sql + " AND ucase(field) like '" + field.trim().toUpperCase() + "'";
        }
        if (SB2.hasCounty && county.compareTo("%") > 0) {
            sql = sql + " AND ucase(county) like '" + county.trim().toUpperCase() + "'";
        }
        if (quadrant.compareTo("%") > 0) {
            sql = sql + " AND ucase(quadrant) like '" + quadrant.trim().toUpperCase() + "'";
        }
        if (block.compareTo("%") > 0) {
            sql = sql + " AND ucase(block) like '" + block.trim().toUpperCase() + "'";
        }
        if (subBlock.compareTo("%") > 0) {
            sql = sql + " AND ucase(sub_block) like '" + subBlock.trim().toUpperCase() + "'";
        }
        if (oper.compareTo("%") > 0) {
            sql = sql + " AND ucase(operator) like '" + oper.trim().toUpperCase() + "'";
        }
        sql = sql + " ORDER BY ucase(well_name),ucase(well_code),ucase(country),ucase(field)";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            WellSearchResult result = new WellSearchResult();
            result.wellName = rs.getString("well_name");
            result.wellCode = rs.getString("well_code");
            result.country = rs.getString("country");
            result.field = rs.getString("field");
            result.oper = rs.getString("operator");
            if (SB2.hasCounty) {
                result.county = rs.getString("county");
            }
            result.quadrant = rs.getString("quadrant");
            result.block = rs.getString("block");
            result.subBlock = rs.getString("sub_block");
            result.wellID = rs.getInt("well_id");
            if (WellHeader.checkWellPerm(SB2, result.country, result.field, result.oper) == 0) continue;
            results.add(result);
        }
        return new ArrayList(results);
    }
}

