/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ArrowCellRenderer
extends DefaultTableCellRenderer {
    boolean showArrow = false;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(Color.lightGray);
        if (object instanceof Boolean) {
            this.showArrow = (Boolean)object;
        } else {
            System.out.println("In arrow renderer, cannot render: " + object);
        }
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.showArrow) {
            Graphics2D g2 = (Graphics2D)g;
            float width = this.getWidth();
            float height = this.getHeight();
            g2.setColor(Color.blue);
            g2.setStroke(new BasicStroke(1.2f));
            float arrLen = width * 2.0f / 3.0f;
            float arrHeight = height / 2.0f;
            float arrX = (width - arrLen) / 2.0f;
            float arrY = (height - arrHeight) / 2.0f;
            g2.drawLine((int)arrX, (int)(height / 2.0f), (int)(arrX + arrLen), (int)(height / 2.0f));
            g2.drawLine((int)(arrX + arrLen), (int)(height / 2.0f), (int)(width / 2.0f), (int)(height / 2.0f) - (int)arrY);
            g2.drawLine((int)(arrX + arrLen), (int)(height / 2.0f), (int)(width / 2.0f), (int)(height / 2.0f) + (int)arrY);
        }
    }
}

