/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class AttributedStringRenderer
extends DefaultTableCellRenderer {
    Border selectedBorder = null;
    AttributedString string = null;
    float textHeight = -1.0f;
    AffineTransform tnf = new AffineTransform();

    public AttributedStringRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        Color colour = Color.white;
        if (isSelected) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(2, 0, 2, 0, table.getSelectionBackground());
            }
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(null);
        }
        colour = isSelected ? table.getSelectionBackground() : table.getBackground();
        if (object instanceof AttributedString) {
            this.string = (AttributedString)object;
        }
        this.setBackground(colour);
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        AffineTransform saveTransform = ((Graphics2D)g).getTransform();
        Dimension d = this.getSize();
        float rectSize = d.width * 10;
        if (this.textHeight < 0.0f) {
            this.textHeight = g.getFontMetrics().getHeight() * 10;
        }
        float vertOffset = this.textHeight + ((float)(d.height * 10) - this.textHeight) / 2.0f;
        System.out.println("In paint component: d.height=" + d.height + ", text height=" + this.textHeight + ", vertOffset=" + vertOffset);
        Font font = new Font(g.getFont().getName(), g.getFont().getStyle(), g.getFont().getSize() * 10);
        g.setFont(font);
        g.drawString(this.string.getIterator(), 0, (int)this.textHeight / 10);
    }
}

