/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import util.GridReader;
import util.SBException;

public class CSVGridReader
implements GridReader {
    String fileName;
    BufferedReader in;
    String delim = null;
    String lineBuff;
    String[] cell;
    int nCell = 0;

    CSVGridReader(String fileName) throws SBException {
        this.fileName = fileName;
        try {
            this.in = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException ex) {
            throw new SBException("Error opening text file.", ex);
        }
    }

    @Override
    public boolean nextRow() throws SBException {
        try {
            this.lineBuff = this.in.readLine();
            if (this.lineBuff == null) {
                return false;
            }
            if (this.lineBuff.length() > 0 && this.delim == null) {
                this.delim = this.parseDelim(this.lineBuff);
            }
            if (this.delim == null) {
                this.cell = null;
                return true;
            }
            this.cell = this.lineBuff.split(this.delim);
            this.nCell = 0;
            return true;
        }
        catch (IOException ioe) {
            throw new SBException("Error reading file", ioe);
        }
    }

    private String parseDelim(String buff) {
        String delims = ",;\t";
        int[] nOccs = new int[delims.length()];
        for (int i = 0; i < buff.length(); ++i) {
            for (int j = 0; j < delims.length(); ++j) {
                if (buff.charAt(i) != delims.charAt(j)) continue;
                int n = j;
                nOccs[n] = nOccs[n] + 1;
            }
        }
        int pop = -1;
        int popSize = 0;
        for (int j = 0; j < delims.length(); ++j) {
            if (nOccs[j] <= popSize) continue;
            pop = j;
            popSize = nOccs[j];
        }
        if (pop >= 0) {
            return "" + delims.charAt(pop);
        }
        return null;
    }

    @Override
    public String getNextCell() throws SBException {
        String strg;
        if (this.cell == null || this.nCell >= this.cell.length) {
            return null;
        }
        if (this.cell[this.nCell] == null) {
            return "";
        }
        if ((strg = this.cell[this.nCell++]).length() > 0 && strg.charAt(0) == '\"') {
            while (strg.charAt(strg.length() - 1) != '\"') {
                if (this.nCell >= this.cell.length) {
                    throw new SBException("Cannot find closing quote on line: " + this.lineBuff + " at cell: " + strg);
                }
                strg = strg + this.cell[this.nCell++];
            }
            strg = strg.substring(1, strg.length() - 1);
        }
        return strg.trim();
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void rewind() throws SBException {
        try {
            this.in.close();
            this.in = new BufferedReader(new FileReader(this.fileName));
        }
        catch (FileNotFoundException ex) {
            throw new SBException("Error re-opening text file.", ex);
        }
        catch (IOException ioe) {
            throw new SBException("I/O Error closeing text file.", ioe);
        }
    }
}

