/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;

public class ColorEditor
extends DefaultCellEditor {
    Color currentColor = null;

    public ColorEditor(JButton b) {
        super(new JCheckBox());
        this.editorComponent = b;
        this.setClickCountToStart(2);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentColor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ((JButton)this.editorComponent).setText(value.toString());
        this.currentColor = (Color)value;
        return this.editorComponent;
    }

    public static void setUpColorEditor(JTable table) {
        final JButton button = new JButton(""){

            @Override
            public void setText(String s) {
            }
        };
        button.setBackground(Color.white);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        final ColorEditor colorEditor = new ColorEditor(button);
        table.setDefaultEditor(Color.class, colorEditor);
        final JColorChooser colorChooser = new JColorChooser();
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                colorEditor.currentColor = colorChooser.getColor();
            }
        };
        final JDialog dialog = JColorChooser.createDialog(button, "Pick a Colour", true, colorChooser, okListener, null);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                button.setBackground(colorEditor.currentColor);
                colorChooser.setColor(colorEditor.currentColor);
                dialog.setLocationRelativeTo(button);
                dialog.setVisible(true);
            }
        });
    }
}

