/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;

public class ColouredRenderer
extends JLabel
implements TableCellRenderer {
    boolean isBordered;
    Border selectedBorder = null;
    Color colour;

    public ColouredRenderer(boolean isBordered, Color colour) {
        this.isBordered = isBordered;
        this.colour = colour;
        this.setOpaque(true);
        this.setHorizontalAlignment(10);
    }

    public ColouredRenderer(boolean isBordered, Color colour, int alignment) {
        this.isBordered = isBordered;
        this.colour = colour;
        this.setOpaque(true);
        this.setHorizontalAlignment(alignment);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(this.colour);
        if (obj != null) {
            this.setText(obj.toString());
        }
        if (this.isBordered && !isSelected) {
            this.setBorder(new LineBorder(new Color(220, 220, 220), 3));
        } else if (isSelected) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(2, 0, 2, 0, table.getSelectionBackground());
            }
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(null);
        }
        return this;
    }
}

