/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import util.SB;
import util.SbugsStatus;

public class DTMonitor
implements SbugsStatus {
    private double depthFrom = 0.0;
    private double depthTo = 0.0;
    private boolean hasData = false;
    private Color status = UNKNOWN;
    private String statusString = "Unassigned";
    private DTMonitor link = null;

    @Override
    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.statusString;
    }

    @Override
    public Color getStatus() {
        return this.status;
    }

    public Color getDbStatus() {
        return this.link != null ? this.link.status : null;
    }

    public String dbStatusString() {
        return this.link != null ? this.link.statusString : null;
    }

    public double getDepthFrom() {
        return this.depthFrom;
    }

    public void setDepthFrom(double depthFrom) {
        this.depthFrom = depthFrom;
    }

    public double getDepthTo() {
        return this.depthTo;
    }

    public void setDepthTo(double depthTo) {
        this.depthTo = depthTo;
    }

    public boolean isHasData() {
        return this.hasData;
    }

    public void setHasData(boolean hasData) {
        this.hasData = hasData;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public void setStatusString(String statusString) {
        this.statusString = statusString;
    }

    public DTMonitor getLink() {
        return this.link;
    }

    public void setLink(DTMonitor link) {
        this.link = link;
    }

    public void setStatus(Color status) {
        this.status = status;
    }

    public void setDataRanges(ResultSet rs, String maxtop, String maxbot, String mintop, String minbot, boolean useString) throws SQLException {
        BigDecimal maxTop = SB.getBigDecimal(rs, maxtop, useString);
        BigDecimal maxBot = SB.getBigDecimal(rs, maxbot, useString);
        BigDecimal minTop = SB.getBigDecimal(rs, mintop, useString);
        BigDecimal minBot = SB.getBigDecimal(rs, minbot, useString);
        boolean baseAssigned = false;
        boolean topAssigned = false;
        if (maxBot != null) {
            this.setDepthTo(maxBot.doubleValue());
            baseAssigned = true;
        } else if (maxTop != null) {
            this.setDepthTo(maxTop.doubleValue());
            baseAssigned = true;
        }
        if (minTop != null) {
            this.setDepthFrom(minTop.doubleValue());
            topAssigned = true;
        } else if (minBot != null) {
            this.setDepthFrom(minBot.doubleValue());
            topAssigned = true;
        }
        if (topAssigned && !baseAssigned) {
            this.setDepthTo(this.getDepthFrom());
        }
        if (baseAssigned && !topAssigned) {
            this.setDepthFrom(this.getDepthTo());
        }
        if (topAssigned || baseAssigned) {
            this.setHasData(true);
        }
    }
}

