/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import util.DTMonitor;

public class DTMonitorRenderer
extends DefaultTableCellRenderer {
    Border selectedBorder = null;
    DTMonitor monitor = null;
    float textHeight = -1.0f;
    AffineTransform tnf = new AffineTransform();

    public DTMonitorRenderer() {
        this.setOpaque(true);
        this.tnf.scale(0.1, 0.1);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object dbItem, boolean isSelected, boolean hasFocus, int row, int column) {
        Color colour = Color.white;
        if (isSelected && dbItem != null) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(2, 0, 2, 0, table.getSelectionBackground());
            }
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(null);
        }
        if (dbItem != null) {
            if (dbItem instanceof DTMonitor) {
                this.monitor = (DTMonitor)dbItem;
                colour = ((DTMonitor)dbItem).getStatus();
                this.setText(" " + ((DTMonitor)dbItem).statusString());
            } else {
                System.out.println("Rendering: " + dbItem);
                this.setText(dbItem.toString());
            }
        } else {
            this.setText("");
            this.monitor = null;
            if (isSelected) {
                colour = table.getSelectionBackground();
            }
        }
        this.setBackground(colour);
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        AffineTransform saveTransform = ((Graphics2D)g).getTransform();
        ((Graphics2D)g).transform(this.tnf);
        Dimension d = this.getSize();
        float rectSize = d.width * 10;
        if (this.textHeight < 0.0f) {
            this.textHeight = g.getFontMetrics().getHeight() * 10;
        }
        float vertOffset = this.textHeight + ((float)(d.height * 10) - this.textHeight) / 2.0f;
        vertOffset -= 30.0f;
        if (this.monitor != null && this.monitor.getDbStatus() != null) {
            rectSize /= 2.0f;
        }
        Font font = new Font(g.getFont().getName(), g.getFont().getStyle(), g.getFont().getSize() * 10);
        g.setFont(font);
        if (this.monitor == null) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(this.monitor.getStatus());
        }
        g.fillRect(0, 0, (int)rectSize, d.height * 10);
        if (this.monitor != null) {
            g.setColor(Color.BLACK);
            g.drawString(this.monitor.statusString(), 0, (int)vertOffset);
            if (this.monitor.getDbStatus() != null) {
                g.setColor(Color.WHITE);
                g.fillRect((int)rectSize, 0, (int)rectSize, d.height * 10);
                g.setColor(Color.GRAY);
                g.drawLine((int)rectSize, 0, (int)rectSize, d.height * 10);
                g.setColor(Color.BLACK);
                g.drawString(this.monitor.dbStatusString(), (int)rectSize + 10, (int)vertOffset);
                g.setColor(Color.BLACK);
                int MARGIN = 2;
                ((Graphics2D)g).setStroke(new BasicStroke(40.0f));
                g.drawLine(d.width * 10 - 2, 0, d.width * 10 - 2, d.height * 10);
            }
        }
        ((Graphics2D)g).setTransform(saveTransform);
    }
}

