/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import util.SBException;
import util.SortEntry;

public class MatchData<T extends SortEntry> {
    List<MatchPair> data = new LinkedList<MatchPair>();

    public int size() {
        return this.data.size();
    }

    public MatchPair get(int row) {
        return this.data.get(row);
    }

    public void init(List<T> ws, List<T> db) throws SBException, SQLException {
        SortEntry p;
        int i;
        this.data.clear();
        if (ws != null) {
            for (i = 0; i < ws.size(); ++i) {
                p = (SortEntry)ws.get(i);
                MatchPair m = new MatchPair(this, p, null);
                boolean inserted = false;
                for (int j = 0; j < this.data.size(); ++j) {
                    if (m.getSortEntry().compareTo(this.data.get(j).getSortEntry()) >= 0) continue;
                    this.data.add(j, m);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                this.data.add(m);
            }
        }
        if (db != null) {
            for (i = 0; i < db.size(); ++i) {
                p = (SortEntry)db.get(i);
                String key = p.getSortEntry();
                boolean found = false;
                for (int j = 0; j < this.data.size(); ++j) {
                    MatchPair m = this.data.get(j);
                    if (m.ws != null && m.ws.isFuncEquivalent(p)) {
                        m.db = p;
                        found = true;
                        break;
                    }
                    if (m.getSortEntry().compareTo(key) <= 0) continue;
                    for (int k = j + 1; k < this.data.size(); ++k) {
                        MatchPair n = this.data.get(k);
                        if (n.ws == null || !n.ws.isFuncEquivalent(p)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    m = new MatchPair(this, null, p);
                    this.data.add(j, m);
                    found = true;
                    break;
                }
                if (found) continue;
                MatchPair m = new MatchPair(this, null, p);
                this.data.add(m);
            }
        }
    }

    public static class MatchPair<T extends SortEntry> {
        T ws;
        T db;
        final /* synthetic */ MatchData this$0;

        public MatchPair(T ws, T db) throws SBException {
            this.this$0 = var1_1;
            if (ws != null && db != null && ws.getSortEntry().equals(db.getSortEntry())) {
                throw new SBException("Match pair sort entries are not equal");
            }
            this.ws = ws;
            this.db = db;
        }

        public String getSortEntry() {
            if (this.ws != null) {
                return this.ws.getSortEntry();
            }
            if (this.db != null) {
                return this.db.getSortEntry();
            }
            return null;
        }

        public T getWs() {
            return this.ws;
        }

        public T getDb() {
            return this.db;
        }
    }
}

