/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import util.SbugsStatus;

public class MergeStatus {
    private Color status;
    public static final float SMALL = 0.0029f;
    Vector conflicts = new Vector();

    public Vector getConflicts() {
        return this.conflicts;
    }

    public MergeStatus(Color status) {
        this.status = status;
    }

    public Color getStatus() {
        return this.status;
    }

    public static Color merge(Color orig, Color addition) {
        if (orig == SbugsStatus.UNKNOWN) {
            return addition;
        }
        if (orig == SbugsStatus.STORED && addition == SbugsStatus.NOTSTORED) {
            return SbugsStatus.PARTSTORED;
        }
        if (orig == SbugsStatus.NOTSTORED && addition == SbugsStatus.STORED) {
            return SbugsStatus.PARTSTORED;
        }
        if (orig == SbugsStatus.STORED && addition == SbugsStatus.STORED) {
            return SbugsStatus.STORED;
        }
        if (orig == SbugsStatus.STORED && addition == SbugsStatus.PARTSTORED) {
            return SbugsStatus.PARTSTORED;
        }
        if (orig == SbugsStatus.NOTSTORED && addition == SbugsStatus.NOTSTORED) {
            return SbugsStatus.NOTSTORED;
        }
        if (addition == SbugsStatus.CONFLICT) {
            return SbugsStatus.CONFLICT;
        }
        return orig;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void compareStringField(String field, StringBuffer fieldValue, String oldFieldValue, boolean fillValue) {
        if (fieldValue != null && fieldValue.length() > 0 && oldFieldValue != null && oldFieldValue.length() > 0 && oldFieldValue.compareTo(fieldValue.toString()) != 0) {
            this.status = SbugsStatus.CONFLICT;
            this.conflicts.add(new Conflict(field, fieldValue.toString(), oldFieldValue));
            return;
        }
        if ((fieldValue == null || fieldValue.length() == 0) && oldFieldValue != null && oldFieldValue.length() > 0) {
            if (fillValue) {
                fieldValue.append(oldFieldValue);
                return;
            }
            this.status = SbugsStatus.CONFLICT;
            this.conflicts.add(new Conflict(field, fieldValue.toString(), oldFieldValue));
            return;
        }
        if (fieldValue == null) return;
        if (fieldValue.length() <= 0) return;
        if (oldFieldValue != null) {
            if (oldFieldValue.length() != 0) return;
        }
        if (this.status == SbugsStatus.CONFLICT) return;
        this.status = SbugsStatus.PARTSTORED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String compareStringField(String field, String fieldValue, String oldFieldValue, boolean fillValue) {
        if (fieldValue != null && fieldValue.length() > 0 && oldFieldValue != null && oldFieldValue.length() > 0 && oldFieldValue.compareTo(fieldValue.toString()) != 0) {
            this.status = SbugsStatus.CONFLICT;
            this.conflicts.add(new Conflict(field, fieldValue, oldFieldValue));
            return fieldValue;
        }
        if ((fieldValue == null || fieldValue.length() == 0) && oldFieldValue != null && oldFieldValue.length() > 0) {
            if (fillValue) {
                return oldFieldValue;
            }
            this.status = SbugsStatus.CONFLICT;
            this.conflicts.add(new Conflict(field, fieldValue, oldFieldValue));
            return fieldValue;
        }
        if (fieldValue == null) return fieldValue;
        if (fieldValue.length() <= 0) return fieldValue;
        if (oldFieldValue != null) {
            if (oldFieldValue.length() != 0) return fieldValue;
        }
        if (this.status == SbugsStatus.CONFLICT) return fieldValue;
        this.status = SbugsStatus.PARTSTORED;
        return fieldValue;
    }

    public int compareIntField(String field, int fieldValue, int oldFieldValue) {
        if (fieldValue > 0 && oldFieldValue > 0 && fieldValue != oldFieldValue) {
            this.status = SbugsStatus.CONFLICT;
            this.conflicts.add(new Conflict(field, String.valueOf(fieldValue), String.valueOf(oldFieldValue)));
            return fieldValue;
        }
        if (fieldValue == 0 && oldFieldValue > 0) {
            fieldValue = oldFieldValue;
        }
        if (fieldValue > 0 && oldFieldValue == 0 && this.status != SbugsStatus.CONFLICT) {
            this.status = SbugsStatus.PARTSTORED;
        }
        return fieldValue;
    }

    public long compareLongField(String field, long fieldValue, long oldFieldValue) {
        if (fieldValue > 0L && oldFieldValue > 0L && fieldValue != oldFieldValue) {
            this.status = SbugsStatus.CONFLICT;
            this.conflicts.add(new Conflict(field, String.valueOf(fieldValue), String.valueOf(oldFieldValue)));
            return fieldValue;
        }
        if (fieldValue == 0L && oldFieldValue > 0L) {
            fieldValue = oldFieldValue;
        }
        if (fieldValue > 0L && oldFieldValue == 0L && this.status != SbugsStatus.CONFLICT) {
            this.status = SbugsStatus.PARTSTORED;
        }
        return fieldValue;
    }

    public char compareCharField(String field, char fieldValue, char oldFieldValue) {
        if (fieldValue > '\u0000' && oldFieldValue > '\u0000' && fieldValue != oldFieldValue) {
            this.status = SbugsStatus.CONFLICT;
            this.conflicts.add(new Conflict(field, String.valueOf(fieldValue), String.valueOf(oldFieldValue)));
            return fieldValue;
        }
        if (fieldValue == '\u0000' && oldFieldValue > '\u0000') {
            fieldValue = oldFieldValue;
        }
        if (fieldValue > '\u0000' && oldFieldValue == '\u0000' && this.status != SbugsStatus.CONFLICT) {
            this.status = SbugsStatus.PARTSTORED;
        }
        return fieldValue;
    }

    public double compareDoubleField(String field, double fieldValue, double oldFieldValue) {
        if (Math.abs(fieldValue) > (double)0.0029f && Math.abs(oldFieldValue) > (double)0.0029f && Math.abs(fieldValue - oldFieldValue) > (double)0.0029f) {
            this.status = SbugsStatus.CONFLICT;
            this.conflicts.add(new Conflict(field, String.valueOf(fieldValue), String.valueOf(oldFieldValue)));
            return fieldValue;
        }
        if (Math.abs(fieldValue) < (double)0.0029f && Math.abs(oldFieldValue) > (double)0.0029f) {
            fieldValue = oldFieldValue;
        }
        if (Math.abs(fieldValue) > (double)0.0029f && Math.abs(oldFieldValue) < (double)0.0029f && this.status != SbugsStatus.CONFLICT) {
            this.status = SbugsStatus.PARTSTORED;
        }
        return fieldValue;
    }

    public float compareFloatField(String field, float fieldValue, float oldFieldValue) {
        if (Math.abs(fieldValue) > 0.0029f && Math.abs(oldFieldValue) > 0.0029f && Math.abs(fieldValue - oldFieldValue) > 0.0029f) {
            this.status = SbugsStatus.CONFLICT;
            this.conflicts.add(new Conflict(field, String.valueOf(fieldValue), String.valueOf(oldFieldValue)));
            return fieldValue;
        }
        if (Math.abs(fieldValue) < 0.0029f && Math.abs(oldFieldValue) > 0.0029f) {
            fieldValue = oldFieldValue;
        }
        if (Math.abs(fieldValue) > 0.0029f && Math.abs(oldFieldValue) < 0.0029f && this.status != SbugsStatus.CONFLICT) {
            this.status = SbugsStatus.PARTSTORED;
        }
        return fieldValue;
    }

    public Date compareDateField(String field, Date fieldValue, Date oldFieldValue) {
        if (fieldValue != null && oldFieldValue != null && !fieldValue.equals(oldFieldValue)) {
            this.status = SbugsStatus.CONFLICT;
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
            this.conflicts.add(new Conflict(field, df.format(fieldValue), df.format(oldFieldValue)));
            return fieldValue;
        }
        if (fieldValue == null && oldFieldValue != null) {
            fieldValue = oldFieldValue;
        }
        if (fieldValue != null && oldFieldValue == null && this.status != SbugsStatus.CONFLICT) {
            this.status = SbugsStatus.PARTSTORED;
        }
        return fieldValue;
    }

    public class Conflict {
        String field;
        String newValue;
        String oldValue;

        public Conflict(String field, String newValue, String oldValue) {
            this.field = field;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public String getField() {
            return this.field;
        }
    }
}

