/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.jdom.Element;
import util.AgeFormat;
import util.CSVGridReader;
import util.GridReader;
import util.SBException;
import util.XLSGridReader;

public final class SB {
    public static boolean showSql = false;
    public static PrintWriter sqlLogFile = null;
    public static String sql;
    public static SimpleDateFormat df;
    public static SimpleDateFormat DBdf;
    public static SimpleDateFormat DBdtf;
    public static boolean hasGUI;

    public static void centreDialog(Dialog dialog) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = dialog.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        dialog.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void centreWindow(Frame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void setTableHeaderBold(JTable table) {
        Font font = table.getTableHeader().getFont();
        font = new Font(font.getName(), 1, font.getSize());
        table.getTableHeader().setFont(font);
        table.setGridColor(new Color(230, 230, 230));
    }

    public static boolean uCaseField(JTextField field, int len, KeyEvent evt) {
        int selectedLenth;
        evt.setKeyChar(Character.toUpperCase(evt.getKeyChar()));
        boolean beep = false;
        int n = selectedLenth = field.getSelectedText() != null ? field.getSelectedText().length() : 0;
        if (field.getText().length() - selectedLenth >= len) {
            evt.consume();
            beep = true;
        }
        return beep;
    }

    public static boolean lenField(JTextField field, int len, KeyEvent evt) {
        int selectedLenth;
        boolean beep = false;
        int n = selectedLenth = field.getSelectedText() != null ? field.getSelectedText().length() : 0;
        if (field.getText().length() - selectedLenth >= len) {
            evt.consume();
            beep = true;
        }
        return beep;
    }

    public static boolean lenField(JTextArea field, int len, KeyEvent evt) {
        int selectedLenth;
        boolean beep = false;
        String str = field.getText();
        int n = selectedLenth = field.getSelectedText() != null ? field.getSelectedText().length() : 0;
        if (str.length() - selectedLenth >= len) {
            evt.consume();
            beep = true;
        }
        return beep;
    }

    public static boolean intFieldVal(JTextField field, int len, KeyEvent evt, boolean allowNegative) {
        int selectedLenth;
        char c = evt.getKeyChar();
        boolean beep = false;
        if (!(c >= '0' && c <= '9' || c == '-' && allowNegative && !field.getText().contains("-") || c == '+' && !field.getText().contains("+") || c == '\b' || c == '\u007f')) {
            beep = true;
            evt.consume();
        }
        String str = field.getText();
        int n = selectedLenth = field.getSelectedText() != null ? field.getSelectedText().length() : 0;
        if (str.length() - selectedLenth >= len) {
            beep = true;
            evt.consume();
        }
        return beep;
    }

    @Deprecated
    public static boolean floatFieldVal(JTextField field, int len, int precision, KeyEvent evt) {
        boolean beep = SB.floatFieldVal(field, len, evt, true);
        if (beep) {
            return beep;
        }
        String str = field.getText();
        int ind = str.indexOf(46);
        if (ind > -1) {
            System.out.println("Str: " + str + " length: " + str.length() + ",ind: " + ind + ", prec: " + precision);
            if (str.length() - ind > precision) {
                evt.consume();
                beep = true;
            }
        }
        return beep;
    }

    public static boolean floatFieldVal(JTextField field, int len, KeyEvent evt, boolean allowNegative) {
        int ind;
        char c = evt.getKeyChar();
        boolean beep = false;
        if (!(c >= '0' && c <= '9' || c == '.' || c == '-' && allowNegative || c == '+' || c == '\b' || c == '\u007f')) {
            beep = true;
            evt.consume();
        }
        String str = field.getText();
        String selection = field.getSelectedText();
        if (str.length() + 1 > len && (selection == null || selection.length() != len)) {
            beep = true;
            evt.consume();
        }
        if (c == '.' && (ind = str.indexOf(c)) > -1) {
            evt.consume();
            field.setCaretPosition(ind + 1);
        } else if (c == '-') {
            evt.consume();
            if (str.startsWith("-")) {
                field.setText(field.getText().substring(1));
            } else {
                field.setText("-" + field.getText().trim());
            }
        } else if (c == '+') {
            evt.consume();
            if (str.startsWith("-")) {
                field.setText(field.getText().substring(1));
            }
        }
        return beep;
    }

    public static void setUnitLabel(JLabel label, char units) {
        if (units == 'M') {
            label.setText("m");
        } else {
            label.setText("ft");
        }
    }

    public static String nullNumber(String s) {
        if ((s = s.trim()).length() == 0) {
            s = "0";
        }
        return s;
    }

    public static String nullString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String crypt(boolean Encrypt, String Key2, String Src) {
        String Dest;
        block9: {
            int TmpSrcAsc;
            int Offset;
            String Hex;
            int SrcAsc;
            short KeyLen;
            short KeyPos;
            block8: {
                boolean Count = false;
                KeyPos = 0;
                KeyLen = 0;
                SrcAsc = 0;
                Dest = new String();
                Hex = new String();
                Offset = 0;
                TmpSrcAsc = 0;
                KeyLen = (short)Key2.length();
                if (!Encrypt) break block8;
                for (Offset = (int)(Math.random() * 1000.0); Offset > 255; Offset -= 255) {
                }
                if (Offset < 16) {
                    Dest = Dest + '0';
                }
                Dest = Dest + Integer.toHexString(Offset).toUpperCase();
                for (int SrcPos = 0; SrcPos < Src.length(); ++SrcPos) {
                    for (SrcAsc = Src.charAt(SrcPos) + Offset; SrcAsc > 255; SrcAsc -= 255) {
                    }
                    SrcAsc ^= Key2.charAt(KeyPos);
                    if ((KeyPos = (short)(KeyPos + 1)) >= KeyLen) {
                        KeyPos = 0;
                    }
                    if (SrcAsc < 16) {
                        Dest = Dest + '0';
                    }
                    Dest = Dest + Integer.toHexString(SrcAsc).toUpperCase();
                    Offset = SrcAsc;
                }
                break block9;
            }
            if (Encrypt) break block9;
            Hex = Src.substring(0, 2);
            Offset = Short.parseShort(Hex, 16);
            for (int SrcPos = 2; SrcPos < Src.length(); SrcPos += 2) {
                Hex = Src.substring(SrcPos, SrcPos + 2);
                SrcAsc = Short.parseShort(Hex, 16);
                TmpSrcAsc = SrcAsc ^ Key2.charAt(KeyPos);
                if ((KeyPos = (short)((short)(KeyPos + 1))) >= KeyLen) {
                    KeyPos = 0;
                }
                TmpSrcAsc = TmpSrcAsc <= Offset ? 255 + TmpSrcAsc - Offset : (TmpSrcAsc -= Offset);
                Dest = Dest + (char)TmpSrcAsc;
                Offset = SrcAsc;
            }
        }
        return Dest;
    }

    public static String DBString(String strg) {
        if (strg == null) {
            return "''";
        }
        strg = strg.replace('\'', '`');
        strg = strg.trim();
        strg = "'" + strg + "'";
        return strg;
    }

    public static String DBChar(char ch) {
        String strg = "null";
        if (ch > '\u0000') {
            strg = "'" + ch + "'";
        }
        return strg;
    }

    public static char getDBChar(ResultSet rs, String field) throws SQLException {
        String strg = rs.getString(field);
        if (strg != null && strg.length() > 0) {
            return strg.charAt(0);
        }
        return '\u0000';
    }

    public static String getDBString(ResultSet rs, String field) throws SQLException {
        String strg = rs.getString(field);
        if (strg != null) {
            return strg.trim();
        }
        return "";
    }

    public static BigDecimal getBigDecimal(ResultSet rs, String field, boolean useString) throws SQLException {
        if (useString) {
            String strg = rs.getString(field);
            if (strg != null) {
                return new BigDecimal(strg);
            }
            return null;
        }
        BigDecimal retval = rs.getBigDecimal(field);
        return retval;
    }

    public static String unitString(char units) {
        if (units == 'F' || units == 'f') {
            return "feet";
        }
        return "metres";
    }

    public static String unitAbr(char units) {
        if (units == 'F' || units == 'f') {
            return "ft";
        }
        return "m";
    }

    public static double convToM(double value, char units) {
        if (units == 'F' || units == 'f') {
            value *= 0.3048;
        }
        if (units > '\u0000') {
            value = (double)Math.round(value * 1000.0) / 1000.0;
        }
        return value;
    }

    public static float convToM(float value, char units) {
        if (units == 'F' || units == 'f') {
            value *= 0.3048f;
        }
        if (units > '\u0000') {
            value = (float)Math.round(value * 1000.0f) / 1000.0f;
        }
        return value;
    }

    public static double convToM(double value, char units, char type) {
        if (units == 'F' || units == 'f') {
            value *= 0.3048;
        }
        if (units > '\u0000') {
            value = (double)Math.round(value * 1000.0) / 1000.0;
        }
        if (type == 'O') {
            value *= -1.0;
        }
        return value;
    }

    public static double convFromM(double value, char units) {
        if (units == 'F' || units == 'f') {
            value /= 0.3048;
            value = (double)Math.round(value * 100.0) / 100.0;
            return value;
        }
        return value;
    }

    public static double convFromM(double value, char units, char type) {
        if (units == 'F' || units == 'f') {
            value /= 0.3048;
            value = (double)Math.round(value * 100.0) / 100.0;
            if (type == 'O') {
                value *= -1.0;
            }
            return value;
        }
        if (type == 'O' && Math.abs(value) > 0.0) {
            value *= -1.0;
        }
        return value;
    }

    public static float convFromM(float value, char units, char type) {
        if (units == 'F' || units == 'f') {
            value /= 0.3048f;
            value = (float)Math.round(value * 100.0f) / 100.0f;
            if (type == 'O') {
                value *= -1.0f;
            }
            return value;
        }
        if (type == 'O' && Math.abs(value) > 0.0f) {
            value *= -1.0f;
        }
        return value;
    }

    public static String getXMLstring(String strg) {
        int i = 0;
        while ((i = strg.indexOf(38, i)) >= 0) {
            strg = strg.substring(0, i) + "&amp;" + strg.substring(i + 1);
            ++i;
        }
        i = 0;
        while ((i = strg.indexOf(60, i)) >= 0) {
            strg = strg.substring(0, i) + "&lt;" + strg.substring(i + 1);
            ++i;
        }
        i = 0;
        while ((i = strg.indexOf(62, i)) >= 0) {
            strg = strg.substring(0, i) + "&gt;" + strg.substring(i + 1);
            ++i;
        }
        while ((i = strg.indexOf(34, i)) >= 0) {
            strg = strg.substring(0, i) + "&quot;" + strg.substring(i + 1);
            ++i;
        }
        while ((i = strg.indexOf(39, i)) >= 0) {
            strg = strg.substring(0, i) + "&apos;" + strg.substring(i + 1);
            ++i;
        }
        return strg;
    }

    public static double parseDepthString(String strg) throws SBException {
        double depth = 0.0;
        strg = strg.trim();
        try {
            if (strg.indexOf(109) >= 0 || strg.indexOf(77) >= 0) {
                depth = Double.parseDouble(strg.substring(0, strg.indexOf(109)));
            } else {
                if (strg.indexOf(34) >= 0) {
                    throw new SBException("Attempt to parse feet & inches in string: " + strg);
                }
                depth = strg.indexOf(39) >= 0 ? SB.convToM(Double.parseDouble(strg.substring(0, strg.indexOf(39))), 'F') : (strg.indexOf(102) >= 0 || strg.indexOf(70) >= 0 ? SB.convToM(Double.parseDouble(strg.substring(0, strg.indexOf(102))), 'F') : Double.parseDouble(strg));
            }
            return depth;
        }
        catch (NumberFormatException e) {
            throw new SBException("Cannot parse depth string: " + strg, e);
        }
    }

    public static char parseDepthUnitsFromString(String strg) throws SBException {
        int units = 77;
        if ((strg = strg.trim()).indexOf(34) >= 0) {
            throw new SBException("Attempt to parse feet & inches in string: " + strg);
        }
        if (strg.indexOf(39) >= 0) {
            units = 70;
        } else if (strg.indexOf(102) >= 0 || strg.indexOf(70) >= 0) {
            units = 70;
        }
        return (char)units;
    }

    public static boolean hasDepthUnitsInString(String strg) throws SBException {
        if ((strg = strg.trim()).indexOf(34) >= 0) {
            throw new SBException("Attempt to parse feet & inches in string: " + strg);
        }
        if (strg.indexOf(39) >= 0) {
            return true;
        }
        if (strg.indexOf(102) >= 0) {
            return true;
        }
        if (strg.indexOf(70) >= 0) {
            return true;
        }
        if (strg.indexOf(109) >= 0) {
            return true;
        }
        return strg.indexOf(77) >= 0;
    }

    public static String removeExcelQuotes(String s) {
        if (s != null && s.startsWith("\"") && s.endsWith("\"") && s.indexOf("\"\"") > 0) {
            s = s.substring(1, s.length() - 1);
            while (s.indexOf("\"\"") > 0) {
                int index = s.indexOf("\"\"");
                s = s.substring(0, index) + s.substring(index + 1);
            }
        }
        return s;
    }

    public static double round(double value, int dp) {
        double div = Math.pow(10.0, dp);
        value = (double)Math.round(value * div) / div;
        return value;
    }

    public static String floatString(float value, int dp) {
        String s;
        double div = Math.pow(10.0, dp);
        value = (float)((double)Math.round((double)value * div) / div);
        if (dp > 0) {
            ++dp;
        }
        if ((s = Float.toString(value)).contains("E")) {
            return s;
        }
        return SB.floatString(s, dp);
    }

    public static String floatString(double value, int dp) {
        String s;
        double div = Math.pow(10.0, dp);
        value = (double)Math.round(value * div) / div;
        if (dp > 0) {
            ++dp;
        }
        if ((s = Double.toString(value)).contains("E")) {
            return s;
        }
        return SB.floatString(s, dp);
    }

    private static String floatString(String s, int dp) {
        s = s + "0000000";
        s = s.substring(0, s.indexOf(46) + dp);
        int leftPad = 4;
        if (s.indexOf(46) > 0) {
            while (s.indexOf(46) < leftPad) {
                s = " " + s;
            }
        } else {
            while (s.length() < leftPad) {
                s = " " + s;
            }
        }
        return s;
    }

    public static String getDepthString(double depth, char units, int precision) {
        String strg = SB.floatString(SB.convFromM(depth, units), precision);
        strg = units == 'F' ? strg + '\'' : strg + 'm';
        return strg;
    }

    public static String getDepthString(double depth, char units, int precision, char type) {
        String strg = SB.floatString(SB.convFromM(depth, units, type), precision);
        strg = units == 'F' ? strg + '\'' : strg + 'm';
        return strg;
    }

    public static float getAgeFloat(double age, AgeFormat af) {
        return (float)(age *= af.getMultiplyer());
    }

    public static String capitalise(String strg) {
        boolean newWord = true;
        String replacement = "";
        for (int i = 0; i < strg.length(); ++i) {
            replacement = newWord ? replacement + strg.substring(i, i + 1).toUpperCase() : replacement + strg.substring(i, i + 1).toLowerCase();
            newWord = strg.charAt(i) == ' ';
        }
        return replacement;
    }

    public static int compareNullStrings(String s1, String s2) {
        if (s1 == null && s2 != null) {
            return 1;
        }
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 != null && s2 == null) {
            return -1;
        }
        return s1.compareToIgnoreCase(s2);
    }

    public static Color getSBColorFromInt(int iColour) {
        Color colour = new Color(iColour);
        colour = new Color(colour.getBlue(), colour.getGreen(), colour.getRed());
        return colour;
    }

    public static int getSBIntFromColor(Color colour) {
        Color newColour = new Color(colour.getBlue(), colour.getGreen(), colour.getRed());
        return newColour.getRGB();
    }

    public static Color getLighterColour(Color baseColour) {
        return SB.getLighterColour(baseColour, 0.5f);
    }

    public static Color getLighterColour(Color baseColour, float factor) {
        if (factor < 0.0f || factor > 1.0f) {
            throw new IllegalArgumentException("Invalid colour density factor: " + factor);
        }
        if (factor == 1.0f) {
            return baseColour;
        }
        float fInverse = 1.0f - factor;
        float[] result = new float[]{(float)baseColour.getRed() * factor + 255.0f * fInverse, (float)baseColour.getGreen() * factor + 255.0f * fInverse, (float)baseColour.getBlue() * factor + 255.0f * fInverse};
        for (int i = 0; i < 3; ++i) {
            if (!(result[i] > 255.0f)) continue;
            result[i] = 255.0f;
        }
        return new Color((int)result[0], (int)result[1], (int)result[2]);
    }

    public static void checkOverlap(int nzTD, int nzBD, int cTD, int cBD, boolean checkSpotPointBoundaries) throws SBException {
        if (nzTD == nzBD && (nzTD == cTD || nzTD == cBD)) {
            throw new SBException("New 'spot' interval lies inside: ");
        }
        if (cTD == cBD && (nzTD == cTD || nzTD == cBD)) {
            throw new SBException("Old 'spot' interval obscured by new interval: ");
        }
        SB.checkOverlap(nzTD, nzBD, cTD, cBD);
    }

    public static void checkOverlap(int nzTD, int nzBD, int cTD, int cBD) throws SBException {
        if (nzTD - nzBD == 0) {
            if (nzTD > cTD && nzTD < cBD) {
                throw new SBException("New 'spot' interval lies inside: ");
            }
            if (nzTD == cTD && nzTD == cBD) {
                throw new SBException("New 'spot' interval coincides with: ");
            }
        } else {
            if (nzTD < cTD && nzBD > cTD) {
                throw new SBException("New top depth lies inside: ");
            }
            if (nzTD < cBD && nzBD > cBD) {
                throw new SBException("New base depth lies inside: ");
            }
            if (nzTD == cTD && nzBD == cBD) {
                throw new SBException("New interval is at same depths as: ");
            }
            if (nzTD >= cTD && nzBD <= cBD) {
                throw new SBException("New interval is obscured by: ");
            }
            if (nzTD <= cTD && nzBD >= cBD) {
                throw new SBException("New interval obscures: ");
            }
        }
    }

    public static String makeFileName(String fileName) {
        String newName = "";
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != ' ') continue;
            newName = newName + c;
        }
        return newName;
    }

    public static double log10(double x) {
        return Math.log(x) / Math.log(10.0);
    }

    public static void showStackError(String msg, Exception ex) {
        if (ex instanceof SQLException) {
            SB.showStackError(msg, (SQLException)ex);
            return;
        }
        if (ex instanceof RuntimeException) {
            if (!msg.isEmpty()) {
                msg = msg + "\n";
            }
            msg = msg + "An internal error has occured. Please copy this message to StrataData";
        }
        StackTraceElement[] trace = ex.getStackTrace();
        String fullMessage = msg + ":\n" + ex.toString() + "\n\nTrace: ";
        int numberedLines = 0;
        for (int i = 0; i < trace.length && numberedLines < 8; ++i) {
            fullMessage = fullMessage + "\n" + trace[i];
            if (trace[i].getLineNumber() > 0) {
                ++numberedLines;
            }
            if (trace[i].getClassName().startsWith("javax.swing.")) break;
        }
        if (hasGUI) {
            JOptionPane.showMessageDialog(null, fullMessage, "SBugs Error", 0);
        }
        ex.printStackTrace();
    }

    public static void showStackError(String msg, SQLException ex) {
        StackTraceElement[] trace = ex.getStackTrace();
        String fullMessage = msg + ":\n" + ex.toString() + "\nSQL: " + sql + "\n\nTrace: ";
        int numberedLines = 0;
        for (int i = 0; i < trace.length && numberedLines < 8; ++i) {
            fullMessage = fullMessage + "\n" + trace[i];
            if (trace[i].getLineNumber() > 0) {
                ++numberedLines;
            }
            if (trace[i].getClassName().startsWith("javax.swing.")) break;
        }
        if (hasGUI) {
            JOptionPane.showMessageDialog(null, fullMessage, "SBugs SQL Error", 0);
        }
        ex.printStackTrace();
    }

    public static void cascade(JDesktopPane desktopPane) {
        JInternalFrame[] frames = desktopPane.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        SB.cascadeLocate(frames, desktopPane.getBounds(), 25);
        SB.cascadeOrder(frames);
    }

    public static void cascadeLocate(JInternalFrame[] frames, Rectangle dBounds, int separation) {
        int margin = frames.length * separation + separation;
        int width = dBounds.width - margin;
        int height = dBounds.height - margin;
        for (int i = 0; i < frames.length; ++i) {
            frames[i].setLocation((frames.length - i - 1) * separation, (frames.length - i - 1) * separation);
        }
    }

    public static void cascadeOrder(JInternalFrame[] frames) {
        for (int i = frames.length - 1; i >= 0; --i) {
            frames[i].moveToFront();
        }
    }

    public static void tile(JDesktopPane desktopPane) {
        JInternalFrame[] frames = desktopPane.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        SB.tile(frames, desktopPane.getBounds());
    }

    public static void tile(JInternalFrame[] frames, Rectangle dBounds) {
        int width;
        int height;
        int rows;
        int cols = (int)Math.sqrt(frames.length);
        int lastRow = frames.length - cols * ((rows = (int)Math.ceil((double)frames.length / (double)cols)) - 1);
        if (lastRow == 0) {
            height = dBounds.height / --rows;
        } else {
            height = dBounds.height / rows;
            if (lastRow < cols) {
                --rows;
                width = dBounds.width / lastRow;
                for (int i = 0; i < lastRow; ++i) {
                    frames[cols * rows + i].setBounds(i * width, rows * height, width, height);
                }
            }
        }
        width = dBounds.width / cols;
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < cols; ++i) {
                frames[i + j * cols].setBounds(i * width, j * height, width, height);
            }
        }
    }

    public static void jInternalFrameClosing(InternalFrameEvent evt, JDesktopPane desktopPane, JMenu menuWindows) {
        JInternalFrame frame = desktopPane.getSelectedFrame();
        JCheckBoxMenuItem item = null;
        for (int m = 0; m < menuWindows.getItemCount(); ++m) {
            JMenuItem menuItem;
            if (menuWindows.getItem(m) == null || (menuItem = menuWindows.getItem(m)).getClass() != JCheckBoxMenuItem.class || !(item = (JCheckBoxMenuItem)menuItem).getText().equals(frame.getTitle())) continue;
            menuWindows.remove(item);
        }
    }

    public static void jInternalFrameActivated(InternalFrameEvent evt, JDesktopPane desktopPane, JMenu menuWindows) {
        JInternalFrame frame = desktopPane.getSelectedFrame();
        JCheckBoxMenuItem item = null;
        for (int m = 0; m < menuWindows.getItemCount(); ++m) {
            JMenuItem menuItem;
            if (menuWindows.getItem(m) == null || (menuItem = menuWindows.getItem(m)).getClass() != JCheckBoxMenuItem.class || !(item = (JCheckBoxMenuItem)menuItem).getText().equals(frame.getTitle())) continue;
            item.setSelected(true);
        }
    }

    public static String mergeString(String s1, String s2, boolean concat) throws SBException {
        if (s1 == null && s2 == null) {
            return null;
        }
        if (s1 == null && s2 != null && s2.length() > 0) {
            return s2;
        }
        if (s1 == null && s2 != null && s2.length() == 0) {
            return s1;
        }
        if (s1 != null && s2 == null) {
            return s1;
        }
        if (s1 != null && s2 != null) {
            if (!s1.equals(s2)) {
                if (concat) {
                    return s1 + " " + s2;
                }
                throw new SBException("Strings: " + s1 + " and " + s2 + " are not equal");
            }
            return s1;
        }
        throw new SBException("Error in string merge for: " + s1 + " and " + s2);
    }

    public static void writeXMLColour(Color colour, BufferedWriter out, String ind) throws IOException {
        out.write(ind + "<Colour>\n");
        out.write(ind + ind + "<Red>" + colour.getRed() + "</Red>\n");
        out.write(ind + ind + "<Green>" + colour.getGreen() + "</Green>\n");
        out.write(ind + ind + "<Blue>" + colour.getBlue() + "</Blue>\n");
        out.write(ind + "</Colour>\n");
    }

    public static Color parseColour(Element xml) {
        int r = 0;
        int g = 0;
        int b = 0;
        String strg = xml.getChildTextNormalize("Red");
        if (strg != null) {
            r = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("Green")) != null) {
            g = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("Blue")) != null) {
            b = Integer.parseInt(strg);
        }
        return new Color(r, g, b);
    }

    public static Cursor getDragMoveCursor() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL url = SB.class.getResource("/util/cursor_drag_move.png");
        if (url != null) {
            Image cursorImage = tk.createImage(url);
            Cursor c = tk.createCustomCursor(cursorImage, new Point(1, 1), "CursorDragMove");
            return c;
        }
        System.out.println("Resource cursor null");
        return new Cursor(1);
    }

    public static Color removeAlpha(Color c) {
        if (c.getAlpha() == 0) {
            return c;
        }
        Color destination = Color.WHITE;
        float[] components = c.getRGBComponents(null);
        float[] destComponents = destination.getRGBColorComponents(null);
        float alpha = components[3];
        float red1 = components[0] * alpha + destComponents[0] * (1.0f - alpha);
        float green1 = components[1] * alpha + destComponents[1] * (1.0f - alpha);
        float blue1 = components[2] * alpha + destComponents[2] * (1.0f - alpha);
        return new Color(red1, green1, blue1);
    }

    public static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public static Color getColour(String colour) {
        String[] split = colour.split(",");
        assert (split.length == 3);
        int r = Integer.parseInt(split[0]);
        int g = Integer.parseInt(split[1]);
        int b = Integer.parseInt(split[2]);
        return new Color(r, g, b);
    }

    public static String getColourString(Color colour) {
        int red = colour.getRed();
        int green = colour.getGreen();
        int blue = colour.getBlue();
        return red + "," + green + "," + blue;
    }

    public static void selectAllFocus(JTable jTableChrono) {
        jTableChrono.selectAll();
        jTableChrono.requestFocus();
    }

    public static GridReader getGridReader(String fileName) throws SBException {
        if (fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx")) {
            return new XLSGridReader(fileName, 0);
        }
        return new CSVGridReader(fileName);
    }

    public static void initSBDateFormatter(final JFormattedTextField field, String dateFormat) {
        if (dateFormat == null) {
            dateFormat = "dd-MMM-yy";
        }
        final String dateFormatString = dateFormat;
        DateFormatter dateFormatter = new DateFormatter(new SimpleDateFormat(dateFormat)){

            @Override
            public String valueToString(Object value) throws ParseException {
                if (value == null) {
                    field.setForeground(Color.LIGHT_GRAY);
                    return dateFormatString;
                }
                field.setForeground(Color.BLACK);
                return super.valueToString(value);
            }
        };
        DateFormatter editFormat = new DateFormatter(new SimpleDateFormat(dateFormat)){

            @Override
            public Object stringToValue(String userInput) throws ParseException {
                Object result = null;
                if (userInput != null && !userInput.trim().isEmpty()) {
                    result = super.stringToValue(userInput);
                }
                return result;
            }

            @Override
            public String valueToString(Object value) throws ParseException {
                field.setForeground(Color.BLACK);
                return super.valueToString(value);
            }
        };
        DefaultFormatterFactory fact = new DefaultFormatterFactory(dateFormatter, dateFormatter, editFormat);
        field.setFormatterFactory(fact);
    }

    public static Clip playSound(Frame parent, Clip soundClip, String soundName, String winSound) {
        try {
            if (soundClip == null) {
                InputStream aStream = parent.getClass().getResourceAsStream(soundName);
                AudioInputStream audioStream = AudioSystem.getAudioInputStream(new BufferedInputStream(aStream));
                soundClip = AudioSystem.getClip();
                soundClip.open(audioStream);
            }
            soundClip.setFramePosition(1);
            soundClip.loop(0);
            return soundClip;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Runnable runnable = (Runnable)parent.getToolkit().getDesktopProperty(winSound);
            if (runnable != null) {
                runnable.run();
            } else {
                parent.getToolkit().beep();
            }
            return null;
        }
    }

    static {
        df = new SimpleDateFormat("dd-MMM-yyyy");
        DBdf = new SimpleDateFormat("yyyy-MM-dd");
        DBdtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        hasGUI = true;
    }
}

