/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import util.SbugsStatus;

public class SbugsStatusRenderer
extends DefaultTableCellRenderer {
    Border selectedBorder = null;
    SbugsStatus status = null;
    float textHeight = -1.0f;
    AffineTransform tnf = new AffineTransform();

    public SbugsStatusRenderer() {
        this.setOpaque(true);
        this.tnf.scale(0.1, 0.1);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object dbItem, boolean isSelected, boolean hasFocus, int row, int column) {
        Color colour = Color.white;
        if (isSelected && dbItem != null) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(2, 0, 2, 0, table.getSelectionBackground());
            }
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(null);
        }
        if (dbItem != null) {
            if (dbItem instanceof SbugsStatus) {
                this.status = (SbugsStatus)dbItem;
                colour = ((SbugsStatus)dbItem).getStatus();
                this.setText(" " + ((SbugsStatus)dbItem).statusString());
            } else {
                this.setText(" " + dbItem.toString());
            }
        } else {
            this.setText("");
            this.status = null;
            if (isSelected) {
                colour = table.getSelectionBackground();
            }
        }
        this.setBackground(colour);
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        AffineTransform saveTransform = ((Graphics2D)g).getTransform();
        ((Graphics2D)g).transform(this.tnf);
        Dimension d = this.getSize();
        float rectSize = d.width * 10;
        if (this.textHeight < 0.0f) {
            this.textHeight = g.getFontMetrics().getHeight() * 10;
        }
        float vertOffset = this.textHeight + ((float)(d.height * 10) - this.textHeight) / 2.0f;
        vertOffset -= 30.0f;
        Font font = new Font(g.getFont().getName(), g.getFont().getStyle(), g.getFont().getSize() * 10);
        g.setFont(font);
        if (this.status == null) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(this.status.getStatus());
        }
        g.fillRect(0, 0, (int)rectSize, d.height * 10);
        if (this.status != null) {
            g.setColor(Color.BLACK);
            if (this.status.statusString() != null) {
                g.drawString(this.status.statusString(), 0, (int)vertOffset);
            } else {
                g.drawString("null", 0, (int)vertOffset);
            }
        }
        ((Graphics2D)g).setTransform(saveTransform);
    }
}

