/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class TextAreaRenderer
extends JTextArea
implements TableCellRenderer {
    boolean changeTableRowHeight = false;
    Border selectedBorder = null;

    public TextAreaRenderer(boolean changeRowHeight, Font font) {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.changeTableRowHeight = changeRowHeight;
        this.setFont(font);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        if (value != null) {
            this.setText(value.toString());
            if (this.changeTableRowHeight) {
                this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
                if (table.getRowHeight(row) != this.getPreferredSize().height) {
                    table.setRowHeight(row, this.getPreferredSize().height);
                }
            }
        } else {
            this.setText(null);
        }
        return this;
    }
}

