/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.IOException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.GridReader;
import util.SBException;

public class XLSGridReader
implements GridReader {
    private String fileName;
    private Workbook wb = null;
    Sheet sheet;
    Row row;
    int nRow = 0;
    int nCol = 0;

    public XLSGridReader(String fileName, int sheetNumber) throws SBException {
        try {
            this.fileName = fileName;
            this.wb = WorkbookFactory.create(new File(fileName));
            this.sheet = this.wb.getSheetAt(sheetNumber);
            if (this.sheet == null) {
                throw new SBException("Workbook sheet number: " + sheetNumber + " not found");
            }
            System.out.println("Parsing workbook sheet: " + this.wb.getSheetName(0));
        }
        catch (IOException ioe) {
            throw new SBException("Error opening file", ioe);
        }
        catch (InvalidFormatException ive) {
            throw new SBException("invalid format opening file", ive);
        }
    }

    @Override
    public boolean nextRow() throws SBException {
        if (this.nRow >= this.sheet.getLastRowNum()) {
            return false;
        }
        this.row = this.sheet.getRow(this.nRow);
        ++this.nRow;
        this.nCol = 0;
        return true;
    }

    @Override
    public String getNextCell() throws SBException {
        if (this.row == null) {
            return null;
        }
        if (this.nCol >= this.row.getLastCellNum()) {
            return null;
        }
        Cell cell = this.row.getCell(this.nCol);
        ++this.nCol;
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            default: {
                return cell.getStringCellValue().trim();
            }
            case 3: 
            case 5: {
                return "";
            }
            case 0: 
            case 2: {
                double num = cell.getNumericCellValue();
                if (Math.abs(num) > 1.0E-4) {
                    if (num - (double)((long)num) > 0.0) {
                        return "" + num;
                    }
                    return "" + (long)num;
                }
                return "";
            }
            case 4: 
        }
        return "" + cell.getBooleanCellValue();
    }

    @Override
    public void close() {
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void rewind() throws SBException {
        this.nRow = 0;
    }
}

