/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import javax.swing.JComboBox;
import model2.Audit;
import model2.SBdb;
import model2.Well;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SortEntry;

public class AbnScheme
extends Observable
implements Comparable,
SortEntry {
    SBdb SB;
    public static final int MAXCLASSES = 12;
    public static final int MAXABRLENGTH = 4;
    public static final int MAXCLASSNAMELENGTH = 25;
    private String name = "";
    private int ID = 0;
    private int nClasses = 0;
    private String[] className;
    private String[] entry;
    private int[] lowBound;
    private int[] outputValue;
    private Audit audit = new Audit();
    private AbnScheme link = null;
    public static String OTC_STRG = "Outside the count (+)";

    AbnScheme(int ID) {
        this.ID = ID;
        this.init();
    }

    public AbnScheme() {
        this.init();
    }

    AbnScheme(SBdb ws, AbnScheme abnScheme) throws SQLException, SBException {
        this.copy(abnScheme);
        this.link = abnScheme;
        this.audit.fillWorkspace(this.SB, ws);
        this.SB = ws;
    }

    public SBdb getDatabase() {
        return this.SB;
    }

    public AbnScheme getLink() {
        return this.link;
    }

    public String getSortEntry() {
        return this.name.toUpperCase();
    }

    public AbnScheme(AbnScheme rhs) {
        this.init();
        if (rhs != null) {
            this.name = rhs.name;
            this.nClasses = rhs.nClasses;
            this.audit = rhs.audit;
            for (int i = 0; i < this.nClasses; ++i) {
                this.entry[i] = rhs.entry[i];
                this.lowBound[i] = rhs.lowBound[i];
                this.className[i] = rhs.className[i];
                this.outputValue[i] = rhs.outputValue[i];
            }
        }
    }

    final void copy(AbnScheme rhs) {
        this.SB = rhs.SB;
        this.init();
        this.name = rhs.name;
        this.ID = rhs.ID;
        this.nClasses = rhs.nClasses;
        this.audit = rhs.audit;
        for (int i = 0; i < this.nClasses; ++i) {
            this.entry[i] = rhs.entry[i];
            this.lowBound[i] = rhs.lowBound[i];
            this.className[i] = rhs.className[i];
            this.outputValue[i] = rhs.outputValue[i];
        }
        this.setChanged();
    }

    public void copy(boolean resetID, AbnScheme rhs) throws SQLException, SBException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to change database abundance scheme");
        }
        this.init();
        this.name = rhs.name;
        this.nClasses = rhs.nClasses;
        this.audit = rhs.audit;
        for (int i = 0; i < this.nClasses; ++i) {
            this.entry[i] = rhs.entry[i];
            this.lowBound[i] = rhs.lowBound[i];
            this.className[i] = rhs.className[i];
            this.outputValue[i] = rhs.outputValue[i];
        }
        if (resetID) {
            this.ID = -1;
        }
        this.link = rhs;
    }

    public int compareTo(Object rhs) {
        return this.name.compareToIgnoreCase(((AbnScheme)rhs).name);
    }

    public void insertRow(int insertPoint) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to modify stored abundance scheme");
        }
        for (int i = this.nClasses; i > insertPoint; --i) {
            this.entry[i] = this.entry[i - 1];
            this.lowBound[i] = this.lowBound[i - 1];
            this.className[i] = this.className[i - 1];
            this.outputValue[i] = this.outputValue[i - 1];
        }
        this.entry[insertPoint] = "";
        this.lowBound[insertPoint] = 0;
        this.className[insertPoint] = "";
        this.outputValue[insertPoint] = 0;
        ++this.nClasses;
    }

    public void deleteRow(int deletePoint) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to modify stored abundance scheme");
        }
        for (int i = deletePoint; i < this.nClasses; ++i) {
            this.entry[i] = this.entry[i + 1];
            this.lowBound[i] = this.lowBound[i + 1];
            this.className[i] = this.className[i + 1];
            this.outputValue[i] = this.outputValue[i + 1];
        }
        --this.nClasses;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        if (this.name.length() == 0) {
            if (this.ID != 0) {
                return "Scheme ID no. " + this.ID;
            }
            return "<No Name or ID>";
        }
        return this.name;
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    void refresh(Statement stmt) throws SQLException, SBException {
        Timestamp time;
        String sql = "SELECT updated FROM " + this.SB.DBTableName("ABNSCHME") + " WHERE scheme_id=" + this.ID;
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next() && (time = rs.getTimestamp("updated")) != null && time.after(this.audit.updated)) {
            AbnScheme temp = new AbnScheme(this.SB, this.ID);
            this.copy(temp);
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void init() {
        this.className = new String[12];
        this.entry = new String[12];
        this.lowBound = new int[12];
        this.outputValue = new int[12];
    }

    public void fillCombo(JComboBox combo, boolean addOTC) {
        if (addOTC) {
            combo.addItem(OTC_STRG);
        }
        for (int i = 0; i < this.nClasses; ++i) {
            combo.addItem(this.className[i]);
        }
    }

    public String getAbr(String desc) {
        for (int i = 0; i < this.nClasses; ++i) {
            if (!desc.equalsIgnoreCase(this.className[i])) continue;
            return this.entry[i];
        }
        return "";
    }

    public String getClassName(String abr) throws SBException {
        for (int i = 0; i < this.nClasses; ++i) {
            if (!abr.equalsIgnoreCase(this.entry[i])) continue;
            return this.className[i];
        }
        throw new SBException("Abundance scheme entry not found for abr: " + abr);
    }

    public String getEntry(int index) {
        return this.entry[index];
    }

    public String getClassName(int index) {
        return this.className[index];
    }

    public int getLowBound(int index) {
        return this.lowBound[index];
    }

    public int getOutputValue(int index) {
        return this.outputValue[index];
    }

    public void setName(String name) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set abnScheme");
        }
        this.name = name;
    }

    public void setEntry(String entry, int index) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set abnScheme");
        }
        if (entry.length() > 4) {
            throw new SBException("Attempt to set abundance scheme entry > 4");
        }
        for (char c : entry.toCharArray()) {
            if (Character.isLetter(c)) continue;
            throw new SBException("Abundance scheme classes must consist of letters only. Entry was: " + entry);
        }
        this.entry[index] = entry;
    }

    public void setClassName(String className, int index) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set abnScheme");
        }
        if (className.length() > 25) {
            throw new SBException("Attempt to set abundance scheme class name > 25");
        }
        this.className[index] = className;
    }

    public void setLowBound(int lowBound, int index) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set abnScheme");
        }
        this.lowBound[index] = lowBound;
    }

    public void setOutputValue(int outputValue, int index) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set abnScheme");
        }
        this.outputValue[index] = outputValue;
    }

    public int getCount(String abr) {
        for (int i = 0; i < this.nClasses; ++i) {
            if (!abr.equalsIgnoreCase(this.entry[i])) continue;
            if (this.outputValue[i] != 0) {
                return this.outputValue[i];
            }
            return this.lowBound[i];
        }
        return 0;
    }

    public String getAbr(int bound) {
        for (int i = this.nClasses - 1; i >= 0; --i) {
            if (this.entry[i].equals("+") && bound == 0) {
                return "+";
            }
            if (bound < this.lowBound[i] || this.entry[i].equals("+") || this.lowBound[i] <= 0) continue;
            return this.entry[i];
        }
        return "";
    }

    public int getNoccs() throws SQLException {
        if (this.ID == 0) {
            return 0;
        }
        String sql = "SELECT count(analy_id) as nOcc FROM " + this.SB.DBTableName("ANALY_HDR") + " WHERE abnsch_id=" + this.ID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        int nOccs = 0;
        if (rs.next()) {
            nOccs = rs.getInt("nOcc");
        }
        return nOccs;
    }

    public List getOccs() throws SQLException, SBException {
        String sql = "SELECT w.well_name,v.well_id,v.well_code,a.disc_id,a.analyst,a.analy_no FROM " + this.SB.DBTableName("ANALY_HDR") + " a," + this.SB.DBTableName("WELL_IDENT") + " v," + this.SB.DBTableName("WELLS") + " w" + " WHERE a.abnsch_id=" + this.ID + " AND a.well_id=v.well_id AND v.well_code=w.well_code ORDER BY well_name";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        ArrayList<String> occs = new ArrayList<String>();
        while (rs.next()) {
            occs.add(rs.getString("well_name") + "|" + rs.getInt("well_id") + "|" + rs.getString("well_code") + "|" + rs.getString("disc_id").trim().charAt(0) + "|" + this.SB.getUser(rs.getInt("analyst")).getAbr() + "|" + rs.getInt("analy_no"));
        }
        stmt.close();
        return occs;
    }

    public int getIndex(String subj) {
        if (subj == null || subj.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < this.nClasses; ++i) {
            if (!subj.equalsIgnoreCase(this.entry[i])) continue;
            return i;
        }
        return -1;
    }

    public int getIndexStartsWith(String subj) {
        if (subj == null || subj.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < this.nClasses; ++i) {
            if (subj.equalsIgnoreCase(this.entry[i])) {
                return i;
            }
            if (this.entry[i].length() <= 1 || !this.entry[i].startsWith(subj.toUpperCase())) continue;
            return i;
        }
        return -1;
    }

    public int getIndexDescr(String descr) {
        if (descr == null) {
            return -1;
        }
        if (descr.length() == 0) {
            return -1;
        }
        for (int i = 0; i < this.nClasses; ++i) {
            if (!descr.equalsIgnoreCase(this.className[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean checkNameUnique(SBdb db, int ID) throws SQLException, SBException {
        if (this.SB != null) {
            throw new SBException("Cannot check stored abundance scheme - use copy");
        }
        String sql = "SELECT scheme_id FROM " + db.DBTableName("ABNSCHME") + " WHERE ucase(name)='" + this.name.toUpperCase() + "'";
        if (ID != 0) {
            sql = sql + " AND scheme_id <> " + ID;
        }
        Statement stmt = db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        boolean unique = true;
        if (rs.next()) {
            unique = false;
        }
        stmt.close();
        return unique;
    }

    public boolean checkAndSort() throws InvalidFieldException {
        int i;
        if (this.SB != null) {
            throw new InvalidFieldException("Cannot check stored abundance scheme - use copy");
        }
        for (i = 0; i < this.nClasses; ++i) {
            if (this.entry[i] == null || this.entry[i].length() == 0) {
                throw new InvalidFieldException("Entry at row " + (i + 1) + " is blank.");
            }
            if (this.entry[i].length() > 4) {
                throw new InvalidFieldException("Entry at row " + (i + 1) + " exceeds Maximum length of :" + 4);
            }
            if (this.className[i] == null || this.className[i].length() == 0) {
                throw new InvalidFieldException("Description at row " + (i + 1) + " is blank.");
            }
            if (this.lowBound[i] >= 0) continue;
            throw new InvalidFieldException("Minimum value at row " + (i + 1) + " is invalid.");
        }
        for (i = 0; i < this.nClasses; ++i) {
            for (int j = 0; j < this.nClasses; ++j) {
                if (i == j) continue;
                if (this.entry[i].equalsIgnoreCase(this.entry[j])) {
                    throw new InvalidFieldException("Duplicate entries at rows : " + (i + 1) + " and " + (j + 1));
                }
                if (this.className[i].equalsIgnoreCase(this.className[j])) {
                    throw new InvalidFieldException("Duplicate descriptions at rows : " + (i + 1) + " and " + (j + 1));
                }
                if (this.lowBound[i] != this.lowBound[j]) continue;
                throw new InvalidFieldException("Duplicate values at rows : " + (i + 1) + " and " + (j + 1));
            }
        }
        boolean swap = true;
        block3: while (swap) {
            swap = false;
            for (int i2 = 0; i2 < this.nClasses - 1; ++i2) {
                if (this.lowBound[i2 + 1] == 0 || this.lowBound[i2] <= this.lowBound[i2 + 1]) continue;
                swap = true;
                int temp = this.lowBound[i2];
                this.lowBound[i2] = this.lowBound[i2 + 1];
                this.lowBound[i2 + 1] = temp;
                String tempString = this.entry[i2];
                this.entry[i2] = this.entry[i2 + 1];
                this.entry[i2 + 1] = tempString;
                temp = this.outputValue[i2];
                this.outputValue[i2] = this.outputValue[i2 + 1];
                this.outputValue[i2 + 1] = temp;
                tempString = this.className[i2];
                this.className[i2] = this.className[i2 + 1];
                this.className[i2 + 1] = tempString;
                continue block3;
            }
        }
        return true;
    }

    public void addClass(String abr, String name, int bound, int oVal) throws SBException {
        int i;
        if (this.SB != null) {
            throw new SBException("Cannot add class to stored abundance scheme - use copy");
        }
        for (char c : abr.toCharArray()) {
            if (Character.isLetter(c)) continue;
            throw new SBException("Abundance scheme classes must consist of letters only. Entry was: " + abr);
        }
        int insertPoint = this.nClasses;
        for (i = 0; i < this.nClasses; ++i) {
            if (abr.equalsIgnoreCase(this.entry[i])) {
                throw new SBException("Abundance scheme entry: '" + abr + "' is already defined in scheme");
            }
            if (bound >= this.lowBound[i]) continue;
            insertPoint = i;
            break;
        }
        if (this.nClasses + 1 > 12) {
            throw new SBException("Number of abundance scheme classes exceeded");
        }
        if (bound == 0) {
            insertPoint = this.nClasses;
        }
        for (i = this.nClasses; i > insertPoint; --i) {
            this.entry[i] = this.entry[i - 1];
            this.lowBound[i] = this.lowBound[i - 1];
            this.className[i] = this.className[i - 1];
            this.outputValue[i] = this.outputValue[i - 1];
        }
        this.entry[insertPoint] = abr;
        this.lowBound[insertPoint] = bound;
        this.className[insertPoint] = name;
        this.outputValue[insertPoint] = oVal;
        ++this.nClasses;
    }

    public AbnScheme(SBdb SB2, int iID) throws SQLException {
        this.SB = SB2;
        this.init();
        String sql = "SELECT name," + Audit.sqlFieldString() + " FROM " + SB2.DBTableName("ABNSCHME") + " WHERE scheme_id=" + iID;
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            this.ID = iID;
            this.name = util.SB.getDBString((ResultSet)rs, (String)"name");
            this.audit = new Audit(rs);
            rs.close();
            this.loadClasses(stmt);
        }
        stmt.close();
    }

    public AbnScheme(SBdb SB2, String findName) throws SQLException {
        this.init();
        String sql = "SELECT scheme_id," + Audit.sqlFieldString() + " FROM " + SB2.DBTableName("ABNSCHME") + " WHERE name='" + findName + "'";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            this.ID = rs.getInt("scheme_id");
            this.audit = new Audit(rs);
            this.SB = SB2;
            this.name = findName;
            rs.close();
            this.loadClasses(stmt);
        }
        stmt.close();
    }

    private void loadClasses(Statement stmt) throws SQLException {
        String sql = "SELECT entry_no,entry_name,abr,min,output_val FROM " + this.SB.DBTableName("ABNSCHMBR") + " WHERE scheme_id=" + this.ID + " ORDER BY entry_no";
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int i = rs.getInt("entry_no") - 1;
            this.className[i] = util.SB.getDBString((ResultSet)rs, (String)"entry_name");
            this.entry[i] = util.SB.getDBString((ResultSet)rs, (String)"abr");
            this.lowBound[i] = rs.getInt("min");
            this.outputValue[i] = rs.getInt("output_val");
            this.nClasses = i + 1;
        }
        rs.close();
    }

    void merge(AbnScheme donor) throws SQLException, SBException {
        if (this.ID == 0 || donor.ID == 0) {
            throw new SBException("Scheme ID zero in AbnScheme.merge");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "UPDATE " + this.SB.DBTableName("ANALY_HDR") + " SET abnsch_id=" + this.ID + " WHERE abnsch_id=" + donor.ID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        donor.delete();
        stmt.close();
    }

    public boolean match(AbnScheme rhs) {
        if (this.nClasses != rhs.nClasses) {
            return false;
        }
        for (int i = 0; i < this.nClasses; ++i) {
            if (this.lowBound[i] != rhs.lowBound[i]) {
                return false;
            }
            if (this.entry[i].equals(rhs.entry[i])) continue;
            return false;
        }
        return true;
    }

    static void loadAll(SBdb SB2, List abnSchemes) throws SQLException {
        String sql = "SELECT scheme_id FROM " + SB2.DBTableName("ABNSCHME") + " ORDER BY scheme_id";
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int ID = rs.getInt("scheme_id");
            AbnScheme abnScheme = AbnScheme.get(abnSchemes, ID, 0);
            if (abnScheme != null) continue;
            abnSchemes.add(new AbnScheme(SB2, ID));
        }
        Collections.sort(abnSchemes);
        stmt.close();
    }

    static AbnScheme get(List abns, int hostID, int donorID) {
        for (AbnScheme scheme : abns) {
            if (hostID <= 0 || scheme.ID != hostID) continue;
            return scheme;
        }
        return null;
    }

    static AbnScheme get(List abns, String name) {
        for (AbnScheme scheme : abns) {
            if (!scheme.name.equals(name)) continue;
            return scheme;
        }
        return null;
    }

    static AbnScheme getDefault(SBdb SB2, List abnSchemes) throws SQLException {
        AbnScheme abn = AbnScheme.get(abnSchemes, "Default Abundance Scheme");
        if (abn == null) {
            AbnScheme.loadAll(SB2, abnSchemes);
            abn = AbnScheme.get(abnSchemes, "Default Abundance Scheme");
        }
        if (abn == null) {
            for (AbnScheme testAbn : abnSchemes) {
                if (abn != null && testAbn.ID >= abn.ID) continue;
                abn = testAbn;
            }
        }
        return abn;
    }

    public List getWellUsage() throws SQLException, SBException {
        if (this.SB == null) {
            throw new SBException("Database pointer null in AbnScheme.getWellUsage");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT well_id, analy_id FROM " + this.SB.DBTableName("ANALY_HDR") + " WHERE abnsch_id=" + this.ID;
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        class WellDisc {
            int wellID;
            int analyID;

            WellDisc() {
            }
        }
        LinkedList<WellDisc> wells = new LinkedList<WellDisc>();
        while (rs.next()) {
            WellDisc wellDisc = new WellDisc();
            wellDisc.wellID = rs.getInt("well_id");
            wellDisc.analyID = rs.getInt("analy_id");
            wells.add(wellDisc);
        }
        Iterator it = wells.iterator();
        LinkedList<String> foundWells = new LinkedList<String>();
        while (it.hasNext()) {
            WellDisc wellDisc = (WellDisc)it.next();
            sql = "SELECT distinct abund FROM " + this.SB.DBTableName("TAXONOCC") + " WHERE well_id=" + wellDisc.wellID + " AND analy_id=" + wellDisc.analyID + " AND abund is not null";
            rs = stmt.executeQuery(this.SB.modQuery(sql));
            boolean found = false;
            String abrs = "";
            while (rs.next()) {
                String subjAbund = rs.getString("abund");
                if (subjAbund.trim().length() <= 0) continue;
                found = true;
                if (abrs.length() > 0) {
                    abrs = abrs + ",";
                }
                abrs = abrs + subjAbund;
            }
            if (!found) continue;
            String well = Well.getName(this.SB, wellDisc.wellID);
            well = well + " Usage: " + abrs;
            foundWells.add(well);
        }
        stmt.close();
        return foundWells;
    }

    void delete() throws SQLException, SBException {
        if (this.SB == null) {
            throw new SBException("Null database pointer in AbnScheme.delete");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        if (this.ID != 0) {
            String sql = "UPDATE " + this.SB.DBTableName("ANALY_HDR") + " set abnsch_id=null WHERE abnsch_id=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
            sql = "DELETE FROM " + this.SB.DBTableName("ABNSCHMBR") + " WHERE scheme_id=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
            sql = "DELETE FROM " + this.SB.DBTableName("ABNSCHME") + " WHERE scheme_id=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
    }

    public void update(AbnScheme rhs) throws SQLException, InvalidFieldException {
        rhs.checkAndSort();
        rhs.update(this.SB, this.ID);
        int saveID = this.ID;
        this.copy(rhs);
        this.ID = saveID;
        this.setChanged();
        this.notifyObservers();
    }

    void store(SBdb SB2, int schemeID) throws SQLException, SBException {
        if (this.ID != 0) {
            throw new SBException("Scheme ID non zero in Abnscheme store");
        }
        this.ID = schemeID;
        Statement stmt = SB2.getDatabase().createStatement();
        if (this.ID == 0) {
            throw new SBException("Attempt to store abnScheme with no ID.");
        }
        String sql = "INSERT INTO " + SB2.DBTableName("ABNSCHME");
        sql = sql + " ( scheme_id, name, " + Audit.sqlFieldString() + " ) VALUES (";
        sql = sql + this.ID + ",'" + this.name + "',";
        sql = sql + this.audit.sqlInsert(SB2, stmt);
        sql = sql + ")";
        stmt.executeUpdate(SB2.modQuery(sql));
        this.storeMembers(SB2, stmt, schemeID);
        this.SB = SB2;
        stmt.close();
    }

    void store(SBdb SB2) throws SQLException, SBException {
        Statement stmt = SB2.getDatabase().createStatement();
        if (this.ID != 0 && this.SB == SB2) {
            throw new SBException("Attempt to store abnScheme for pre-existing ID - use update()");
        }
        this.ID = SB2.nextControl("ABNSCHME", "SCHEME_ID");
        String sql = "INSERT INTO " + SB2.DBTableName("ABNSCHME");
        sql = sql + " ( scheme_id, name, " + Audit.sqlFieldString() + " ) VALUES (";
        sql = sql + this.ID + ",'" + this.name + "',";
        sql = sql + this.audit.sqlInsert(SB2, stmt);
        sql = sql + ")";
        stmt.executeUpdate(SB2.modQuery(sql));
        this.storeMembers(SB2, stmt, this.ID);
        this.SB = SB2;
        stmt.close();
    }

    private void storeMembers(SBdb SB2, Statement stmt, int ID) throws SQLException {
        for (int i = 0; i < this.nClasses; ++i) {
            String sql = "INSERT INTO " + SB2.DBTableName("ABNSCHMBR") + " (scheme_id, entry_no, entry_name, abr, min, output_val) VALUES (";
            sql = sql + ID + "," + (i + 1) + ",'" + this.className[i] + "','" + this.entry[i] + "'," + this.lowBound[i] + "," + this.outputValue[i];
            sql = sql + ")";
            stmt.executeUpdate(SB2.modQuery(sql));
        }
    }

    private void update(SBdb SB2, int ID) throws SQLException {
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "UPDATE " + SB2.DBTableName("ABNSCHME") + " SET name=" + util.SB.DBString((String)this.name) + "," + this.audit.sqlUpdate(SB2, stmt, false) + " WHERE scheme_id=" + ID;
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("ABNSCHMBR") + " WHERE scheme_id=" + ID;
        stmt.executeUpdate(SB2.modQuery(sql));
        this.storeMembers(SB2, stmt, ID);
        this.SB = SB2;
        stmt.close();
    }

    void writeSbugs(FileWriter out) throws IOException {
        out.write("ABNSCHME\n");
        String blanks = "                                                        ";
        for (int i = 0; i < this.nClasses; ++i) {
            out.write(blanks.substring(0, 4 - this.entry[i].length()) + this.entry[i]);
            out.write(blanks.substring(0, 25 - this.className[i].length()) + this.className[i]);
            out.write(String.valueOf(this.lowBound[i]) + '\n');
        }
    }

    AbnScheme(SBdb db, Element xml) throws SBException {
        this.SB = db;
        this.init();
        String strgID = xml.getChildTextNormalize("SchemeID");
        if (strgID == null) {
            throw new SBException("ID null in XML - invalid");
        }
        this.ID = Integer.parseInt(strgID);
        this.name = xml.getChildText("SchemeName");
        Iterator it = xml.getContent((Filter)new ElementFilter("Category")).iterator();
        this.nClasses = 0;
        while (it.hasNext()) {
            Element el = (Element)it.next();
            this.className[this.nClasses] = el.getChildText("Name");
            this.entry[this.nClasses] = el.getChildTextNormalize("Entry");
            this.lowBound[this.nClasses] = Integer.parseInt(el.getChildTextNormalize("LowBound"));
            this.outputValue[this.nClasses] = Integer.parseInt(el.getChildTextNormalize("OutputValue"));
            ++this.nClasses;
        }
    }

    public void writeXML(BufferedWriter out, int indent) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        String ind2 = new String();
        while (ind2.length() < indent + 3) {
            ind2 = ind2 + ' ';
        }
        out.write(ind + "<SchemeID>" + this.ID + "</SchemeID>\n");
        out.write(ind + "<SchemeName>" + this.name + "</SchemeName>\n");
        for (int i = 0; i < this.nClasses; ++i) {
            out.write(ind + "<Category>\n");
            out.write(ind2 + "<Name>" + this.className[i] + "</Name>\n");
            out.write(ind2 + "<Entry>" + this.entry[i] + "</Entry>\n");
            out.write(ind2 + "<LowBound>" + this.lowBound[i] + "</LowBound>\n");
            out.write(ind2 + "<OutputValue>" + this.outputValue[i] + "</OutputValue>\n");
            out.write(ind + "</Category>\n");
        }
    }

    void writeDEX(FileWriter out, String eol) throws IOException {
        String ind = new String();
        out.write("Scheme ID = " + this.ID + eol);
        out.write("Scheme name = " + this.name + eol);
        out.write("Number of categories = " + this.nClasses + eol);
        for (int i = 0; i < this.nClasses; ++i) {
            out.write("  Category number = " + (i + 1) + eol);
            out.write("    Name : " + this.className[i] + eol);
            out.write("    Entry : " + this.entry[i] + eol);
            out.write("    Low Bound : " + this.lowBound[i] + eol);
            out.write("    Output Value : " + this.outputValue[i] + eol);
        }
        out.write(eol);
    }

    void parseXML(String chars, String element) {
        if (element.compareTo("SchemeName") == 0) {
            this.name = chars;
        } else if (element.compareTo("Name") == 0) {
            if (this.className[this.nClasses] != null && this.nClasses < 12) {
                ++this.nClasses;
            }
            this.className[this.nClasses] = chars;
        } else if (element.compareTo("Entry") == 0) {
            if (this.entry[this.nClasses] != null && this.nClasses < 12) {
                ++this.nClasses;
            }
            this.entry[this.nClasses] = chars;
        } else if (element.compareTo("LowBound") == 0) {
            if (this.lowBound[this.nClasses] != 0 && this.nClasses < 12) {
                ++this.nClasses;
            }
            this.lowBound[this.nClasses] = Integer.parseInt(chars);
        } else if (element.compareTo("OutputValue") == 0) {
            if (this.outputValue[this.nClasses] != 0 && this.nClasses < 12) {
                ++this.nClasses;
            }
            this.outputValue[this.nClasses] = Integer.parseInt(chars);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.ID;
    }

    public int getNClasses() {
        return this.nClasses;
    }

    public Set<String> getAbrChanges(AbnScheme newScheme) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.nClasses; ++i) {
            String abr = this.entry[i];
            if (newScheme.getIndex(abr) >= 0) continue;
            set.add(abr);
        }
        return set;
    }

    public int getAbrOccs(String abr) throws SQLException {
        int nOccs = 0;
        String sql = "SELECT count(abund) AS nOccs FROM " + this.SB.DBTableName("taxonocc") + " t, " + this.SB.DBTableName("analy_hdr") + " h WHERE h.abnsch_id=" + this.ID + " AND t.analy_id=h.analy_id AND h.well_id=t.well_id AND t.abund=" + util.SB.DBString((String)abr);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            nOccs = rs.getInt("nOccs");
        }
        return nOccs;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    public int getIndex(int count) {
        for (int i = 0; i < this.nClasses; ++i) {
            if (count > this.lowBound[i]) continue;
            return i;
        }
        return this.nClasses;
    }
}

