/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import model2.Audit;
import model2.SBdb;
import model2.TSCreatorReader;
import util.SB;
import util.SBException;

public class AgeCurve {
    public static String[] styles = new String[]{"Solid"};
    public static final int STYLE_SOLID = 0;
    List<AgeCurveValue> trace = new LinkedList<AgeCurveValue>();
    int curveID;
    int schID;
    String title;
    String units;
    Double oldest;
    Double youngest;
    Color colour;
    float lineWidth;
    int style;
    String fileName;
    Audit audit;

    public AgeCurve(File file, String title, String units, Color colour, int style, float lineWidth, int schID) throws FileNotFoundException, IOException {
        String buff;
        this.title = title;
        this.units = units;
        this.style = style;
        this.lineWidth = lineWidth;
        this.schID = schID;
        this.colour = colour;
        this.fileName = file.getPath();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((buff = in.readLine()) != null) {
            StringTokenizer tok;
            if (buff.trim().length() == 0 || (tok = new StringTokenizer(buff, " ,;\t")).countTokens() < 2) continue;
            try {
                while (tok.hasMoreTokens()) {
                    AgeCurveValue val = new AgeCurveValue();
                    val.age = Double.parseDouble(tok.nextToken());
                    val.value = Double.parseDouble(tok.nextToken());
                    this.trace.add(val);
                }
            }
            catch (NumberFormatException ex) {
                System.out.println("Number format exception in : " + buff);
            }
        }
        in.close();
    }

    public AgeCurve(TSCreatorReader.TSCCurve curve, String units, Color colour, int style, float lineWidth, int schID) throws FileNotFoundException, IOException {
        this.schID = schID;
        this.title = curve.name;
        this.units = units;
        this.lineWidth = lineWidth;
        this.colour = colour;
        this.style = style;
        for (TSCreatorReader.TSCPoint point : curve.points) {
            AgeCurveValue value = new AgeCurveValue();
            value.age = point.age;
            if (this.youngest == null || value.age < this.youngest) {
                this.youngest = value.age;
            }
            if (this.oldest == null || value.age > this.oldest) {
                this.oldest = value.age;
            }
            value.value = point.value;
            this.trace.add(value);
        }
    }

    AgeCurve(SBdb db, int curveID, int schID, String title, String units, float lineWidth, Color colour, int style, Audit audit) throws SQLException {
        this.curveID = curveID;
        this.schID = schID;
        this.title = title;
        this.units = units;
        this.lineWidth = lineWidth;
        this.colour = colour;
        this.style = style;
        this.audit = audit;
        String sql = "SELECT age, trace_value FROM " + db.DBTableName("AGE_TRACE") + " WHERE curve_id=" + curveID + " ORDER BY age";
        Statement stmt = db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        while (rs.next()) {
            double age;
            AgeCurveValue value = new AgeCurveValue();
            value.age = age = rs.getDouble("age");
            if (this.youngest == null || age < this.youngest) {
                this.youngest = age;
            }
            if (this.oldest == null || age > this.oldest) {
                this.oldest = age;
            }
            value.value = rs.getDouble("trace_value");
            this.trace.add(value);
        }
        stmt.close();
    }

    static void loadAll(SBdb db, List ageCurves) throws SQLException, SBException {
        String sql = "SELECT curve_id, sch_id, title, units, linewidth, red, green, blue, style," + Audit.sqlFieldString() + " FROM " + db.DBTableName("AGE_CURVE");
        Statement stmt = db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        while (rs.next()) {
            int curveID = rs.getInt("curve_id");
            int schID = rs.getInt("sch_id");
            String title = rs.getString("title");
            String units = rs.getString("units");
            float lineWidth = rs.getFloat("linewidth");
            int red = rs.getInt("red");
            int green = rs.getInt("green");
            int blue = rs.getInt("blue");
            Color colour = new Color(red, green, blue);
            int style = rs.getInt("style");
            Audit audit = new Audit(rs);
            ageCurves.add(new AgeCurve(db, curveID, schID, title, units, lineWidth, colour, style, audit));
        }
        stmt.close();
    }

    void store(SBdb db) throws SBException, SQLException {
        this.audit = new Audit();
        this.curveID = db.nextControl("AGE_CURVE", "CURVE_ID");
        Statement stmt = db.getDatabase().createStatement();
        String sql = "INSERT INTO " + db.DBTableName("AGE_CURVE") + " ( curve_id, sch_id, title, units, linewidth, red, green, blue, style," + Audit.sqlFieldString() + ") VALUES (";
        sql = sql + this.curveID + "," + this.schID + "," + SB.DBString((String)this.title) + "," + SB.DBString((String)this.units) + "," + this.lineWidth + "," + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + "," + this.style + "," + this.audit.sqlInsert(db, stmt) + ")";
        stmt.executeUpdate(db.modQuery(sql));
        sql = "INSERT INTO " + db.DBTableName("AGE_TRACE") + " (curve_id, age, trace_value) VALUES (" + this.curveID + ",?,?)";
        stmt.close();
        PreparedStatement pStmt = db.getDatabase().prepareStatement(db.modQuery(sql));
        for (AgeCurveValue value : this.trace) {
            pStmt.setDouble(1, value.age);
            pStmt.setDouble(2, value.value);
            try {
                pStmt.executeUpdate();
            }
            catch (SQLException sqle) {
                System.out.println("SQL Exception " + sqle.getMessage() + " while inserting value: " + value.age + "," + value.value);
            }
        }
    }

    public void updateAttributes(SBdb db) throws SBException, SQLException {
        if (this.curveID <= 0) {
            return;
        }
        Statement stmt = db.getDatabase().createStatement();
        String sql = "UPDATE " + db.DBTableName("AGE_CURVE") + " SET sch_id=" + this.schID + ",title=" + SB.DBString((String)this.title) + ",units=" + SB.DBString((String)this.units) + ",linewidth=" + this.lineWidth + ",red=" + this.colour.getRed() + ",green=" + this.colour.getGreen() + ",blue=" + this.colour.getBlue() + ",style=" + this.style + "," + this.audit.sqlUpdate(db, stmt, false);
        sql = sql + " WHERE curve_id=" + this.curveID;
        stmt.executeUpdate(db.modQuery(sql));
        stmt.close();
    }

    public void delete(SBdb db) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        String sql = "DELETE FROM " + db.DBTableName("AGE_TRACE") + " WHERE curve_id=" + this.curveID;
        stmt.executeUpdate(db.modQuery(sql));
        sql = "DELETE FROM " + db.DBTableName("AGE_CURVE") + " WHERE curve_id=" + this.curveID;
        stmt.executeUpdate(db.modQuery(sql));
        stmt.close();
    }

    public void deleteRow(SBdb db, AgeCurveValue curveValue) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        String sql = "DELETE FROM " + db.DBTableName("AGE_TRACE") + " WHERE curve_id=" + this.curveID + " AND age > " + (curveValue.age - 0.001) + " AND age < " + (curveValue.age + 0.001);
        stmt.executeUpdate(db.modQuery(sql));
        stmt.close();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public Double getYoungest() {
        if (this.youngest == null) {
            this.setYoungest();
        }
        return this.youngest;
    }

    private void setYoungest() {
        for (AgeCurveValue val : this.trace) {
            if (this.youngest != null && !(val.age < this.youngest)) continue;
            this.youngest = val.age;
        }
    }

    public Double getOldest() {
        if (this.oldest == null) {
            this.setOldest();
        }
        return this.oldest;
    }

    private void setOldest() {
        for (AgeCurveValue val : this.trace) {
            if (this.oldest != null && !(val.age > this.oldest)) continue;
            this.oldest = val.age;
        }
    }

    public double getMin() {
        Double min = null;
        for (AgeCurveValue val : this.trace) {
            if (min != null && !(val.value < min)) continue;
            min = val.value;
        }
        return min;
    }

    public double getMax() {
        Double max = null;
        for (AgeCurveValue val : this.trace) {
            if (max != null && !(val.value > max)) continue;
            max = val.value;
        }
        return max;
    }

    public int getSchID() {
        return this.schID;
    }

    public void setSchID(int schID) {
        this.schID = schID;
    }

    public String getFilename() {
        return this.fileName;
    }

    public List<AgeCurveValue> getTrace() {
        return this.trace;
    }

    public void setColour(Color colour) {
        this.colour = colour;
    }

    public Color getColour() {
        return this.colour;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public int getCurveID() {
        return this.curveID;
    }

    public String toString() {
        return "" + this.title;
    }

    public double getValue(double age) {
        AgeCurveValue n1 = null;
        AgeCurveValue n2 = null;
        for (AgeCurveValue n : this.trace) {
            if (n.age < age) {
                n1 = n;
                continue;
            }
            if (Math.abs(n.age - age) < 0.01) {
                return n.value;
            }
            if (!(n.age > age)) continue;
            n2 = n;
            break;
        }
        if (n1 != null && n2 != null) {
            return n1.value + (age - n1.age) * ((n2.value - n1.value) / (n2.age - n1.age));
        }
        return 0.0;
    }

    public class AgeCurveValue {
        double age;
        double value;

        public double getAge() {
            return this.age;
        }

        public double getValue() {
            return this.value;
        }
    }
}

