/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import model2.SBdb;
import model2.Userdef;
import org.jdom.Element;
import util.SB;
import util.SBException;

public class Audit {
    public static final String CREATOR = "creator";
    public static final String CREATED = "created";
    public static final String MODIFIER = "modifier";
    public static final String MODIFIED = "modified";
    public static final String UPDATER = "updater";
    public static final String UPDATED = "updated";
    int creator;
    Date created;
    int modifier;
    Date modified;
    int updater;
    Date updated;
    public static final String[] AUDIT_TABLES = new String[]{"ABNSCHME", "ANALY_HDR", "BCMMNTS", "CASING", "CMPSTD", "CORES", "ENV_SCH", "EVENTDIC", "EVENTS", "GENUS", "GROUPSET", "IGD", "IGD_DICT", "IGD_ENV", "IGD_HDR", "IGD_SCH", "INTCMMNTS", "INTERP", "LOC", "LOG_CURVE", "OVERLAY", "SAMPLES", "SBCHARTS", "SBSLITH", "SBSSR", "SBWLLST", "SMPDTL", "SPECIES", "SQPICK", "SURFACE", "TAXONOCC", "TXGROUP", "WELLS", "WELLSMARK"};
    static Date serverDate;

    Audit(ResultSet rs) throws SQLException {
        this.creator = rs.getInt(CREATOR);
        this.created = rs.getTimestamp(CREATED);
        this.modifier = rs.getInt(MODIFIER);
        this.modified = rs.getTimestamp(MODIFIED);
        this.updater = rs.getInt(UPDATER);
        this.updated = rs.getTimestamp(UPDATED);
        if (this.updated == null) {
            this.updated = Calendar.getInstance().getTime();
        }
    }

    Audit(ResultSet rs, String alias) throws SQLException {
        this.creator = rs.getInt(alias + CREATOR);
        this.created = rs.getTimestamp(alias + CREATED);
        this.modifier = rs.getInt(alias + MODIFIER);
        this.modified = rs.getTimestamp(alias + MODIFIED);
        this.updater = rs.getInt(alias + UPDATER);
        this.updated = rs.getTimestamp(alias + UPDATED);
    }

    Audit(Audit rhs) {
        if (rhs == null) {
            return;
        }
        this.creator = rhs.creator;
        if (rhs.created != null) {
            this.created = new Date(rhs.created.getTime());
        }
        this.modifier = rhs.modifier;
        if (rhs.modified != null) {
            this.modified = new Date(rhs.modified.getTime());
        }
        this.updater = rhs.updater;
        if (rhs.updated != null) {
            this.updated = new Date(rhs.updated.getTime());
        }
    }

    Audit(int creator, Date created, int modifier, Date modified) {
        this.creator = creator;
        this.created = created;
        this.modifier = modifier;
        this.modified = modified;
    }

    public Audit() {
    }

    static String sqlFieldString() {
        return "creator,created,modifier,modified,updater,updated";
    }

    static String sqlFieldString(String alias) {
        return alias + "." + CREATOR + " AS " + alias + CREATOR + "," + alias + "." + CREATED + " AS " + alias + CREATED + "," + alias + "." + MODIFIER + " AS " + alias + MODIFIER + "," + alias + "." + MODIFIED + " AS " + alias + MODIFIED + "," + alias + "." + UPDATER + " AS " + alias + UPDATER + "," + alias + "." + UPDATED + " AS " + alias + UPDATED;
    }

    public Audit(SBdb db, SBdb ws, Audit rhs) throws SQLException, SBException {
        if (rhs.creator > 0) {
            this.creator = Audit.getDBUserID(db, ws, rhs.creator);
        }
        this.created = rhs.created;
        if (rhs.modifier > 0) {
            this.modifier = Audit.getDBUserID(db, ws, rhs.modifier);
        }
        this.modified = rhs.modified;
    }

    static int getDBUserID(SBdb db, SBdb ws, int wsID) throws SBException, SQLException {
        int userID = 0;
        Userdef user = ws.getUser(wsID);
        if (user == null) {
            throw new SBException("No user found in workspace for user ID : " + wsID);
        }
        if (user.getLink() == null) {
            if ((user = db.getUser(user.getAbr())) != null) {
                userID = user.getUsrID();
            }
        } else {
            userID = user.getLink().getUsrID();
        }
        return userID;
    }

    public static void setServerDate(SBdb db, Statement stmt) throws SQLException {
        serverDate = stmt != null ? Audit.getDatabaseServerDate(db, stmt) : null;
    }

    String sqlInsert(SBdb db, Statement stmt) throws SQLException {
        if (this.creator == 0) {
            this.creator = db.getUserID();
        }
        if (this.created == null) {
            this.created = new Date();
        }
        if (this.modifier == 0) {
            this.modifier = db.getUserID();
        }
        if (this.modified == null) {
            this.modified = new Date();
        }
        this.updater = db.getUserID();
        this.updated = serverDate == null ? Audit.getDatabaseServerDate(db, stmt) : serverDate;
        return this.creator + ",'" + SB.DBdf.format(this.created) + "'," + this.modifier + ",'" + SB.DBdf.format(this.modified) + "'," + this.updater + ",'" + SB.DBdtf.format(this.updated) + "'";
    }

    static Date getDatabaseServerDate(SBdb db, Statement stmt) throws SQLException {
        boolean createStatement;
        if (db.dbType == SBdb.DBType.SQLITE) {
            return new Date();
        }
        String sql = "SELECT ";
        sql = db.dbType == SBdb.DBType.ORACLE ? sql + "SYSDATE AS DT FROM DUAL" : (db.dbType == SBdb.DBType.MSSQLSERVER ? sql + "getdate() as DT" : sql + "now() AS DT");
        boolean bl = createStatement = stmt == null;
        if (createStatement) {
            stmt = db.getDatabase().createStatement();
        }
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        Date date = new Date();
        if (rs.next()) {
            date = rs.getTimestamp("dt");
        }
        rs.close();
        if (createStatement) {
            stmt.close();
        }
        return date;
    }

    String sqlUpdate(SBdb db, Statement stmt, boolean preserveModification) throws SQLException {
        if (this.modifier == 0 || !preserveModification) {
            this.modifier = db.getUserID();
        }
        if (this.modified == null || !preserveModification) {
            this.modified = new Date();
        }
        this.updater = db.getUserID();
        this.updated = Audit.getDatabaseServerDate(db, stmt);
        return "modifier=" + this.modifier + ",modified='" + SB.DBdf.format(this.modified) + "'" + ",updater=" + db.getUserID() + ",updated='" + SB.DBdtf.format(this.updated) + "'";
    }

    public LinkedList<Integer> writeXML(BufferedWriter out, int indent) throws IOException {
        LinkedList<Integer> userIDList = new LinkedList<Integer>();
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write(ind + "<Audit>\n");
        if (this.created != null) {
            out.write(ind + ind + "<Created>" + SB.DBdf.format(this.created) + "</Created>\n");
        }
        if (this.creator > 0) {
            out.write(ind + ind + "<Creator>" + this.creator + "</Creator>\n");
            userIDList.add(this.creator);
        }
        if (this.modified != null) {
            out.write(ind + ind + "<Modified>" + SB.DBdf.format(this.modified) + "</Modified>\n");
        }
        if (this.modifier > 0) {
            out.write(ind + ind + "<Modifier>" + this.modifier + "</Modifier>\n");
            userIDList.add(this.modifier);
        }
        out.write(ind + "</Audit>\n");
        return userIDList;
    }

    Audit(SBdb db, Element xml) throws ParseException, SQLException, SBException {
        String strg = xml.getChildTextNormalize("Created");
        if (strg != null) {
            this.created = SB.DBdf.parse(strg);
        }
        if ((strg = xml.getChildTextNormalize("Creator")) != null) {
            this.creator = Integer.parseInt(strg);
            if (db.getUser(this.creator) == null) {
                throw new SBException("User not found for ID in Audit: " + this.creator);
            }
        }
        if ((strg = xml.getChildTextNormalize("Modified")) != null) {
            this.modified = SB.DBdf.parse(strg);
        }
        if ((strg = xml.getChildTextNormalize("Modifier")) != null) {
            this.modifier = Integer.parseInt(strg);
            if (db.getUser(this.modifier) == null) {
                throw new SBException("User not found for ID in Audit: " + this.modifier);
            }
        }
    }

    void fillWorkspace(SBdb db, SBdb ws) throws SQLException, SBException {
        assert (db.isConnected() && !ws.isConnected());
        if (this.creator > 0) {
            ws.fillUser(db, this.creator);
        }
        if (this.modifier > 0) {
            ws.fillUser(db, this.modifier);
        }
    }

    void setAnalyst(int analyst) {
        this.creator = analyst;
        this.modifier = analyst;
        this.updater = analyst;
    }

    public String toString(SBdb sbdb, boolean includeCreated) {
        String label = "";
        if (includeCreated && this.created != null) {
            label = label + "Created " + SB.df.format(this.created);
            if (this.creator > 0) {
                try {
                    label = label + " by " + sbdb.getUser(this.creator).getAbr();
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
        }
        if (!(this.modified == null || this.created != null && this.modified.equals(this.created))) {
            if (!label.isEmpty()) {
                label = label + "; ";
            }
            label = label + "Modified " + SB.df.format(this.modified);
            if (this.modifier > 0) {
                try {
                    label = label + " by " + sbdb.getUser(this.modifier).getAbr();
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
        }
        return label;
    }
}

