/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import model2.Audit;
import model2.DEXFile;
import model2.Discipline;
import model2.InterpHdr;
import model2.SBdb;
import model2.Sample;
import model2.SbugsSampleObject;
import model2.Userdef;
import model2.Well;
import model2.WellInterp;
import org.jdom.Element;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;

public class Biocom
implements SbugsStatus,
SortEntry,
SbugsSampleObject {
    private final SBdb sbdb;
    private Discipline discID;
    private int analyst;
    private String text;
    private String source;
    private Sample topSample = null;
    private Sample baseSample = null;
    private Audit audit = new Audit();
    Color status = UNKNOWN;

    static Biocom copyToWorkspace(SBdb ws, Biocom dbBiocom, Well wsWell) throws SQLException, SBException {
        if (ws.isConnected()) {
            throw new IllegalArgumentException("Attempt to copy Biocom to connected workspace");
        }
        Builder builder = Builder.copyOf(dbBiocom, ws);
        builder.audit.fillWorkspace(dbBiocom.sbdb, ws);
        builder.sample(wsWell.getSample(dbBiocom.getTopSample().getSampID()));
        if (dbBiocom.baseSample != null) {
            builder.baseSample(wsWell.getSample(dbBiocom.getBaseSample().getSampID()));
        }
        ws.fillUser(dbBiocom.sbdb, builder.analyst);
        builder.status = Biocom.STORED;
        return builder.build();
    }

    static Biocom copyToDatabase(Biocom wsBiocom, SBdb db) throws SBException, SQLException {
        if (!db.isConnected()) {
            throw new IllegalArgumentException("Attempt to copy Biocom to unconnected database");
        }
        Builder builder = Builder.copyOf(wsBiocom, db);
        builder.audit(new Audit(db, wsBiocom.sbdb, builder.audit));
        builder.sample(wsBiocom.topSample.link);
        if (builder.topSample == null) {
            throw new SBException("Biocom top sample not linked: " + wsBiocom);
        }
        if (wsBiocom.baseSample != null) {
            builder.baseSample(wsBiocom.baseSample.link);
            if (builder.baseSample == null) {
                throw new SBException("Biocom base sample not linked: " + wsBiocom);
            }
        }
        builder.analyst(wsBiocom.sbdb.getUser(wsBiocom.analyst).getLink().getUsrID());
        builder.status = Biocom.NOTSTORED;
        return builder.build();
    }

    static Biocom parseDEX(DEXFile.DEXsection section, SBdb db, Well well) throws SQLException, SBException {
        int topID = 0;
        int baseID = 0;
        int analyst = 0;
        Discipline discID = null;
        String text = "";
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (label.equalsIgnoreCase("Discipline")) {
                discID = Discipline.getDisc(value);
                continue;
            }
            if (label.equalsIgnoreCase("Sample ID")) {
                topID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Base Sample ID")) {
                baseID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Analyst")) {
                analyst = db.getAddUserID(value);
                continue;
            }
            if (!label.equalsIgnoreCase("Comment")) continue;
            if (text != null && text.length() > 0) {
                text = text + "\r\n";
                text = text + value;
                continue;
            }
            text = value;
        }
        if (analyst == 0) {
            analyst = db.getUserID();
        }
        if (text.isEmpty()) {
            return null;
        }
        Builder builder = new Builder(db, discID, analyst, well.getSample(topID), text);
        if (baseID > 0) {
            builder.baseSample(well.getSample(baseID));
        }
        return builder.build();
    }

    public String getModifierAbr() {
        if (this.sbdb == null) {
            return "" + this.audit.modifier;
        }
        try {
            return this.sbdb.getUser(this.audit.modifier).getAbr();
        }
        catch (Exception e) {
            return "Not found: " + this.audit.modifier;
        }
    }

    public String getSortEntry() {
        try {
            return this.topSample.getSortEntry() + Discipline.getChar(this.discID) + '-' + this.getAnalystString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.topSample.getSortEntry() + Discipline.getChar(this.discID) + '-' + this.getAnalyst();
        }
    }

    public Date getModified() {
        return new Date(this.audit.modified.getTime());
    }

    public Sample getTopSample() {
        return this.topSample;
    }

    public int getTopID() {
        return this.topSample.getSampID();
    }

    public int getBaseID() {
        if (this.baseSample != null) {
            return this.baseSample.getSampID();
        }
        return 0;
    }

    public Sample getBaseSample() {
        return this.baseSample;
    }

    public int getAnalyst() {
        return this.analyst;
    }

    public String getAnalystString() throws SQLException, SBException {
        if (this.analyst > 0) {
            return this.sbdb.getUser(this.analyst).getAbr();
        }
        return "" + this.analyst;
    }

    public char getDiscID() {
        return Discipline.getChar(this.discID);
    }

    public Discipline getDiscipline() {
        return this.discID;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public Biocom(Statement stmt, SBdb SB2, int wellID, int interpID, char discID, int topSample, int baseSample, int analyst, String text, String source) throws SQLException {
        this.sbdb = SB2;
        this.discID = Discipline.getDisc(discID);
        if (this.discID == null) {
            System.out.println("WARNING: no discipline found for comment: " + text + ", reset to M");
            this.discID = Discipline.MICRO;
        }
        if (baseSample == 0) {
            baseSample = topSample;
        }
        this.analyst = analyst;
        this.text = text;
        this.source = source;
        this.status = NOTSTORED;
        this.store(wellID, interpID, stmt, topSample, baseSample);
    }

    static Biocom load(SBdb sbdb, Well well, int interpID, int sampID, Discipline discID, int analystID, Biocom b) throws SQLException, SBException {
        Builder builder = new Builder(sbdb, discID, analystID, well.getSample(sampID), null);
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT lsamp_id,comments,source," + Audit.sqlFieldString();
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql = sql + " FROM " + sbdb.DBTableName("BCMMNTS") + " WHERE well_id=" + well.wellID + " AND interp_id=" + interpID + " AND usamp_id=" + sampID + " AND analyst=" + analystID + " AND disc_id='" + (Object)((Object)discID) + "'"));
        if (rs.next()) {
            int topID = sampID;
            int baseID = rs.getInt("lsamp_id");
            if (baseID == topID) {
                baseID = 0;
            }
            if (baseID > 0) {
                builder.baseSample(well.getSample(baseID));
            }
            builder.comment(rs.getString("comments"));
            builder.source(rs.getString("source"));
            builder.audit(new Audit(rs));
        }
        stmt.close();
        builder.status(STORED);
        if (b == null) {
            return builder.build();
        }
        if (b.topSample != builder.topSample || b.discID != builder.discID || b.analyst != builder.analyst) {
            throw new SBException("Attempt to copy fields to unquivalent Biocom object");
        }
        b.baseSample = builder.baseSample;
        b.text = builder.text;
        b.source = builder.source;
        b.audit = builder.audit;
        return b;
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        if (this.text == null) {
            this.text = "";
        }
        String strg = this.text.replace('\n', '/');
        strg = strg.replace('\r', '/');
        return strg;
    }

    void store(int wellID, int interpID) throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        this.store(wellID, interpID, stmt, this.topSample.getSampID(), this.baseSample != null ? Integer.valueOf(this.baseSample.getSampID()) : null);
        stmt.close();
    }

    private void store(int wellID, int interpID, Statement stmt, int topID, Integer baseID) throws SQLException {
        String sql;
        if (topID == 0 && this.topSample == null) {
            return;
        }
        if (topID == 0) {
            topID = this.topSample.getSampID();
        }
        if (baseID == null || baseID == 0) {
            baseID = this.baseSample != null ? Integer.valueOf(this.baseSample.getSampID()) : Integer.valueOf(topID);
        }
        if (this.status == PARTSTORED) {
            sql = "DELETE FROM " + this.sbdb.DBTableName("BCMMNTS") + " WHERE well_id=" + wellID + " AND usamp_id=" + topID + " AND disc_id='" + this.discID.getChar() + "'" + " AND analyst=" + this.analyst + " AND interp_id=" + interpID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            this.status = NOTSTORED;
        }
        if (this.status == NOTSTORED || this.status == PARTSTORED) {
            sql = "INSERT INTO " + this.sbdb.DBTableName("BCMMNTS") + " (well_id,usamp_id,lsamp_id,disc_id,analyst,comments,interp_id,source," + Audit.sqlFieldString();
            sql = sql + ") VALUES (" + wellID + "," + topID + "," + baseID + ",'" + this.discID.getChar() + "'" + "," + this.analyst + "," + SB.DBString((String)this.text) + "," + interpID + "," + SB.DBString((String)this.source) + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            this.status = STORED;
        }
    }

    void setText(String text) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set biocom text when database connected - use for workspace only");
        }
        this.text = text;
    }

    void update(Biocom biocom, int wellID, int interpID) throws SQLException, SQLException, SBException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        this.audit.modified = biocom.audit.modified;
        Userdef wsUser = biocom.sbdb.getUser(biocom.audit.modifier);
        if (wsUser != null && wsUser.getLink() != null) {
            this.audit.modifier = wsUser.getLink().getUsrID();
        }
        String baseSampTxt = biocom.baseSample != null && this.baseSample == null ? ",lsamp_id=" + biocom.getBaseID() : "";
        String sql = "UPDATE " + this.sbdb.DBTableName("BCMMNTS") + " SET" + " comments=" + SB.DBString((String)biocom.text) + ",source=" + SB.DBString((String)biocom.source) + baseSampTxt + "," + this.audit.sqlUpdate(this.sbdb, stmt, true) + " WHERE well_id=" + wellID + " AND usamp_id=" + this.getTopID() + " AND disc_id='" + this.discID.getChar() + "'" + " AND analyst=" + this.analyst + " AND interp_id=" + interpID;
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        this.text = biocom.text;
        this.source = biocom.source;
        this.status = STORED;
        stmt.close();
    }

    private void copyPrimitives(Biocom rhs) {
        this.discID = rhs.discID;
        this.text = rhs.text;
        this.source = rhs.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to comment deletion from well: " + wellID + ", interp: " + interpID);
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("BCMMNTS") + " WHERE well_id=" + wellID + " AND usamp_id=" + this.getTopID() + " AND disc_id='" + this.discID.getChar() + "' ";
        sql = sql + "AND analyst=" + this.analyst + " AND interp_id=" + interpID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.status = NOTSTORED;
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    void updateStatus(List comments) throws SQLException, SBException {
        this.status = NOTSTORED;
        int nzTD = (int)Math.round(100.0 * this.topSample.getDepth('M'));
        for (Biocom comment : comments) {
            int cTD;
            if (comment == this) continue;
            if (this.isFuncEquivalent(comment)) {
                this.status = STORED;
                if (!SB.DBString((String)this.text).equalsIgnoreCase(SB.DBString((String)comment.text))) {
                    String s2;
                    String s1 = SB.DBString((String)this.text);
                    this.status = s1.startsWith((s2 = SB.DBString((String)comment.text)).substring(0, s2.length() - 1)) ? PARTSTORED : CONFLICT;
                }
                if (this.source != null) {
                    if (comment.source == null) {
                        this.status = PARTSTORED;
                    } else if (!this.source.equals(comment.source)) {
                        this.status = CONFLICT;
                    }
                }
                if (this.baseSample == null || this.baseSample.isFuncEquivalent(this.topSample)) break;
                if (comment.baseSample != null) {
                    if (this.baseSample.isFuncEquivalent(comment.baseSample)) break;
                    this.status = CONFLICT;
                    break;
                }
                this.status = PARTSTORED;
                break;
            }
            if (this.discID != comment.discID || !this.getAnalystString().equals(comment.getAnalystString())) continue;
            int cBD = cTD = (int)Math.round(100.0 * comment.topSample.getDepth('M'));
            if (comment.baseSample != null) {
                cBD = (int)Math.round(100.0 * comment.baseSample.getDepth('M'));
            }
            if (nzTD == cTD && comment.topSample.getType().equals(this.topSample.getType())) {
                this.status = CONFLICT;
            }
            if (this.status != CONFLICT) continue;
            break;
        }
    }

    void writeDEX(FileWriter out, String eol) throws IOException, SBException, SQLException {
        out.write("[BIOSTRATIGRAPHIC COMMENT " + this.topSample.toString() + "]" + eol);
        out.write("Discipline = " + this.discID.getNoun() + eol);
        out.write("Sample ID = " + this.topSample.getSampID() + eol);
        if (this.baseSample != null && this.baseSample.getSampID() != this.topSample.getSampID()) {
            out.write("Base Sample ID = " + this.baseSample.getSampID() + eol);
        }
        if (this.analyst > 0) {
            out.write("Analyst = " + this.sbdb.getUser(this.analyst).getAbr() + eol);
        }
        if (this.source != null && this.source.length() > 0) {
            out.write("Source = " + this.source + eol);
        }
        StringTokenizer tok = new StringTokenizer(this.text, "\n\r");
        while (tok.hasMoreTokens()) {
            out.write("Comment = " + tok.nextToken() + eol);
        }
        out.write(eol);
    }

    LinkedList<Integer> writeXML(BufferedWriter out, int indent, char units) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write("<BiostratigraphicComment Depth=\"" + SB.getDepthString((double)this.topSample.getDepth(), (char)units, (int)2) + "\">\n");
        if (this.topSample.getSampID() > 0) {
            out.write(ind + "<TopSampleID>" + this.topSample.getSampID() + "</TopSampleID>\n");
        }
        if (this.baseSample != null && this.baseSample.getSampID() != this.topSample.getSampID()) {
            out.write(ind + "<BaseSampleID>" + this.baseSample.getSampID() + "</BaseSampleID>\n");
        }
        out.write(ind + "<DisciplineID>" + this.discID.getChar() + "</DisciplineID>\n");
        if (this.analyst > 0) {
            out.write(ind + "<Analyst>" + this.analyst + "</Analyst>\n");
            userIDs.add(this.analyst);
        }
        if (this.source != null && this.source.length() > 0) {
            out.write(ind + "<Source>" + SB.getXMLstring((String)this.source) + "</Source>\n");
        }
        StringTokenizer tok = new StringTokenizer(this.text, "\n\r");
        while (tok.hasMoreTokens()) {
            out.write(ind + "<Comment>" + SB.getXMLstring((String)tok.nextToken()) + "</Comment>\n");
        }
        userIDs.addAll(this.audit.writeXML(out, indent));
        out.write("</BiostratigraphicComment>\n");
        return userIDs;
    }

    static Biocom parse(SBdb db, Well well, Element xml, List<Integer> dataTypes) throws SQLException, SBException, ParseException {
        Element el2;
        int sampID;
        int analyst = 0;
        Sample topSample = null;
        String strg = xml.getChildTextNormalize("DisciplineID");
        if (strg == null || strg.isEmpty()) {
            throw new SBException("Discipline missing in Biostatigraphic Comment");
        }
        Discipline discID = Discipline.getDisc(strg);
        if (!dataTypes.contains(SBdb.did2comType(discID.getChar()))) {
            dataTypes.add(SBdb.did2comType(discID.getChar()));
        }
        if ((strg = xml.getChildTextNormalize("Analyst")) != null && db.getUser(analyst = Integer.parseInt(strg)) == null) {
            throw new SBException("Cannot find user ID in Biostrat Comment");
        }
        strg = xml.getChildTextNormalize("TopSampleID");
        if (strg != null && (topSample = well.getSample(sampID = Integer.parseInt(strg))) == null) {
            throw new SBException("Cannot find Top Sample in Biostrat Comment for ID: " + sampID);
        }
        Builder builder = new Builder(db, discID, analyst, topSample, "");
        strg = xml.getChildTextNormalize("BaseSampleID");
        if (strg != null) {
            int sampID2 = Integer.parseInt(strg);
            builder.baseSample(well.getSample(sampID2));
            if (builder.baseSample == null) {
                throw new SBException("Cannot find Base Sample in Biostrat Comment for ID: " + sampID2);
            }
        }
        if ((strg = xml.getChildTextNormalize("Source")) != null) {
            builder.source(strg);
        }
        String text = null;
        for (Element el2 : xml.getChildren("Comment")) {
            if (text == null) {
                text = "";
            } else if (text.length() > 0) {
                text = text + "\r\n";
            }
            if ((strg = el2.getText()) == null) continue;
            text = text + strg;
        }
        builder.comment(text);
        el2 = xml.getChild("Audit");
        if (el2 != null) {
            builder.audit(new Audit(db, el2));
        } else {
            System.out.println("Warning: no audit info for biocom: " + text);
        }
        builder.status = Biocom.NOTSTORED;
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int loadAll(SBdb SB2, HashMap<Integer, Well> wells, HashMap<Integer, InterpHdr> interpHdrs) throws SQLException {
        int nInserted = 0;
        String sql = "SELECT well_id,interp_id,usamp_id,lsamp_id,disc_id,analyst,comments,source," + Audit.sqlFieldString();
        sql = sql + " FROM " + SB2.DBTableName("BCMMNTS");
        Statement stmt = SB2.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            while (rs.next()) {
                Well well;
                int wellID = rs.getInt("well_id");
                int interpID = rs.getInt("interp_id");
                int topID = rs.getInt("usamp_id");
                int baseID = rs.getInt("lsamp_id");
                Discipline discID = Discipline.getDisc(SB.getDBChar((ResultSet)rs, (String)"disc_id"));
                if (baseID == topID) {
                    baseID = 0;
                }
                int analyst = rs.getInt("analyst");
                String text = rs.getString("comments");
                if (text == null) {
                    text = "";
                }
                if ((well = wells.get(wellID)) == null) {
                    System.out.println("Null well ID for comment: " + (Object)((Object)discID) + "," + analyst + "," + topID + "," + wellID);
                    continue;
                }
                try {
                    WellInterp interp = well.getAddInterp(interpID, interpHdrs);
                    Sample topSample = well.getSample(topID);
                    Builder builder = new Builder(SB2, discID, analyst, topSample, text);
                    builder.baseSample(well.getSample(baseID));
                    builder.source = rs.getString("source");
                    builder.audit = new Audit(rs);
                    builder.status = Biocom.STORED;
                    interp.insertBiocom(builder.build());
                    ++nInserted;
                }
                catch (SBException sbe) {
                    System.out.println("Cannot insert biocom: " + (Object)((Object)discID) + "," + analyst + "," + topID + " " + sbe.getMessage());
                }
            }
        }
        finally {
            stmt.close();
        }
        return nInserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void move(int wellID, int interpID, int newInterpID) throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit tempAudit = new Audit(this.audit);
        String sql = "UPDATE " + this.sbdb.DBTableName("BCMMNTS") + " SET" + " interp_id=" + newInterpID + "," + tempAudit.sqlUpdate(this.sbdb, stmt, true) + " WHERE well_id=" + wellID + " AND usamp_id=" + this.getTopID() + " AND interp_id=" + interpID;
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.audit = tempAudit;
    }

    boolean mergeSamples(Sample donor, Sample target) {
        boolean hasChanged = false;
        if (this.topSample == donor) {
            this.topSample = target;
            hasChanged = true;
        }
        if (this.baseSample == donor) {
            this.baseSample = target;
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean isFuncEquivalent(SortEntry e) throws SQLException, SBException {
        if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
            return true;
        }
        if (e instanceof Biocom) {
            Biocom comp = (Biocom)e;
            if (this.topSample.isFuncEquivalent(comp.topSample) && this.discID == comp.getDiscipline() && this.getAnalystString().equals(comp.getAnalystString())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Sample getSample() {
        return this.getTopSample();
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for biocom: " + this);
        }
        this.analyst = analyst.getUsrID();
        this.audit.setAnalyst(analyst.getUsrID());
    }

    private Biocom(Builder builder) {
        this.sbdb = builder.sbdb;
        this.discID = builder.discID;
        this.analyst = builder.analyst;
        this.topSample = builder.topSample;
        this.text = builder.text;
        this.source = builder.source;
        this.baseSample = builder.baseSample;
        this.audit = builder.audit;
        this.status = builder.status;
    }

    public static class Builder {
        private final SBdb sbdb;
        private final Discipline discID;
        private int analyst;
        private Sample topSample;
        private String text;
        private String source;
        private Sample baseSample = null;
        private Audit audit = new Audit();
        private Color status = SbugsStatus.UNKNOWN;

        public Builder(SBdb sbdb, Discipline discID, int analyst, Sample topSample, String text) {
            this.sbdb = sbdb;
            this.discID = discID;
            this.analyst = analyst;
            this.topSample = topSample;
            this.text = text;
        }

        public static Builder copyOf(Biocom biocom, SBdb sbdb) {
            Builder builder = new Builder(sbdb, biocom.discID, biocom.analyst, biocom.topSample, biocom.text);
            builder.source(biocom.source).baseSample(biocom.baseSample);
            builder.audit = new Audit(biocom.audit);
            return builder;
        }

        public final Builder analyst(int analyst) {
            this.analyst = analyst;
            return this;
        }

        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Builder sample(Sample sample) {
            this.topSample = sample;
            return this;
        }

        public final Builder baseSample(Sample baseSample) {
            this.baseSample = baseSample;
            return this;
        }

        public final Builder audit(Audit audit) {
            this.audit = audit;
            return this;
        }

        public final Builder status(Color status) {
            this.status = status;
            return this;
        }

        final Builder comment(String comment) {
            this.text = comment;
            return this;
        }

        Biocom build() {
            return this.build(0);
        }

        private Biocom build(int topSampID) {
            if (this.sbdb == null) {
                throw new IllegalStateException("Attempt to build Biocom with null data model");
            }
            if (this.text == null || this.text.isEmpty()) {
                System.out.println("WARNING: building Biocom with no comment");
                this.text = "";
            }
            if (this.discID == null) {
                throw new IllegalStateException("Attempt to build Biocom with no discipline");
            }
            if (this.analyst == 0) {
                throw new IllegalStateException("Attempt to build Biocom with no analyst");
            }
            if (this.topSample == null && topSampID == 0) {
                throw new IllegalStateException("Attempt to build Biocom with no sample");
            }
            if (this.status == SbugsStatus.UNKNOWN) {
                this.status = SbugsStatus.NOTSTORED;
            }
            return new Biocom(this);
        }

        Biocom build(int wellID, int interpID, Statement stmt) throws SQLException {
            assert (this.sbdb.getDatabase() != null);
            Biocom comment = this.build();
            comment.status = SbugsStatus.NOTSTORED;
            if (stmt == null) {
                stmt = this.sbdb.getDatabase().createStatement();
            }
            comment.store(wellID, interpID, stmt, comment.topSample.getSampID(), comment.baseSample != null ? Integer.valueOf(comment.baseSample.getSampID()) : null);
            return comment;
        }

        public static void conversionStore(SBdb sbdb, char discID, int topSampleID, int baseSampleID, int analyst, String text, String source, int wellID, int interpID, Statement stmt) throws SQLException, SBException {
            Biocom b = new Builder(sbdb, Discipline.getDisc(discID), analyst, null, text).source(source).build(topSampleID);
            b.store(wellID, interpID, stmt, topSampleID, baseSampleID);
        }

        public int getAnalyst() {
            return this.analyst;
        }

        public char getDiscID() {
            return this.discID.getChar();
        }

        public Discipline getDiscipline() {
            return this.discID;
        }

        public Sample getTopSample() {
            return this.topSample;
        }
    }
}

