/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import model2.AnalystHeader;
import model2.Audit;
import model2.Biocom;
import model2.Discipline;
import model2.EnvScheme;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Userdef;
import model2.Well;
import model2.WellHeader;
import model2.WsWell;
import util.InvalidFieldException;
import util.MergeStatus;
import util.SB;
import util.SBException;

public final class BugWareReader {
    List dataTypes;
    String dataSource;
    char discID;
    char units;
    EnvScheme envScheme;
    int waterDepthUpper = 0;
    int waterDepthLower = 0;
    int topWaterDepthProx = 0;
    int topWaterDepthDist = 0;
    int baseWaterDepthProx = 0;
    int baseWaterDepthDist = 0;
    Sample envSample = null;
    Sample topEnvSample = null;
    Sample baseEnvSample = null;
    boolean useBiostratComments;
    boolean ignoreSemiQuant;
    SBdb ws;
    int specID = 1;
    SourceDetails sourceDetails = new SourceDetails();

    public BugWareReader(SBdb ws, String fileName, List dataTypes, char discID, char units, Userdef analyst, boolean useBiostratComments, boolean ignoreSemiQuant, boolean useSampleTops) throws SBException, SQLException {
        this.dataTypes = dataTypes;
        this.discID = discID;
        this.units = units;
        this.useBiostratComments = useBiostratComments;
        this.ignoreSemiQuant = ignoreSemiQuant;
        this.sourceDetails.analystID = ws.getAddUserID(analyst.getAbr());
        Userdef wsAnalyst = ws.getUser(this.sourceDetails.analystID);
        wsAnalyst.setLink(analyst);
        this.ws = ws;
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            try {
                String buff = in.readLine();
                if (!buff.substring(0, 7).equals("BUGWARE")) {
                    throw new SBException("Not a BugWare format file");
                }
                WsWell well = new WsWell(ws, fileName);
                String wellCode = fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1, fileName.lastIndexOf(46));
                well.getHeader().setWellName(wellCode);
                well.getHeader().setWellCode(Well.makeCode(wellCode));
                well.getHeader().setWellUnits(units);
                if (this.envScheme == null) {
                    this.envScheme = new EnvScheme(ws, 1, "BugWare Scheme");
                    ws.addEnvScheme(this.envScheme);
                }
                AnalystHeader analyHdr = well.getAnalystHeader(analyst.getAbr(), discID, 1, true);
                analyHdr.setEnvScheme(this.envScheme.getID());
                well.getSamples();
                buff = this.parseWell(in, this.sourceDetails, well, useSampleTops);
                buff = "";
                while (buff != null && !buff.startsWith(" @@@@")) {
                    buff = this.parseSample(discID, in, this.sourceDetails, well, analyHdr, useSampleTops);
                }
                if (well.getSamples().size() > 0) {
                    well.getHeader().setTD(well.getSamples().get(well.getSamples().size() - 1).getDepth('M'));
                }
                well.updateStatus(dataTypes);
                ws.getProject(0).addWell(well);
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
            in.close();
        }
        catch (Exception fnf) {
            JOptionPane.showMessageDialog(null, "Can't open file for some reason - sorry");
            return;
        }
    }

    String parseWell(BufferedReader in, SourceDetails sourceDetails, Well well, boolean useSampleTops) throws IOException, SBException {
        String buff = in.readLine();
        WellHeader header = well.getHeader();
        header.setWellUnits(this.units);
        SimpleDateFormat df1 = new SimpleDateFormat("M,y");
        SimpleDateFormat df2 = new SimpleDateFormat("mm/dd/yy");
        sourceDetails.analysisDate = new Date();
        while (buff != null && !buff.startsWith(" @@@@")) {
            if ((buff = buff.trim()).indexOf(58) > 0) {
                String value = buff.substring(buff.lastIndexOf(58) + 1).trim();
                if (buff.startsWith("API:")) {
                    header.setWellCode(value);
                } else if (buff.startsWith("AREA")) {
                    header.setWellName(value);
                } else if (buff.startsWith("BLOCK")) {
                    header.setWellName(header.getWellName() + " " + value);
                } else if (buff.startsWith("OCS")) {
                    header.setOCS(value);
                } else if (buff.startsWith("WELL NUMBER")) {
                    header.setWellName(header.getWellName() + "-" + value);
                } else if (buff.startsWith("OPERATOR")) {
                    header.setOper(value);
                } else if (buff.startsWith("LAST SAMPLE")) {
                    if (value != null && value.length() != 0) {
                        Sample sample = new Sample(this.ws, well.getHeader().getType());
                        sample.parseDepthString(value.trim(), this.units, false, useSampleTops);
                        header.setTD(SB.convToM((double)sample.getDepth(), (char)this.units));
                    }
                } else if (buff.startsWith("PALEONTOLOGIST")) {
                    sourceDetails.analystName = value;
                } else if (buff.startsWith("SOURCE")) {
                    sourceDetails.sourceName = value;
                } else if (buff.startsWith("DATE")) {
                    try {
                        sourceDetails.analysisDate = df1.parse(value);
                    }
                    catch (ParseException ex) {
                        try {
                            sourceDetails.analysisDate = df2.parse(value);
                        }
                        catch (ParseException ex1) {
                            // empty catch block
                        }
                    }
                }
            }
            buff = in.readLine();
        }
        return buff;
    }

    String parseSample(char discID, BufferedReader in, SourceDetails sourceDetails, Well well, AnalystHeader analyHdr, boolean useSampleTops) throws IOException, SBException, SQLException {
        String buff = in.readLine();
        Sample sample = null;
        Biocom biocom = null;
        Biocom lithcom = null;
        Smpdtl smpdtl = null;
        LinkedList<String> markerList = new LinkedList<String>();
        try {
            while (buff != null) {
                buff = buff.trim();
                System.out.println(buff);
                if (buff.length() > 0) {
                    if (buff.startsWith("@@@@")) break;
                    char recType = buff.charAt(0);
                    buff = buff.substring(1);
                    switch (recType) {
                        case '.': {
                            return buff;
                        }
                        case '@': {
                            sample = new Sample(this.ws, well.getHeader().getType());
                            sample.setType("CU");
                            sample.parseDepthString(buff, this.units, false, useSampleTops);
                            sample.displayUnits = this.units;
                            Audit audit = new Audit(analyHdr.getAnalystUsrid(), sourceDetails.analysisDate, analyHdr.getAnalystUsrid(), sourceDetails.analysisDate);
                            smpdtl = new Smpdtl(this.ws, sample, analyHdr, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, audit, Smpdtl.AnalysisType.ANALYSED);
                            sample.insert(smpdtl);
                            Sample.insert(well.getSamples(), sample, this.units);
                            if (sample.getBaseDepth('M') > well.getTD()) {
                                well.getHeader().setTD(sample.getBaseDepth('M'));
                            }
                            markerList.clear();
                            break;
                        }
                        case '!': {
                            if (sample == null) {
                                throw new SBException("Biostratigraphic comment lies outside sample: " + buff);
                            }
                            if (this.useBiostratComments) {
                                if (biocom == null || biocom.getTopID() != sample.getSampID()) {
                                    biocom = new Biocom.Builder(this.ws, Discipline.getDisc(discID), analyHdr.getAnalystUsrid(), sample, buff.trim()).build();
                                    well.getAddInterp(this.ws.getInterp(0)).insertBiocom(biocom);
                                    this.addDataType(SBdb.did2comType(discID));
                                } else {
                                    biocom.setText(biocom.getText() + '\n' + buff.trim());
                                }
                                if (biocom.getText().length() <= 240) break;
                                biocom.setText(biocom.getText().substring(0, 240));
                                System.out.println("Biostratigraphic Comments truncated");
                                break;
                            }
                            if (smpdtl == null) {
                                throw new SBException("Sample record for comment blank in sample: " + (sample != null ? sample.toString() : "") + " Line: " + buff);
                            }
                            buff = buff.trim();
                            if (smpdtl.getNotes() != null && smpdtl.getNotes().length() > 0) {
                                smpdtl.appendNote("\n");
                            }
                            smpdtl.appendNote(buff);
                            break;
                        }
                        case '$': {
                            if (sample == null) {
                                throw new SBException("Biostratigraphic comment lies outside sample: " + buff);
                            }
                            if (this.useBiostratComments) {
                                try {
                                    if (lithcom == null || lithcom.getTopID() != sample.getSampID()) {
                                        lithcom = new Biocom.Builder(this.ws, Discipline.MACRO, analyHdr.getAnalystUsrid(), sample, buff.trim()).build();
                                        well.getAddInterp(this.ws.getInterp(0)).insertBiocom(lithcom);
                                        this.addDataType(SBdb.did2comType('A'));
                                    } else {
                                        well.getAddInterp(this.ws.getInterp(0)).updateBiocom(biocom, well.getWellID(), Discipline.MACRO, sample, null, analyHdr.getAnalyst(), null, lithcom.getText() + " " + buff.trim());
                                    }
                                    if (lithcom.getText().length() <= 240) break;
                                    well.getAddInterp(this.ws.getInterp(0)).updateBiocom(biocom, well.getWellID(), Discipline.MACRO, sample, null, analyHdr.getAnalyst(), null, lithcom.getText().substring(0, 240));
                                    System.out.println("Biostratigraphic Comments truncated");
                                }
                                catch (InvalidFieldException e) {
                                    System.out.println(e.getMessage());
                                }
                                break;
                            }
                            if (smpdtl == null) {
                                throw new SBException("Sample record for comment blank in sample: " + (sample != null ? sample.toString() : "") + " Line: " + buff);
                            }
                            buff = buff.trim();
                            if (smpdtl.getNotes() != null && smpdtl.getNotes().length() > 0) {
                                smpdtl.appendNote("\n");
                            }
                            smpdtl.appendNote(buff);
                            break;
                        }
                        case '&': 
                        case '(': 
                        case '*': 
                        case ';': {
                            if (smpdtl == null) {
                                throw new SBException("Cannot read file correctly - Sample record blank in sample: " + (sample != null ? sample.toString() : "") + " Line: " + buff);
                            }
                            buff = buff.trim();
                            if (smpdtl.getNotes() != null && smpdtl.getNotes().length() > 0) {
                                smpdtl.appendNote("\n");
                            }
                            smpdtl.appendNote(buff);
                            break;
                        }
                        case ')': {
                            int index;
                            if (this.envScheme == null || buff.indexOf(45) <= 0 || buff.length() <= buff.indexOf(45) + 2) break;
                            String term = buff.substring(buff.indexOf(45) + 2);
                            try {
                                index = this.envScheme.getTermIndex(term);
                            }
                            catch (SBException sbe) {
                                index = this.envScheme.getNClasses();
                                this.envScheme.addRow();
                                this.envScheme.setTerm(index + 1, term);
                            }
                            if (smpdtl == null) {
                                throw new SBException("Cannot read file correctly - Sample record blank in sample: " + (sample != null ? sample.toString() : "") + " Line: " + buff);
                            }
                            smpdtl.setProximal(index);
                            smpdtl.setDistal(index);
                            break;
                        }
                        case '+': 
                        case '/': {
                            if (buff.length() > 32) {
                                markerList.add(buff.substring(0, 32).trim());
                                break;
                            }
                            markerList.add(buff.trim());
                            break;
                        }
                        case '-': 
                        case '=': {
                            if (smpdtl == null) {
                                if (sample == null) {
                                    throw new SBException("Cannot read file correctly - invalid sample around line: " + buff);
                                }
                                throw new SBException("Cannot read file correctly - Sample record blank in sample: " + sample.toString());
                            }
                            Taxon taxonRef = this.parseTaxon(buff.substring(0, 32).trim());
                            String comment = buff.substring(32, 42).trim();
                            boolean rw = false;
                            boolean cv = false;
                            String subjAbundString = buff.substring(32, 42).trim();
                            String subjAbund = "";
                            if (subjAbundString.equalsIgnoreCase("REWORKED")) {
                                rw = true;
                            } else if (subjAbundString.equalsIgnoreCase("REWORK")) {
                                rw = true;
                            } else if (subjAbundString.equalsIgnoreCase("RWK")) {
                                rw = true;
                            } else if (subjAbundString.equalsIgnoreCase("RW")) {
                                rw = true;
                            } else if (subjAbundString.equalsIgnoreCase("CAVE")) {
                                rw = true;
                            } else if (subjAbundString.equalsIgnoreCase("CAVING")) {
                                cv = true;
                            } else if (subjAbundString.equalsIgnoreCase("CV")) {
                                cv = true;
                            } else if (!this.ignoreSemiQuant) {
                                subjAbund = subjAbundString;
                            }
                            int ind = 0;
                            ind = buff.indexOf(91);
                            if (ind < 0 || buff.indexOf(93) < ind) {
                                throw new SBException("(Check abundance bracketing in line:\n \"" + buff + "\" ");
                            }
                            int counts = Integer.parseInt(buff.substring(buff.indexOf(91) + 1, buff.indexOf(93)).trim());
                            if (counts == 0) {
                                throw new SBException("Counts for taxon: " + taxonRef.toString() + " are zero in sample: " + sample.toString());
                            }
                            boolean marker = false;
                            for (String markerName : markerList) {
                                if (!markerName.equalsIgnoreCase(taxonRef.donorString)) continue;
                                marker = true;
                                break;
                            }
                            TaxonOcc.Builder builder = new TaxonOcc.Builder(this.ws, taxonRef, rw, false, 0);
                            builder = builder.count(counts).subjAbund(subjAbund).marker(marker).caved(cv).comment(comment);
                            try {
                                smpdtl.insertOccurrence(builder, well.getWellID(), false);
                            }
                            catch (SBException ex) {
                                throw new SBException(ex.getMessage() + " in Sample: " + sample.toString());
                            }
                            sample.status = MergeStatus.merge((Color)sample.status, (Color)smpdtl.status);
                            this.addDataType(1);
                            this.addDataType(SBdb.did2dtype(smpdtl.getDiscID()));
                            well.useDonorTaxa = true;
                            well.useDonorSamples = true;
                            break;
                        }
                    }
                }
                buff = in.readLine();
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new SBException("at line: " + buff + "\nError message: " + ex.toString());
        }
        return buff;
    }

    Taxon parseTaxon(String strg) {
        Taxon t = this.ws.getTaxon(strg, this.specID, true);
        if (t.getSpecID() == this.specID) {
            ++this.specID;
        }
        return t;
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
    }

    static void scanForEnvs(String fileName, List envs) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            try {
                String buff = in.readLine();
                if (!buff.substring(0, 7).equals("BUGWARE")) {
                    throw new SBException("Not a BugWare format file");
                }
                while (buff != null) {
                    if (buff.length() > 0 && buff.charAt(0) == ')' && !envs.contains(buff.substring(1).trim())) {
                        envs.add(buff.substring(1).trim());
                    }
                    buff = in.readLine();
                }
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
            in.close();
        }
        catch (Exception fnf) {
            JOptionPane.showMessageDialog(null, "Can't open file for some reason - sorry");
            return;
        }
    }

    class SourceDetails {
        String analystName;
        String sourceName;
        Date analysisDate;
        int analystID;

        SourceDetails() {
        }
    }
}

