/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.File;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import model2.AnalystHeader;
import model2.Audit;
import model2.Biocom;
import model2.Discipline;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Well;
import model2.WsWell;
import util.CSVGridReader;
import util.GridReader;
import util.SB;
import util.SBException;

public class CSVReader {
    private final List dataTypes;
    public final HashSet<String> rejects = new HashSet();
    boolean setEmptyAsBarren;
    GridReader in;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSVReader(SBdb db, GridReader in, List dataTypes, char discID, char units, String analyst, int titleRow, int catRow, int dataRow, int topColumn, int baseColumn, int typeColumn, int analystColumn, int commentsColumn, int labelColumn, int taxaColumn, int taxaColumnEnd, boolean useBioComments, boolean isWell, boolean setEmptyAsBarren, String sampleType) throws SBException, SQLException {
        this.in = in;
        this.dataTypes = dataTypes;
        this.setEmptyAsBarren = setEmptyAsBarren;
        if (db.getProject(0).getSize() == 0) {
            dataTypes.clear();
        }
        String fileName = in.getFileName();
        WsWell well = new WsWell(db, fileName);
        String wellCode = fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1, fileName.lastIndexOf(46));
        well.getHeader().setWellName(wellCode);
        well.getHeader().setWellCode(Well.makeCode(wellCode));
        well.getHeader().setWellUnits(units);
        if (!isWell) {
            well.getHeader().setType('O');
        }
        well.getSamples();
        try {
            dataTypes.clear();
            int nRow = 0;
            while (in.nextRow()) {
                if (nRow == titleRow) {
                    this.parseTitles(db, taxaColumn);
                } else if (nRow == catRow) {
                    this.parseCategories(db, taxaColumn);
                } else if (nRow >= dataRow) {
                    String strg;
                    Double topDepth = null;
                    Double baseDepth = null;
                    String type = sampleType;
                    String label = "";
                    Sample sample = null;
                    Smpdtl smpdtl = null;
                    String comment = null;
                    char sampleUnits = units;
                    int col = 0;
                    while ((strg = in.getNextCell()) != null) {
                        if (!strg.isEmpty()) {
                            if ((col == topColumn || col == baseColumn) && strg.indexOf("-") > 0) {
                                topDepth = SB.parseDepthString((String)strg.substring(0, strg.indexOf("-")));
                                baseDepth = SB.parseDepthString((String)strg.substring(strg.indexOf("-") + 1, strg.length()));
                                if (topColumn == -1) {
                                    topColumn = baseColumn;
                                } else if (baseColumn == -1) {
                                    baseColumn = topColumn;
                                }
                                if (SB.parseDepthUnitsFromString((String)strg) == 'F' && units == 'F') {
                                    sampleUnits = 'M';
                                }
                            } else if (col == topColumn) {
                                if (strg.length() > 0) {
                                    topDepth = SB.parseDepthString((String)strg);
                                    if (SB.parseDepthUnitsFromString((String)strg) == 'F' && units == 'F') {
                                        sampleUnits = 'M';
                                    }
                                }
                            } else if (col == baseColumn) {
                                if (strg.length() > 0) {
                                    baseDepth = SB.parseDepthString((String)strg);
                                    if (SB.parseDepthUnitsFromString((String)strg) == 'F' && units == 'F') {
                                        sampleUnits = 'M';
                                    }
                                }
                            } else if (col == typeColumn) {
                                type = strg;
                            } else if (col == analystColumn) {
                                analyst = strg;
                            } else if (col == commentsColumn) {
                                comment = strg;
                            } else if (col == labelColumn) {
                                label = strg;
                            } else if (!strg.isEmpty() && col >= taxaColumn && col <= taxaColumnEnd) {
                                Taxon taxon;
                                if (topDepth == null && baseDepth == null) {
                                    System.out.println("CSV Reader: Skipping row: " + nRow);
                                    break;
                                }
                                if (smpdtl == null) {
                                    if (sample == null) {
                                        sample = this.getSample(db, well, sampleUnits, discID, topDepth, baseDepth, type, label, units);
                                    }
                                    smpdtl = this.getSmpdtl(db, well, sample, analyst, discID);
                                }
                                if ((taxon = db.getTaxon(col)) == null) {
                                    throw new SBException("Error: Taxon name is blank for column: " + col + ", but data column is not blank.");
                                }
                                TaxonOcc.Builder builder = TaxonOcc.Builder.parseOcc(db, taxon, strg, this.rejects);
                                if (builder != null) {
                                    smpdtl.insertOccurrence(builder, well.getWellID(), false);
                                }
                            }
                        }
                        ++col;
                    }
                    if (smpdtl == null && (topDepth != null || baseDepth != null)) {
                        if (sample == null) {
                            sample = this.getSample(db, well, sampleUnits, discID, topDepth, baseDepth, type, label, units);
                        }
                        smpdtl = this.getSmpdtl(db, well, sample, analyst, discID);
                    }
                    if (comment != null) {
                        if (topDepth == null && baseDepth == null) {
                            System.out.println("CSV Reader: Skipping comment for row: " + nRow);
                            break;
                        }
                        if (useBioComments) {
                            Biocom biocom = new Biocom.Builder(db, Discipline.getDisc(discID), db.getUserID(analyst), sample, comment).build();
                            well.getAddInterp(db.getInterp(0)).insertBiocom(biocom);
                            this.addDataType(SBdb.did2comType(discID));
                        } else {
                            smpdtl.appendNote(comment);
                        }
                    }
                }
                ++nRow;
            }
            this.addDataType(SBdb.did2dtype(discID));
            well.updateStatus(dataTypes);
            db.getProject(0).addWell(well);
        }
        finally {
            in.close();
        }
    }

    private Sample getSample(SBdb db, Well well, char sampleUnits, char discID, Double topDepth, Double baseDepth, String type, String label, char wellUnits) throws SBException, SQLException {
        if (topDepth == null && baseDepth == null) {
            return null;
        }
        Sample.SampleType stype = Sample.SampleType.parseType(type);
        if (stype == null) {
            throw new IllegalArgumentException("Cannot parse sample type: " + type);
        }
        Sample sample = well.getSample(topDepth, baseDepth, stype.toString(), false);
        if (sample == null) {
            sample = new Sample(db, well.getType());
            if (topDepth != null) {
                sample.setTopDepth(topDepth, sampleUnits);
            }
            if (baseDepth != null) {
                sample.setBaseDepth(baseDepth, sampleUnits);
            }
            sample.parseType(type);
            if (label != null) {
                sample.setLabel(label);
            }
            Sample.insert(well.getSamples(), sample, wellUnits);
        }
        if (sample.getDepth() == 0.0) {
            throw new SBException("zero sample depth found");
        }
        return sample;
    }

    private Smpdtl getSmpdtl(SBdb db, WsWell well, Sample sample, String analyst, char discID) throws SBException, SQLException {
        AnalystHeader header = well.getAnalystHeader(analyst, discID, 1, true);
        Smpdtl smpdtl = sample.getSmpdtl(header.getAnalyID());
        if (smpdtl == null) {
            smpdtl = new Smpdtl(db, sample, header, null, null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), this.setEmptyAsBarren ? Smpdtl.AnalysisType.BARREN : Smpdtl.AnalysisType.PREPARED);
            sample.addDtl(smpdtl);
        }
        return smpdtl;
    }

    private void parseTitles(SBdb db, int taxaColumn) throws SBException, SQLException {
        String strg;
        if (taxaColumn < 0) {
            return;
        }
        int col = 0;
        while ((strg = this.in.getNextCell()) != null) {
            if (!strg.isEmpty()) {
                if (this.in instanceof CSVGridReader && strg.charAt(0) == '\"' && !strg.substring(1).contains("\"")) {
                    throw new SBException("Quotation chars found on input line");
                }
                if (col >= taxaColumn) {
                    Taxon temp = db.getTaxon(col);
                    String taxonName = SB.removeExcelQuotes((String)strg);
                    if (temp != null) {
                        if (!taxonName.equals(temp.toString())) {
                            throw new SBException("Attempt to read mismatching spreadsheet files into same workspace");
                        }
                    } else {
                        db.getTaxon(taxonName, col, true);
                    }
                }
            }
            ++col;
        }
    }

    private void parseCategories(SBdb db, int taxaColumn) throws SBException, SQLException {
        String strg;
        if (taxaColumn < 0) {
            return;
        }
        int col = 0;
        while ((strg = this.in.getNextCell()) != null) {
            if (!strg.isEmpty() && col >= taxaColumn) {
                Taxon taxon = db.getTaxon(col);
                if (taxon == null) {
                    throw new SBException("Error: Taxon name is blank (or duplicated) for column: " + (col + 1) + ", but category is not blank");
                }
                db.setTaxonCat(taxon.getSpecID(), strg);
            }
            ++col;
        }
    }

    private void addDataType(int dType) {
        if (!this.dataTypes.contains(dType)) {
            this.dataTypes.add(dType);
        }
    }
}

