/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import model2.CasingPoint;
import model2.SBdb;
import util.SB;
import util.SBException;

public class Casing
extends Observable {
    private final SBdb sbdb;
    private final List<CasingPoint> casing = new ArrayList<CasingPoint>();

    public List<CasingPoint> getList() {
        return this.casing;
    }

    public Casing(SBdb SB2) {
        this.sbdb = SB2;
    }

    public int getSize() {
        return this.casing.size();
    }

    void clear() {
        this.casing.clear();
    }

    public SBdb getDataModel() {
        return this.sbdb;
    }

    public CasingPoint getCasingPoint(int row) {
        return this.casing.get(row);
    }

    public boolean add(CasingPoint casingPoint) throws SBException {
        this.casing.add(this.checkOverlap(casingPoint), casingPoint);
        this.setChanged();
        return true;
    }

    public int checkOverlap(CasingPoint casingPoint) throws SBException {
        Iterator<CasingPoint> it = this.casing.iterator();
        int insertPoint = 0;
        int lastDiamIndex = -1;
        int diamIndex = -1;
        try {
            diamIndex = this.sbdb.getCasingDiameters().indexOf(casingPoint.getDiameter());
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        int nzD = (int)(casingPoint.getDepth() * 100.0);
        while (it.hasNext()) {
            CasingPoint compareWith = it.next();
            try {
                lastDiamIndex = this.sbdb.getCasingDiameters().indexOf(compareWith.getDiameter());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            if (compareWith != casingPoint) {
                int cD = (int)(compareWith.getDepth() * 100.0);
                if (nzD == cD) {
                    throw new SBException("Casing point depth already exists: " + casingPoint.toString());
                }
                if (nzD < cD) {
                    if (diamIndex <= lastDiamIndex) break;
                    throw new SBException("Casing point not in descending diameter" + casingPoint);
                }
                ++insertPoint;
                continue;
            }
            return -1;
        }
        return insertPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(int wellID) throws SQLException {
        this.casing.clear();
        String sql = "SELECT depth, diam FROM " + this.sbdb.DBTableName("casing") + " WHERE well_id=" + wellID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                double depth = rs.getDouble("depth");
                String diam = rs.getString("diam");
                CasingPoint casingPoint = new CasingPoint(depth, diam);
                casingPoint.status = CasingPoint.STORED;
                try {
                    this.add(casingPoint);
                }
                catch (SBException e) {
                    System.out.println("Error adding casing point: " + e.getMessage());
                }
            }
        }
        finally {
            stmt.close();
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromView(SBdb db, String wellCode) throws SQLException {
        this.casing.clear();
        String sql = "SELECT depth, diam FROM " + this.sbdb.DBTableName("CASING_CDS") + " WHERE well_code=" + SB.DBString((String)wellCode);
        Statement stmt = db.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                double depth = rs.getDouble("depth");
                String diam = rs.getString("diam");
                CasingPoint casingPoint = new CasingPoint(depth, diam);
                try {
                    this.add(casingPoint);
                }
                catch (SBException e) {
                    System.out.println("Error adding casing point: " + e.getMessage());
                }
            }
        }
        finally {
            stmt.close();
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.sbdb.DBTableName("casing") + " WHERE well_id=" + wellID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int wellID, CasingPoint point) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            String sql = "DELETE FROM " + this.sbdb.DBTableName("casing") + " WHERE well_id=" + wellID + " AND depth > " + (point.getDepth() - 0.01) + " AND depth < " + (point.getDepth() + 0.01);
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                int nRows = stmt.executeUpdate(this.sbdb.modQuery(sql));
                if (nRows < 1) {
                    throw new SBException("Failed to delete casing point at depth: " + point.getDepth());
                }
            }
            finally {
                stmt.close();
            }
        }
        this.casing.remove(point);
        this.setChanged();
    }

    void setIntervalStatus(Color status) {
        Iterator<CasingPoint> it = this.casing.iterator();
        while (it.hasNext()) {
            it.next().status = status;
        }
    }

    public void store(int wellID) throws SQLException {
        Iterator<CasingPoint> it = this.casing.iterator();
        boolean refresh = false;
        while (it.hasNext()) {
            if (it.next().status != CasingPoint.NOTSTORED) continue;
            refresh = true;
            break;
        }
        if (!refresh) {
            return;
        }
        this.deleteAll(wellID);
        for (CasingPoint point : this.casing) {
            point.status = CasingPoint.NOTSTORED;
            point.store(this.sbdb, wellID);
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        Iterator<CasingPoint> it = this.casing.iterator();
        while (it.hasNext()) {
            it.next().writeDEX(out, eol, units);
        }
    }

    void writeXML(BufferedWriter out, int ind, char units) throws IOException {
        Iterator<CasingPoint> it = this.casing.iterator();
        while (it.hasNext()) {
            it.next().writeXML(out, ind, units);
        }
    }
}

