/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.TreeMap;
import javax.swing.JComboBox;
import model2.Category;
import model2.Discipline;
import model2.SBdb;
import util.SB;
import util.SBException;

public class Categories
extends Observable {
    TreeMap<String, Category> cats = new TreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Categories(SBdb sbdb) throws SQLException {
        if (sbdb != null && sbdb.isConnected()) {
            String sql = "SELECT disc_id, cat_mnem, cat_name from " + sbdb.DBTableName("category") + " ORDER BY cat_mnem";
            Statement stmt = sbdb.getDatabase().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                while (rs.next()) {
                    Discipline discID = Discipline.getDisc(SB.getDBChar((ResultSet)rs, (String)"disc_id"));
                    String mnem = rs.getString("cat_mnem");
                    if (mnem == null) continue;
                    mnem = mnem.trim();
                    String name = rs.getString("cat_name");
                    if (name.length() > 1) {
                        boolean hasMixedCase = false;
                        for (char c : name.toCharArray()) {
                            if (!Character.isLowerCase(c)) continue;
                            hasMixedCase = true;
                            break;
                        }
                        if (!hasMixedCase) {
                            String temp = "";
                            temp = temp + name.charAt(0);
                            name = name.toLowerCase();
                            name = temp = temp + name.substring(1).trim();
                        }
                    }
                    Category cat = new Category(discID, mnem, name);
                    this.cats.put(cat.getMnem(), cat);
                }
            }
            finally {
                stmt.close();
            }
            this.loadColours(sbdb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColours(SBdb sbdb) throws SQLException {
        PreparedStatement pStmt = sbdb.getDatabase().prepareStatement(sbdb.modQuery("SELECT red,green,blue FROM " + sbdb.DBTableName("CATCOL") + " WHERE ABR=?"));
        Iterator<Category> it = this.cats.values().iterator();
        try {
            while (it.hasNext()) {
                Category cat = it.next();
                pStmt.setString(1, cat.getMnem());
                ResultSet rs = pStmt.executeQuery();
                if (!rs.next()) continue;
                cat.setColour(new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue")));
            }
        }
        finally {
            pStmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Category add(SBdb sbdb, String mnem, Discipline discID, String name, Color colour) throws SQLException {
        if (sbdb != null && sbdb.isConnected()) {
            String sql = "INSERT INTO " + sbdb.DBTableName("category") + " (disc_id, cat_mnem, cat_name) VALUES (";
            sql = sql + SB.DBChar((char)Discipline.getChar(discID)) + "," + SB.DBString((String)mnem) + "," + SB.DBString((String)name) + ")";
            Statement stmt = sbdb.getDatabase().createStatement();
            try {
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
            finally {
                stmt.close();
            }
        }
        Category cat = new Category(discID, mnem, name);
        if (colour != null) {
            cat.setColour(colour);
            if (sbdb != null && sbdb.isConnected()) {
                cat.storeColour(sbdb);
            }
        }
        this.cats.put(cat.getMnem(), cat);
        this.setChanged();
        return cat;
    }

    public void delete(SBdb db, Category cat) throws SBException, SQLException {
        if (cat.getNGenera() > 0) {
            throw new SBException("Attempt to delete category containing genera");
        }
        cat.delete(db);
        this.cats.remove(cat.getMnem());
        this.setChanged();
        this.notifyObservers();
    }

    public Category getCategory(String mnem) {
        return this.cats.get(mnem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadGenOcc(SBdb sbdb) throws SQLException {
        for (Category cat : this.cats.values()) {
            cat.nGenera = 0;
        }
        String sql = "SELECT cat_mnem, count(cat_mnem) AS genera FROM " + sbdb.DBTableName("genus") + " GROUP BY (cat_mnem) ORDER BY (cat_mnem)";
        Statement stmt = sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                String mnem = rs.getString("cat_mnem");
                int genera = rs.getInt("genera");
                Category cat = this.getCategory(mnem);
                if (cat == null) {
                    cat = this.add(sbdb, mnem, Discipline.PALY, "NO NAME category " + mnem, null);
                }
                cat.nGenera = genera;
            }
        }
        finally {
            stmt.close();
        }
    }

    void fillCombo(JComboBox combo, boolean mnemOnly, Discipline discID) {
        for (Category cat : this.cats.values()) {
            if (discID != null && cat.getDisc() != discID) continue;
            String item = cat.getMnem();
            if (!mnemOnly) {
                while (item.length() < 10) {
                    item = item + " ";
                }
                item = item + cat.getName();
            }
            combo.addItem(item);
        }
        combo.insertItemAt("", 0);
    }

    void setSelection(JComboBox combo, String cat_mnem) {
        int index = 0;
        for (Category cat : this.cats.values()) {
            if (cat.getMnem().equals(cat_mnem)) {
                combo.setSelectedIndex(index + 1);
                return;
            }
            ++index;
        }
        combo.setSelectedIndex(0);
    }

    public static String getCatmnem(JComboBox combo) {
        String cat_mnem = "";
        Object object = combo.getSelectedItem();
        if (object instanceof String) {
            cat_mnem = (String)object;
        } else if (object instanceof Category) {
            cat_mnem = ((Category)object).getMnem();
        }
        cat_mnem = cat_mnem.trim();
        if (cat_mnem.length() > 0 && cat_mnem.indexOf(32) > 0) {
            cat_mnem = cat_mnem.substring(0, cat_mnem.indexOf(32));
        }
        return cat_mnem;
    }

    public Category getCategory(JComboBox combo) {
        Object object = combo.getSelectedItem();
        if (object instanceof String) {
            String cat_mnem = ((String)object).trim();
            if (cat_mnem.length() > 0 && cat_mnem.indexOf(32) > 0) {
                cat_mnem = cat_mnem.substring(0, cat_mnem.indexOf(32));
            }
            return this.cats.get(cat_mnem);
        }
        if (object instanceof Category) {
            return (Category)object;
        }
        return null;
    }

    public char getDiscID(String cat_mnem) {
        for (Category cat : this.cats.values()) {
            if (!cat.getMnem().equals(cat_mnem)) continue;
            return cat.getDiscID();
        }
        return '\u0000';
    }

    public String getName(String cat_mnem) {
        Category cat = this.cats.get(cat_mnem);
        if (cat == null) {
            return "";
        }
        return cat.getName();
    }

    public boolean exists(String cat_mnem) {
        return this.cats.get(cat_mnem) != null;
    }

    public List<Category> getList() {
        return new LinkedList<Category>(this.cats.values());
    }

    public void updateCat(SBdb db, Category original, String abr, Discipline discID, String description, Color colour) throws SQLException {
        if (!abr.equalsIgnoreCase(original.getMnem())) {
            this.cats.remove(original.getMnem());
        }
        original.update(db, abr, discID, description);
        if (original.getColour() != colour) {
            original.setColour(colour);
            original.storeColour(db);
        }
        if (this.cats.get(abr) == null) {
            this.cats.put(abr, original);
        }
        this.setChanged();
    }
}

