/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import model2.Discipline;
import model2.SBdb;
import model2.Taxon;
import util.SB;

public class Category
implements Comparable {
    private Discipline discID;
    private String mnem;
    private String name;
    private Color colour = Color.BLACK;
    int nGenera;

    public Discipline getDisc() {
        return this.discID;
    }

    public char getDiscID() {
        return Discipline.getChar(this.discID);
    }

    public String getMnem() {
        return this.mnem;
    }

    public String getName() {
        return this.name;
    }

    Category(Discipline discID, String mnem, String name) {
        this.discID = discID;
        this.mnem = mnem;
        this.name = name;
        this.colour = Color.BLACK;
    }

    void setColour(Color colour) {
        this.colour = colour;
    }

    public String toString() {
        return this.mnem;
    }

    void storeColour(SBdb sbdb) throws SQLException {
        if (sbdb.isConnected()) {
            Category.storeColour(sbdb, this.colour, this.mnem);
        }
    }

    public Color getColour() {
        return this.colour;
    }

    static Color getColour(SBdb SB2, String mnem, Color defaultColour) throws SQLException {
        Color colour = defaultColour;
        if (SB2 != null && SB2.isConnected()) {
            String sql = "SELECT red,green,blue FROM " + SB2.DBTableName("catcol") + " WHERE UCASE(ABR)=" + SB.DBString((String)mnem);
            Statement stmt = SB2.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            if (rs.next()) {
                colour = new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue"));
            }
            stmt.close();
        }
        return colour;
    }

    public static void storeColour(SBdb sbdb, Color colour, String mnem) throws SQLException {
        String sql;
        Statement stmt = sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql = "SELECT red,green,blue FROM " + sbdb.DBTableName("catcol") + " WHERE abr=" + SB.DBString((String)mnem)));
        if (rs.next()) {
            int r = rs.getInt("red");
            int g = rs.getInt("green");
            int b = rs.getInt("blue");
            if (colour.getRed() != r || colour.getGreen() != g || colour.getBlue() != b) {
                sql = "UPDATE " + sbdb.DBTableName("catcol") + " SET red=" + colour.getRed() + ",green=" + colour.getGreen() + ",blue=" + colour.getBlue() + " WHERE ABR=" + SB.DBString((String)mnem);
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
        } else {
            sql = "INSERT INTO " + sbdb.DBTableName("catcol") + " (abr,red,green,blue) VALUES (" + SB.DBString((String)mnem) + "," + colour.getRed() + "," + colour.getGreen() + "," + colour.getBlue() + ")";
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        stmt.close();
    }

    public int checkOcc(SBdb SB2) throws SQLException {
        String sql = "SELECT count(f.spec_id) AS spec_id FROM " + SB2.DBTableName("genus") + " g, " + SB2.DBTableName("species") + " s," + SB2.DBTableName("TAXONOCC") + " f " + " WHERE g.cat_mnem=" + SB.DBString((String)this.mnem) + " AND g.gen_id=s.gen_id AND s.spec_id=f.spec_id";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        int count = 0;
        if (rs.next()) {
            count = rs.getInt("spec_id");
        }
        stmt.close();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SBdb SB2, String mnem, Discipline discID, String name) throws SQLException {
        if (SB2.isConnected()) {
            Statement stmt = SB2.getDatabase().createStatement();
            try {
                if (!mnem.equals(this.mnem)) {
                    String sql = "INSERT INTO " + SB2.DBTableName("category") + " (disc_id, cat_mnem, cat_name) VALUES (";
                    sql = sql + SB.DBChar((char)Discipline.getChar(discID)) + "," + SB.DBString((String)mnem) + "," + SB.DBString((String)name) + ")";
                    stmt.executeUpdate(SB2.modQuery(sql));
                    sql = "UPDATE " + SB2.DBTableName("genus") + " SET cat_mnem=" + SB.DBString((String)mnem) + " WHERE cat_mnem=" + SB.DBString((String)this.mnem);
                    stmt.executeUpdate(SB2.modQuery(sql));
                    sql = "UPDATE " + SB2.DBTableName("catcol") + " SET abr=" + SB.DBString((String)mnem) + " WHERE abr=" + SB.DBString((String)this.mnem);
                    stmt.executeUpdate(SB2.modQuery(sql));
                    sql = "DELETE FROM " + SB2.DBTableName("category") + " WHERE cat_mnem=" + SB.DBString((String)this.mnem);
                    stmt.executeUpdate(SB2.modQuery(sql));
                } else {
                    String sql = "UPDATE " + SB2.DBTableName("category") + " SET disc_id=" + SB.DBChar((char)Discipline.getChar(discID)) + ", cat_name=" + SB.DBString((String)name) + " WHERE cat_mnem=" + SB.DBString((String)this.mnem);
                    stmt.executeUpdate(SB2.modQuery(sql));
                }
            }
            finally {
                stmt.close();
            }
        }
        this.discID = discID;
        this.mnem = mnem;
        this.name = name;
    }

    public int checkEvents(SBdb SB2) throws SQLException {
        String sql = "SELECT count(e.spec_id) AS spec_id FROM " + SB2.DBTableName("genus") + " g, " + SB2.DBTableName("species") + " s," + SB2.DBTableName("eventdic") + " e " + " WHERE g.cat_mnem=" + SB.DBString((String)this.mnem) + " AND g.gen_id=s.gen_id AND s.spec_id=e.spec_id";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        int count = 0;
        if (rs.next()) {
            count = rs.getInt("spec_id");
        }
        stmt.close();
        return count;
    }

    public void delete(SBdb SB2) throws SQLException {
        String sql = "SELECT spec_id FROM " + SB2.DBTableName("genus") + " g, " + SB2.DBTableName("species") + " s WHERE g.cat_mnem=" + SB.DBString((String)this.mnem) + " AND g.gen_id=s.gen_id";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        LinkedList<Integer> specIDs = new LinkedList<Integer>();
        while (rs.next()) {
            int specID = rs.getInt("spec_id");
            specIDs.add(new Integer(specID));
        }
        if (specIDs.size() > 0) {
            Taxon.deleteSpecies(SB2, specIDs, true, null);
            Iterator it = specIDs.iterator();
            sql = "DELETE FROM " + SB2.DBTableName("TAXONOCC") + " WHERE spec_id=?";
            PreparedStatement pStmt = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
            while (it.hasNext()) {
                pStmt.setInt(1, (Integer)it.next());
                pStmt.executeUpdate();
            }
            pStmt.close();
            it = specIDs.iterator();
            sql = "UPDATE " + SB2.DBTableName("eventdic") + " SET spec_id=0, generate='N' WHERE spec_id=?";
            pStmt = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
            while (it.hasNext()) {
                pStmt.setInt(1, (Integer)it.next());
                pStmt.executeUpdate();
            }
            pStmt.close();
        }
        sql = "DELETE FROM " + SB2.DBTableName("genus") + " WHERE cat_mnem=" + SB.DBString((String)this.mnem);
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("catcol") + " WHERE abr=" + SB.DBString((String)this.mnem);
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("category") + " WHERE cat_mnem=" + SB.DBString((String)this.mnem);
        stmt.executeUpdate(SB2.modQuery(sql));
    }

    public int getNGenera() {
        return this.nGenera;
    }

    public int compareTo(Object o) {
        Category c = (Category)o;
        return this.mnem.compareTo(c.getMnem());
    }

    static Category load(SBdb sbdb, String mnem, Statement stmt, Category cat) throws SQLException {
        if (cat != null && !cat.getMnem().equals(mnem)) {
            throw new IllegalArgumentException("Attempt to update a category with incorrect mnemonic");
        }
        String sql = "SELECT a.disc_id,a.cat_name,b.red,b.green,b.blue from " + sbdb.DBTableName("CATEGORY") + "AS a," + sbdb.DBTableName("CATCOL") + "AS b WHERE a.cat_mnem=" + mnem + " AND b.abr=" + mnem;
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        if (rs.next()) {
            Discipline disc = Discipline.getDisc(rs.getString("disc_id"));
            String name = rs.getString("cat_name");
            int red = rs.getInt("red");
            int green = rs.getInt("green");
            int blue = rs.getInt("blue");
            Color colour = new Color(red, green, blue);
            if (cat != null) {
                cat.discID = disc;
                cat.name = name;
            } else {
                cat = new Category(disc, mnem, name);
            }
            cat.colour = colour;
            return cat;
        }
        return null;
    }
}

