/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import model2.Audit;
import model2.CompositeStandardEventBase;
import model2.Discipline;
import model2.EventCompareCSU;
import model2.SBEvent;
import model2.SBdb;
import model2.Userdef;
import org.jdom.Element;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;

public class CompositeStandardEvent
implements Comparable,
SortEntry,
SbugsStatus,
CompositeStandardEventBase {
    private final SBdb sbdb;
    private SBEvent sbEvent;
    private double csu;
    private SBEvent.EventType type;
    private Audit audit = new Audit();
    private Color status = UNKNOWN;
    static final int SORTALPHA = 0;
    static final int SORTCSU_UP = 1;
    static final int SORTCSU_DOWN = 2;
    private static String PREFIX_F = "Top";
    private static String PREFIX_L = "Base";

    public char getEvType() {
        return this.type.getChar();
    }

    public String getEvTypeString() {
        return CompositeStandardEvent.getEvTypeString(this.type);
    }

    public static String getEvTypeString(SBEvent.EventType type) {
        switch (type) {
            case TOP: {
                return PREFIX_F;
            }
            case BASE: {
                return PREFIX_L;
            }
            case SINGLE: {
                return "Single";
            }
        }
        assert (false);
        return null;
    }

    public int getEvID() {
        return this.sbEvent.getEvID();
    }

    @Override
    public double getCSU() {
        return this.csu;
    }

    public String getName() {
        return this.sbEvent.getName();
    }

    @Override
    public SBEvent getEvent() {
        return this.sbEvent;
    }

    @Override
    public SBEvent.EventType getType() {
        return this.type;
    }

    public Audit getAudit() {
        return new Audit(this.audit);
    }

    public String toString() {
        return this.csu + " " + this.toStringName();
    }

    public String toStringName() {
        String strg = "";
        if (this.type == SBEvent.EventType.TOP) {
            strg = strg + PREFIX_F + " ";
        } else if (this.type == SBEvent.EventType.BASE) {
            strg = strg + PREFIX_L + " ";
        }
        strg = strg + this.sbEvent.getName();
        return strg;
    }

    public int compareTo(Object o) {
        CompositeStandardEvent rhs = (CompositeStandardEvent)o;
        return this.sbEvent.compareTo(rhs.sbEvent);
    }

    public static void sort(List<CompositeStandardEvent> events, int sort) {
        switch (sort) {
            case 0: {
                Collections.sort(events);
                break;
            }
            case 1: {
                Collections.sort(events, new EventCompareCSU(false));
                break;
            }
            case 2: {
                Collections.sort(events, new EventCompareCSU(true));
            }
        }
    }

    static Builder parse(SBdb ws, Element xml) throws SQLException, SBException, ParseException {
        Element el;
        Builder builder = new Builder();
        String strg = xml.getChildTextNormalize("EventID");
        if (strg != null) {
            int eventID = Integer.parseInt(strg);
            builder.event(ws.getSBEvent(eventID));
        }
        if ((strg = xml.getChildTextNormalize("CSU")) != null) {
            builder.csu(Double.parseDouble(strg));
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null && strg.length() > 0) {
            builder.type(SBEvent.EventType.getType(strg));
        }
        if ((el = xml.getChild("Audit")) != null) {
            builder.audit(new Audit(ws, el));
        }
        return builder;
    }

    void writeXML(BufferedWriter out, String ind) throws IOException {
        out.write(ind + "<EventID>" + this.sbEvent.getEvID() + "</EventID>\n");
        out.write(ind + "<CSU>" + this.csu + "</CSU>\n");
        out.write(ind + "<Type>" + this.getEvTypeString() + "</Type>\n");
        this.audit.writeXML(out, ind.length());
    }

    public void setCsu(double csu) throws SBException {
        if (this.sbdb != null) {
            throw new SBException("Attempt to set CSU for event: " + this);
        }
        this.csu = csu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCsu(int stdID, double csu) throws SBException, SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.sbdb.DBTableName("CMPSTDEV") + " SET csu=" + csu + "," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE std_id=" + stdID + " AND ev_id=" + this.sbEvent.getEvID() + " AND ev_type=" + SB.DBChar((char)this.type.getChar());
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.csu = csu;
    }

    void setSBEvent(SBEvent event) {
        this.sbEvent = event;
    }

    public String getSortEntry() {
        return this.sbEvent.getName().toUpperCase() + '-' + this.type.getChar();
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException, SQLException {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    public Color getStatus() {
        return this.status;
    }

    public void setStatus(Color status) {
        this.status = status;
    }

    public String statusString() {
        return this.toString();
    }

    public Discipline getDisc() {
        if (this.sbEvent.getTaxon() == null) {
            return null;
        }
        return this.sbEvent.getTaxon().getDisc();
    }

    public static String getPrefixF() {
        return PREFIX_F;
    }

    public static void setPrefixes(String f, String l) {
        if (f != null && !f.isEmpty()) {
            PREFIX_F = f;
        }
        if (l != null && !l.isEmpty()) {
            PREFIX_L = l;
        }
    }

    public static String getPrefixL() {
        return PREFIX_L;
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for composite standard event: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    private CompositeStandardEvent(Builder builder, SBdb sbdb) {
        this.sbdb = sbdb;
        this.sbEvent = builder.sbEvent;
        this.type = builder.type;
        this.csu = builder.csu;
        this.audit = builder.audit;
        this.status = NOTSTORED;
    }

    public static class Builder
    implements CompositeStandardEventBase {
        private SBEvent sbEvent;
        private SBEvent.EventType type;
        private double csu;
        Audit audit = new Audit();

        CompositeStandardEvent build(SBdb sbdb) {
            this.verify();
            return new CompositeStandardEvent(this, sbdb);
        }

        public void verify() {
            if (this.sbEvent == null) {
                throw new IllegalStateException("Attempt to build CmpStdEvent with null event");
            }
            if (this.type == null) {
                if (this.sbEvent.isSingle()) {
                    this.type = SBEvent.EventType.SINGLE;
                } else {
                    throw new IllegalStateException("Attempt to build CmpStdEvent with no type");
                }
            }
            if (this.sbEvent.isSingle() != this.type.isSingle()) {
                if (this.sbEvent.isSingle()) {
                    this.type = SBEvent.EventType.SINGLE;
                } else {
                    throw new IllegalStateException("Attempt to build CmpStdEvent with invalid event type");
                }
            }
        }

        public static Builder copyOf(CompositeStandardEvent rhs) {
            return new Builder().type(rhs.type).csu(rhs.csu).audit(new Audit(rhs.audit));
        }

        public Builder event(SBEvent event) {
            this.sbEvent = event;
            return this;
        }

        public Builder csu(double csu) {
            if (csu >= 0.0) {
                this.csu = csu;
            }
            return this;
        }

        public Builder type(SBEvent.EventType type) {
            this.type = type;
            return this;
        }

        public Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        @Override
        public SBEvent getEvent() {
            return this.sbEvent;
        }

        @Override
        public SBEvent.EventType getType() {
            return this.type;
        }

        @Override
        public double getCSU() {
            return this.csu;
        }
    }
}

