/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Observable;
import model2.SBImage;
import model2.SBdb;
import util.SB;
import util.SBException;

public class CoreImage
extends Observable {
    SBdb db;
    private double topDepth = 0.0;
    private double baseDepth = 0.0;
    private SBImage image = null;
    static final int IMAGE_ROW_HEIGHT = 150;

    CoreImage(SBdb db, int wellID, double topDepth, double baseDepth, SBImage image) throws SQLException, SBException, FileNotFoundException, IOException {
        image.store(db.storeImage());
        String sql = "INSERT INTO " + db.DBTableName("COREIMAGE") + " (well_id,top_depth,base_depth,image_id) VALUES (" + wellID + "," + topDepth + "," + baseDepth + "," + image.getImageID() + ")";
        Statement stmt = db.getDatabase().createStatement();
        stmt.executeUpdate(db.modQuery(sql));
        stmt.close();
        this.db = db;
        this.topDepth = topDepth;
        this.baseDepth = baseDepth;
        this.image = image;
    }

    private CoreImage(SBdb SB2, double topDepth, double baseDepth, SBImage image) {
        this.db = SB2;
        this.topDepth = topDepth;
        this.baseDepth = baseDepth;
        this.image = image;
    }

    CoreImage(SBdb db, CoreImage coreImage) {
        this.db = db;
        this.copy(coreImage);
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public double getBaseDepth() {
        return this.baseDepth;
    }

    public SBImage getImage() {
        return this.image;
    }

    static void load(int wellID, SBdb SB2, List<CoreImage> coreImages) throws SQLException {
        String sql = "SELECT top_depth,base_depth,image_id FROM " + SB2.DBTableName("COREIMAGE") + " WHERE well_id=" + wellID;
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            double topDepth = rs.getDouble("top_depth");
            double baseDepth = rs.getDouble("base_depth");
            int imageID = rs.getInt("image_id");
            CoreImage coreImage = new CoreImage(SB2, topDepth, baseDepth, SB2.getImage(imageID));
            coreImages.add(coreImage);
        }
        stmt.close();
    }

    void delete(int wellID) throws SQLException, SBException {
        String sql = "DELETE FROM " + this.db.DBTableName("COREIMAGE") + " WHERE well_id=" + wellID + " AND image_id=" + this.image.getImageID();
        Statement stmt = this.db.getDatabase().createStatement();
        stmt.executeUpdate(this.db.modQuery(sql));
        stmt.close();
        this.db.deleteImage(this.image.getImageID());
    }

    void copy(CoreImage rhs) {
        this.baseDepth = rhs.baseDepth;
        this.topDepth = rhs.topDepth;
        this.image = rhs.image;
    }

    void writeXML(FileWriter out, int indent, char units) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write("<CoreImage>\n");
        if (this.getTopDepth() > 0.0) {
            out.write(ind + "<TopDepth>" + SB.getDepthString((double)this.getTopDepth(), (char)units, (int)2) + "</TopDepth>\n");
        }
        if (this.getBaseDepth() > 0.0) {
            out.write(ind + "<BaseDepth>" + SB.getDepthString((double)this.getBaseDepth(), (char)units, (int)2) + "</BaseDepth>\n");
        }
        if (this.getImage() != null) {
            out.write(ind + "<CoreImageID>" + this.getImage().getImageID() + "</CoreImageID>\n");
        }
        out.write("<CoreImage>\n");
    }
}

