/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import model2.Audit;
import model2.Cores;
import model2.Coreshift;
import model2.DEXFile;
import model2.SBdb;
import model2.Well;
import org.jdom.Element;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;

public class CoredInterval
implements SbugsStatus,
SortEntry {
    CoredInterval link = null;
    private double topDepth;
    private double baseDepth;
    private String corenum = "";
    private boolean recovered = true;
    private Audit audit = new Audit();
    Color status = SbugsStatus.UNKNOWN;

    public CoredInterval(double top, double base, String corenum, boolean recovered, Audit audit) {
        this.topDepth = top;
        this.baseDepth = base;
        this.recovered = recovered;
        this.corenum = corenum;
        this.audit = audit;
    }

    public CoredInterval(CoredInterval rhs) {
        this.copy(rhs);
    }

    CoredInterval(SBdb SB2, SBdb wsDB, int wellID, CoredInterval ws) throws SQLException, SBException {
        this.copy(ws);
        this.audit = new Audit(SB2, wsDB, ws.audit);
        this.status = ws.status;
        this.store(SB2, wellID);
        ws.link = this;
    }

    public String getSortEntry() {
        String entry = "" + (int)this.topDepth * 100;
        while (entry.length() < 7) {
            entry = ' ' + entry;
        }
        return entry;
    }

    CoredInterval(Well well, DEXFile.DEXsection section) throws SBException, SQLException {
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (label.equalsIgnoreCase("Core number")) {
                this.corenum = value;
                continue;
            }
            if (label.equalsIgnoreCase("Recovered")) {
                this.recovered = value.toUpperCase().charAt(0) != 'N';
                continue;
            }
            if (label.equalsIgnoreCase("Top depth")) {
                this.topDepth = SB.parseDepthString((String)value);
                continue;
            }
            if (label.equalsIgnoreCase("Base depth")) {
                this.baseDepth = SB.parseDepthString((String)value);
                continue;
            }
            if (label.equalsIgnoreCase("Top depth correction")) {
                double deltaTop = SB.parseDepthString((String)value);
                well.getCoreShift().add(well.getWellID(), this.topDepth, (float)deltaTop);
                continue;
            }
            if (!label.equalsIgnoreCase("Base depth correction")) continue;
            double deltaBase = SB.parseDepthString((String)value);
            well.getCoreShift().add(well.getWellID(), this.baseDepth, (float)deltaBase);
        }
    }

    public CoredInterval(SBdb v2sbdb, int wellID, double topDepth, double baseDepth, String corenum, boolean recovered) throws SQLException {
        this.topDepth = topDepth;
        this.baseDepth = baseDepth;
        this.corenum = corenum;
        this.recovered = recovered;
        this.audit.created = this.audit.modified = new Date();
        this.audit.creator = this.audit.modifier = v2sbdb.getUser().getUsrID();
        this.status = NOTSTORED;
        this.store(v2sbdb, wellID);
    }

    public void copy(CoredInterval rhs) {
        this.topDepth = rhs.topDepth;
        this.baseDepth = rhs.baseDepth;
        this.recovered = rhs.recovered;
        this.corenum = rhs.corenum;
        this.audit = rhs.audit;
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public double getBaseDepth() {
        return this.baseDepth;
    }

    public String getCorenum() {
        return this.corenum;
    }

    public boolean getRecovered() {
        return this.recovered;
    }

    public String toString() {
        if (this.corenum == null || this.corenum.isEmpty()) {
            if (this.recovered) {
                return "(no number)";
            }
            return "(unrecovered)";
        }
        return this.corenum;
    }

    public String statusString() {
        return this.toString();
    }

    public Color getDbStatus() {
        return this.link != null ? this.link.status : null;
    }

    public String dbStatusString() {
        return this.link != null ? this.link.statusString() : null;
    }

    public Color getStatus() {
        return this.status;
    }

    public void store(SBdb SB2, int wellID) throws SQLException {
        if (this.status == NOTSTORED || this.status == UNKNOWN) {
            Statement stmt = SB2.getDatabase().createStatement();
            String sql = "INSERT INTO " + SB2.DBTableName("CORES") + " (well_id,top_depth,base_depth,corenum,recovered," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + this.topDepth + "," + this.baseDepth + ",'" + this.corenum + "','" + (this.recovered ? (char)'Y' : 'N') + "'," + this.audit.sqlInsert(SB2, stmt) + ")";
            stmt.executeUpdate(SB2.modQuery(sql));
            stmt.close();
            this.status = STORED;
        }
    }

    public void delete(SBdb SB2, int wellID) throws SQLException, SBException {
        String sql = "DELETE FROM " + SB2.DBTableName("CORES") + " WHERE well_id=" + wellID + " AND top_depth > " + (this.topDepth - 0.01) + " AND top_depth < " + (this.topDepth + 0.01);
        Statement stmt = SB2.getDatabase().createStatement();
        int rows = stmt.executeUpdate(SB2.modQuery(sql));
        this.status = NOTSTORED;
        stmt.close();
        if (rows != 1) {
            throw new SBException("Error deleting core: " + this + ", nRows=" + rows);
        }
    }

    public void updateStatus(Cores oldData) {
        Iterator it = oldData.getIterator();
        if (this.corenum == null) {
            this.corenum = "";
        }
        int nzTD = (int)(this.topDepth * 100.0);
        int nzBD = (int)(this.baseDepth * 100.0);
        this.status = NOTSTORED;
        while (it.hasNext()) {
            CoredInterval core = (CoredInterval)it.next();
            if (core.corenum == null) {
                core.corenum = "";
            }
            if (core == this) continue;
            int cTD = (int)(core.topDepth * 100.0);
            int cBD = (int)(core.baseDepth * 100.0);
            if (cTD == nzTD && cBD == nzBD) {
                this.status = STORED;
                if (!this.corenum.equalsIgnoreCase(core.corenum)) {
                    this.status = CONFLICT;
                }
                if (this.recovered == core.recovered) break;
                this.status = CONFLICT;
                break;
            }
            try {
                SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD);
            }
            catch (SBException sbe) {
                this.status = CONFLICT;
            }
            if (this.status != CONFLICT) continue;
            break;
        }
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    void writeDEX(FileWriter out, String eol, char units, Float deltaTop, Float deltaBase) throws IOException {
        out.write("[CORE " + SB.getDepthString((double)this.topDepth, (char)units, (int)2).trim() + " - " + SB.getDepthString((double)this.baseDepth, (char)units, (int)2).trim() + "]" + eol);
        if (this.corenum != null) {
            out.write("Core number = " + this.corenum + eol);
        }
        out.write("Recovered = ");
        if (this.recovered) {
            out.write("yes");
        } else {
            out.write("no");
        }
        out.write(eol);
        out.write("Top depth = " + SB.getDepthString((double)this.topDepth, (char)units, (int)2).trim() + eol);
        out.write("Base depth = " + SB.getDepthString((double)this.baseDepth, (char)units, (int)2).trim() + eol);
        if (deltaTop != null) {
            out.write("Top depth correction = " + SB.getDepthString((double)deltaTop.floatValue(), (char)units, (int)2).trim() + eol);
        }
        if (deltaBase != null) {
            out.write("Base depth correction = " + SB.getDepthString((double)deltaBase.floatValue(), (char)units, (int)2).trim() + eol);
        }
        out.write(eol);
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write("<CoredInterval Depth=\"" + SB.getDepthString((double)this.topDepth, (char)units, (int)2).trim() + " - " + SB.getDepthString((double)this.baseDepth, (char)units, (int)2).trim() + "\">\n");
        if (this.corenum != null && this.corenum.length() > 0) {
            out.write(ind + "<CoreNumber>" + this.corenum + "</CoreNumber>\n");
        }
        out.write(ind + "<Recovered>");
        if (this.recovered) {
            out.write("Yes");
        } else {
            out.write("No");
        }
        out.write("</Recovered>\n");
        out.write(ind + "<TopDepth>" + SB.getDepthString((double)this.topDepth, (char)units, (int)2).trim() + "</TopDepth>\n");
        if (SB.getDepthString((double)this.baseDepth, (char)units, (int)2).trim() != null && SB.getDepthString((double)this.baseDepth, (char)units, (int)2).trim().length() > 0) {
            out.write(ind + "<BaseDepth>" + SB.getDepthString((double)this.baseDepth, (char)units, (int)2).trim() + "</BaseDepth>\n");
        }
        out.write("</CoredInterval>\n");
    }

    CoredInterval(SBdb db, Element xml) throws SBException {
        String strg = xml.getChildTextNormalize("CoreNumber");
        if (strg != null) {
            this.corenum = strg;
        }
        if ((strg = xml.getChildTextNormalize("Recovered")) != null && strg.equalsIgnoreCase("NO")) {
            this.recovered = false;
        }
        if ((strg = xml.getChildTextNormalize("TopDepth")) != null) {
            this.topDepth = SB.parseDepthString((String)strg);
        }
        if ((strg = xml.getChildTextNormalize("BaseDepth")) != null) {
            this.baseDepth = SB.parseDepthString((String)strg);
        }
    }

    public Float getDeltaTop(Well well) throws SQLException {
        Coreshift coreshift = well.getCoreShift();
        for (int i = coreshift.getSize() - 1; i >= 0; --i) {
            Coreshift.CoreShiftDepth d = coreshift.get(i);
            if (!(Math.abs(d.getDepth() - this.topDepth) < 0.0099)) continue;
            return Float.valueOf(d.getShift());
        }
        return null;
    }

    public Float getDeltaBase(Well well) throws SQLException {
        Coreshift coreshift = well.getCoreShift();
        for (int i = 0; i < coreshift.getSize(); ++i) {
            Coreshift.CoreShiftDepth d = coreshift.get(i);
            if (!(Math.abs(d.getDepth() - (this.baseDepth - 0.01)) < 0.011)) continue;
            return Float.valueOf(d.getShift());
        }
        return null;
    }

    double getShift(Well well, double depth) throws SQLException, SBException {
        return well.getCorrectedDepth(depth) - depth;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }
}

