/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import model2.Audit;
import model2.CoredInterval;
import model2.SBdb;
import model2.Well;
import util.SB;
import util.SBException;

public class Cores
extends Observable {
    private SBdb SB;
    private List<CoredInterval> cores = new ArrayList<CoredInterval>();

    public Cores(SBdb SB2) {
        this.SB = SB2;
    }

    public int getSize() {
        return this.cores.size();
    }

    public List<CoredInterval> getList() {
        return this.cores;
    }

    public void clear() {
        this.cores.clear();
    }

    Iterator getIterator() {
        return this.cores.iterator();
    }

    public CoredInterval getCore(int index) {
        return this.cores.get(index);
    }

    public CoredInterval getCore(String corenum) {
        for (CoredInterval core : this.cores) {
            if (core.getCorenum() == null || !core.getCorenum().equals(corenum)) continue;
            return core;
        }
        return null;
    }

    public boolean add(CoredInterval core) throws SBException {
        if (this.cores.contains(core)) {
            return false;
        }
        int insertPoint = this.checkOverlap(null, core);
        this.cores.add(insertPoint, core);
        this.setChanged();
        return true;
    }

    public int checkOverlap(CoredInterval original, CoredInterval core) throws SBException {
        Iterator<CoredInterval> it = this.cores.iterator();
        int insertPoint = 0;
        int nzTD = (int)(core.getTopDepth() * 100.0);
        int nzBD = (int)(core.getBaseDepth() * 100.0);
        while (it.hasNext()) {
            CoredInterval compareWith = it.next();
            if (compareWith == original) continue;
            int cTD = (int)(compareWith.getTopDepth() * 100.0);
            int cBD = (int)(compareWith.getBaseDepth() * 100.0);
            try {
                util.SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD);
            }
            catch (SBException ex) {
                throw new SBException("Error inserting cored interval: " + ex.getMessage() + " core " + core);
            }
            if (nzTD < cTD) break;
            ++insertPoint;
        }
        return insertPoint;
    }

    public void load(int wellID) throws SQLException, SBException {
        this.cores.clear();
        String sql = "SELECT top_depth, base_depth, corenum, recovered," + Audit.sqlFieldString() + " FROM " + this.SB.DBTableName("CORES") + " WHERE well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            double topDepth = rs.getDouble("top_depth");
            double baseDepth = rs.getDouble("base_depth");
            String corenum = rs.getString("corenum");
            if (corenum == null) {
                corenum = "";
            }
            String strg = rs.getString("recovered");
            boolean recovered = true;
            if (strg != null && strg.charAt(0) == 'N') {
                recovered = false;
            }
            CoredInterval core = new CoredInterval(topDepth, baseDepth, corenum, recovered, new Audit(rs));
            this.add(core);
        }
        stmt.close();
        this.notifyObservers();
    }

    public static void deleteAll(SBdb SB2, int wellID) throws SQLException {
        String sql = "DELETE FROM " + SB2.DBTableName("CORES") + " WHERE well_id=" + wellID;
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    public void delete(SBdb SB2, int wellID, CoredInterval core) throws SQLException, SBException {
        if (SB2 != null && SB2.isConnected()) {
            core.delete(SB2, wellID);
        }
        this.cores.remove(core);
        this.setChanged();
    }

    public void store(int wellID) throws SQLException {
        Iterator<CoredInterval> it = this.cores.iterator();
        boolean refresh = false;
        while (it.hasNext()) {
            if (it.next().status != CoredInterval.NOTSTORED) continue;
            refresh = true;
            break;
        }
        if (!refresh) {
            return;
        }
        Cores.deleteAll(this.SB, wellID);
        it = this.cores.iterator();
        while (it.hasNext()) {
            it.next().store(this.SB, wellID);
        }
    }

    void refresh(Statement stmt, int wellID) throws SQLException, SBException {
        String sql = "SELECT top_depth,updated ";
        sql = sql + " FROM " + this.SB.DBTableName("cores") + " WHERE well_id=" + wellID;
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        boolean reload = false;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int topDepth = (int)(rs.getDouble("top_depth") * 1000.0);
            keys.add(topDepth);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (CoredInterval s : this.cores) {
                if ((int)(s.getTopDepth() * 1000.0) != topDepth) continue;
                found = true;
                if (time == null || !time.after(s.getUpdated())) break;
                reload = true;
                break;
            }
            if (!found) {
                reload = true;
            }
            if (!reload) continue;
            break;
        }
        if (keys.size() != this.cores.size()) {
            reload = true;
        }
        if (reload) {
            this.load(wellID);
            this.setChanged();
            this.notifyObservers();
        }
    }

    void setIntervalStatus(Color status) {
        Iterator<CoredInterval> it = this.cores.iterator();
        while (it.hasNext()) {
            it.next().status = status;
        }
    }

    void writeDEX(FileWriter out, String eol, char units, Well well) throws IOException, SQLException {
        for (CoredInterval core : this.cores) {
            core.writeDEX(out, eol, units, core.getDeltaTop(well), core.getDeltaBase(well));
        }
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        Iterator<CoredInterval> it = this.cores.iterator();
        while (it.hasNext()) {
            it.next().writeXML(out, indent, units);
        }
    }
}

