/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import model2.SBdb;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import util.SB;
import util.SBException;

public class Coreshift {
    private final SBdb db;
    private boolean isDirty = false;
    private List<CoreShiftDepth> list;

    Coreshift(SBdb db, int wellID) throws SQLException {
        this.db = db;
        this.load(wellID);
    }

    Coreshift(SBdb db, Element xml) throws SBException {
        this.db = db;
        this.list = new LinkedList<CoreShiftDepth>();
        Iterator it = xml.getDescendants((Filter)new ElementFilter("CoreShiftDepth"));
        while (it.hasNext()) {
            this.list.add(new CoreShiftDepth((Element)it.next()));
        }
    }

    public Coreshift(Coreshift rhs) {
        this.db = rhs.db;
        this.list = new LinkedList<CoreShiftDepth>();
        for (CoreShiftDepth shift : rhs.list) {
            this.list.add(new CoreShiftDepth(shift));
        }
        this.isDirty = false;
    }

    public Coreshift(SBdb db, Coreshift rhs) {
        this.db = db;
        this.list = new LinkedList<CoreShiftDepth>();
        for (CoreShiftDepth shift : rhs.list) {
            this.list.add(new CoreShiftDepth(shift));
        }
        this.isDirty = true;
    }

    public void insertAfter(CoreShiftDepth d) {
        int pos = 0;
        for (CoreShiftDepth depth : this.list) {
            if (depth == d) {
                this.list.add(pos, new CoreShiftDepth(0.0, 0.0f));
                break;
            }
            ++pos;
        }
        if (d == null) {
            if (pos == 0) {
                this.list.add(pos, new CoreShiftDepth(0.0, 0.0f));
            } else {
                this.list.add(pos, new CoreShiftDepth(0.0, 0.0f));
            }
        }
        this.isDirty = true;
    }

    public void remove(CoreShiftDepth d) {
        this.list.remove(d);
        this.isDirty = true;
    }

    public void update(int wellID, Coreshift coreshift) throws SQLException {
        coreshift.store(wellID);
        this.list.clear();
        for (CoreShiftDepth d : coreshift.list) {
            this.list.add(new CoreShiftDepth(d));
        }
        Collections.sort(this.list);
        this.isDirty = false;
    }

    public static boolean hasDuplicateDepths(Coreshift coreshift) {
        for (CoreShiftDepth csd : coreshift.list) {
            double depth = csd.getDepth();
            int i = 0;
            for (CoreShiftDepth csd2 : coreshift.list) {
                double depth2 = csd2.getDepth();
                if (!(Math.abs(depth2 - depth) < (double)0.0029f)) continue;
                ++i;
            }
            if (i <= true) continue;
            return true;
        }
        return false;
    }

    public void setDepth(int row, double depth) {
        CoreShiftDepth core = this.get(row);
        core.setDepth(depth);
        this.isDirty = true;
    }

    public void setShift(int row, float shift) {
        CoreShiftDepth core = this.get(row);
        core.setShift(shift);
        this.isDirty = true;
    }

    public void updateFromCoredInterval(int wellID, double topDepth, double baseDepth, Float topShift, Float baseShift) throws SQLException {
        CoreShiftDepth csd4;
        CoreShiftDepth csd2;
        for (CoreShiftDepth csd3 : this.list) {
            System.out.println("CoreShift before: " + csd3.depth + " / " + csd3.shift);
        }
        ListIterator<CoreShiftDepth> it = this.list.listIterator();
        boolean found = false;
        while (it.hasNext()) {
            csd2 = it.next();
            if (!(Math.abs(baseDepth - 0.01 - csd2.depth) < 0.0099)) continue;
            found = true;
            if (baseShift != null) {
                if (!((double)Math.abs(baseShift.floatValue() - csd2.shift) > 0.001)) continue;
                csd2.shift = baseShift.floatValue();
                this.isDirty = true;
                break;
            }
            it.remove();
            this.isDirty = true;
            break;
        }
        if (!found && baseShift != null) {
            it = this.list.listIterator();
            int insertPos = 0;
            while (it.hasNext()) {
                csd4 = it.next();
                if (baseDepth - 0.01 < csd4.depth) break;
                ++insertPos;
            }
            this.list.add(insertPos, new CoreShiftDepth(baseDepth - 0.01, baseShift.floatValue()));
            this.isDirty = true;
        }
        found = false;
        it = this.list.listIterator(this.list.size());
        while (it.hasPrevious()) {
            csd2 = it.previous();
            if (!(Math.abs(topDepth - csd2.depth) < 0.0099)) continue;
            found = true;
            if (topShift != null) {
                if (!((double)Math.abs(topShift.floatValue() - csd2.shift) > 0.001)) continue;
                csd2.shift = topShift.floatValue();
                this.isDirty = true;
                break;
            }
            it.remove();
            this.isDirty = true;
            break;
        }
        if (!found && topShift != null) {
            it = this.list.listIterator();
            int insertPos = 0;
            while (it.hasNext()) {
                csd4 = it.next();
                if (topDepth < csd4.depth) break;
                ++insertPos;
            }
            this.list.add(insertPos, new CoreShiftDepth(topDepth, topShift.floatValue()));
            this.isDirty = true;
        }
        for (CoreShiftDepth csd4 : this.list) {
            System.out.println("CoreShift after: " + csd4.depth + " / " + csd4.shift);
        }
        if (this.isDirty) {
            this.store(wellID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(int wellID) throws SQLException {
        if (this.list == null) {
            this.list = new LinkedList<CoreShiftDepth>();
            if (this.db != null && this.db.isConnected()) {
                String sql = "SELECT depth, shift FROM " + this.db.DBTableName("CORESHIFT") + " WHERE well_id=" + wellID + " ORDER BY depth";
                Statement stmt = this.db.getDatabase().createStatement();
                try {
                    ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                    while (rs.next()) {
                        double depth = rs.getDouble("depth");
                        float shift = rs.getFloat("shift");
                        this.list.add(new CoreShiftDepth(depth, shift));
                    }
                }
                finally {
                    stmt.close();
                }
                this.isDirty = false;
            }
        }
    }

    public CoreShiftDepth get(int index) {
        if (this.list == null) {
            return null;
        }
        return this.list.get(index);
    }

    public void add(int wellID, double depth, float shift) throws SQLException {
        if (this.list == null) {
            this.load(wellID);
        }
        boolean found = false;
        int pos = 0;
        for (CoreShiftDepth shiftDepth : this.list) {
            if (Math.abs(shiftDepth.depth - depth) < (double)0.0029f) {
                shiftDepth.shift = shift;
                this.isDirty = true;
                found = true;
                break;
            }
            if (depth < shiftDepth.depth) break;
            ++pos;
        }
        if (!found) {
            CoreShiftDepth d = new CoreShiftDepth(depth, shift);
            this.list.add(pos, d);
            this.isDirty = true;
        }
    }

    public void store(int wellID) throws SQLException {
        if (this.isDirty) {
            this.deleteAll(wellID);
            String sql = "INSERT INTO " + this.db.DBTableName("CORESHIFT") + "(well_id,depth,shift) VALUES (" + wellID + ",?,?)";
            PreparedStatement pstmt = this.db.getDatabase().prepareStatement(sql);
            for (CoreShiftDepth shiftDepth : this.list) {
                pstmt.setDouble(1, shiftDepth.depth);
                pstmt.setFloat(2, shiftDepth.shift);
                pstmt.executeUpdate();
            }
            pstmt.close();
            this.isDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteAll(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.db.DBTableName("CORESHIFT") + " WHERE well_id=" + wellID;
        Statement stmt = this.db.getDatabase().createStatement();
        try {
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    double getCorrectedDepth(double depth) {
        if (this.list == null) {
            throw new IllegalStateException("Attempt to get core shift when not loaded");
        }
        if (this.list.isEmpty()) {
            return depth;
        }
        CoreShiftDepth lower = null;
        CoreShiftDepth upper = null;
        ListIterator<CoreShiftDepth> it = this.list.listIterator();
        while (it.hasNext()) {
            CoreShiftDepth csd = it.next();
            if (lower == null || depth >= csd.depth) {
                lower = csd;
                continue;
            }
            upper = csd;
            break;
        }
        if (upper == null) {
            upper = lower;
        }
        if (upper.depth < lower.depth) {
            upper = lower;
        }
        if (lower == upper) {
            return depth + (double)lower.shift;
        }
        if (depth < lower.depth) {
            return depth + (double)lower.shift;
        }
        if (depth > upper.depth) {
            return depth + (double)upper.shift;
        }
        double proportion = (depth - upper.depth) / (lower.depth - upper.depth);
        double deltaSample = (double)upper.shift + proportion * (double)(lower.shift - upper.shift);
        return depth += deltaSample;
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        if (this.list.size() > 0) {
            Iterator<CoreShiftDepth> it = this.list.iterator();
            out.write("<CoreShift>\n");
            while (it.hasNext()) {
                out.write(ind + "<CoreShiftDepth>\n");
                CoreShiftDepth coreShiftDepth = it.next();
                String ddepth = SB.getDepthString((double)coreShiftDepth.depth, (char)units, (int)2).trim();
                String shift = SB.getDepthString((double)coreShiftDepth.shift, (char)units, (int)2).trim();
                if (ddepth != null && ddepth.length() > 0) {
                    out.write(ind + ind + "<Depth>" + ddepth + "</Depth>\n");
                }
                if (shift != null && shift.length() > 0) {
                    out.write(ind + ind + "<Shift>" + shift + "</Shift>\n");
                }
                out.write(ind + "</CoreShiftDepth>\n");
            }
            out.write("</CoreShift>\n");
        }
    }

    public int getSize() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public float getMinShift() {
        Float min = null;
        for (CoreShiftDepth i : this.list) {
            if (min == null) {
                min = Float.valueOf(i.shift);
                continue;
            }
            if (!(i.shift < min.floatValue())) continue;
            min = Float.valueOf(i.shift);
        }
        if (min == null) {
            return 0.0f;
        }
        return min.floatValue();
    }

    public float getMaxShift() {
        Float max = null;
        for (CoreShiftDepth i : this.list) {
            if (max == null) {
                max = Float.valueOf(i.shift);
                continue;
            }
            if (!(i.shift > max.floatValue())) continue;
            max = Float.valueOf(i.shift);
        }
        if (max == null) {
            return 0.0f;
        }
        return max.floatValue();
    }

    public class CoreShiftDepth
    implements Comparable {
        double depth;
        float shift;

        CoreShiftDepth(double depth, float shift) {
            this.depth = depth;
            this.shift = shift;
        }

        CoreShiftDepth(Element xml) throws SBException {
            String strg = xml.getChildTextNormalize("Depth");
            if (strg != null) {
                this.depth = SB.parseDepthString((String)strg);
            }
            if ((strg = xml.getChildTextNormalize("Shift")) != null) {
                this.shift = (float)SB.parseDepthString((String)strg);
            }
        }

        public String toString() {
            return "" + this.depth + "/" + this.shift;
        }

        public int compareTo(Object o) {
            if (o instanceof CoreShiftDepth) {
                int val1 = (int)(this.depth * 1000.0);
                double d2 = ((CoreShiftDepth)o).depth;
                int val2 = (int)(d2 * 1000.0);
                return val1 - val2;
            }
            return 0;
        }

        private CoreShiftDepth(CoreShiftDepth rhs) {
            this.depth = rhs.depth;
            this.shift = rhs.shift;
        }

        public double getDepth() {
            return this.depth;
        }

        public float getShift() {
            return this.shift;
        }

        void setDepth(double depth) {
            this.depth = depth;
        }

        void setShift(float shift) {
            this.shift = shift;
        }
    }
}

