/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import model2.Audit;
import model2.LogDef;
import model2.LogFile;
import model2.SBdb;
import util.SB;

public class Curve {
    private List<CurveValue> trace = new LinkedList<CurveValue>();
    private int curveID;
    private String abr;
    private String mnem;
    private Double top;
    private Double base;
    private String fileName;
    private Audit audit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Curve(SBdb db, int curveID, String abr, String curveMnem, String fileName, Audit audit) throws SQLException {
        this.curveID = curveID;
        this.abr = abr;
        this.mnem = curveMnem;
        this.fileName = fileName;
        this.audit = audit;
        String sql = "SELECT depth, trace_value FROM " + db.DBTableName("LOG_TRACE") + " WHERE curve_id=" + curveID + " ORDER BY depth";
        Statement stmt = db.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                CurveValue value = new CurveValue();
                value.depth = rs.getDouble("depth");
                if (this.top == null || this.top > value.depth) {
                    this.top = value.depth;
                }
                if (this.base == null || this.base < value.depth) {
                    this.base = value.depth;
                }
                value.value = rs.getDouble("trace_value");
                this.trace.add(value);
            }
        }
        finally {
            stmt.close();
        }
    }

    public Curve(Curve curve) {
        this.curveID = curve.curveID;
        this.trace = new LinkedList<CurveValue>();
        for (CurveValue value : curve.trace) {
            CurveValue newValue = new CurveValue();
            newValue.depth = value.depth;
            newValue.value = value.value;
            this.trace.add(newValue);
        }
        this.top = curve.top;
        this.base = curve.base;
        this.mnem = curve.mnem;
        this.abr = curve.abr;
    }

    public List<CurveValue> getTrace() {
        return this.trace;
    }

    Curve(File file, char units, String curveMnem, LogDef logDef, int nCurve, float depthFilter) throws FileNotFoundException, IOException {
        String buff;
        this.abr = logDef.toString();
        this.mnem = curveMnem;
        this.fileName = file.getPath();
        BufferedReader in = new BufferedReader(new FileReader(file));
        double lastDepth = 0.0;
        while ((buff = in.readLine()) != null) {
            StringTokenizer tok;
            if (buff.trim().length() == 0 || (tok = new StringTokenizer(buff, " ,;\t")).countTokens() < nCurve + 1) continue;
            try {
                double depth = Double.parseDouble(tok.nextToken());
                if (Math.abs(depth - lastDepth) > (double)depthFilter) {
                    int i = 0;
                    while (tok.hasMoreTokens()) {
                        if (i == nCurve) {
                            CurveValue value = new CurveValue();
                            value.depth = SB.convToM((double)depth, (char)units);
                            value.value = Double.parseDouble(tok.nextToken());
                            if ((int)value.value == -999) break;
                            this.trace.add(value);
                            if (this.top == null || value.depth < this.top) {
                                this.top = value.depth;
                            }
                            if (this.base != null && !(value.depth > this.base)) break;
                            this.base = value.depth;
                            break;
                        }
                        tok.nextElement();
                        ++i;
                    }
                }
                lastDepth = depth;
            }
            catch (NumberFormatException ex) {
                System.out.println("Number format exception in : " + buff);
            }
        }
        in.close();
    }

    public Curve(LogFile file, char units, LogDef logDef, int nCurve, float depthFilter, char sectionType) throws FileNotFoundException, IOException {
        this.abr = logDef.toString();
        this.mnem = file.getMnem(nCurve);
        this.fileName = file.getPath();
        double lastDepth = 0.0;
        for (LogFile.LogValue logFileValue : file.getRecords()) {
            double depth = logFileValue.depth;
            if (!(Math.abs(depth - lastDepth) > (double)depthFilter)) continue;
            CurveValue value = new CurveValue();
            value.depth = SB.convToM((double)depth, (char)units, (char)sectionType);
            value.value = logFileValue.values[nCurve];
            if (!(value.value <= -999.0) || !(value.value >= -999.25)) {
                this.trace.add(value);
                if (this.top == null || value.depth < this.top) {
                    this.top = value.depth;
                }
                if (this.base == null || value.depth > this.base) {
                    this.base = value.depth;
                }
            }
            lastDepth = depth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(SBdb db, int wellID) throws SQLException {
        this.audit = new Audit();
        this.curveID = db.nextControl("LOG_CURVE", "CURVE_ID");
        Statement stmt = db.getDatabase().createStatement();
        String sql = "INSERT INTO " + db.DBTableName("LOG_CURVE") + " ( curve_id, well_id, abr, curve_mnem, filename, " + Audit.sqlFieldString() + ") VALUES (";
        sql = sql + this.curveID + "," + wellID + "," + SB.DBString((String)this.abr) + "," + SB.DBString((String)this.mnem) + "," + SB.DBString((String)this.fileName) + "," + this.audit.sqlInsert(db, stmt) + ")";
        try {
            stmt.executeUpdate(db.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        sql = "INSERT INTO " + db.DBTableName("LOG_TRACE") + " (curve_id, depth, trace_value) VALUES (" + this.curveID + ",?,?)";
        PreparedStatement pStmt = db.getDatabase().prepareStatement(db.modQuery(sql));
        try {
            for (CurveValue value : this.trace) {
                pStmt.setDouble(1, value.depth);
                pStmt.setDouble(2, value.value);
                try {
                    pStmt.executeUpdate();
                }
                catch (SQLException sqle) {
                    System.out.println("SQL Exception " + sqle.getMessage() + " while inserting value: " + value.depth + "," + value.value);
                }
            }
        }
        finally {
            pStmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(SBdb db) throws SQLException {
        if (this.curveID <= 0) {
            throw new IllegalStateException("Invalid curve ID: " + this.curveID);
        }
        Statement stmt = db.getDatabase().createStatement();
        String sql = "DELETE FROM " + db.DBTableName("LOG_TRACE") + " WHERE curve_id=" + this.curveID;
        try {
            stmt.executeUpdate(db.modQuery(sql));
            sql = "DELETE FROM " + db.DBTableName("LOG_CURVE") + " WHERE curve_id=" + this.curveID;
            stmt.executeUpdate(db.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow(SBdb db, CurveValue curveValue) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        if (this.trace.remove(curveValue)) {
            String sql = "DELETE FROM " + db.DBTableName("LOG_TRACE") + " WHERE curve_id=" + this.curveID + " AND depth > " + (curveValue.depth - 0.01) + " AND depth < " + (curveValue.depth + 0.01);
            try {
                stmt.executeUpdate(db.modQuery(sql));
            }
            finally {
                stmt.close();
            }
        }
    }

    public Double getTopDepth() {
        return this.top;
    }

    public Double getBaseDepth() {
        return this.base;
    }

    public String getAbr() {
        return this.abr;
    }

    public String getMnem() {
        return this.mnem;
    }

    public String getFilename() {
        return this.fileName;
    }

    public static class CurveValue {
        double depth;
        double value;

        public double getDepth() {
            return this.depth;
        }

        public double getValue() {
            return this.value;
        }
    }
}

