/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model2.Audit;
import model2.Curve;
import model2.LogDef;
import model2.LogFile;
import model2.SBdb;
import model2.Well;
import util.SBException;

public class Curves
extends Observable {
    private final List<Curve> list = new LinkedList<Curve>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Curves(SBdb db, Well well) throws SQLException {
        String sql = "SELECT curve_id, abr, curve_mnem, filename, " + Audit.sqlFieldString() + " FROM " + db.DBTableName("LOG_CURVE") + " WHERE well_id=" + well.getWellID();
        Statement stmt = db.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                int curveID = rs.getInt("curve_id");
                String abr = rs.getString("abr");
                String curveMnem = rs.getString("curve_mnem");
                String fileName = rs.getString("filename");
                Audit audit = new Audit(rs);
                this.list.add(new Curve(db, curveID, abr, curveMnem, fileName, audit));
            }
        }
        finally {
            stmt.close();
        }
    }

    public List<Curve> getCurves() {
        return this.list;
    }

    public int getSize() {
        return this.list.size();
    }

    public void add(SBdb db, Well well, Curve curve) throws SQLException {
        curve.store(db, well.getWellID());
        this.list.add(curve);
        this.setChanged();
    }

    public void add(SBdb db, Well well, LogFile file, LogDef logDef, int nCurve, float depthFilter, char units) throws FileNotFoundException, IOException, SBException, SQLException {
        Curve curve = new Curve(file, units, logDef, nCurve, depthFilter, well.getType());
        curve.store(db, well.getWellID());
        this.list.add(curve);
        this.setChanged();
    }

    public void add(SBdb db, Well well, File file, String curveMnem, LogDef logDef, int nCurve, float depthFilter, char units) throws FileNotFoundException, IOException, SBException, SQLException {
        Curve curve = new Curve(file, units, curveMnem, logDef, nCurve, depthFilter);
        curve.store(db, well.getWellID());
        this.list.add(curve);
        this.setChanged();
    }

    public void delete(SBdb db, Curve curve) throws SQLException {
        curve.delete(db);
        this.list.remove(curve);
        this.setChanged();
    }

    public boolean checkOverlap(Curve curve) {
        boolean overlap = false;
        double topDepth = curve.getTopDepth();
        double baseDepth = curve.getBaseDepth();
        for (Curve c : this.list) {
            if (!c.getAbr().equals(curve.getAbr()) || !(c.getTopDepth() >= topDepth && c.getTopDepth() <= baseDepth) && (!(c.getBaseDepth() >= topDepth) || !(c.getBaseDepth() <= baseDepth))) continue;
            overlap = true;
            break;
        }
        return overlap;
    }
}

