/*
 * Decompiled with CFR 0.152.
 */
package model2;

public enum Discipline {
    MICRO('M', "Micropalaeontology", "Microfaunal", "Micro"),
    PALY('P', "Palynology", "Palynofloral", "Paly"),
    NANNO('N', "Nannopalaeontology", "Nannofloral", "Nanno"),
    MACRO('A', "Macropalaeontology", "Macrofaunal", "Macro");

    private char charType;
    private String noun;
    private String adjective;
    private String abr;

    private Discipline(char charType, String noun, String adj, String abr) {
        this.charType = charType;
        this.noun = noun;
        this.adjective = adj;
        this.abr = abr;
    }

    public char getChar() {
        return this.charType;
    }

    public String getNoun() {
        return this.noun;
    }

    public String getAdj() {
        return this.adjective;
    }

    public String getAbr(boolean withPeriod) {
        return this.abr + (withPeriod ? "." : "");
    }

    public static Discipline getDisc(char discID) {
        for (Discipline d : Discipline.values()) {
            if (d.getChar() != discID) continue;
            return d;
        }
        return null;
    }

    public static Discipline getDisc(String s) {
        for (Discipline d : Discipline.values()) {
            if (!d.getNoun().equalsIgnoreCase(s) && !d.getAdj().equalsIgnoreCase(s) && !d.getAbr(false).equalsIgnoreCase(s) && (s.length() != 1 || d.getChar() != s.charAt(0))) continue;
            return d;
        }
        return null;
    }

    public static char getChar(Discipline d) {
        if (d == null) {
            return '\u0000';
        }
        return d.getChar();
    }

    public static String getNoun(Discipline d) {
        if (d == null) {
            return "";
        }
        return d.getNoun();
    }

    public String toString() {
        return this.getNoun();
    }

    public static String[] getNouns() {
        String[] nouns = new String[Discipline.values().length];
        for (int i = 0; i < Discipline.values().length; ++i) {
            nouns[i] = Discipline.values()[i].getNoun();
        }
        return nouns;
    }
}

