/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import model2.Audit;
import model2.DEXFile;
import model2.IGDIntervalEnv;
import model2.SBdb;
import model2.Userdef;
import model2.Well;
import model2.WellInterp;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import util.SB;
import util.SBException;
import util.SbugsStatus;

public class EnvScheme
extends Observable
implements SbugsStatus,
Comparable {
    SBdb SB;
    EnvScheme link = null;
    static final int MAXCLASSES = 30;
    private int ID;
    private String name;
    private String[] term = new String[30];
    private Color[] colour = new Color[30];
    private int[] nOccs = new int[30];
    private int[] linkTerm = new int[30];
    private int nClasses = 0;
    private Audit audit = new Audit();
    final String NOTERMTEXT = "<no term>";
    static String[] intervalFields = new String[]{"up", "ud", "lp", "ld", "qual"};
    Color status = UNKNOWN;

    EnvScheme(SBdb SB2, int ID, String name) {
        this.SB = SB2;
        this.ID = ID;
        this.name = name;
    }

    public EnvScheme() {
    }

    EnvScheme(SBdb ws, EnvScheme rhs) throws SQLException, SBException {
        this.copy(rhs, true);
        this.audit.fillWorkspace(rhs.SB, ws);
        this.SB = ws;
        this.link = rhs;
    }

    EnvScheme(SBdb ws, Element xml) throws ParseException, SQLException, SBException {
        Element el;
        this.SB = ws;
        String strg = xml.getChildText("SchemeName");
        if (strg != null) {
            this.name = strg;
        }
        if ((strg = xml.getChildTextNormalize("SchemeID")) != null) {
            this.ID = Integer.parseInt(strg);
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(ws, el);
        } else {
            System.out.println("Warning: no audit info for Scheme: " + this);
        }
        Iterator it = xml.getDescendants((Filter)new ElementFilter("Member"));
        while (it.hasNext()) {
            Element cEl;
            Element termEl = (Element)it.next();
            strg = termEl.getChildTextNormalize("Term");
            if (strg != null) {
                this.term[this.nClasses] = strg;
            }
            if ((cEl = termEl.getChild("Colour")) != null) {
                this.colour[this.nClasses] = util.SB.parseColour((Element)cEl);
            }
            ++this.nClasses;
        }
    }

    public Color getColour(int indexNumber) {
        return this.colour[indexNumber - 1];
    }

    public int getNoccs(int indexNumber) {
        return this.nOccs[indexNumber - 1];
    }

    public void setNoccs(int indexNumber, int n) {
        this.nOccs[indexNumber - 1] = n;
    }

    public EnvScheme(EnvScheme rhs) {
        this.name = rhs.name;
        this.ID = rhs.ID;
        this.nClasses = rhs.nClasses;
        for (int i = 0; i < this.nClasses; ++i) {
            this.term[i] = rhs.term[i];
            this.colour[i] = rhs.colour[i];
        }
        this.audit = rhs.audit;
    }

    EnvScheme(DEXFile.DEXsection section, SBdb db) throws SBException, SQLException {
        this.SB = db;
        int nColumns = 0;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = ((String)section.value.get(i)).trim();
            if (label.equalsIgnoreCase("Scheme ID")) {
                this.ID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Scheme name")) {
                this.setName(value);
                continue;
            }
            if (label.equalsIgnoreCase("Number of columns")) continue;
            if (label.equalsIgnoreCase("Column Name")) {
                this.addRow();
                this.setTerm(++nColumns, value);
                continue;
            }
            if (!label.equalsIgnoreCase("Colour")) continue;
            StringTokenizer tok = new StringTokenizer(value, ",");
            int red = Integer.parseInt(tok.nextToken());
            int green = Integer.parseInt(tok.nextToken());
            int blue = Integer.parseInt(tok.nextToken());
            this.setColour(nColumns, new Color(red, green, blue));
        }
    }

    public int compareTo(Object rhs) {
        return this.name.compareTo(rhs.toString());
    }

    public void copy(EnvScheme rhs, boolean copyID) {
        this.name = rhs.name;
        if (copyID) {
            this.ID = rhs.ID;
        }
        this.nClasses = rhs.nClasses;
        for (int i = 0; i < this.nClasses; ++i) {
            this.term[i] = rhs.term[i];
            this.colour[i] = rhs.colour[i];
        }
        this.audit = rhs.audit;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public boolean match(EnvScheme rhs) {
        if (this.nClasses != rhs.nClasses) {
            return false;
        }
        for (int i = 0; i < this.nClasses; ++i) {
            if (this.term[i].equals(rhs.term[i])) continue;
            return false;
        }
        return true;
    }

    public Color getDbStatus() {
        return this.link != null ? this.link.status : null;
    }

    public String dbStatusString() {
        return this.link != null ? this.link.statusString() : null;
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.name;
    }

    public EnvScheme getLink() {
        return this.link;
    }

    public String getLinkTerm(int termIndex) {
        if (this.link == null) {
            return null;
        }
        if (this.linkTerm[termIndex - 1] > 0) {
            return this.link.getTerm(this.linkTerm[termIndex - 1]);
        }
        return null;
    }

    public Integer getLinkTermIndex(int termIndex) {
        if (this.link == null) {
            return null;
        }
        if (this.linkTerm[termIndex - 1] > 0) {
            return this.linkTerm[termIndex - 1];
        }
        return null;
    }

    public Color getLinkColour(int termIndex) {
        if (this.link == null) {
            return Color.WHITE;
        }
        if (this.linkTerm[termIndex - 1] > 0) {
            return this.link.getColour(this.linkTerm[termIndex - 1]);
        }
        return Color.WHITE;
    }

    public void setLinkTerm(int termIndex, String className) throws SBException {
        if (this.link == null) {
            return;
        }
        this.linkTerm[termIndex - 1] = this.link.getTermIndex(className);
    }

    public void setLink(EnvScheme scheme) throws SBException {
        for (int i = 0; i < 30; ++i) {
            this.linkTerm[i] = -1;
        }
        this.link = scheme;
        if (this.link != null) {
            boolean allMatched = true;
            for (int i = 0; i < this.nClasses; ++i) {
                try {
                    this.linkTerm[i] = this.link.getTermIndex(this.getTerm(i + 1));
                    continue;
                }
                catch (Exception ex) {
                    this.linkTerm[i] = -1;
                    allMatched = false;
                }
            }
            this.status = allMatched ? STORED : PARTSTORED;
        } else {
            this.status = NOTSTORED;
        }
    }

    public String toString() {
        if (this.name.length() == 0 && this.ID != 0) {
            return "Scheme ID no. " + this.ID;
        }
        return this.name;
    }

    EnvScheme(SBdb SB2, int iID) throws SQLException, SBException {
        this.SB = SB2;
        String sql = "SELECT name," + Audit.sqlFieldString() + " FROM " + SB2.DBTableName("ENV_SCH") + " WHERE envsch_id=" + iID;
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            this.ID = iID;
            this.name = util.SB.getDBString((ResultSet)rs, (String)"name");
            this.audit = new Audit(rs);
            rs.close();
            sql = "SELECT term_no, term, red, green, blue FROM " + SB2.DBTableName("ENVSCHMBR") + " WHERE envsch_id=" + iID + " ORDER BY term_no";
            rs = stmt.executeQuery(SB2.modQuery(sql));
            int i = 0;
            while (rs.next()) {
                i = rs.getInt("term_no") - 1;
                if (i >= 30 || i < 0) {
                    throw new SBException("Incorrect term_no found in ENVSCHMBR for scheme ID: " + iID);
                }
                this.term[i] = util.SB.getDBString((ResultSet)rs, (String)"term");
                int r = rs.getInt("red");
                int g = rs.getInt("green");
                int b = rs.getInt("blue");
                this.colour[i] = new Color(r, g, b);
                this.nClasses = i + 1;
            }
        }
        stmt.close();
    }

    public void insertRow(int insertPoint) throws SBException, SQLException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to update env scheme");
        }
        for (int i = this.nClasses; i > insertPoint; --i) {
            this.term[i] = this.term[i - 1];
            this.colour[i] = this.colour[i - 1];
        }
        this.term[insertPoint] = "";
        this.colour[insertPoint] = Color.CYAN;
        ++this.nClasses;
    }

    public void addRow() throws SBException, SQLException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to update env scheme");
        }
        if (this.nClasses >= 30) {
            throw new SBException("Maxiumum number of classes reached");
        }
        this.term[this.nClasses] = "";
        this.colour[this.nClasses] = Color.CYAN;
        ++this.nClasses;
    }

    public void setTerm(int row, String term) throws SBException, SQLException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to update env scheme");
        }
        if (row > this.nClasses) {
            throw new SBException("Attempt to update env scheme row: " + row + " outside range: " + this.nClasses);
        }
        this.term[row - 1] = term;
    }

    public void setColour(int row, Color colour) throws SBException, SQLException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to update env scheme");
        }
        if (row > this.nClasses) {
            throw new SBException("Attempt to update env scheme row: " + row + " outside range: " + this.nClasses);
        }
        this.colour[row - 1] = colour;
    }

    public void deleteRow(int deletePoint) throws SBException, SQLException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to update env scheme");
        }
        for (int i = deletePoint; i < this.nClasses; ++i) {
            this.term[i] = this.term[i + 1];
            this.colour[i] = this.colour[i + 1];
        }
        --this.nClasses;
    }

    public boolean checkNameUnique() throws SQLException {
        String sql = "SELECT envsch_id FROM " + this.SB.DBTableName("ENV_SCH") + " WHERE ucase(name)='" + this.name.toUpperCase() + "'";
        if (this.ID != 0) {
            sql = sql + " AND envsch_id <> " + this.ID;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        boolean unique = true;
        if (rs.next()) {
            unique = false;
        }
        stmt.close();
        return unique;
    }

    public int getNoccs() throws SQLException {
        String sql = "SELECT count(envsch_id) as nOcc FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE envsch_id=" + this.ID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        int nDbOccs = 0;
        if (rs.next()) {
            nDbOccs = rs.getInt("nOcc");
        }
        return nDbOccs;
    }

    public int getNAnalyHdrOccs() throws SQLException {
        String sql = "SELECT count(envsch_id) as nOcc FROM " + this.SB.DBTableName("ANALY_HDR") + " WHERE envsch_id=" + this.ID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        int nDbOccs = 0;
        if (rs.next()) {
            nDbOccs = rs.getInt("nOcc");
        }
        return nDbOccs;
    }

    public List getOccs(int entryNo) throws SQLException {
        String sql = "SELECT DISTINCT w.well_name,v.well_code FROM " + this.SB.DBTableName("IGD_ENV") + " i," + this.SB.DBTableName("WELL_IDENT") + " v," + this.SB.DBTableName("WELLS") + " w" + " WHERE i.envsch_id=" + this.ID + " AND i.well_id=v.well_id AND v.well_code=w.well_code";
        if (entryNo > 0) {
            sql = sql + " AND (i.up=" + entryNo + " OR i.ud=" + entryNo + " OR i.lp=" + entryNo + " OR i.ld=" + entryNo + " OR i.qual=" + entryNo + ")";
        }
        sql = sql + " ORDER BY well_name";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        ArrayList<String> occs = new ArrayList<String>();
        while (rs.next()) {
            occs.add(rs.getString("well_name") + " (" + rs.getString("well_code") + ") ");
        }
        stmt.close();
        return occs;
    }

    public void setDBOccs() throws SQLException {
        for (int entry = 1; entry <= this.nClasses; ++entry) {
            this.setNoccs(entry, this.getNdbOccs(entry));
        }
    }

    public int getNdbOccs(int entry) throws SQLException {
        int occs = 0;
        Statement stmt = this.SB.getDatabase().createStatement();
        for (String field : intervalFields) {
            String sql = "SELECT count(well_id) as total FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE envsch_id=" + this.ID + " AND " + field + "=" + entry;
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                occs += rs.getInt("total");
            }
            rs.close();
        }
        stmt.close();
        return occs;
    }

    void deleteEntries() throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        if (this.ID != 0) {
            String sql = "DELETE FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE envsch_id=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
    }

    void delete() throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        if (this.ID != 0) {
            String sql = "DELETE FROM " + this.SB.DBTableName("ENVSCHMBR") + " WHERE envsch_id=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
            sql = "DELETE FROM " + this.SB.DBTableName("ENV_SCH") + " WHERE envsch_id=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
    }

    public void update(EnvScheme rhs) throws SQLException, SBException {
        rhs.store(this.SB);
        this.copy(rhs, true);
        this.setChanged();
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    void store(SBdb SB2, int schemeID) throws SQLException, SBException {
        Statement stmt = SB2.getDatabase().createStatement();
        this.ID = schemeID;
        String sql = "INSERT INTO " + SB2.DBTableName("ENV_SCH");
        sql = sql + " ( envsch_id,name," + Audit.sqlFieldString() + " ) VALUES (";
        sql = sql + this.ID + ",'" + this.name + "',";
        sql = sql + this.audit.sqlInsert(SB2, stmt);
        sql = sql + ")";
        stmt.executeUpdate(SB2.modQuery(sql));
        this.store(SB2);
    }

    void store(SBdb SB2) throws SQLException, SBException {
        String sql;
        int tempID;
        Statement stmt = SB2.getDatabase().createStatement();
        if (this.ID != 0) {
            tempID = this.ID;
            sql = "DELETE FROM " + SB2.DBTableName("ENVSCHMBR") + " WHERE envsch_id=" + this.ID;
            stmt.executeUpdate(SB2.modQuery(sql));
            Audit temp = new Audit(this.audit);
            sql = "UPDATE " + SB2.DBTableName("ENV_SCH") + " SET name=" + util.SB.DBString((String)this.name) + "," + temp.sqlUpdate(SB2, stmt, false) + " WHERE envsch_id=" + this.ID;
            stmt.executeUpdate(SB2.modQuery(sql));
            this.audit = temp;
        } else {
            tempID = SB2.nextControl("ENV_SCH", "ENVSCH_ID");
            sql = "INSERT INTO " + SB2.DBTableName("ENV_SCH");
            sql = sql + " ( envsch_id,name," + Audit.sqlFieldString() + " ) VALUES (";
            sql = sql + tempID + "," + util.SB.DBString((String)this.name) + ",";
            sql = sql + this.audit.sqlInsert(SB2, stmt);
            sql = sql + ")";
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        for (int i = 0; i < this.nClasses; ++i) {
            sql = "INSERT INTO " + SB2.DBTableName("ENVSCHMBR");
            sql = sql + " ( envsch_id,term_no,term,red,green,blue ) VALUES (";
            sql = sql + tempID + "," + (i + 1) + "," + util.SB.DBString((String)this.term[i]) + "," + this.colour[i].getRed() + "," + this.colour[i].getGreen() + "," + this.colour[i].getBlue() + ")";
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        this.ID = tempID;
        this.SB = SB2;
    }

    public String getTerm(int classNumber) {
        if (classNumber > 0 && classNumber <= this.nClasses) {
            return this.term[classNumber - 1];
        }
        return "<no term>";
    }

    public int getTermIndex(String className) throws SBException {
        if (className.equals("<no term>")) {
            return 0;
        }
        for (int i = 0; i < this.nClasses; ++i) {
            if (!className.equalsIgnoreCase(this.term[i])) continue;
            return i + 1;
        }
        throw new SBException("Cannot find palaeoenvironment term '" + className + "' in scheme: " + this.name);
    }

    static void loadAll(SBdb SB2, List envSchemes) throws SQLException, SBException {
        String sql = "SELECT envsch_id FROM " + SB2.DBTableName("env_sch") + " ORDER BY envsch_id";
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int ID = rs.getInt("envsch_id");
            EnvScheme envScheme = EnvScheme.get(envSchemes, ID, 0);
            if (envScheme != null) continue;
            envSchemes.add(new EnvScheme(SB2, ID));
        }
        Collections.sort(envSchemes);
        stmt.close();
    }

    public void fillCombo(JComboBox combo, int selectedIndex, boolean allowBlank) {
        combo.removeAllItems();
        if (allowBlank) {
            combo.addItem("");
        }
        for (int i = 0; i < this.nClasses; ++i) {
            combo.addItem(this.term[i]);
        }
        if (selectedIndex > 0 && selectedIndex <= this.nClasses) {
            combo.setSelectedIndex(selectedIndex - (allowBlank ? 0 : 1));
        }
    }

    void writeDEX(FileWriter out, String eol) throws IOException {
        out.write("[Palaeoenvironment Scheme]" + eol);
        out.write("Scheme name = " + this.name + eol);
        out.write("  Scheme ID : " + this.ID + eol);
        out.write("  Number of columns : ");
        out.write(this.nClasses + eol);
        for (int i = 0; i < this.nClasses; ++i) {
            out.write("Column name = " + this.term[i] + eol);
            out.write("  Colour : " + this.colour[i].getRed() + ',' + this.colour[i].getGreen() + ',' + this.colour[i].getBlue() + eol);
        }
        out.write(eol);
    }

    void writeXML(BufferedWriter out, int indent) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write("<EnvironmentScheme>\n");
        out.write(ind + "<SchemeName>" + this.name + "</SchemeName>\n");
        out.write(ind + "<SchemeID>" + this.ID + "</SchemeID>\n");
        for (int i = 0; i < this.nClasses; ++i) {
            out.write(ind + "<Member>\n");
            out.write(ind + ind + "<Term>" + util.SB.getXMLstring((String)this.term[i]) + "</Term>\n");
            util.SB.writeXMLColour((Color)this.colour[i], (BufferedWriter)out, (String)(ind + ind));
            out.write(ind + "</Member>\n");
        }
        out.write("</EnvironmentScheme>\n");
    }

    static EnvScheme get(List schemes, int hostID, int donorID) {
        EnvScheme scheme2 = null;
        for (EnvScheme scheme2 : schemes) {
            if (hostID <= 0 || scheme2.ID != hostID) continue;
            return scheme2;
        }
        return null;
    }

    static EnvScheme get(List schemes, String name) {
        EnvScheme scheme2 = null;
        for (EnvScheme scheme2 : schemes) {
            if (!scheme2.name.equals(name)) continue;
            return scheme2;
        }
        return null;
    }

    public int getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws SBException, SQLException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to update env scheme");
        }
        this.name = name;
    }

    public int getNClasses() {
        return this.nClasses;
    }

    public void resetNoccs() {
        for (int i = 0; i < this.nClasses; ++i) {
            this.nOccs[i] = 0;
        }
    }

    public void updateSchemeFromLink() throws SBException, SQLException {
        boolean updateZones = false;
        if (this.link == null) {
            throw new SBException("Link null in updateFromLink");
        }
        for (int i = 0; i < this.nClasses; ++i) {
            if (this.linkTerm[i] == i) continue;
            updateZones = true;
            break;
        }
        if (updateZones) {
            Iterator<Well> it = this.SB.getProject(0).getWellIterator();
            while (it.hasNext()) {
                Well well = it.next();
                Iterator<WellInterp> iti = well.getInterpIterator();
                while (iti.hasNext()) {
                    WellInterp wellInterp = iti.next();
                    for (IGDIntervalEnv zone : wellInterp.getEnvs()) {
                        if (zone.getSchID() != this.getID()) continue;
                        zone.updateFromLink(zone.getUp() > 0 ? this.linkTerm[zone.getUp() - 1] : 0, zone.getUd() > 0 ? this.linkTerm[zone.getUd() - 1] : 0, zone.getLp() > 0 ? this.linkTerm[zone.getLp() - 1] : 0, zone.getLd() > 0 ? this.linkTerm[zone.getLd() - 1] : 0, zone.getQual() > 0 ? this.linkTerm[zone.getQual() - 1] : 0);
                    }
                }
            }
        }
        this.copy(this.link, false);
    }

    public void resetID() throws SQLException, SBException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to reset EnvScheme ID in database scheme");
        }
        this.ID = 0;
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.SB != null && this.SB.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for env scheme: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reassignFromLink() throws SBException, SQLException {
        if (this.link == null) {
            throw new SBException("Link null in EnvScheme.reassignFromLink");
        }
        if (this.SB == null || !this.SB.isConnected()) {
            throw new SBException("Attempt to reassign EnvScheme in workspace or no database connection" + this);
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        try {
            Audit temp = new Audit();
            for (String field : intervalFields) {
                for (int entry = 1; entry <= this.nClasses; ++entry) {
                    Integer linkIndex = this.getLinkTermIndex(entry);
                    if (linkIndex == null) continue;
                    String sql = "UPDATE " + this.SB.DBTableName("igd_env") + " set " + field + "=" + linkIndex + "," + temp.sqlUpdate(this.SB, stmt, false) + " WHERE " + field + "=" + entry + " AND envsch_id=" + this.ID;
                    stmt.executeUpdate(this.SB.modQuery(sql));
                }
            }
            String sql = "UPDATE " + this.SB.DBTableName("igd_env") + " set envsch_id=" + this.link.getID() + "," + temp.sqlUpdate(this.SB, stmt, false) + " WHERE envsch_id=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }
}

