/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model2.Audit;
import model2.SBEvent;
import model2.SBdb;
import model2.Taxon;
import org.jdom.Element;
import util.SBException;

public class EventDictionary
extends Observable {
    private final SBdb sbdb;
    private final HashMap<Integer, SBEvent> events;

    EventDictionary(SBdb sbdb) {
        this.sbdb = sbdb;
        this.events = new HashMap();
    }

    SBEvent getEvent(int evID) throws SQLException {
        SBEvent event = this.events.get(evID);
        if (event != null) {
            return event;
        }
        if (this.sbdb.isConnected() && (event = SBEvent.load(this.sbdb, evID, null, null)) != null) {
            this.putEvent(event);
            return event;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putEvent(SBEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Attempt to put null event");
        }
        if (this.events.get(event.getEvID()) == null) {
            HashMap<Integer, SBEvent> hashMap = this.events;
            synchronized (hashMap) {
                this.events.put(event.getEvID(), event);
            }
        }
    }

    SBEvent getEvent(String name, int specID, Boolean isSingle, Boolean generate) throws SQLException {
        if (name != null && name.isEmpty()) {
            name = null;
        }
        if (specID < 0) {
            specID = 0;
        }
        if (name == null && specID == 0) {
            throw new IllegalArgumentException("Attempt to look up event with no name or speciesID");
        }
        SBEvent event = null;
        if (!this.sbdb.isConnected()) {
            for (SBEvent e : this.events.values()) {
                if (name != null && !e.getName().equalsIgnoreCase(name) || specID != 0 && e.getSpecID() != specID) continue;
                if (isSingle == null || e.isSingle() == isSingle.booleanValue()) {
                    event = e;
                    break;
                }
                if (generate != null && e.isGenerate() != generate.booleanValue()) continue;
                event = e;
                break;
            }
            return event;
        }
        event = SBEvent.lookup(this.sbdb, name, specID, generate);
        if (event != null) {
            if (this.events.get(event.getEvID()) != null) {
                event = this.events.get(event.getEvID());
            } else {
                this.putEvent(event);
            }
            if (isSingle != null && event.isSingle() != isSingle.booleanValue()) {
                event = null;
            }
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SBEvent> getEvents(int specID) throws SQLException {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to get species events in workspace");
        }
        LinkedList<SBEvent> list = new LinkedList<SBEvent>();
        String sql = "SELECT ev_id FROM " + this.sbdb.DBTableName("EVENTDIC") + " WHERE spec_id=" + specID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int evID = rs.getInt("ev_id");
                SBEvent event = this.events.get(evID);
                if (event == null) {
                    event = SBEvent.load(this.sbdb, evID, null, null);
                    this.putEvent(event);
                }
                list.add(event);
            }
        }
        finally {
            stmt.close();
        }
        return list;
    }

    SBEvent addEvent(SBEvent.Builder builder) throws SQLException {
        SBEvent event;
        if (this.sbdb.isConnected()) {
            event = builder.store(this.sbdb);
            if (event.getTaxon() != null && event.isGenerate()) {
                try {
                    event.checkGenerateUnique(event.getTaxon());
                }
                catch (SBEvent.GenerateUniqueException e) {
                    try {
                        System.out.println("Resetting generate flag for event...");
                        event.setGenerate(false);
                    }
                    catch (SBEvent.GenerateUniqueException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        } else {
            event = builder.build(this.nextID(), this.sbdb);
        }
        this.putEvent(event);
        this.setChanged();
        this.notifyObservers(event);
        return event;
    }

    SBEvent addEvent(SBEvent.Builder builder, int evID) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to add event with ID in database");
        }
        SBEvent event = builder.build(evID, this.sbdb);
        this.putEvent(event);
        return event;
    }

    private int nextID() {
        int maxID = 1;
        for (SBEvent e : this.events.values()) {
            if (e.getEvID() < maxID) continue;
            maxID = e.getEvID() + 1;
        }
        return maxID;
    }

    void loadAll() throws SQLException {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to load all events in unconnected database");
        }
        LinkedList list = new LinkedList();
        SBEvent.loadAll(this.sbdb, list);
        for (SBEvent e : list) {
            this.putEvent(e);
        }
    }

    List<SBEvent> getEvents() {
        Collection<SBEvent> values = this.events.values();
        return new LinkedList<SBEvent>(values);
    }

    boolean hasEvents() {
        return !this.events.isEmpty();
    }

    SBEvent copyToDatabase(SBEvent wsEvent, SBdb ws) throws SBException, SQLException {
        if (!this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to copy workspace event to unconnected database");
        }
        SBEvent.Builder builder = SBEvent.Builder.copyOf(wsEvent);
        builder.audit(new Audit(this.sbdb, ws, wsEvent.getAudit()));
        SBEvent event = builder.store(this.sbdb);
        this.putEvent(event);
        return event;
    }

    SBEvent copyToWorkspace(SBEvent dbEvent, SBdb db, Taxon wsTaxon) throws SBException, SQLException {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to copy workspace event to unconnected database");
        }
        SBEvent.Builder builder = SBEvent.Builder.copyOf(dbEvent).taxon(wsTaxon);
        Audit audit = new Audit(dbEvent.getAudit());
        audit.fillWorkspace(db, this.sbdb);
        builder.audit(audit);
        SBEvent event = builder.build(dbEvent.getEvID(), this.sbdb);
        event.setLink(dbEvent);
        this.putEvent(event);
        return event;
    }

    void updateEvent(int evID, SBEvent.Builder builder) throws SQLException, SBEvent.GenerateUniqueException {
        SBEvent event = this.events.get(evID);
        event.update(builder);
        event.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteEvent(int evID) throws SQLException {
        SBEvent event = this.events.get(evID);
        if (event != null) {
            HashMap<Integer, SBEvent> hashMap = this.events;
            synchronized (hashMap) {
                if (this.sbdb.isConnected()) {
                    event.delete();
                }
                this.events.remove(evID);
            }
        } else {
            throw new IllegalStateException("Attempt to delete event which was not loaded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshEvents(Statement stmt) throws SQLException, SBException {
        if (this.events == null) {
            return;
        }
        HashMap<Integer, SBEvent> hashMap = this.events;
        synchronized (hashMap) {
            Iterator<SBEvent> it = this.events.values().iterator();
            SBEvent notifier = null;
            while (it.hasNext()) {
                SBEvent event = it.next();
                String sql = "SELECT updated FROM " + this.sbdb.DBTableName("EVENTDIC") + " WHERE ev_id=" + event.getEvID();
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    Timestamp time = rs.getTimestamp("updated");
                    if (time == null || event.getUpdated() == null || !time.after(event.getUpdated())) continue;
                    SBEvent.load(this.sbdb, event.getEvID(), stmt, event);
                    event.notifyObservers();
                    continue;
                }
                it.remove();
                notifier = event;
            }
            if (notifier != null) {
                this.setChanged();
                this.notifyObservers(notifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeTaxonEvents(int donorSpecID, int targetSpecID) throws SQLException, SBException {
        Taxon donorTaxon = this.sbdb.getTaxon(donorSpecID);
        List<SBEvent> donorEvents = this.getEvents(donorTaxon.getSpecID());
        Taxon targetTaxon = this.sbdb.getTaxon(targetSpecID);
        List<SBEvent> targetEvents = this.getEvents(targetTaxon.getSpecID());
        Iterator<SBEvent> it = donorEvents.iterator();
        while (it.hasNext()) {
            SBEvent donorEvent = it.next();
            SBEvent foundTarget = null;
            boolean donorNameIsTaxonName = false;
            if (donorTaxon.toString(false, false).equalsIgnoreCase(donorEvent.getName())) {
                donorNameIsTaxonName = true;
            }
            for (SBEvent targetEvent : targetEvents) {
                if (targetEvent.getName().equalsIgnoreCase(donorEvent.getName())) {
                    foundTarget = targetEvent;
                    break;
                }
                if (!donorNameIsTaxonName || !targetTaxon.toString(false, false).equalsIgnoreCase(targetEvent.getName())) continue;
                foundTarget = targetEvent;
                break;
            }
            if (foundTarget == null) continue;
            this.sbdb.mergeEvents(donorEvent, foundTarget);
            it.remove();
        }
        it = donorEvents.iterator();
        if (it.hasNext()) {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            String sql = "SELECT ev_id FROM " + this.sbdb.DBTableName("EVENTDIC") + " WHERE spec_id=" + targetSpecID + " AND generate='Y'";
            boolean keepGenerateFlag = true;
            try {
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    keepGenerateFlag = false;
                }
            }
            finally {
                stmt.close();
            }
            while (it.hasNext()) {
                SBEvent donorEvent = it.next();
                SBEvent.Builder builder = SBEvent.Builder.copyOf(donorEvent).taxon(targetTaxon);
                if (donorTaxon.toString(false, false).equalsIgnoreCase(donorEvent.getName())) {
                    builder.name(targetTaxon.toString(false, false));
                }
                if (!keepGenerateFlag) {
                    builder.isGenerate(false);
                }
                donorEvent.update(builder);
            }
        }
    }

    void parseEvent(Element xml) throws SQLException, SBException {
        Element el;
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to parse SBEvent directly into connected database");
        }
        SBEvent.Builder builder = new SBEvent.Builder();
        int evID = Integer.parseInt(xml.getChildTextNormalize("ID"));
        if (this.events.get(evID) != null) {
            return;
        }
        builder.name(xml.getChildText("Name"));
        String strg = xml.getChildTextNormalize("SpeciesID");
        if (strg != null) {
            int specID = Integer.parseInt(strg);
            builder.taxon(this.sbdb.getTaxon(specID));
        }
        if ((strg = xml.getChildTextNormalize("Paired")) != null) {
            builder.isSingle(!Boolean.parseBoolean(strg));
        } else {
            builder.isSingle(false);
        }
        strg = xml.getChildTextNormalize("Generate");
        if (strg != null) {
            builder.isGenerate(Boolean.parseBoolean(strg));
        }
        if ((strg = xml.getChildTextNormalize("Extent")) != null && strg.length() > 0) {
            builder.evExtent(strg.charAt(0));
        }
        if ((strg = xml.getChildText("Description")) != null) {
            builder.desc(strg);
        }
        if ((el = xml.getChild("Audit")) != null) {
            try {
                builder.audit(new Audit(this.sbdb, el));
            }
            catch (ParseException e) {
                System.out.println(e.getMessage());
            }
        } else {
            System.out.println("Warning: no audit info for event: " + this);
        }
        SBEvent event = builder.build(evID, this.sbdb);
        this.putEvent(event);
    }

    void copyLink(int evID) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to copy taxon in connected workspace");
        }
        SBEvent event = this.events.get(evID);
        if (event == null) {
            throw new IllegalStateException("Attempt to copy link on non-existant taxon");
        }
        if (event.getLink() == null) {
            throw new IllegalArgumentException("Attempt to copy link on unlinked taxon: " + event.toString() + " ID=" + event.getEvID());
        }
        if (event.getName().equalsIgnoreCase(event.getLink().getName())) {
            return;
        }
        try {
            SBEvent.Builder copyEv = SBEvent.Builder.copyOf(event.getLink());
            copyEv.taxon(event.getTaxon());
            event.update(copyEv);
        }
        catch (SQLException sql) {
            System.out.println("WARNING error copying fields to workspace taxon: " + event);
            sql.printStackTrace();
        }
        catch (SBException sbe) {
            System.out.println("WARNING error copying fields to workspace taxon: " + event);
            sbe.printStackTrace();
        }
    }
}

