/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.SBEvent;
import model2.SBdb;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class EventXLSReader {
    private final SBdb ws;
    private final Workbook wb;
    private String top;
    private String base;
    private final String name;
    private final List<Event> events = new LinkedList<Event>();

    public EventXLSReader(SBdb ws, File file) throws IOException, InvalidFormatException {
        this.ws = ws;
        this.wb = WorkbookFactory.create((File)file);
        for (int j = 0; j < this.wb.getNumberOfSheets(); ++j) {
            Sheet sheet = this.wb.getSheetAt(j);
            System.out.println("Contains sheet: " + this.wb.getSheetName(j) + "/" + sheet.getSheetName() + "\n");
        }
        String n = file.getName();
        if (n.lastIndexOf(46) > 1) {
            n = n.substring(0, n.lastIndexOf(46));
        }
        this.name = n;
    }

    public List<String> scanPrefixes() {
        LinkedList<String> prefixes = new LinkedList<String>();
        Sheet sheet = this.wb.getSheetAt(0);
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            String[] eventNames;
            String cellString;
            Cell cell;
            Row row = sheet.getRow(nRow);
            if (row == null || (cell = row.getCell(0)) == null || cell.getCellType() != 1 || (cellString = cell.getStringCellValue()) == null) continue;
            for (String eventName : eventNames = cellString.split(",")) {
                String[] words;
                if ((eventName = eventName.trim()).isEmpty() || (words = eventName.split(" ")).length <= 1 || prefixes.contains(words[0].toUpperCase())) continue;
                prefixes.add(words[0].toUpperCase());
            }
        }
        return prefixes;
    }

    public void getEvents(SBdb ws) throws SQLException, SBException {
        Sheet sheet = this.wb.getSheetAt(0);
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            String[] eventNames;
            String cellString;
            Cell cell;
            Row row = sheet.getRow(nRow);
            if (row == null || (cell = row.getCell(0)) == null || (cellString = cell.getStringCellValue().trim()) == null) continue;
            for (String eventName : eventNames = cellString.split(",")) {
                boolean isTop;
                boolean isSingle;
                if ((eventName = eventName.trim()).isEmpty()) continue;
                if (this.top != null && eventName.toUpperCase().startsWith(this.top + " ")) {
                    eventName = eventName.substring(this.top.length() + 1).trim();
                    isSingle = false;
                    isTop = true;
                } else if (this.base != null && eventName.toUpperCase().startsWith(this.base + " ")) {
                    eventName = eventName.substring(this.base.length() + 1).trim();
                    isSingle = false;
                    isTop = false;
                } else {
                    isSingle = true;
                    isTop = false;
                }
                SBEvent sbEvent = ws.getSBEvent(eventName);
                if (sbEvent == null) {
                    sbEvent = ws.addSBEvent(new SBEvent.Builder().name(eventName).isGenerate(!isSingle).isSingle(isSingle));
                }
                double age = 0.0;
                cell = row.getCell(1);
                if (cell != null && cell.getCellType() == 0) {
                    age = cell.getNumericCellValue();
                }
                age = SB.round((double)age, (int)6);
                Event rowEvent = null;
                for (Event event : this.events) {
                    if (!event.name.equals(eventName)) continue;
                    if (event.event != sbEvent) {
                        throw new SBException("Internal error: mis-match events");
                    }
                    rowEvent = event;
                    break;
                }
                if (rowEvent == null) {
                    rowEvent = new Event();
                    rowEvent.name = eventName;
                    rowEvent.event = sbEvent;
                    this.events.add(rowEvent);
                }
                if (!(age > 0.0)) continue;
                if (isSingle || isTop) {
                    rowEvent.top = age;
                    continue;
                }
                rowEvent.base = age;
            }
        }
    }

    public CompositeStandard getCompositeStandard(List<SBException> exceptions) throws SBException, SQLException {
        LinkedList<CompositeStandardEvent.Builder> builders = new LinkedList<CompositeStandardEvent.Builder>();
        Double minAge = null;
        Double maxAge = null;
        for (Event event : this.events) {
            CompositeStandardEvent.Builder builder;
            if (event.event == null || event.event.getLink() == null) continue;
            if (!event.event.isSingle()) {
                if (event.top > 0.0) {
                    builder = new CompositeStandardEvent.Builder().event(event.event);
                    builder.type(SBEvent.EventType.TOP);
                    builder.csu(event.top);
                    builders.add(builder);
                }
                if (event.base > 0.0) {
                    builder = new CompositeStandardEvent.Builder().event(event.event);
                    builder.type(SBEvent.EventType.BASE);
                    builder.csu(event.base);
                    builders.add(builder);
                }
            } else {
                builder = new CompositeStandardEvent.Builder().event(event.event);
                builder.type(SBEvent.EventType.SINGLE);
                builder.csu(event.top);
                builders.add(builder);
            }
            if (minAge == null || event.top > 0.0 && event.top < minAge) {
                minAge = event.top;
            }
            if (maxAge == null || event.top > 0.0 && event.top > maxAge) {
                maxAge = event.top;
            }
            if (minAge == null || event.base > 0.0 && event.base < minAge) {
                minAge = event.base;
            }
            if (maxAge != null && (!(event.base > 0.0) || !(event.base > maxAge))) continue;
            maxAge = event.base;
        }
        if (minAge == null) {
            minAge = 0.0;
        }
        if (maxAge == null) {
            maxAge = 0.0;
        }
        try {
            return this.ws.addCompositeStandard(this.name, minAge, maxAge, maxAge, maxAge, true, builders, null);
        }
        catch (InvalidFieldException e) {
            exceptions.add(new SBException(e.getMessage()));
            return null;
        }
    }

    public void setPrefixes(String top, String base) {
        this.top = top;
        this.base = base;
    }

    private static class Event {
        String name;
        SBEvent event;
        double top;
        double base;

        private Event() {
        }
    }
}

