/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Observable;
import model2.Audit;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import util.SB;

public class Fault
extends Observable {
    private Sample sample;
    private String label;
    private double faultThrow;
    private Audit audit = new Audit();
    private SBdb db;

    Fault(SBdb db, Sample sample, double faultThrow, String label, Audit audit) {
        this.sample = sample;
        this.faultThrow = faultThrow;
        this.label = label;
        this.audit = audit;
        this.db = db;
    }

    Fault(SBdb db, Sample sample, int wellID, double faultThrow, String label, int interpID) throws SQLException {
        this.sample = sample;
        this.faultThrow = faultThrow;
        this.label = label;
        this.db = db;
        this.store(wellID, interpID);
    }

    Fault(SBdb db, Well well, int interpID, int sampID) throws SQLException {
        String sql = "SELECT throw,label," + Audit.sqlFieldString() + " FROM " + db.DBTableName("FAULTS") + " WHERE well_id=" + well.wellID + " AND interp_id=" + interpID + " AND samp_id=" + sampID;
        Statement stmt = db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        while (rs.next()) {
            this.db = db;
            this.sample = well.getSample(sampID);
            this.faultThrow = rs.getDouble("throw");
            this.label = rs.getString("label");
            this.audit = new Audit(rs);
        }
        stmt.close();
    }

    void copy(Fault rhs) {
        this.db = rhs.db;
        this.faultThrow = rhs.faultThrow;
        this.label = rhs.label;
        this.sample = rhs.sample;
        this.audit = new Audit(rhs.audit);
    }

    public Sample getSample() {
        return this.sample;
    }

    public double getThrow() {
        return this.faultThrow;
    }

    public String getLabel() {
        return this.label;
    }

    public Date getUpdated() {
        return this.audit.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void store(int wellID, int interpID) throws SQLException {
        if (wellID <= 0 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to Fault.store, wellID: " + wellID + ", interpID: " + interpID);
        }
        Statement stmt = this.db.getDatabase().createStatement();
        String sql = "INSERT INTO " + this.db.DBTableName("faults") + " (well_id,interp_id,samp_id,throw,label," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + interpID + "," + this.sample.getSampID() + "," + this.faultThrow + "," + SB.DBString((String)this.label) + "," + this.audit.sqlInsert(this.db, stmt) + ")";
        try {
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal argument to Fault.delete: wellID is " + wellID + ", interpID is " + interpID);
        }
        String sql = "DELETE FROM " + this.db.DBTableName("faults") + " WHERE well_id=" + wellID + " AND samp_id=" + this.sample.getSampID() + " AND interp_id=" + interpID;
        Statement stmt = this.db.getDatabase().createStatement();
        try {
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    boolean mergeSamples(Sample donor, Sample target) {
        if (this.sample == donor) {
            this.sample = target;
            return true;
        }
        return false;
    }
}

