/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import model2.AnalystHeader;
import model2.Audit;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Well;
import model2.WsWell;
import util.SBException;

public class GenericReader {
    List nonInserts = new LinkedList();
    int donorSampleID = 1;
    List dataTypes;
    boolean hasDonorSampleTypes = false;

    public GenericReader(SBdb ws, String fileName, List dataTypes) throws SBException, SQLException, IOException {
        String analyst = "JA";
        char units = 'M';
        String sampleType = "CO";
        char discID = 'M';
        this.dataTypes = dataTypes;
        ws.getAddUserID(analyst);
        if (ws.getProject(0).getSize() == 0) {
            dataTypes.clear();
        }
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        String buff = in.readLine();
        buff = in.readLine();
        boolean sampID = true;
        while (buff != null) {
            System.out.println("buff: " + buff);
            String wellCode = "";
            double topDepth = 0.0;
            double baseDepth = 0.0;
            Float weight = null;
            StringTokenizer tok = new StringTokenizer(buff, ",", false);
            if (tok.hasMoreTokens()) {
                wellCode = tok.nextToken();
            }
            if (tok.hasMoreTokens()) {
                topDepth = Double.parseDouble(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                baseDepth = Double.parseDouble(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                weight = Float.valueOf(Float.parseFloat(tok.nextToken()));
            }
            Well well = null;
            Iterator<Well> it = ws.getProject(0).getWellIterator();
            while (it.hasNext()) {
                WsWell wswell = (WsWell)it.next();
                if (!wswell.getHeader().getWellCode().equals(wellCode)) continue;
                well = wswell;
                break;
            }
            if (well == null) {
                well = new WsWell(ws, fileName);
                well.getHeader().setWellCode(wellCode);
                well.getHeader().setWellName(wellCode);
                well.getHeader().setWellUnits(units);
                well.getHeader().setType('W');
                well.getHeader().setCountry("ITALY");
                well.getSamples();
                ws.getProject(0).addWell(well);
            }
            Sample sample = new Sample(ws, well.getType());
            sample.setTopDepth(topDepth, units);
            sample.setBaseDepth(baseDepth, units);
            sample.setType(sampleType);
            Sample.insert(well.getSamples(), sample, units);
            well.getHeader().setTD(baseDepth);
            if (weight != null) {
                AnalystHeader header = well.getAnalystHeader(analyst, discID, 1, true);
                Smpdtl smpdtl = new Smpdtl(ws, sample, header, null, null, null, 0, 0, 0, weight.floatValue(), 0.0f, 0.0f, 0.0f, new Audit(), Smpdtl.AnalysisType.ANALYSED);
                sample.addDtl(smpdtl);
            }
            buff = in.readLine();
        }
        this.addDataType(1);
        this.addDataType(2);
        Iterator<Well> it = ws.getProject(0).getWellIterator();
        while (it.hasNext()) {
            WsWell ww = (WsWell)it.next();
            ww.updateStatus(dataTypes);
        }
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
    }
}

