/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import model2.CompositeStandardEvent;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.SBEvent;
import model2.SBdb;
import model2.Surface;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import util.InvalidFieldException;
import util.SBException;

public class GenericReaderXLS {
    List nonInserts = new LinkedList();
    int donorSampleID = 1;
    List<Integer> dataTypes;
    int depthColumn = 0;
    int splitFactorColumn = -1;
    int sampleTypeColumn = -1;
    int sampleWeightColumn = -1;
    int taxaColumn = 1;
    SBdb ws;

    public GenericReaderXLS(SBdb ws, String fileName, List<Integer> dataTypes) throws SBException, FileNotFoundException, IOException, SQLException {
        this.dataTypes = dataTypes;
        this.ws = ws;
        FileInputStream istream = new FileInputStream(fileName);
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(fileName));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        dataTypes.clear();
        block6: for (int j = 0; j < wb.getNumberOfSheets(); ++j) {
            HSSFSheet sheet = wb.getSheetAt(j);
            System.out.println("processing sheet: " + wb.getSheetName(j) + "\n");
            switch (j) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    this.parseChronoStratSheet(sheet);
                    continue block6;
                }
                case 2: {
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
    }

    void parseSurfaceSheet(HSSFSheet sheet, int schID, String title) throws SBException, SQLException {
        IGDScheme scheme = new IGDScheme(this.ws, 10, title, null, IGDScheme.SequenceType.DEPOSITIONAL);
        scheme.setSchID(schID);
        this.ws.addIGDScheme(scheme);
        for (int nRow = 0; nRow <= sheet.getLastRowNum(); ++nRow) {
            HSSFRow row = sheet.getRow(nRow);
            if (row == null) continue;
            HSSFCell cell = row.getCell((short)0);
            cell = row.getCell((short)1);
            String surfaceName = "";
            double age = 0.0;
            if (cell != null && cell.getCellType() != 3) {
                surfaceName = cell.getStringCellValue();
            }
            if ((cell = row.getCell((short)2)) != null && cell.getCellType() != 3) {
                age = cell.getNumericCellValue();
            }
            if (surfaceName.startsWith("0MY_")) {
                surfaceName = surfaceName.substring(11);
            }
            if ((surfaceName = surfaceName.replace("'", "`")).trim().length() == 0) continue;
            try {
                Surface.SurfaceType type = Surface.SurfaceType.SB;
                if (surfaceName.endsWith("MFS")) {
                    type = Surface.SurfaceType.MFS;
                }
                scheme.addSurface(new Surface.Builder(this.ws).name(surfaceName).age(age).type(type));
                continue;
            }
            catch (Exception ex) {
                System.out.println("Error adding surface: " + surfaceName + " (age=" + age + ")");
            }
        }
    }

    void parseLithoStratSheet(HSSFSheet sheet) throws SBException, SQLException {
        IGDScheme scheme = this.ws.addIGDScheme(3, "Nexen Lithostratigraphy");
        for (int nRow = 0; nRow <= sheet.getLastRowNum(); ++nRow) {
            HSSFRow row = sheet.getRow(nRow);
            if (row == null) continue;
            HSSFCell cell = row.getCell((short)0);
            int hier = -1;
            if (cell != null && cell.getCellType() != 3) {
                String hierString = cell.getStringCellValue();
                if (hierString.length() > 1) {
                    hier = Integer.parseInt(hierString.substring(1));
                } else {
                    throw new SBException("Unrecognised hierarchy string: " + hierString);
                }
            }
            cell = row.getCell((short)1);
            String unitName = "";
            double age = 0.0;
            if (cell != null && cell.getCellType() != 3) {
                unitName = cell.getStringCellValue();
            }
            if ((cell = row.getCell((short)2)) != null && cell.getCellType() != 3) {
                age = cell.getNumericCellValue();
            }
            if (unitName.startsWith("0MY_")) {
                unitName = unitName.substring(11);
            }
            if ((unitName = unitName.replace("'", "`")).trim().length() == 0) continue;
            if (unitName.contains("BASE_")) {
                IGDUnit unit = scheme.findUnit(unitName = unitName.replace("BASE_", ""));
                if (unit != null) {
                    unit.setLage(age);
                    continue;
                }
                System.out.println("No unit found for base: " + unitName + " age=" + age);
                continue;
            }
            try {
                scheme.addUnit(new IGDUnit.Builder(scheme.getDatabase()).name(unitName).hier(hier).age(age, age));
                continue;
            }
            catch (Exception ex) {
                System.out.println("Error adding unit: " + unitName + " (age=" + age + ")");
            }
        }
    }

    void parseChronoStratSheet(HSSFSheet sheet) throws SBException, SQLException {
        IGDScheme scheme = this.ws.addIGDScheme(3, "Nexen Chronostratigraphy");
        for (int nRow = 0; nRow <= sheet.getLastRowNum(); ++nRow) {
            HSSFRow row = sheet.getRow(nRow);
            if (row == null) continue;
            HSSFCell cell = row.getCell((short)0);
            int hier = -1;
            if (cell != null && cell.getCellType() != 3) {
                hier = (int)cell.getNumericCellValue();
            }
            cell = row.getCell((short)1);
            String unitName = "";
            double age = 0.0;
            if (cell != null && cell.getCellType() != 3) {
                unitName = cell.getStringCellValue();
            }
            if ((cell = row.getCell((short)2)) != null && cell.getCellType() != 3) {
                age = cell.getNumericCellValue();
            }
            if (unitName.startsWith("0MY_")) {
                unitName = unitName.substring(11);
            }
            if ((unitName = unitName.replace("'", "`")).trim().length() == 0) continue;
            if (unitName.contains("BASE_")) {
                IGDUnit unit = scheme.findUnit(unitName = unitName.replace("BASE_", ""));
                if (unit != null) {
                    unit.setLage(age);
                    continue;
                }
                System.out.println("No unit found for base: " + unitName + " age=" + age);
                continue;
            }
            try {
                scheme.addUnit(new IGDUnit.Builder(scheme.getDatabase()).name(unitName).hier(hier).age(age, age));
                continue;
            }
            catch (Exception ex) {
                System.out.println("Error adding unit: " + unitName + " (age=" + age + ")");
            }
        }
    }

    void parseEventSheet(HSSFSheet sheet) throws SBException, SQLException, InvalidFieldException {
        this.ws.getSBEvents(true);
        LinkedList<CompositeStandardEvent.Builder> builders = new LinkedList<CompositeStandardEvent.Builder>();
        for (int nRow = 2; nRow <= sheet.getLastRowNum(); ++nRow) {
            System.out.println("Row: " + nRow);
            HSSFRow row = sheet.getRow(nRow);
            if (row == null) continue;
            HSSFCell cell = row.getCell((short)1);
            String eventName = "";
            double age = 0.0;
            if (cell != null && cell.getCellType() != 3) {
                eventName = cell.getStringCellValue();
            }
            if ((cell = row.getCell((short)2)) != null && cell.getCellType() != 3) {
                age = cell.getNumericCellValue();
            }
            if (eventName.startsWith("0MY_")) {
                eventName = eventName.substring(4);
            }
            System.out.println("Read event: " + eventName + " at age: " + age);
            eventName = eventName.replace("'", "`");
            SBEvent event = this.ws.getSBEvent(eventName);
            if (event == null) {
                event = this.ws.addSBEvent(new SBEvent.Builder().name(eventName).isSingle(true).desc("Nexen Std.").isGenerate(false));
            }
            builders.add(new CompositeStandardEvent.Builder().event(event).type(SBEvent.EventType.SINGLE).csu(age));
        }
        this.ws.addCompositeStandard("Nexen std. events", 0.0, 542.0, 0.0, 0.0, true, builders, null);
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
    }
}

