/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.font.TextAttribute;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.AttributedString;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import model2.Audit;
import model2.Category;
import model2.Discipline;
import model2.Qualifier;
import model2.SBdb;
import model2.TaxonQual;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class Genus
extends Observable
implements Comparable {
    private int genID;
    private Category category;
    private String genusName = "";
    private String subGenus = "";
    private final Qualifier[] qualifiers;
    private Audit audit = new Audit();

    public String getGenus() {
        return this.genusName;
    }

    public String getSubGenus() {
        return this.subGenus;
    }

    public Category getCategory() {
        return this.category;
    }

    public Qualifier getQ1() {
        return this.qualifiers[0];
    }

    public Qualifier getQ2() {
        return this.qualifiers[1];
    }

    public Qualifier getQ3() {
        return this.qualifiers[2];
    }

    public Qualifier getQ4() {
        return this.qualifiers[3];
    }

    Discipline getDisc() {
        return this.category.getDisc();
    }

    public int getGenID() {
        return this.genID;
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeCat) {
        return this.toString(includeCat, null);
    }

    String toString(boolean includeCat, List<Integer> italics) {
        String strg = "";
        if (includeCat) {
            strg = this.category.getMnem();
            while (strg.length() < 6) {
                strg = strg + ' ';
            }
        }
        if (this.qualifiers[0].hasQuals()) {
            strg = strg + this.qualifiers[0].toString(true);
        }
        if (italics != null) {
            italics.add(strg.length());
        }
        strg = strg + this.genusName;
        if (italics != null) {
            italics.add(strg.length());
        }
        if (this.qualifiers[1].hasQuals()) {
            strg = strg + this.qualifiers[1].toString(false);
        }
        strg = strg.trim();
        if (!this.subGenus.isEmpty()) {
            strg = strg + " (";
            if (this.qualifiers[2].hasQuals()) {
                strg = strg + this.qualifiers[2].toString(true);
            }
            if (italics != null) {
                italics.add(strg.length());
            }
            strg = strg + this.getSubGenus();
            if (italics != null) {
                italics.add(strg.length());
            }
            if (this.qualifiers[3].hasQuals()) {
                strg = strg + this.qualifiers[3].toString(false);
            }
            strg = strg + ")";
        }
        return strg.trim();
    }

    public AttributedString toAttributedString(boolean includeCat) {
        LinkedList<Integer> italicsPos = new LinkedList<Integer>();
        String string = this.toString(includeCat, italicsPos);
        AttributedString ats = new AttributedString(string);
        Iterator it = italicsPos.iterator();
        while (it.hasNext()) {
            ats.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, (Integer)it.next(), (Integer)it.next());
        }
        return ats;
    }

    boolean hasQualifiers() {
        for (Qualifier q : this.qualifiers) {
            if (!q.hasQuals()) continue;
            return true;
        }
        return false;
    }

    public boolean hasQual(TaxonQual qual) {
        for (Qualifier q : this.qualifiers) {
            if (!q.hasQual(qual)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Genus load(SBdb sbdb, int genID, Statement statement, Genus genus) throws SQLException {
        if (genus != null && genus.getGenID() != genID) {
            throw new IllegalArgumentException("Attempt to refresh genus with incorrect ID");
        }
        String query = "SELECT cat_mnem,genus,sub_genus,q1,q2,q3,q4," + Audit.sqlFieldString();
        query = query + " FROM " + sbdb.DBTableName("genus") + " WHERE gen_id=" + genID;
        query = sbdb.modQuery(query);
        Statement stmt = statement != null ? statement : sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                Builder builder = new Builder();
                String catMnem = rs.getString("cat_mnem");
                builder.category(sbdb.getCategory(catMnem.trim()));
                builder.genusName(rs.getString("genus"));
                builder.subGenus(rs.getString("sub_genus"));
                builder.qual(0, rs.getString("q1"));
                builder.qual(1, rs.getString("q2"));
                builder.qual(2, rs.getString("q3"));
                builder.qual(3, rs.getString("q4"));
                builder.audit(new Audit(rs));
                if (genus == null) {
                    Genus genus2 = builder.build(genID);
                    return genus2;
                }
                genus.category = builder.category;
                genus.genusName = builder.genusName;
                genus.subGenus = builder.subGenus;
                genus.qualifiers[0] = builder.qualifiers[0];
                genus.qualifiers[1] = builder.qualifiers[1];
                genus.qualifiers[2] = builder.qualifiers[2];
                genus.qualifiers[3] = builder.qualifiers[3];
                genus.audit = builder.audit;
                genus.setChanged();
                Genus genus3 = genus;
                return genus3;
            }
        }
        finally {
            if (statement == null) {
                stmt.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Genus[] load(SBdb sbdb, String cat_mnem, String genus, String subGenus, Qualifier gq1, Qualifier gq2, Qualifier gq3, Qualifier gq4) throws SQLException {
        String sql = "SELECT cat_mnem, gen_id, genus, sub_genus, q1, q2, q3, q4," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("GENUS") + " WHERE ";
        if (cat_mnem != null) {
            sql = sql + "cat_mnem='" + cat_mnem + "' AND ";
        }
        sql = sql + " ucase(genus)=" + SB.DBString((String)genus.toUpperCase());
        if (gq1 != null) {
            sql = gq1.hasQuals() ? sql + " AND lcase(q1)='" + gq1 + "'" : sql + " AND (q1 IS NULL or q1='')";
        }
        if (gq2 != null) {
            sql = gq2.hasQuals() ? sql + " AND lcase(q2)='" + gq2 + "'" : sql + " AND (q2 IS NULL or q2='')";
        }
        if (gq3 != null) {
            sql = gq3.hasQuals() ? sql + " AND lcase(q3)='" + gq3 + "'" : sql + " AND (q3 IS NULL or q3='')";
        }
        if (subGenus != null) {
            sql = !subGenus.isEmpty() ? sql + " AND ucase(sub_genus)=" + SB.DBString((String)subGenus.toUpperCase()) : sql + " AND (sub_genus IS NULL or sub_genus='')";
        }
        if (gq4 != null) {
            sql = gq4.hasQuals() ? sql + " AND lcase(q4)='" + gq4 + "'" : sql + " AND (q4 IS NULL or q4='')";
        }
        Statement stmt = sbdb.getDatabase().createStatement();
        LinkedList<Genus> genera = new LinkedList<Genus>();
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                Builder builder = new Builder();
                String catMnem = rs.getString("cat_mnem");
                builder.category(sbdb.getCategory(catMnem.trim()));
                int genID = rs.getInt("gen_id");
                builder.genusName(rs.getString("genus"));
                builder.subGenus(rs.getString("sub_genus"));
                builder.qual(0, rs.getString("q1"));
                builder.qual(1, rs.getString("q2"));
                builder.qual(2, rs.getString("q3"));
                builder.qual(3, rs.getString("q4"));
                builder.audit(new Audit(rs));
                genera.add(builder.build(genID));
            }
        }
        finally {
            stmt.close();
        }
        if (!genera.isEmpty()) {
            return genera.toArray(new Genus[genera.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAll(SBdb sbdb, HashMap<Integer, Genus> set) throws SQLException {
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT gen_id,cat_mnem,genus,sub_genus,q1,q2,q3,q4," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("genus");
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int genID = rs.getInt("gen_id");
                Builder builder = new Builder();
                String catMnem = rs.getString("cat_mnem");
                builder.category(sbdb.getCategory(catMnem.trim()));
                builder.genusName(rs.getString("genus"));
                builder.subGenus(rs.getString("sub_genus"));
                builder.qual(0, rs.getString("q1"));
                builder.qual(1, rs.getString("q2"));
                builder.qual(2, rs.getString("q3"));
                builder.qual(3, rs.getString("q4"));
                builder.audit(new Audit(rs));
                try {
                    set.put(genID, builder.build(genID));
                }
                catch (RuntimeException re) {
                    SB.showStackError((String)"", (Exception)re);
                }
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<String> lookupGenus(SBdb sbdb, String catMnem, String genus) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        String sql = "SELECT DISTINCT cat_mnem,genus FROM " + sbdb.DBTableName("genus") + " WHERE ucase(genus) like " + SB.DBString((String)(genus.toUpperCase() + "%"));
        if (catMnem.length() > 0) {
            sql = sql + " AND cat_mnem like '" + catMnem + "%'";
        }
        sql = sql + " ORDER BY genus, cat_mnem";
        Statement stmt = sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                String item = rs.getString("cat_mnem");
                while (item.length() < 6) {
                    item = item + ' ';
                }
                item = item + " " + rs.getString("genus");
                list.add(item);
            }
            LinkedList<String> linkedList = list;
            return linkedList;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkNSpecies(SBdb sbdb) throws SQLException {
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT count(spec_id) AS nspecies FROM " + sbdb.DBTableName("species") + " WHERE gen_id=" + this.genID;
        int nSpecies = 0;
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                nSpecies = rs.getInt("nspecies");
            }
        }
        finally {
            stmt.close();
        }
        return nSpecies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(SBdb sbdb) throws SQLException {
        if (!sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to store workspace Genus");
        }
        if (this.genID < 1) {
            throw new IllegalStateException("Attempt to store genus with illegal ID: " + this.genID);
        }
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "INSERT INTO " + sbdb.DBTableName("GENUS") + " ( cat_mnem, gen_id, genus";
        if (this.qualifiers[0].hasQuals()) {
            sql = sql + ",q1";
        }
        if (this.qualifiers[1].hasQuals()) {
            sql = sql + ",q2";
        }
        if (this.qualifiers[2].hasQuals()) {
            sql = sql + ",q3";
        }
        if (!this.subGenus.isEmpty()) {
            sql = sql + ",sub_genus";
        }
        if (this.qualifiers[3].hasQuals()) {
            sql = sql + ",q4";
        }
        sql = sql + "," + Audit.sqlFieldString() + ") VALUES ('" + this.category.getMnem() + "'," + this.genID + "," + SB.DBString((String)this.genusName);
        if (this.qualifiers[0].hasQuals()) {
            sql = sql + ",'" + this.qualifiers[0].toString(null) + "'";
        }
        if (this.qualifiers[1].hasQuals()) {
            sql = sql + ",'" + this.qualifiers[1].toString(null) + "'";
        }
        if (this.qualifiers[2].hasQuals()) {
            sql = sql + ",'" + this.qualifiers[2].toString(null) + "'";
        }
        if (this.subGenus.length() > 0) {
            sql = sql + "," + SB.DBString((String)this.subGenus);
        }
        if (this.qualifiers[3].hasQuals()) {
            sql = sql + ",'" + this.qualifiers[3].toString(null) + "'";
        }
        sql = sql + "," + this.audit.sqlInsert(sbdb, stmt) + ")";
        try {
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(SBdb sbdb, Builder builder) throws SQLException {
        if (sbdb.isConnected()) {
            Statement stmt = sbdb.getDatabase().createStatement();
            String sql = "UPDATE " + sbdb.DBTableName("GENUS") + " SET " + "cat_mnem=" + SB.DBString((String)builder.category.getMnem()) + ",genus=" + SB.DBString((String)builder.genusName) + ",q1=" + SB.DBString((String)builder.qualifiers[0].toString(null)) + ",q2=" + SB.DBString((String)builder.qualifiers[1].toString(null)) + ",q3=" + SB.DBString((String)builder.qualifiers[2].toString(null)) + ",q4=" + SB.DBString((String)builder.qualifiers[3].toString(null)) + ",sub_genus=" + SB.DBString((String)builder.subGenus) + "," + this.audit.sqlUpdate(sbdb, stmt, false) + " WHERE gen_id=" + this.genID;
            try {
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
            finally {
                stmt.close();
            }
        }
        this.category = builder.category;
        this.genusName = builder.genusName;
        this.subGenus = builder.subGenus;
        System.arraycopy(builder.qualifiers, 0, this.qualifiers, 0, this.qualifiers.length);
        this.audit = new Audit(builder.audit);
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkDelete(SBdb sbdb) throws SQLException, SBException {
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT COUNT(spec_id) as n_spec from " + sbdb.DBTableName("SPECIES") + " WHERE gen_id=" + this.genID;
        int count = 0;
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (!rs.next()) {
                throw new RuntimeException("Result set did not return any results");
            }
            count = rs.getInt("n_spec");
            if (count == 0) {
                sql = "DELETE FROM " + sbdb.DBTableName("GENUS") + " WHERE gen_id=" + this.genID;
                int updated = stmt.executeUpdate(sbdb.modQuery(sql));
                if (updated < 1) {
                    throw new SBException("No records updated in delete genus: " + this.genusName);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteGenera(SBdb sbdb, Set<Integer> genIDs) throws SQLException {
        int NSTATEMENTS = 2;
        PreparedStatement[] pStmt = new PreparedStatement[2];
        int n = 0;
        String sql = "SELECT distinct gen_id FROM " + sbdb.DBTableName("SPECIES") + " WHERE gen_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("GENUS") + " WHERE gen_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        Iterator<Integer> it = genIDs.iterator();
        try {
            while (it.hasNext()) {
                int genID = it.next();
                pStmt[0].setInt(1, genID);
                ResultSet rs = pStmt[0].executeQuery();
                if (!rs.next()) {
                    pStmt[1].setInt(1, genID);
                    pStmt[1].executeUpdate();
                    continue;
                }
                it.remove();
            }
        }
        finally {
            for (n = 0; n < pStmt.length; ++n) {
                pStmt[n].close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deleteUnusedGenera(SBdb sbdb) throws SQLException {
        int nRows;
        String sql = "DELETE FROM " + sbdb.DBTableName("GENUS") + " WHERE gen_id NOT IN (SELECT distinct gen_id FROM " + sbdb.DBTableName("SPECIES") + ")";
        Statement stmt = sbdb.getDatabase().createStatement();
        try {
            nRows = stmt.executeUpdate(sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        return nRows;
    }

    public boolean equalsBuilder(Builder builder, boolean ignoreCase) {
        if (this.category != builder.category) {
            return false;
        }
        if (ignoreCase) {
            if (!this.genusName.equalsIgnoreCase(builder.genusName)) {
                return false;
            }
            if (!this.subGenus.equalsIgnoreCase(builder.subGenus)) {
                return false;
            }
        } else {
            if (!this.genusName.equals(builder.genusName)) {
                return false;
            }
            if (!this.subGenus.equals(builder.subGenus)) {
                return false;
            }
        }
        for (int i = 0; i < this.qualifiers.length; ++i) {
            if (this.qualifiers[i].equals(builder.qualifiers[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Genus genus) {
        if (this.category != genus.category) {
            return false;
        }
        if (!this.genusName.equals(genus.genusName)) {
            return false;
        }
        if (!this.subGenus.equals(genus.subGenus)) {
            return false;
        }
        for (int i = 0; i < this.qualifiers.length; ++i) {
            if (this.qualifiers[i].equals(genus.qualifiers[i])) continue;
            return false;
        }
        return true;
    }

    Audit getAudit() {
        return this.audit;
    }

    Qualifier getQualifier(int pos) {
        if (pos < 0 || pos > this.qualifiers.length - 1) {
            return null;
        }
        return this.qualifiers[pos];
    }

    public int compareTo(Object o) {
        return this.genusName.compareTo(((Genus)o).getGenus());
    }

    void writeXML(BufferedWriter out, int indent, List<File> files) throws IOException, SQLException, SBException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write(ind + "<Category>" + this.category.getMnem() + "</Category>\n");
        out.write(ind);
        out.write("<GenusID>");
        out.write(String.valueOf(this.genID));
        out.write("</GenusID>\n");
        if (this.qualifiers[0].hasQuals()) {
            out.write(ind);
            out.write("<GQ1>");
            out.write(this.qualifiers[0].toString(true));
            out.write("</GQ1>\n");
        }
        out.write(ind);
        out.write("<Genus>");
        out.write(SB.getXMLstring((String)this.genusName));
        out.write("</Genus>\n");
        if (this.qualifiers[1].hasQuals()) {
            out.write(ind);
            out.write("<GQ2>");
            out.write(this.qualifiers[1].toString(false));
            out.write("</GQ2>\n");
        }
        if (this.qualifiers[2].hasQuals()) {
            out.write(ind);
            out.write("<GQ3>");
            out.write(this.qualifiers[2].toString(true));
            out.write("</GQ3>\n");
        }
        if (this.subGenus != null && this.subGenus.length() > 0) {
            out.write(ind);
            out.write("<SubGenus>");
            out.write(SB.getXMLstring((String)this.subGenus));
            out.write("</SubGenus>\n");
        }
        if (this.qualifiers[3].hasQuals()) {
            out.write(ind);
            out.write("<GQ4>");
            out.write(this.qualifiers[3].toString(false));
            out.write("</GQ4>\n");
        }
    }

    void writeDEX(FileWriter out, String eol) throws IOException {
        out.write("   Category : " + this.category.getMnem() + eol);
        if (this.qualifiers[0].hasQuals()) {
            out.write("   Pre-Genus qualifier : " + this.qualifiers[0].toString(true) + eol);
        }
        out.write("   Genus : " + this.genusName + eol);
        if (this.qualifiers[1].hasQuals()) {
            out.write("   Post-Genus qualifier : " + this.qualifiers[1].toString(false) + eol);
        }
        if (this.qualifiers[2].hasQuals()) {
            out.write("   Pre-Subgenus qualifier : " + this.qualifiers[2].toString(true) + eol);
        }
        if (!this.subGenus.isEmpty()) {
            out.write("   Subgenus : " + this.subGenus + eol);
        }
        if (this.qualifiers[3].hasQuals()) {
            out.write("   Post-Subgenus qualifier : " + this.qualifiers[3].toString(false) + eol);
        }
    }

    public static String toGenusCase(String strg) {
        strg = SB.capitalise((String)strg);
        return strg;
    }

    void clean(boolean convertCase, Category cat) {
        if (convertCase) {
            this.genusName = Genus.toGenusCase(this.genusName);
            this.subGenus = Genus.toGenusCase(this.subGenus);
        }
        this.category = cat;
    }

    private Genus(Builder builder, int genID) {
        this.genID = genID;
        this.category = builder.category;
        this.genusName = builder.genusName;
        this.subGenus = builder.subGenus;
        this.qualifiers = builder.qualifiers;
        this.audit = builder.audit;
    }

    public static class Builder {
        private Category category;
        private String genusName = "";
        private String subGenus = "";
        private Qualifier[] qualifiers = new Qualifier[4];
        private Audit audit = new Audit();

        public Builder() {
            for (int i = 0; i < this.qualifiers.length; ++i) {
                this.qualifiers[i] = new Qualifier(i);
            }
        }

        public static Builder copyOf(Genus genus) {
            Builder builder = new Builder();
            builder.genusName(genus.genusName).subGenus(genus.subGenus);
            for (int i = 0; i < builder.qualifiers.length; ++i) {
                Qualifier q = genus.getQualifier(i);
                if (q == null) continue;
                builder.qualifiers[i] = q.copy();
            }
            return builder;
        }

        public void verify() throws InvalidFieldException {
            if (this.qualifiers[0].hasQual(TaxonQual.QUOTE) || this.qualifiers[1].hasQual(TaxonQual.QUOTE)) {
                this.qualifiers[0].addQual(TaxonQual.QUOTE);
                this.qualifiers[1].addQual(TaxonQual.QUOTE);
            }
            if (this.qualifiers[2].hasQual(TaxonQual.QUOTE) || this.qualifiers[3].hasQual(TaxonQual.QUOTE)) {
                this.qualifiers[2].addQual(TaxonQual.QUOTE);
                this.qualifiers[3].addQual(TaxonQual.QUOTE);
            }
        }

        Genus build(int genID) {
            if (genID <= 0) {
                throw new IllegalArgumentException("Attempt to build Genus with ID: " + genID);
            }
            if (this.category == null) {
                throw new IllegalStateException("Attempt to build Genus with no Category");
            }
            if (this.genusName.isEmpty()) {
                throw new IllegalArgumentException("Attempt to build Genus with no name");
            }
            return new Genus(this, genID);
        }

        Genus store(SBdb sbdb) throws SQLException {
            int genID = sbdb.nextControl("GENUS", "GEN_ID");
            Genus genus = this.build(genID);
            genus.store(sbdb);
            return genus;
        }

        public Builder genusName(String name) {
            this.genusName = name != null ? name.trim() : "";
            return this;
        }

        public Builder subGenus(String name) {
            this.subGenus = name != null ? name.trim() : "";
            return this;
        }

        public Builder category(Category cat) {
            this.category = cat;
            return this;
        }

        public Builder qual(int qual, String s) {
            if (s == null || s.isEmpty() || qual < 0 || qual > 3) {
                return this;
            }
            if (!this.qualifiers[qual].hasQuals()) {
                this.qualifiers[qual] = new Qualifier(s.trim(), qual);
            } else {
                for (TaxonQual parsed : TaxonQual.parse(s, qual)) {
                    this.qualifiers[qual].addQual(parsed);
                }
            }
            return this;
        }

        public Builder qual(int qual, Qualifier q) {
            if (qual < 0 || qual > 3) {
                return this;
            }
            this.qualifiers[qual] = q == null ? new Qualifier(qual) : q;
            return this;
        }

        Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        public boolean hasQual(TaxonQual qual) {
            for (Qualifier q : this.qualifiers) {
                if (!q.hasQual(qual)) continue;
                return true;
            }
            return false;
        }

        Qualifier getQualifier(int i) {
            return this.qualifiers[i];
        }

        public String getName() {
            return this.genusName;
        }

        public String getSubGenus() {
            return this.subGenus;
        }

        public Category getCategory() {
            return this.category;
        }
    }
}

