/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import model2.IGDIntervalZone;
import model2.SBdb;
import util.SB;
import util.SBException;

public class IGDColMap {
    List<IGDColMapEntry> entries = null;

    public IGDColMap(SBdb db, int wellID, int interpID, int igdType) throws SQLException {
        this.loadEntry(db, wellID, interpID, igdType);
    }

    public IGDColMap(IGDColMap rhs) {
        this.entries = new LinkedList<IGDColMapEntry>();
        for (IGDColMapEntry entry : rhs.entries) {
            this.entries.add(new IGDColMapEntry(entry));
        }
    }

    public void setTitle(int selection, String columnTitle) {
        this.entries.get((int)(selection - 1)).title = columnTitle;
    }

    public boolean check() {
        for (IGDColMapEntry entry : this.entries) {
            for (IGDColMapEntry comp : this.entries) {
                if (entry == comp) continue;
                if (entry.title.equalsIgnoreCase(comp.title)) {
                    return false;
                }
                if (entry.column == comp.column) {
                    return false;
                }
                if (entry.maxHier != comp.maxHier) continue;
                return false;
            }
        }
        return true;
    }

    public void setHier(int index, int minHier, int maxHier) {
        IGDColMapEntry entry = this.entries.get(index - 1);
        entry.maxHier = maxHier;
        if (index > 1) {
            for (int decIndex = index - 1; decIndex > 0; --decIndex) {
                IGDColMapEntry decEntry = this.entries.get(decIndex - 1);
                if (decEntry.maxHier < this.entries.get((int)decIndex).maxHier) continue;
                decEntry.maxHier = this.entries.get((int)decIndex).maxHier - 1;
                System.out.println("Decrementing: " + decEntry.title + " to maxHier=" + decEntry.maxHier);
            }
        }
        for (int incIndex = index + 1; incIndex <= this.entries.size(); ++incIndex) {
            IGDColMapEntry incEntry = this.entries.get(incIndex - 1);
            if (incEntry.maxHier > this.entries.get((int)(incIndex - 2)).maxHier) continue;
            incEntry.maxHier = this.entries.get((int)(incIndex - 2)).maxHier + 1;
            System.out.println("Incrementing: " + incEntry.title + " to maxHier=" + incEntry.maxHier);
        }
    }

    public void deleteColumn(int selection) {
        if (selection == this.entries.size()) {
            this.entries.get((int)(selection - 2)).maxHier = this.entries.get((int)(selection - 1)).maxHier;
        }
        for (int index = selection; index < this.entries.size(); ++index) {
            this.entries.get((int)index).column = index;
        }
        this.entries.remove(selection - 1);
    }

    public void insertEntry(int maxHier, int index, String title) throws SBException {
        if (index > this.entries.size()) {
            throw new SBException("Cannot insert into colmap: " + index + "," + this.entries.size());
        }
        if (this.entries.size() == this.entries.get((int)(this.entries.size() - 1)).maxHier) {
            throw new SBException("Not enough space for new entry in colmap");
        }
        if (index == 1 && this.entries.get((int)0).maxHier == 1) {
            throw new SBException("Can't insert entry - existing entry hierarchy needs increasing.");
        }
        IGDColMapEntry newEntry = new IGDColMapEntry();
        newEntry.column = index;
        newEntry.title = title;
        this.entries.add(index - 1, newEntry);
        Iterator<IGDColMapEntry> it = this.entries.iterator();
        int column = 1;
        while (it.hasNext()) {
            IGDColMapEntry entry = it.next();
            entry.column = column++;
        }
        boolean conflict = true;
        block1: while (conflict) {
            int lastMax = 0;
            for (IGDColMapEntry entry : this.entries) {
                if (entry.maxHier > lastMax) {
                    lastMax = entry.maxHier;
                } else if (entry.maxHier <= lastMax) {
                    entry.maxHier = ++lastMax;
                    conflict = true;
                    continue block1;
                }
                conflict = false;
            }
        }
        this.checkLevelsContiguous();
        this.checkMaxLevels();
    }

    private void checkLevelsContiguous() {
        boolean conflict = true;
        block0: while (conflict) {
            int lastMax = 0;
            for (IGDColMapEntry entry : this.entries) {
                if (entry.maxHier > lastMax) {
                    lastMax = entry.maxHier;
                } else if (entry.maxHier <= lastMax) {
                    entry.maxHier = ++lastMax;
                    conflict = true;
                    continue block0;
                }
                conflict = false;
            }
        }
    }

    private void checkMaxLevels() {
        IGDColMapEntry lastEntry = this.entries.get(this.entries.size() - 1);
        if (lastEntry.maxHier > this.entries.size()) {
            --lastEntry.maxHier;
            for (int i = lastEntry.column - 2; i >= 0; --i) {
                if (this.entries.get((int)i).maxHier < this.entries.get((int)(i + 1)).maxHier) continue;
                --this.entries.get((int)i).maxHier;
            }
        }
    }

    public void addEntry(int maxHier, String columnTitle) throws SBException {
        IGDColMapEntry newEntry = new IGDColMapEntry();
        newEntry.column = this.entries.size() + 1;
        newEntry.title = columnTitle;
        newEntry.maxHier = this.entries.get((int)(this.entries.size() - 1)).maxHier;
        this.entries.add(newEntry);
        this.checkMaxLevels();
        this.checkLevelsContiguous();
    }

    public int getSize() throws SBException {
        if (this.entries == null) {
            throw new SBException("Attempt to get size from ColMap when not loaded");
        }
        return this.entries.size();
    }

    public String getColTitle(int column) throws SBException {
        if (this.entries == null) {
            throw new SBException("Attempt to get title from ColMap when not loaded");
        }
        return this.entries.get((int)(column - 1)).title;
    }

    public int getMaxhier(int column) throws SBException {
        if (this.entries == null) {
            throw new SBException("Attempt to get hier from ColMap when not loaded");
        }
        return this.entries.get((int)(column - 1)).maxHier;
    }

    public int getMinhier(int column) throws SBException {
        if (this.entries == null) {
            throw new SBException("Attempt to get hier from ColMap when not loaded");
        }
        if (column > 1) {
            return this.entries.get((int)(column - 2)).maxHier + 1;
        }
        return 1;
    }

    void store(SBdb db, int wellID, int interpID, int igdType) throws SBException, SQLException {
        Statement stmt;
        if (this.entries == null) {
            throw new SBException("Attempt to store column map with null entries");
        }
        if (db != null && db.isConnected()) {
            stmt = db.getDatabase().createStatement();
            String sql = "DELETE FROM " + db.DBTableName("IGD_COLMAP") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND igd_type=" + igdType;
            stmt.executeUpdate(db.modQuery(sql));
            for (IGDColMapEntry entry : this.entries) {
                sql = "INSERT INTO " + db.DBTableName("IGD_COLMAP") + " (well_id, interp_id, igd_type, col, title, maxhier) VALUES (" + wellID + "," + interpID + "," + igdType + "," + entry.column + "," + SB.DBString((String)entry.title) + "," + entry.maxHier + ")";
                stmt.executeUpdate(db.modQuery(sql));
            }
        } else {
            throw new SBException("Attempt to store column map with null or disconnected database");
        }
        stmt.close();
    }

    private void loadEntry(SBdb db, int wellID, int interpID, int igdType) throws SQLException {
        if (this.entries == null) {
            this.entries = new LinkedList<IGDColMapEntry>();
        } else {
            this.entries.clear();
        }
        if (db != null && db.isConnected()) {
            String sql = "SELECT col, title, maxhier FROM " + db.DBTableName("IGD_COLMAP") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND igd_type=" + igdType + " ORDER BY COL";
            Statement stmt = db.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                IGDColMapEntry entry = new IGDColMapEntry();
                entry.column = rs.getInt("col");
                entry.title = rs.getString("title");
                entry.maxHier = rs.getInt("maxhier");
                this.entries.add(entry);
            }
            stmt.close();
        }
        if (this.entries.size() == 0) {
            switch (igdType) {
                case 3: {
                    IGDColMapEntry entry = new IGDColMapEntry();
                    entry.column = 1;
                    entry.title = "Period/Epoch";
                    entry.maxHier = 6;
                    this.entries.add(entry);
                    entry = new IGDColMapEntry();
                    entry.column = 2;
                    entry.title = "Age";
                    entry.maxHier = 8;
                    this.entries.add(entry);
                    break;
                }
                default: {
                    int hier = 1;
                    while (hier <= IGDIntervalZone.getNHier(igdType, true)) {
                        IGDColMapEntry entry = new IGDColMapEntry();
                        entry.column = hier;
                        entry.title = IGDIntervalZone.getHierName(igdType, hier, true);
                        entry.maxHier = hier++;
                        this.entries.add(entry);
                    }
                    break block0;
                }
            }
        }
    }

    class IGDColMapEntry {
        int column;
        String title;
        int maxHier;

        private IGDColMapEntry(IGDColMapEntry rhs) {
            this.column = rhs.column;
            this.title = rhs.title;
            this.maxHier = rhs.maxHier;
        }

        private IGDColMapEntry() {
        }
    }
}

