/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import model2.Audit;
import model2.SBdb;
import util.SB;
import util.SBException;

public class IGDHdr {
    private SBdb SB;
    private int schID;
    private String source;
    private String authorised;
    private String comments;
    private Audit audit = new Audit();

    public IGDHdr(SBdb v2sbdb, int wellID, int interpID, int schID, String source, Date modified, String authorised, String comments) throws SQLException, SBException {
        this.SB = v2sbdb;
        this.schID = schID;
        this.source = source;
        if (modified != null) {
            this.audit.created = this.audit.modified = modified;
        }
        this.authorised = authorised;
        this.comments = comments;
        this.store(wellID, interpID);
    }

    IGDHdr(SBdb SB2, int wellID, int interpID, int schID) throws SQLException, SBException {
        this.SB = SB2;
        this.load(interpID, wellID, schID);
    }

    IGDHdr(SBdb SB2, int schID, String source, String authorised, String comments, Audit audit) {
        this.SB = SB2;
        this.schID = schID;
        this.source = source;
        this.authorised = authorised;
        this.comments = comments;
        this.audit = audit;
    }

    void copy(IGDHdr rhs) {
        this.schID = rhs.schID;
        this.source = rhs.source;
        this.authorised = rhs.authorised;
        this.comments = rhs.comments;
        this.audit = new Audit(rhs.audit);
    }

    void store(int wellID, int interpID) throws SQLException, SBException {
        if (this.schID == 0) {
            throw new SBException("Attempt to store IGD Header for null scheme ID");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        this.delete(stmt, wellID, interpID);
        String sql = "INSERT INTO " + this.SB.DBTableName("IGD_HDR") + " (well_id,interp_id,sch_id,source,authorised,comments," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + interpID + "," + this.schID + "," + util.SB.DBString((String)this.source) + "," + util.SB.DBString((String)this.authorised) + "," + util.SB.DBString((String)this.comments) + "," + this.audit.sqlInsert(this.SB, stmt) + ")";
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    void delete(Statement stmt, int wellID, int interpID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD_HDR") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + "  AND sch_id=" + this.schID;
        stmt.executeUpdate(this.SB.modQuery(sql));
    }

    void delete(int wellID, int interpID) throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        this.delete(stmt, wellID, interpID);
        stmt.close();
    }

    public int getSchID() {
        return this.schID;
    }

    public String getSource() {
        return this.source;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public int getUpdater() {
        return this.audit.updater;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public Date getUpdated() {
        return this.audit.updated;
    }

    public String getAuthorised() {
        return this.authorised;
    }

    public String getComments() {
        return this.comments;
    }

    void load(int interpID, int wellID, int schID) throws SQLException, SBException {
        if (schID == 0) {
            throw new SBException("Attempt to load IGD Header for null igd type");
        }
        String sql = "SELECT source,authorised,comments," + Audit.sqlFieldString() + " FROM " + this.SB.DBTableName("IGD_HDR") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND sch_id=" + schID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            this.source = rs.getString("source");
            this.authorised = rs.getString("authorised");
            this.comments = rs.getString("comments");
            this.audit = new Audit(rs);
        }
        stmt.close();
    }

    static void refresh(Statement stmt, SBdb SB2, int wellID, int interpID, List<IGDHdr> headers) throws SQLException, SBException {
        String sql = "SELECT sch_id,updated ";
        sql = sql + " FROM " + SB2.DBTableName("IGD_HDR") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        sql = SB2.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("sch_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (IGDHdr o : headers) {
                if (o.getSchID() != key) continue;
                found = true;
                if (time == null || !time.after(o.getUpdated())) break;
                IGDHdr hdr = new IGDHdr(SB2, wellID, interpID, key);
                System.out.println("In IGDHdr.refresh - got new header");
                o.copy(hdr);
                break;
            }
            if (found) continue;
            headers.add(new IGDHdr(SB2, wellID, interpID, key));
        }
        if (keys.size() < headers.size()) {
            Iterator<IGDHdr> it = headers.iterator();
            while (it.hasNext()) {
                IGDHdr o = it.next();
                if (keys.contains(o.getSchID())) continue;
                it.remove();
            }
        }
    }

    static void load(SBdb SB2, int wellID, int interpID, List<IGDHdr> list) throws SQLException, SBException {
        String sql = "SELECT sch_id,source,authorised,comments," + Audit.sqlFieldString() + " FROM " + SB2.DBTableName("IGD_HDR") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int schID = rs.getInt("sch_id");
            String source = rs.getString("source");
            String authorised = rs.getString("authorised");
            String comments = rs.getString("comments");
            Audit audit = new Audit(rs);
            list.add(new IGDHdr(SB2, schID, source, authorised, comments, audit));
        }
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IGDHdrOcc> getOccs(SBdb db, int schID) throws SQLException {
        LinkedList<IGDHdrOcc> occs = new LinkedList<IGDHdrOcc>();
        String sql = "SELECT v.well_id, w.well_name, w.well_code, i.descrip, h.comments FROM " + db.DBTableName("well_ident") + " v, " + db.DBTableName("wells") + " w, " + db.DBTableName("igd_hdr") + " h, " + db.DBTableName("interp") + " i WHERE h.sch_id=" + schID + " AND h.well_id=v.well_id AND v.well_code=w.well_code AND h.interp_id=i.interp_id ORDER BY w.well_name";
        Statement stmt = db.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                IGDHdrOcc occ = new IGDHdrOcc();
                occ.wellID = rs.getInt("well_id");
                occ.wellName = rs.getString("well_name");
                occ.wellCode = rs.getString("well_code");
                occ.interp = rs.getString("descrip");
                occ.comments = rs.getString("comments");
                occs.add(occ);
            }
        }
        finally {
            stmt.close();
        }
        return occs;
    }

    public static class IGDHdrOcc {
        private int wellID;
        private String wellName;
        private String wellCode;
        private String interp;
        private String comments;

        public int getWellID() {
            return this.wellID;
        }

        public String getWellName() {
            return this.wellName;
        }

        public String getWellCode() {
            return this.wellCode;
        }

        public String getInterp() {
            return this.interp;
        }

        public String getComments() {
            return this.comments;
        }
    }
}

