/*
 * Decompiled with CFR 0.152.
 */
package model2;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import model2.Audit;
import model2.DEXFile;
import model2.EnvScheme;
import model2.IGDInterval;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import model2.WsWell;
import org.jdom.Element;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;

public class IGDIntervalEnv
extends IGDInterval
implements SortEntry {
    private int schID = 0;
    private int up;
    private int ud;
    private int lp;
    private int ld;
    private int qual;

    public IGDIntervalEnv(SBdb SB2, Statement stmt, int wellID, int interpID, int topID, int baseID, int up, int ud, int lp, int ld, int qual, int schID, Date modified, String modifier) throws SQLException, SBException {
        super(SB2);
        this.up = up;
        if (up == 0) {
            throw new SBException("Upper proximal env zero for wellID: " + wellID + ", samp_id: " + topID);
        }
        this.ud = ud;
        if (up == 0) {
            throw new SBException("Upper distal env zero for wellID: " + wellID + ", samp_id: " + topID);
        }
        this.lp = lp;
        if (up == 0) {
            throw new SBException("Lower proximal env zero for wellID: " + wellID + ", samp_id: " + topID);
        }
        this.ld = ld;
        if (up == 0) {
            throw new SBException("Lower distal env zero for wellID: " + wellID + ", samp_id: " + topID);
        }
        this.qual = qual;
        this.schID = schID;
        this.audit.created = this.audit.modified = modified;
        this.audit.creator = SB2.getUser(modifier) != null ? (this.audit.modifier = SB2.getUser(modifier).getUsrID()) : (this.audit.modifier = SB2.getUser().getUsrID());
        this.status = NOTSTORED;
        this.store(stmt, wellID, interpID, topID, baseID);
    }

    IGDIntervalEnv(SBdb ws, IGDIntervalEnv dbEnv, Well wsWell) throws SQLException, SBException {
        super(ws, dbEnv, wsWell);
        this.copyPrimitives(dbEnv);
        this.schID = dbEnv.schID;
        EnvScheme scheme = ws.getEnvScheme(this.schID);
        if (scheme == null) {
            scheme = new EnvScheme(ws, dbEnv.sbdb.getEnvScheme(dbEnv.schID));
            ws.addEnvScheme(scheme);
        }
        this.status = STORED;
    }

    IGDIntervalEnv(SBdb db, IGDIntervalEnv wsEnv) throws SBException, SQLException {
        super(db, wsEnv);
        this.copyPrimitives(wsEnv);
        if (wsEnv.schID <= 0) {
            throw new SBException("Workspace env has no scheme for: " + this);
        }
        if (wsEnv.sbdb.getEnvScheme((int)wsEnv.schID).link == null) {
            throw new SBException("Palaeoenvironment scheme not matched for: " + this);
        }
        this.schID = wsEnv.sbdb.getEnvScheme((int)wsEnv.schID).link.getID();
        this.status = NOTSTORED;
    }

    static IGDIntervalEnv parse(SBdb db, WsWell well, Element xml) throws SBException, SQLException, ParseException {
        Element el;
        int sampID;
        Sample topSample = null;
        Sample baseSample = null;
        String strg = xml.getChildTextNormalize("TopSampleID");
        if (strg != null && (topSample = well.getSample(sampID = Integer.parseInt(strg))) == null) {
            throw new SBException("Cannot find Top Sample in Biostrat Comment for ID: " + sampID);
        }
        strg = xml.getChildTextNormalize("BaseSampleID");
        if (strg != null && (baseSample = well.getSample(sampID = Integer.parseInt(strg))) == null) {
            throw new SBException("Cannot find Base Sample in Biostrat Comment for ID: " + sampID);
        }
        strg = xml.getChildTextNormalize("EnvironmentSchemeID");
        if (strg == null) {
            throw new SBException("Cannot find Scheme ID for env interval: " + topSample + "-" + baseSample);
        }
        int schID = Integer.parseInt(strg);
        EnvScheme scheme = db.getEnvScheme(schID);
        if (scheme == null) {
            System.out.println("No Env Scheme found for ID: " + schID);
        }
        Builder builder = new Builder(db, topSample, baseSample, schID);
        strg = xml.getChildTextNormalize("UpperProximalUnit");
        if (strg != null) {
            builder.up(scheme.getTermIndex(strg));
        }
        if ((strg = xml.getChildTextNormalize("UpperDistalUnit")) != null) {
            builder.ud(scheme.getTermIndex(strg));
        }
        if ((strg = xml.getChildTextNormalize("LowerProximalUnit")) != null) {
            builder.lp(scheme.getTermIndex(strg));
        }
        if ((strg = xml.getChildTextNormalize("LowerDistalUnit")) != null) {
            builder.ld(scheme.getTermIndex(strg));
        }
        if ((strg = xml.getChildTextNormalize("EnvironmentQualifier")) != null) {
            builder.qual(scheme.getTermIndex(strg));
        }
        if ((el = xml.getChild("Audit")) != null) {
            builder.audit(new Audit(db, el));
        } else {
            System.out.println("Warning: no audit info for IGDInterval: " + builder);
        }
        builder.status = NOTSTORED;
        return builder.build();
    }

    final void copyPrimitives(IGDIntervalEnv rhs) {
        this.igdType = rhs.igdType;
        this.up = rhs.up;
        this.ud = rhs.ud;
        this.lp = rhs.lp;
        this.ld = rhs.ld;
        this.qual = rhs.qual;
    }

    public String getSortEntry() {
        return this.topSample.getSortEntry() + "-" + this.baseSample.getSortEntry();
    }

    public EnvScheme getScheme() {
        if (this.sbdb != null) {
            try {
                return this.sbdb.getEnvScheme(this.schID);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    static IGDIntervalEnv load(SBdb sbdb, int topID, int interpID, Well well, IGDIntervalEnv e) throws SQLException, SBException {
        String sql = "SELECT base_id,envsch_id,up,ud,lp,ld,qual," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("IGD_ENV") + " WHERE " + " interp_id=" + interpID + " AND well_id=" + well.wellID + " AND top_id=" + topID;
        Statement stmt = sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        Builder builder = null;
        if (rs.next()) {
            int baseID = rs.getInt("base_id");
            int schID = rs.getInt("envsch_id");
            builder = new Builder(sbdb, well.getSample(topID), well.getSample(baseID), schID);
            builder.up(rs.getInt("up"));
            builder.ud(rs.getInt("ud"));
            builder.lp(rs.getInt("lp"));
            builder.ld(rs.getInt("ld"));
            builder.qual(rs.getInt("qual"));
            builder.audit(new Audit(rs));
        }
        if (builder == null) {
            return null;
        }
        if (e == null) {
            return builder.build();
        }
        if (e.getTopSample() != builder.getTopSample() || e.getSchID() != builder.schID) {
            throw new SBException("Attempt to copy fields to unequivalent env interval object");
        }
        builder.validate();
        e.baseSample = builder.baseSample;
        e.up = builder.up;
        e.lp = builder.lp;
        e.ud = builder.ud;
        e.ld = builder.ld;
        e.qual = builder.qual;
        e.audit = builder.audit;
        return e;
    }

    static IGDIntervalEnv parse(DEXFile.DEXsection section, SBdb ws, Well well) throws SQLException, SBException {
        EnvScheme scheme = null;
        int topID = 0;
        int baseID = 0;
        int up = 0;
        int ud = 0;
        int lp = 0;
        int ld = 0;
        int qual = 0;
        Audit audit = new Audit();
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (label.equalsIgnoreCase("Top sample ID")) {
                topID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Base sample ID")) {
                baseID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Environment Scheme ID")) {
                int schID = Integer.parseInt(value);
                scheme = ws.getEnvScheme(schID);
                if (scheme != null || schID != 1) continue;
                scheme = ws.getEnvScheme(1);
                continue;
            }
            if (label.equalsIgnoreCase("Upper proximal unit")) {
                if (scheme == null) {
                    throw new SBException("Scheme missing from palaeoenvironment interval");
                }
                up = scheme.getTermIndex(value);
                continue;
            }
            if (label.equalsIgnoreCase("Upper distal unit")) {
                if (scheme == null) {
                    throw new SBException("Scheme missing from palaeoenvironment interval");
                }
                ud = scheme.getTermIndex(value);
                continue;
            }
            if (label.equalsIgnoreCase("Lower proximal unit")) {
                if (scheme == null) {
                    throw new SBException("Scheme missing from palaeoenvironment interval");
                }
                lp = scheme.getTermIndex(value);
                continue;
            }
            if (label.equalsIgnoreCase("Lower distal unit")) {
                if (scheme == null) {
                    throw new SBException("Scheme missing from palaeoenvironment interval");
                }
                ld = scheme.getTermIndex(value);
                continue;
            }
            if (label.equalsIgnoreCase("Environment qualifier")) {
                if (scheme == null) {
                    throw new SBException("Scheme missing from palaeoenvironment interval");
                }
                qual = scheme.getTermIndex(value);
                continue;
            }
            if (label.equalsIgnoreCase("Modified")) {
                try {
                    audit.modified = SB.df.parse(value);
                }
                catch (ParseException ex) {
                    audit.modified = new Date();
                }
                continue;
            }
            if (!label.equalsIgnoreCase("Modifier")) continue;
            audit.modifier = ws.getAddUserID(value);
        }
        Builder builder = new Builder(ws, well.getSample(topID), well.getSample(baseID), scheme.getID());
        builder.up(up).lp(lp).ud(ud).ld(ld).qual(qual);
        if (audit.modified == null) {
            audit.modified = new Date();
        }
        if (audit.modifier == 0) {
            // empty if block
        }
        builder.audit(audit);
        return builder.build();
    }

    public int getSchID() {
        return this.schID;
    }

    public Color getColour() {
        try {
            return this.sbdb.getEnvScheme(this.schID).getColour(this.up);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Color getColourDistal() {
        try {
            return this.sbdb.getEnvScheme(this.schID).getColour(this.ld);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getUp() {
        return this.up;
    }

    public int getUd() {
        return this.ud;
    }

    public int getLd() {
        return this.ld;
    }

    public int getLp() {
        return this.lp;
    }

    public int getQual() {
        return this.qual;
    }

    void store(Statement stmt, int wellID, int interpID) throws SQLException, SBException {
        this.store(stmt, wellID, interpID, this.topSample.getSampID(), this.baseSample.getSampID());
    }

    private void store(Statement stmt, int wellID, int interpID, int topID, int baseID) throws SQLException, SBException {
        if (this.status == NOTSTORED) {
            boolean createStatement = false;
            if (stmt == null) {
                stmt = this.sbdb.getDatabase().createStatement();
                createStatement = true;
            }
            String sql = "INSERT INTO " + this.sbdb.DBTableName("IGD_ENV") + " (well_id,top_id,base_id,interp_id,envsch_id,up,ud,lp,ld,qual," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + topID + "," + baseID + "," + interpID + "," + this.schID + "," + this.up + "," + this.ud + "," + this.lp + "," + this.ld + "," + this.qual + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (createStatement) {
                stmt.close();
            }
            this.status = STORED;
        } else if (this.status == PARTSTORED) {
            throw new SBException("Attempt to update IGDEnv");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to environment interval deletion from well: " + wellID + ", interp: " + interpID);
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("IGD_ENV") + " WHERE well_id=" + wellID + " AND top_id=" + this.topSample.getSampID() + " AND base_id=" + this.baseSample.getSampID() + " AND interp_id=" + interpID;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.status = NOTSTORED;
    }

    public String toString() {
        EnvScheme scheme = null;
        try {
            scheme = this.sbdb.getEnvScheme(this.schID);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (scheme == null) {
            return "" + this.up + "," + this.ud + "," + this.lp + "," + this.ld;
        }
        String strg = scheme.getTerm(this.up);
        if (this.up != this.ud) {
            strg = strg + "/" + scheme.getTerm(this.ud);
        }
        if (this.lp != this.up || this.ld != this.ud) {
            strg = strg + " - " + scheme.getTerm(this.lp);
            if (this.ld != this.lp) {
                strg = strg + "/" + scheme.getTerm(this.ld);
            }
        }
        return strg;
    }

    public String getConflictReason() {
        if (this.conflictReason == null) {
            return "";
        }
        return this.conflictReason;
    }

    void updateStatus(List igdList) throws SQLException, SBException {
        this.status = NOTSTORED;
        this.conflictReason = "";
        int nzTD = (int)(100.0 * this.topSample.getDepth('M'));
        int nzBD = (int)(100.0 * this.baseSample.getDepth('M'));
        for (IGDIntervalEnv zone : igdList) {
            int cBD;
            if (zone == this) continue;
            if (this.isFuncEquivalent(zone)) {
                this.status = STORED;
                if (this.up != zone.up) {
                    this.status = CONFLICT;
                    this.conflictReason = "Upper proximal conflict";
                }
                if (this.ud != zone.ud) {
                    this.status = CONFLICT;
                    this.conflictReason = "Upper distal conflict";
                }
                if (this.lp != zone.lp) {
                    this.status = CONFLICT;
                    this.conflictReason = "Lower proximal conflict";
                }
                if (this.ld != zone.ld) {
                    this.status = CONFLICT;
                    this.conflictReason = "Lower distal conflict";
                }
                if (this.qual != zone.qual) {
                    this.status = CONFLICT;
                    this.conflictReason = "Qualifier conflict: " + this.qual + ", existing: " + zone.qual;
                }
                if (this.sbdb.getEnvScheme((int)this.schID).link.getID() != zone.schID) {
                    this.status = CONFLICT;
                    this.conflictReason = "Scheme conflict";
                }
                if (this.status == CONFLICT) break;
                break;
            }
            int cTD = (int)(100.0 * zone.topSample.getDepth('M'));
            if (this.checkDepthBracketing(cTD, cBD = (int)(100.0 * zone.baseSample.getDepth('M')), nzTD, nzBD)) continue;
            break;
        }
    }

    @Deprecated
    int getAnySchID() {
        return this.schID;
    }

    void writeDEX(FileWriter out, String eol, char units, SimpleDateFormat df) throws IOException, SBException, SQLException {
        out.write("[INTERVAL " + this.topSample.getDepth(units) + " - " + this.baseSample.getDepth(units) + "]" + eol);
        out.write("Palaeoenvironment = " + this.toString() + eol);
        if (this.getSchID() > 0) {
            out.write("Environment scheme ID : " + this.getSchID() + eol);
        }
        EnvScheme scheme = this.sbdb.getEnvScheme(this.schID);
        out.write("Top sample : " + this.topSample.toString() + eol);
        out.write("Base sample : " + this.baseSample.toString() + eol);
        out.write("Top sample ID : " + this.topSample.getSampID() + eol);
        out.write("Base sample ID : " + this.baseSample.getSampID() + eol);
        out.write("Upper proximal unit : " + scheme.getTerm(this.up) + eol);
        out.write("Upper distal unit : " + scheme.getTerm(this.ud) + eol);
        out.write("Lower proximal unit : " + scheme.getTerm(this.lp) + eol);
        out.write("Lower distal unit : " + scheme.getTerm(this.ld) + eol);
        if (this.qual > 0) {
            out.write("Environment qualifier : " + scheme.getTerm(this.qual) + eol);
        }
        if (this.audit.modified != null) {
            out.write("Modified = " + df.format(this.audit.modified) + eol);
        }
        if (this.audit.modifier > 0) {
            out.write("Modifier = " + this.sbdb.getUser(this.audit.modifier).getAbr() + eol);
        }
        out.write(eol);
    }

    @Override
    LinkedList<Integer> writeXML(BufferedWriter out, int indent, char units) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write("<EnvironmentInterval Depth=\"" + SB.getDepthString((double)this.topSample.getDepth(), (char)units, (int)2) + " - " + SB.getDepthString((double)this.baseSample.getDepth(), (char)units, (int)2) + "\">\n");
        if (this.toString() != null && this.toString().length() > 0) {
            out.write(ind + "<" + IGDInterval.getIGDName(5) + ">" + SB.getXMLstring((String)this.toString()) + "</" + IGDInterval.getIGDName(5) + ">\n");
        }
        if (this.getAnySchID() > 0) {
            out.write(ind + "<EnvironmentSchemeID>" + this.getSchID() + "</EnvironmentSchemeID>\n");
        }
        if (this.topSample.getSampID() > 0) {
            out.write(ind + "<TopSampleID>" + this.topSample.getSampID() + "</TopSampleID>\n");
        }
        if (this.baseSample.getSampID() > 0) {
            out.write(ind + "<BaseSampleID>" + this.baseSample.getSampID() + "</BaseSampleID>\n");
        }
        EnvScheme scheme = this.sbdb.getEnvScheme(this.schID);
        if (this.up > 0 && scheme.getTerm(this.up).length() > 0) {
            out.write(ind + "<UpperProximalUnit>" + SB.getXMLstring((String)scheme.getTerm(this.up)) + "</UpperProximalUnit>\n");
        }
        if (this.ud > 0 && scheme.getTerm(this.ud).length() > 0) {
            out.write(ind + "<UpperDistalUnit>" + SB.getXMLstring((String)scheme.getTerm(this.ud)) + "</UpperDistalUnit>\n");
        }
        if (this.lp > 0 && scheme.getTerm(this.lp).length() > 0) {
            out.write(ind + "<LowerProximalUnit>" + SB.getXMLstring((String)scheme.getTerm(this.lp)) + "</LowerProximalUnit>\n");
        }
        if (this.ld > 0 && scheme.getTerm(this.ld).length() > 0) {
            out.write(ind + "<LowerDistalUnit>" + SB.getXMLstring((String)scheme.getTerm(this.ld)) + "</LowerDistalUnit>\n");
        }
        if (this.qual > 0) {
            out.write(ind + "<EnvironmentQualifier>" + SB.getXMLstring((String)scheme.getTerm(this.qual)) + "</EnvironmentQualifier>\n");
        }
        if (this.audit != null) {
            userIDs.addAll(this.audit.writeXML(out, indent));
        }
        out.write("</EnvironmentInterval>\n");
        return userIDs;
    }

    void updateFromLink(int linkUp, int linkUd, int linkLp, int linkLd, int linkQual) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Cannot update database Env interval from link");
        }
        if (linkUd == 0) {
            linkUd = linkUp;
        }
        if (linkLp == 0) {
            linkLp = linkUp;
        }
        if (linkLd == 0) {
            linkLd = linkLp;
        }
        if (linkUp > linkUd || linkLp > linkLd) {
            System.out.println("Updating suspicious env interval: " + linkUp + " " + linkUd + " " + linkLp + " " + linkLd);
        }
        this.up = linkUp;
        this.ud = linkUd;
        this.lp = linkLp;
        this.ld = linkLd;
        this.qual = linkQual;
    }

    void update(IGDIntervalEnv ws, int wellID, int interpID) throws SQLException, SBException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        this.audit.modified = ws.audit.modified;
        this.audit.modifier = ws.sbdb.getUser(ws.audit.modifier).getLink().getUsrID();
        String sql = "UPDATE " + this.sbdb.DBTableName("IGD_ENV") + " SET" + " up=" + ws.up + ",ud=" + ws.ud + ",lp=" + ws.lp + ",ld=" + ws.ld + ",qual=" + ws.qual + this.audit.sqlUpdate(this.sbdb, stmt, true) + " WHERE well_id=" + wellID + " AND top_id=" + this.getTopID() + " AND interp_id=" + interpID;
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        this.up = ws.up;
        this.lp = ws.lp;
        this.ud = ws.ud;
        this.ud = ws.ud;
        this.qual = ws.qual;
        this.status = STORED;
        stmt.close();
    }

    void move(int wellID, int interpID, int newInterpID) throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit tempAudit = new Audit(this.audit);
        String sql = "UPDATE " + this.sbdb.DBTableName("IGD_ENV") + " SET" + " interp_id=" + newInterpID + "," + tempAudit.sqlUpdate(this.sbdb, stmt, true) + " WHERE well_id=" + wellID + " AND top_id=" + this.getTopID() + " AND interp_id=" + interpID;
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        this.audit = tempAudit;
        stmt.close();
    }

    boolean mergeSamples(Sample donor, Sample target) {
        boolean hasChanged = false;
        if (this.topSample == donor) {
            this.topSample = target;
            hasChanged = true;
        }
        if (this.baseSample == donor) {
            this.baseSample = target;
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException {
        if (e instanceof IGDIntervalEnv) {
            if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
                return true;
            }
            IGDIntervalEnv comp = (IGDIntervalEnv)e;
            if (this.topSample.isFuncEquivalent(comp.topSample) && this.baseSample.isFuncEquivalent(comp.baseSample)) {
                return true;
            }
        }
        return false;
    }

    private IGDIntervalEnv(Builder builder) {
        super(builder);
        this.schID = builder.schID;
        this.up = builder.up;
        this.ld = builder.ld;
        this.ud = builder.ud;
        this.lp = builder.lp;
        this.qual = builder.qual;
    }

    public static class Builder
    extends IGDInterval.Builder {
        public static final String EXCEPTION_PREFIX = "Attempt to build env interval";
        private final int schID;
        private int qual = 0;
        private int up;
        private int ud;
        private int lp;
        private int ld;

        public Builder(SBdb sbdb, Sample topSample, Sample baseSample, int schID) {
            super(sbdb, 5, topSample, baseSample);
            this.schID = schID;
        }

        public static Builder copyOf(IGDIntervalEnv env) throws SBException {
            Builder builder = new Builder(env.sbdb, env.topSample, env.baseSample, env.schID);
            builder.up(env.up).ud(env.ud).lp(env.lp).ld(env.ld).qual(env.qual);
            return builder;
        }

        public static Builder copyOf(IGDIntervalEnv env, Sample topSample, Sample baseSample) throws SBException {
            Builder builder = new Builder(env.sbdb, topSample, baseSample, env.schID);
            builder.up(env.up).ud(env.ud).lp(env.lp).ld(env.ld).qual(env.qual).audit(new Audit(env.audit));
            return builder;
        }

        IGDIntervalEnv build() {
            this.validate();
            if (this.status == SbugsStatus.UNKNOWN) {
                this.status = SbugsStatus.NOTSTORED;
            }
            return new IGDIntervalEnv(this);
        }

        @Override
        void validate() {
            super.validate();
            if (this.schID <= 0) {
                throw new IllegalStateException("Attempt to build IGDIntervalZone with illegal scheme ID: " + this.schID);
            }
            if (this.up == 0) {
                throw new IllegalStateException("Attempt to build env interval with no upper proximal");
            }
            if (this.ud == 0) {
                throw new IllegalStateException("Attempt to build env interval with no upper distal");
            }
            if (this.lp == 0) {
                throw new IllegalStateException("Attempt to build env interval with no lower proximal");
            }
            if (this.ld == 0) {
                throw new IllegalStateException("Attempt to build env interval with no lower distal");
            }
            if (this.ud < this.up) {
                System.out.println("Changed ud in IGDIntervalEnv.Builder");
                this.ud = this.up;
            }
            if (this.ld < this.lp) {
                System.out.println("Changed ld in IGDIntervalEnv.Builder");
                this.ld = this.lp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IGDIntervalEnv build(int wellID, int interpID, Statement stmt) throws SQLException, SBException {
            IGDIntervalEnv env = this.build();
            boolean createdStatement = false;
            if (stmt == null) {
                stmt = this.sbdb.getDatabase().createStatement();
                createdStatement = true;
            }
            try {
                env.store(stmt, wellID, interpID);
            }
            finally {
                if (createdStatement) {
                    stmt.close();
                }
            }
            return env;
        }

        Builder audit(Audit audit) {
            this.audit = audit;
            return this;
        }

        public Builder up(int up) {
            this.up = up;
            return this;
        }

        public Builder ud(int ud) {
            this.ud = ud;
            return this;
        }

        public Builder lp(int lp) {
            this.lp = lp;
            return this;
        }

        public Builder ld(int ld) {
            this.ld = ld;
            return this;
        }

        public Builder qual(int qual) {
            this.qual = qual;
            return this;
        }
    }
}

